/*

  "Ruined Experiment".

  IRTC Sept-Oct 2000, topic LABORATORY.

  Jaime Vives Piqueres, (?)2000.

*/

// *** THAT'S MEGAPOV CODE ***
#version unofficial MegaPov 0.5;

// *** STANDARD INCLUDES ***
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "woods.inc"
#include "skies.inc"

// *** CONTROL ***
#declare luz_techo        =0;
#declare luz_foco         =1;
#declare mechero_encendido=0;
#declare test_glass       =0;
#declare usar_radiosidad  =1;
#declare usar_area        =1;
#declare usar_tubo    =1;
#declare usar_soporte =1;
#declare usar_pies    =1;
#declare usar_crisol  =1;
#declare usar_humo    =1;
#declare usar_chispas =1;
#declare usar_mechero =1;
#declare usar_balanza =1;
#declare usar_magnesio=1;
#declare usar_armario =1;
#declare usar_botes   =1;
#declare usar_computer=1;
#declare usar_foco    =1;
#declare usar_room    =1;
#declare usar_table   =1;

// *** GLOBBAL SETTINGS ***
global_settings{
 max_trace_level 13           // just to not see many black dots...
 ambient_light 0.0            // let this job to radiosity and photons.
 #if (usar_radiosidad)
  #include "i_radiosity.inc"
 #end
}

// *** CAMERA ***
#declare c_from=<40,134,-162>;
#declare c_to=<3,93,0>;
// camera settings are in the same scale as the whole scene
camera{
 location c_from
 right <4,0,0>
 up <0,3,0>
// direction 5*z // real 50 mm
 direction 8.5 // tele 85 mm
 look_at c_to
}

// *** GLOBAL VARIABLES ***
#declare r_pots=seed(1672);

// *** CUSTOM INCLUDES ***
#include "meshlath.inc"
#include "i_textures.inc"



// ### LAB STUFF ###

// *** PIES ***
#if (usar_pies)
#include "i_pies.inc"
#end

// *** CRISOL ***
#if (usar_crisol)
#include "i_crisol.inc"
#end

// *** MECHERO ***
#if (usar_mechero)
#include "i_mechero.inc"
#end

// *** BALANZA ***
#if (usar_balanza)
#include "i_balanza.inc"
#end

// *** SOPORTE TUBOS ***
#if (usar_soporte)
#include "i_soportt.inc"
#end

// *** VIRUTAS DE MANGNESIO ***
#if (usar_magnesio)
#include "i_magnesio.inc"
#end

// *** ARMARIO 1 ***
#if (usar_armario)
#include "i_armario.inc"
#end

// *** BOTES ***
#if (usar_botes)
#include "i_botes.inc"
#end

// *** TUBO DE ENSAYO ***
#if (usar_tubo)
#include "i_tubo.inc"
#end

// *** COMPUTER ***
#if (usar_computer)
#include "i_computer.inc"
#end

// *** LAMPARA FOCO ***
#if (usar_foco)
#include "i_foco.inc"
#end




// ### ARRANGEMENT ###
// *** MESA ***
#if (usar_computer)
object{monitor
 scale 1.3
 rotate -4*y
 translate <-23,91.6,18>
}
object{keyboard
 scale .8
 translate <-23.8,81.6,-5>
}
#end
#if (usar_pies)
union{
 object{pie2}
 #if (usar_mechero)
 object{mechero rotate 95*y translate <-3.5,.51,0>}
 #end
 rotate -14*y
 translate <17,80,-1>+.5*y
}
#end
#if (usar_crisol)
object{soporte_triangulo
 rotate 20*y
 translate <4,80,-.5>
}
object{rejilla_alambre rotate -113*y translate <3.5,80+alt_sop-.05,-1>}
object{rejilla_alambre rotate -112*y translate <3.4,80+alt_sop+.05,-.9>}
object{crisol
 translate <3.5,83.6+alt_sop,-1>
}
object{tapa_crisol
 translate <2,80.6,-6>
}
#include "i_macros.inc"
#declare r_smk=seed(637);
#if (usar_humo)
object{chimey_smoke(2.5,.5,8,White,White,1,.2,.3,r_smk) translate <3.5,82+alt_sop,-1>}
light_source{
 <3.5,82+alt_sop,0>
 OrangeRed*2
 fade_distance 10
 fade_power 8
}
object{fulgor translate <3.5,82+alt_sop,0>}
#end
#if (usar_chispas)
object{particulas translate <3.5,81.1+alt_sop,0>}
#end
#end
#if (usar_botes)
object{probeta(1,pigment{rgb <.9,.8,.6> filter 0.99},.3)
 scale 1.2
 translate <-5,80.1,13>
}
object{matraz1_lleno
 scale .6
 translate <-8.5,80.1,17>
}
object{bote_agua_destilada
 scale .68
 translate <8,80.1,11>
}
object{bote_oscuro1
 scale .74
 translate <-4,80.1,23>
}
#end
#if (usar_balanza)
object{balanza
 rotate 1*y
 translate <20,82.5,18>
}
#end
#if (usar_magnesio)
object{virutas
 rotate -1*x
 translate <20.1,87.6,18>
}
#end
#if (usar_soporte)
union{
 object{soporte_tubos}
 #if (usar_tubo)
 object{tubo_ensayo(1,pigment{rgb <.9,.8,.6> filter 0.99},.3)
  translate <-1.1,6.4,-1.1>
 }
 object{tubo_ensayo(1,pigment{rgb <.7,.9,.7> filter 0.99},.2)
  translate <3.3,6.4,-1.1>
 }
 object{tubo_ensayo(1,pigment{rgb <.9,.9,.7> filter 0.99},.1)
  translate <1.1,6.4,1.1>
 }
 object{tubo_ensayo(1,pigment{rgb <.9,.7,.9> filter 0.99},.2)
  translate <-3.3,6.4,1.1>
 }
 #end
 rotate 3*y
 translate <8,80.6,23>
}
#end
#if (usar_foco)
object{foco_normal
 translate <27,83,29>
}
#end
// *** SEGUNDA MESA ***
#if (usar_pies)
object{pie1
 rotate 90*y
 translate <23,80.6,53>
}
#end
#if (usar_botes)
object{bote_cristal
 scale .68
 rotate 36*y
 translate <-16,80.1,34>
}
object{bote_cristal_2
 scale .74
 rotate -16*y
 translate <-9,80.1,35>
}
object{pot03
 scale .4 translate <-20,80.1,47>
}
object{pot03
 scale .6 translate <-28,80.1,46>
}
object{pot03
 scale .6 translate <-25,80.1,57>
}
object{pot03
 scale .5 translate <-20,80.1,58>
}
#if (usar_tubo)
object{destiladora
 rotate 180*y
 translate <-19,80.1,35>
}
#end
#end


// *** PRIMER ARMARIO ***
#if (usar_armario)
union{
object{armario1
 translate <0,0,298>
}
#if (usar_pies)
object{pie1
 rotate -93*y
 translate <-21,60.1,288>+.5*y
}
#end
#if (usar_botes)
object{bote_agua_destilada rotate 360*rand(r_pots)*y translate <0,60,280>}
object{bote_agua_destilada rotate 360*rand(r_pots)*y translate <1,60,290>}
object{bote_cristal rotate 360*rand(r_pots)*y translate <-8,60,279>}
object{bote_cristal rotate 360*rand(r_pots)*y translate <-7,60,291>}
object{bote_oscuro1 rotate 360*rand(r_pots)*y translate <9,60,290>}
object{bote_cristal_2 rotate 360*rand(r_pots)*y translate <11,60,280>}
object{bote_cristal_2 rotate 360*rand(r_pots)*y translate <16.5,60,291>}
object{bote_cristal_2 rotate 360*rand(r_pots)*y translate <21.2,60,289>}
object{bote_cristal rotate 360*rand(r_pots)*y translate <19,60,281>}
object{pot01 translate <-18,35.5,292>}
object{pot02 translate <-7,35.5,291>}
object{pot01 translate <3,35.5,291>}
object{pot01 translate <13,35.5,292>}
object{pot02 translate <-18,35.5,281>}
object{pot02 translate <-7,35.5,280>}
object{pot01 translate <3,35.5,279>}
object{pot02 translate <13,35.5,280>}
#end
translate <-50,0,0>
}
#end

// *** SEGUNDO ARMARIO ***
#if (usar_armario)
union{
object{armario1
 translate <-61,0,298>
}
#if (usar_botes)
object{matraz1
 translate <-47,60,286>
}
object{matraz1
 translate <-38,60,280>
}
object{matraz2
 translate <-59,60.1,285>
}
object{bidon1
 rotate -2*y
 translate <-71,68.1,280>
}
object{bidon1
 rotate 1*y
 translate <-83,68.1,280>
}
#end
translate <-50,0,0>
}
#end

// *** TERCER ARMARIO ***
#if (usar_armario)
union{
object{armario1
 translate <61,0,298>
}
#if (usar_botes)
object{pot03 scale .7 translate <40,60.1,292>}
object{pot03 scale .6 translate <48,60.1,291>}
object{pot03 scale .8 translate <54,60.1,291>}
object{pot03 scale .5 translate <61,60.1,290>}
object{matraz2
 scale .8
 translate <41,60,278>
}
object{matraz1
 scale .8
 translate <52,60.1,281>
}
object{bote_agua_destilada rotate 360*rand(r_pots)*y translate <68,35.5,280>}
object{bote_agua_destilada rotate 360*rand(r_pots)*y translate <69,35.5,290>}
object{bote_agua_destilada rotate 360*rand(r_pots)*y translate <77,35.5,280>}
object{bote_agua_destilada rotate 360*rand(r_pots)*y translate <78,35.5,290>}
object{bote_agua_destilada rotate 360*rand(r_pots)*y translate <86,35.5,279>}
object{bote_agua_destilada rotate 360*rand(r_pots)*y translate <85,35.5,291>}
object{bote_oscuro1 rotate 360*rand(r_pots)*y translate <59,35.5,290>}
object{bote_oscuro1 rotate 360*rand(r_pots)*y translate <49,35.5,290>}
object{bote_oscuro1 rotate 360*rand(r_pots)*y translate <41,35.5,278>}
object{bote_oscuro1 rotate 360*rand(r_pots)*y translate <51,35.5,281>}
object{bote_oscuro1 rotate 360*rand(r_pots)*y translate <59,35.5,280>}
#end
translate <-50,0,0>
}
#end

// *** OTROS ARMARIOS ***
#if (usar_armario)
object{armario2 rotate 180*y translate <-122,0,-498>}
object{armario2 rotate 180*y translate <122,0,-498>}
object{armario2 rotate 90*y translate <198,0,-430>}
object{armario2 rotate -90*y translate <-198,0,-430>}
object{armario2 rotate 90*y translate <198,0,-430+61>}
object{armario2 rotate 90*y translate <198,0,-430+61*2>}
object{armario2 rotate 90*y translate <198,0,180>}
object{armario2 rotate 90*y translate <198,0,180-61>}
#end

// *** ROOM ***
#if (usar_room)
#include "i_room.inc"
#end

// *** TABLE ***
#if (usar_table)
#include "i_table.inc"
object{mesa_2
 translate <0,79,(45*.5-15)+45+1>
}
object{soporte_bancada
 translate <0,80,31>
}
object{mesa
 translate <0,79,45*.5-15>
}
object{mesa translate <0,79,45*.5-15-200>}
#end


#if (usar_room)
sky_sphere{S_Cloud2}
#end
