// Keyboard include file
// by Robert Fremin, d96rfr@csd.uu.se, 1999
//
// Macros:
// Keyboard()
//	Key(...)
//	KeyHole(...)
//	KeyLED(...)
//

#ifndef (KEYBOARD_INC)
#declare KEYBOARD_INC = true;
#debug "=#= included keyboard.inc =#=\n"

#version 3.1;

#include "colors.inc"
#include "units.inc"


// ---------------------------------------------------------------------------

#declare KeyboardTexture =
texture
{
	pigment { rgb <.9, .9, .88> * 1.4 }
	finish { diffuse .6 specular .3 phong .2 }
}

#declare CableTexture =
texture
{
	pigment { rgb <.9, .9, .88> * 1.1 }
	finish { diffuse .3 specular .4 phong .2 }
}

#declare KeyFinish =
//finish { diffuse .6 specular .3 phong .05 reflection .01 }
//finish { ambient 3.5 diffuse .1 specular .3 phong .05 reflection .01 }
finish { specular 1 phong .7 phong_size 100 }

#declare KeyTextureL =
texture
{
	pigment { Gray90*1.3 }
	finish { KeyFinish }
}

#declare KeyTextureD =
texture
{
	pigment { Gray60*1.3 }
	finish { KeyFinish }
}

// ---------------------------------------------------------------------------


// key placement constants
#declare KeyL    = -210*mm;		// Key left (center of Esc-key)
#declare KeyH    = 9*mm;		// Key height (center of cube)
#declare KeyRow1 = 50*mm;
#declare KeyRow2 = 15*mm;
#declare KeyRow3 = -4*mm;
#declare KeyRow4 = -23*mm;
#declare KeyRow5 = -42*mm;
#declare KeyRow6 = -61*mm;

// key sizes
#declare KeyNml = < 18, 13, 18> * mm;	// normal
#declare KeyBSp = < 37, 13, 18> * mm;
#declare KeyTab = < 28, 13, 18> * mm;
#declare KeyRe1 = < 28, 13, 18> * mm;	// return is special
#declare KeyRe2 = < 23, 13, 36> * mm;
#declare KeyPls = < 15, 13, 37> * mm;
#declare KeyCpL = < 33, 13, 18> * mm;
#declare KeyLSh = < 22, 13, 18> * mm;
#declare KeyRSh = < 52, 13, 18> * mm;
#declare KeyEnt = < 15, 13, 37> * mm;
#declare KeyCtr = < 27, 13, 18> * mm;
#declare KeyAlt = < 27, 13, 18> * mm;
#declare KeySpc = <132, 13, 18> * mm;
#declare KeyZer = < 37, 13, 18> * mm;

#declare NumberOfKeys = 88;

// key tint
#declare Darker =
array[NumberOfKeys]
{
	1, 0,0,0,0, 1,1,1,1, 0,0,0,0, 1,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0, 1,1,1, 1,1,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0, 1,1,1, 0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0, 0,0,0,
	0,0,0,0,0,0,0,0,0,0,0, 1, 0,0,0,
	1,1,1, 0
}

#declare KeyPrint =
array[NumberOfKeys]
{
	"Esc", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12", "PrS", "ScL", "Pse",
	"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "+", "", "Ins", "Hme", "PgU", "NmL", "/", "*", "-",
	"Q", "W", "E", "R",  "T", "Y", "U", "I", "O", "P", "", "", "Del", "End", "PgD", "7", "8", "9",
	"A", "S", "D", "F", "G", "H", "J", "K", "L", "", "", "*", "4", "5", "6",
	"< |", "Z", "X", "C", "V", "B", "N", "M", ",", ".", "-", "^", "1", "2", "3",
	"<-", "V", "->", ","
}

// key positions
#declare Keys =
array[NumberOfKeys]
{
	// row 1
	<KeyL, KeyH, KeyRow1>

	<KeyL+39*mm, KeyH, KeyRow1>
	<KeyL+58*mm, KeyH, KeyRow1>
	<KeyL+77*mm, KeyH, KeyRow1>
	<KeyL+96*mm, KeyH, KeyRow1>

	<KeyL+125*mm, KeyH, KeyRow1>
	<KeyL+144*mm, KeyH, KeyRow1>
	<KeyL+163*mm, KeyH, KeyRow1>
	<KeyL+182*mm, KeyH, KeyRow1>

	<KeyL+211*mm, KeyH, KeyRow1>
	<KeyL+230*mm, KeyH, KeyRow1>
	<KeyL+249*mm, KeyH, KeyRow1>
	<KeyL+268*mm, KeyH, KeyRow1>

	<KeyL+297*mm, KeyH, KeyRow1>
	<KeyL+316*mm, KeyH, KeyRow1>
	<KeyL+335*mm, KeyH, KeyRow1>

	// row 2
	<KeyL, KeyH, KeyRow2>
	<KeyL+19*mm, KeyH, KeyRow2>
	<KeyL+38*mm, KeyH, KeyRow2>
	<KeyL+57*mm, KeyH, KeyRow2>
	<KeyL+76*mm, KeyH, KeyRow2>
	<KeyL+95*mm, KeyH, KeyRow2>
	<KeyL+114*mm, KeyH, KeyRow2>
	<KeyL+133*mm, KeyH, KeyRow2>
	<KeyL+152*mm, KeyH, KeyRow2>
	<KeyL+171*mm, KeyH, KeyRow2>
	<KeyL+190*mm, KeyH, KeyRow2>
	<KeyL+209*mm, KeyH, KeyRow2>
	<KeyL+228*mm, KeyH, KeyRow2>

	<KeyL+297*mm, KeyH, KeyRow2>
	<KeyL+316*mm, KeyH, KeyRow2>
	<KeyL+335*mm, KeyH, KeyRow2>

	<KeyL+364*mm, KeyH, KeyRow2>
	<KeyL+383*mm, KeyH, KeyRow2>
	<KeyL+402*mm, KeyH, KeyRow2>
	<KeyL+421*mm, KeyH, KeyRow2>

	// row 3
	<KeyL+29*mm, KeyH, KeyRow3>
	<KeyL+48*mm, KeyH, KeyRow3>
	<KeyL+67*mm, KeyH, KeyRow3>
	<KeyL+86*mm, KeyH, KeyRow3>
	<KeyL+105*mm, KeyH, KeyRow3>
	<KeyL+124*mm, KeyH, KeyRow3>
	<KeyL+143*mm, KeyH, KeyRow3>
	<KeyL+162*mm, KeyH, KeyRow3>
	<KeyL+181*mm, KeyH, KeyRow3>
	<KeyL+200*mm, KeyH, KeyRow3>
	<KeyL+219*mm, KeyH, KeyRow3>
	<KeyL+238*mm, KeyH, KeyRow3>

	<KeyL+297*mm, KeyH, KeyRow3>
	<KeyL+316*mm, KeyH, KeyRow3>
	<KeyL+335*mm, KeyH, KeyRow3>

	<KeyL+364*mm, KeyH, KeyRow3>
	<KeyL+383*mm, KeyH, KeyRow3>
	<KeyL+402*mm, KeyH, KeyRow3>

	// row 4
	<KeyL+34*mm, KeyH, KeyRow4>
	<KeyL+53*mm, KeyH, KeyRow4>
	<KeyL+72*mm, KeyH, KeyRow4>
	<KeyL+91*mm, KeyH, KeyRow4>
	<KeyL+110*mm, KeyH, KeyRow4>
	<KeyL+129*mm, KeyH, KeyRow4>
	<KeyL+148*mm, KeyH, KeyRow4>
	<KeyL+167*mm, KeyH, KeyRow4>
	<KeyL+186*mm, KeyH, KeyRow4>
	<KeyL+205*mm, KeyH, KeyRow4>
	<KeyL+224*mm, KeyH, KeyRow4>
	<KeyL+243*mm, KeyH, KeyRow4>

	<KeyL+364*mm, KeyH, KeyRow4>
	<KeyL+383*mm, KeyH, KeyRow4>
	<KeyL+402*mm, KeyH, KeyRow4>

	// row 5
	<KeyL+24*mm, KeyH, KeyRow5>
	<KeyL+43*mm, KeyH, KeyRow5>
	<KeyL+62*mm, KeyH, KeyRow5>
	<KeyL+81*mm, KeyH, KeyRow5>
	<KeyL+100*mm, KeyH, KeyRow5>
	<KeyL+119*mm, KeyH, KeyRow5>
	<KeyL+138*mm, KeyH, KeyRow5>
	<KeyL+157*mm, KeyH, KeyRow5>
	<KeyL+176*mm, KeyH, KeyRow5>
	<KeyL+195*mm, KeyH, KeyRow5>
	<KeyL+214*mm, KeyH, KeyRow5>

	<KeyL+316*mm, KeyH, KeyRow5>

	<KeyL+364*mm, KeyH, KeyRow5>
	<KeyL+383*mm, KeyH, KeyRow5>
	<KeyL+402*mm, KeyH, KeyRow5>

	// row 6

	<KeyL+297*mm, KeyH, KeyRow6>
	<KeyL+316*mm, KeyH, KeyRow6>
	<KeyL+335*mm, KeyH, KeyRow6>

	<KeyL+402*mm, KeyH, KeyRow6>
}


// ---------------------------------------------------------------------------

// a generic key, scalable
#macro Key(Scale, Pos, Dark, Text)
union
{
	#local p4 = <-Scale.x/2, -Scale.y/2,  Scale.z/2>;
	#local p5 = < Scale.x/2, -Scale.y/2,  Scale.z/2>;
	#local p6 = < Scale.x/2, -Scale.y/2, -Scale.z/2>;

	#local p1 = p4 + vrotate(vrotate(y * Scale.y, z * -17.5), y *  45);
	#local p2 = p5 + vrotate(vrotate(y * Scale.y, z *  17.5), y * -45); 
	#local p3 = p6 + vrotate(vrotate(y * Scale.y, z *  17.5), y *  45);

	#local Round = .001;	// roundness
	#local p1n = p1 + <-1, 1, 1> * mm * Round;
	#local p2n = p2 + < 1, 1, 1> * mm * Round; 
	#local p3n = p3 + < 1, 1,-1> * mm * Round; 
	#local p4n = p4 + <-1, 0, 1> * mm * Round;
	#local p5n = p5 + < 1, 0, 1> * mm * Round;
	#local p6n = p6 + < 1, 0,-1> * mm * Round;

	//  p4--------p5
	//    \      / |
	//    p1----p2 |
	//      \_   | |
	//        \_ | |
	//          p3 |
	//           \ |
	//            p6


	#local Half =
 	union
	{
		triangle { p1 p2 p3 }
		triangle { p4 p5 p1 }
		triangle { p5 p2 p1 }
		triangle { p2 p5 p6 }
		triangle { p6 p3 p2 }
		cylinder { p1 p2 .1*mm }
		cylinder { p2 p3 .1*mm }
		sphere { p1 .1*mm }
		sphere { p2 .1*mm }
		sphere { p3 .1*mm }
		cylinder { p1 p4 .1*mm }
		cylinder { p2 p5 .1*mm }
	}

	object { Half }
	object { Half rotate y*180 }

	text
	{
//		ttf "timrom.ttf" Text 2*mm 0
		ttf "crystal.ttf" Text 2*mm 0
//		ttf "cyrvetic.ttf" Text 2*mm 0
		rotate x*90
		scale .6
		pigment { Gray10 }
		finish { KeyFinish }
		translate <-Scale.x/2+5*mm, Scale.y/2-.4*mm, Scale.z/2-10*mm>
	}

	translate Pos

	#if (Dark)
		texture { KeyTextureD }
	#else
		texture { KeyTextureL }
	#end
}
#end  // Key()


#macro KeyHole(XLeft, ZTop, XRight, ZBottom)
box
{
	<XLeft  - KeyNml.x/2 - .5*mm, -KeyNml.y/2, ZBottom - KeyNml.z/2 - .5*mm>
	<XRight + KeyNml.x/2 + .5*mm,  KeyNml.y,   ZTop    + KeyNml.z/2 + .5*mm>
}
#end  // Key()


#macro KeyLED(Pos, Lit)
union
{
	box
	{
		<-.5,-.5,-.5> <.5,.5,.5> scale <5*mm, 1*mm, 2*mm>
		pigment { Green }
		finish { ambient Lit*10 }
	}
	text
	{
		ttf "crystal.ttf" ".." 2*mm 0
		rotate x*90
		scale .6
		pigment { Gray10 }
		finish { KeyFinish }
		translate <-3*mm, 1*mm,-8*mm>
	}

	translate Pos
}
#end  // KeyLED()


#macro Keyboard()
union
{
	difference
	{
		// body
		superellipsoid { <.075,.075> scale .5 scale <480*mm, 22*mm, 180*mm> }

		// inside
		box { <-.5,-.5,-.5> <.5,.5,.5> scale <470*mm, 15*mm, 170*mm> }

		// joint
		box { <-.5,-.5,-.5> <.5,.5,.5> scale <500*mm, 2*mm, 200*mm> }

		// LED place
		box
		{
			<-.5,-.5,-.5> <.5,.5,.5> scale <77*mm, 2*mm, 20*mm>
			translate <KeyL+393*mm, 10*mm, KeyRow1>
			pigment { Gray80 }
		}

		// holes for the keys
		KeyHole(Keys[0].x, KeyRow1, Keys[0].x, KeyRow1)
		KeyHole(Keys[1].x, Keys[1].z, Keys[4].x, Keys[4].z)
		KeyHole(Keys[5].x, Keys[5].z, Keys[8].x, Keys[8].z)
		KeyHole(Keys[9].x, Keys[9].z, Keys[12].x, Keys[12].z)
		KeyHole(Keys[13].x, Keys[13].z, Keys[15].x, Keys[15].z)

		KeyHole(Keys[29].x, KeyRow2, Keys[31].x, KeyRow3)

		KeyHole(Keys[16].x, Keys[16].z, Keys[12].x, KeyRow5)
		KeyHole(KeyL, KeyRow6, KeyL+10*mm, KeyRow6)
		KeyHole(Keys[37].x, KeyRow6, Keys[46].x, KeyRow6)
		KeyHole(Keys[12].x-10*mm, KeyRow6, Keys[12].x, KeyRow6)

		KeyHole(Keys[30].x, KeyRow5, Keys[30].x, KeyRow5)
		KeyHole(Keys[29].x, KeyRow6, Keys[31].x, KeyRow6)

		KeyHole(Keys[32].x, KeyRow2, Keys[35].x, KeyRow6)

		scale <1,.75,1>
	}

	// LED's
	KeyLED(<KeyL+370*mm, 6.5*mm, KeyRow1+4*mm>, yes)
	KeyLED(<KeyL+396*mm, 6.5*mm, KeyRow1+4*mm>, no)
	KeyLED(<KeyL+422*mm, 6.5*mm, KeyRow1+4*mm>, no)


	// keys
	union
	{
		#local i = 0;
		#while (i < NumberOfKeys)
			Key(KeyNml, Keys[i], Darker[i], KeyPrint[i])
			#local i = i + 1;
		#end

		// 275.5 = right edge of F12
		Key(KeyBSp, <KeyL+258*mm, KeyH, KeyRow2>,             1, "<--"  )
		Key(KeyTab, <KeyL+5*mm,   KeyH, KeyRow3>,             1, "->|"  )
		Key(KeyRe1, <KeyL+262*mm, KeyH, KeyRow3>,             1, ""     )
		Key(KeyRe2, <KeyL+265*mm, KeyH, (KeyRow3+KeyRow4)/2>, 1, "<-/"  )
		Key(KeyPls, <KeyL+421*mm, KeyH, (KeyRow3+KeyRow4)/2>, 1, "+"    )
		Key(KeyCpL, <KeyL+7*mm,   KeyH, KeyRow4>,             1, "Cps L")
		Key(KeyLSh, <KeyL+2*mm,   KeyH, KeyRow5>,             1, "^"    )
		Key(KeyRSh, <KeyL+250*mm, KeyH, KeyRow5>,             1, "^"    )
		Key(KeyEnt, <KeyL+421*mm, KeyH, (KeyRow5+KeyRow6)/2>, 1, "En"   )
		Key(KeyCtr, <KeyL+5*mm,   KeyH, KeyRow6>,             1, "Ctrl" )
		Key(KeyAlt, <KeyL+54*mm,  KeyH, KeyRow6>,             1, "Alt"  )
		Key(KeySpc, <KeyL+134*mm, KeyH, KeyRow6>,             0, ""     )
		Key(KeyAlt, <KeyL+214*mm, KeyH, KeyRow6>,             1, "A Gr" )
		Key(KeyCtr, <KeyL+263*mm, KeyH, KeyRow6>,             1, "Ctrl" )
		Key(KeyZer, <KeyL+374*mm, KeyH, KeyRow6>,             0, "0"    )
	}

	// the cable
	union
	{
		#declare i = 0;
		#while (i < 1500)
			sphere
			{
				z*-i*.3*mm 2.5*mm
				translate -x*6*mm rotate z*i*10		// screw it
				translate <12*sin(i/400), 1.5*sin(i/1000), 5*sin(i/2000)>*cm	// cable bend
			}
			#declare i = i + 1;
		#end
		rotate y*130
		rotate z*2
		translate <0*cm, -1.25*cm, 12*cm>

		texture { CableTexture }
	}

	texture { KeyboardTexture }
}
#end  // Keyboard()


#end  // ifndef
