
// Persistence of Vision Ray Tracer Scene Description File
// File: gasflame.pov
// Vers: 3
// Desc: A simple lab' gas burner (Bunsen)
// Date: 9_11_04
// Auth: ReVerSi (reinhard.rettelbach.KH@t-online.de

//#version unofficial MegaPov 0.5; 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "kolors.inc"	// 
 
global_settings {max_trace_level 70}

#declare camera_location = <0, 1.5, -18.5>;
#declare camera_look_at = <0, 0, 0>;
#declare Lpos = camera_location + <0, 3, -1>


camera
{
  location  camera_location
  look_at   camera_look_at
}

/*
// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1  blue 1 // light's color
  translate Lpos
}   
light_source
{
  0*x // light's position (translated below)
  color rgb 1    // light's color 
  translate Lpos+<0, 25, -25> rotate 45*y
}
*/    
 
    
/*     
cylinder{<0, -15, 0>, <0, 50, 0>, 45 open hollow inverse
	pigment{ rgb <0.2, 0.1, 0>} 
	finish{ reflection 0.3}
	}

plane {y, -12 pigment {brick  color rgb <0.65, 0.65, 0.65> color rgb <0.6, 0.15, 0>}}
*/

/*
#declare rocket_flame =
difference{                          
	sphere{0, 1}
	sphere{<0, -0.3, 0>, 0.8}
	hollow
    	pigment {rgbt <1, 1, 1, 1>}
	interior {media {emission rgbf<0.6, 0.6, 1, 0>//0.5
			 scattering{1 rgbf<0, 0.1, 0.8, 1>}
			 density{onion color_map{
			 	[0.1 rgb <0, 0, 0.2>] 
			 	//[0.1 color Firebrick4]
				[0.4 rgb <0.6, 0.2 1>]//, 1>]
				//[0.4 color IndianRed5]
				[0.75 rgb <0.8, 0.8, 1.45>]//, 0.2>]
				//[0.75 color OrangeRed5]
				[0.95 rgb <0, 0.1, 0.8>]
				//[0.95 color Orange]
				}//, 1>]} 
			 	scale 0.8 turbulence <0.35, 0.1, 0.35>}
				}
			}
		scale <1, 4, 1> translate 3*y}
*/

#declare rocket_flame =
difference{                          
	sphere{0, 1}
	sphere{<0, -0.3, 0>, 0.8}
	hollow
    	pigment {rgbt <1, 1, 1, 1>}
	interior {media {emission rgbf<0.6, 0.6, 1, 0>//0.5
			 scattering{1 rgbf<1, 0.0, 0.0, 1>}
			 density{onion color_map{
			 	//[0.1 rgb <0, 0, 0.2>] 
			 	[0.1 color DarkEggPlant]
				//[0.4 rgb <0.6, 0.2 1>]//, 1>]
				[0.4 color BakersChoc]
				//[0.75 rgb <0.8, 0.8, 1.45>]//, 0.2>]
				[0.75 color Red3]
				//[0.95 rgb <0, 0.1, 0.8>]
				[0.95 color Orange]
				}//, 1>]} 
			 	scale 0.8 turbulence <0.35, 0.1, 0.35>}
				}
			}
		scale <1, 4, 1> translate 3*y}
		

//object {rocket_flame}

/*	
union{
	cylinder{<0, -2, 0>, <0, 1.5, 0>, 1.3 open
		 pigment {gradient y color_map{
		 		[0 rgb <0.7, 0.7, 0.8>]
		 		[1 rgb <0.2, 0.05, 0.1>]
		 		}
		 		scale 4 translate -2*y}
		finish {reflection 0.2 diffuse 0.3 brilliance 2 metallic reflect_metallic}
		 		}
	difference{
		cylinder{<0, -2, 0>, <0, 1.3, 0>, 1.2999}
		cylinder{<0, -2.1, 0>, <0, 1.31, 0>, 1}
		pigment {rgb <0.9, 0.9, 0.85>}
		}
	union{
		cylinder{<0, -7.5, 0>, <0, -2.099, 0>, 1}
		cone{<0, -9.8, 0>, 2.3, <0, -7.1, 0>, 0.9}
			pigment {rgb<0.65, 0.65, 0.7>}
			normal {bumps 0.05 scale 0.01}
			finish {specular 0.1 reflection 0.15 roughness 0.02}
			}
	}
	
*/	
	
/*	
union{
cylinder{<0, -10.101, 0>, <0, -9.899, 0>, 2.5
         pigment {rgb<0.65, 0.65, 0.7>}
         finish {specular 0.1 reflection 0.15 roughness 0.02}
         }
cylinder{<0, -10.1, 0>, <0, -9.9, 0>, 2.55
	 pigment {rgb<0.65, 0.65, 0.7>}
	 normal {radial 1 frequency 36}
	 finish {specular 0.1 reflection 0.15 roughness 0.02}
	 }
	 }
	 
*/

/*	 
sphere{<0, -19, 0>, 9
	pigment{rgb<0.1, 0.4, 0.3>}
	normal {wrinkles 0.2 scale 0.2}
	scale <1.25, 1, 1.25>
	}
*/	

/*
sphere_sweep{b_spline_sphere_sweep, 9
	<0, -10.2, -0.5>, 0.7 
	<0, -10.2, 0>, 0.7 
	<-6, -11, 3>, 0.7
	<-12, -11.3, 12>, 0.7
	<0, -11.3, 23>, 0.7
	<12, -11.3, 30>, 0.7
	<25, -11.3, 35>, 0.7          
	<40, -11.3, 37>, 0.7
	<50, -11.3, 40>, 0.7
	pigment {rgb< 0.7, 0.1, 0.15>}
	finish {specular 0.15 roughness 0.5}
	}	 	 						                                                                   
*/	