//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 95 materials and 665 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 10/09/2000    (09.10.2000)
//



/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 500
  max_trace_level 500
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            200
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.596,0.596,0.592> }

camera {  //  Camera StdCam
  location  <     39.696,     -51.008,      12.411>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      8.446,      -6.332,       3.952>
  // Focal blur settings
  focal_point  <8.446, -6.332, 3.952> // Always Lookat
  aperture     0.2
  blur_samples 100
  confidence   0.999
  variance     0.0001
}

//
// *******  L I G H T S *******
//

light_source {   // Light001
  <36.800, -7.094, 19.073>
  color rgb <1.000, 1.000, 0.857>*0.9500
  fade_distance  400.0
  fade_power 2.0
}

light_source {   // blue_fill_light
  <-8.470, -24.950, 19.070>
  color rgb <0.829, 0.843, 0.914>*0.3750
  fade_distance  150.0
  fade_power 2.0
}


//
// ********  MATERIALS  *******
//

#include "perking9a.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cylndr001 = object {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 4.0>
    translate  <-6.0, 0.0, 1.0>
  }
}




//
// ********  OBJECTS  *******
//

#declare powder_on_table = object { 
  height_field {
    tga "G:\irtc\lab\POWDER3.tga"
    water_level 0.01
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    powder_texture
  }
  scale <5.0, 4.5, 0.01>
  translate  <10.772052, -17.543183, 0.51>
}
#declare Testtube3 = lathe {
  linear_spline
  22  // control points
  <-0.002321, 0.002445>,
  <0.110896, 0.000679>,
  <0.203527, 0.022607>,
  <0.323147, 0.05164>,
  <0.400693, 0.092671>,
  <0.466514, 0.173913>,
  <0.467217, 6.182593>,
  <0.475763, 6.402549>,
  <0.499466, 6.434699>,
  <0.55782, 6.476649>,
  <0.562807, 6.552554>,
  <0.524704, 6.585672>,
  <0.457678, 6.579173>,
  <0.426528, 6.557851>,
  <0.418717, 6.495204>,
  <0.417139, 6.447301>,
  <0.419983, 6.158729>,
  <0.424715, 0.235475>,
  <0.383882, 0.176002>,
  <0.27453, 0.110966>,
  <0.118861, 0.08883>,
  <-0.001058, 0.085325>
  rotate <90,0,90>
  material {
    Glass
  }
  rotate <89.473167, 1.076217, 61.884037>
  translate  <-0.448866, -13.898604, 1.023861>
}
union { // spill
  object { powder_on_table }
  object { Testtube3 }
  bounded_by { // Bound00003
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <8.341986, 4.790498, 0.75139>
      translate  <7.608064, -17.655683, 1.073392>
    }
  }
  translate  <11.110302, -8.157532, 0.0>
}






union { // room
  box { // Ceiling
    <-1, -1, -1>, <1, 1, 1>
    material {
      ceiling_texture
    }
    scale <100.0, 60.0, 1.0>
    translate  <-1.706148, -53.743659, 72.0>
  }
  box { // Wall2
    <-1, -1, -1>, <1, 1, 1>
    material {
      ceiling_texture
    }
    scale <1.0, 60.0, 60.0>
    translate  <-100.033757, -53.61954, 11.724983>
  }
  box { // Wall3
    <-1, -1, -1>, <1, 1, 1>
    material {
      ceiling_texture
    }
    scale <1.0, 60.0, 60.0>
    translate  <100.0, -57.263748, 10.281246>
  }
  box { // Wall4
    <-1, -1, -1>, <1, 1, 1>
    material {
      ceiling_texture
    }
    scale <100.0, 1.0, 60.0>
    translate  <1.043422, -115.272777, 10.281246>
  }
  // All transformations fixed
  translate  <2.195378, -1.463585, 0.0>
}


#declare tt_rack_body = union {
  box { // stand_top
    <-1, -1, -1>, <1, 1, 1>
    scale <7.75, 1.4, 0.25>
    translate  <-0.103932, -0.023811, 3.023873>
  }
  superellipsoid { // Q_Rack_end_2
    <0.1, 0.1>
    scale <0.25, 1.5, 2.5>
    rotate <-0.0, 0.0, 0.049256>
    translate  <7.636298, 0.015406, 2.227823>
  }
  superellipsoid { // Q_Rack_end_1
    <0.1, 0.1>
    scale <0.25, 1.5, 2.5>
    rotate <-0.0, 0.0, 0.314335>
    translate  <-7.708425, -0.019304, 2.09977>
  }
  superellipsoid { // Q_tt__rack_
    <0.1, 0.1>
    scale <8.0, 2.0, 0.4>
    rotate <-0.0, 0.0, -0.353462>
    translate  <0.001941, 0.050524, -0.00858>
  }
  translate  0.023873*z
}
#declare tt_cutouts = union {
  object { Cylndr001 }
  object { // Cylndr2->Cylndr001
    Cylndr001
    translate  3.0*x
  }
  object { // Cylndr3->Cylndr001
    Cylndr001
    translate  6.0*x
  }
  object { // Cylndr4->Cylndr001
    Cylndr001
    translate  9.0*x
  }
  object { // Cylndr5->Cylndr001
    Cylndr001
    translate  12.0*x
  }
}
#declare tt_rack = difference {
  object { tt_rack_body }
  object { tt_cutouts }
  material {
    test_tube_rack_texture
  }
  translate  <7.168849, -19.121187, 0.0>
}
#declare Testtube1 = lathe {
  linear_spline
  22  // control points
  <-0.002321, 0.002445>,
  <0.110896, 0.000679>,
  <0.203527, 0.022607>,
  <0.323147, 0.05164>,
  <0.400693, 0.092671>,
  <0.466514, 0.173913>,
  <0.467217, 6.182593>,
  <0.475763, 6.402549>,
  <0.499466, 6.434699>,
  <0.55782, 6.476649>,
  <0.562807, 6.552554>,
  <0.524704, 6.585672>,
  <0.457678, 6.579173>,
  <0.426528, 6.557851>,
  <0.418717, 6.495204>,
  <0.417139, 6.447301>,
  <0.419983, 6.158729>,
  <0.424715, 0.235475>,
  <0.383882, 0.176002>,
  <0.27453, 0.110966>,
  <0.118861, 0.08883>,
  <-0.001058, 0.085325>
  rotate <90,0,90>
  material {
    Glass
  }
  rotate <-0.501134, -0.414737, 0.001814>
  translate  <7.323651, -19.067361, 0.43025>
}
#declare Testtube2 = lathe {
  linear_spline
  22  // control points
  <-0.002321, 0.002445>,
  <0.110896, 0.000679>,
  <0.203527, 0.022607>,
  <0.323147, 0.05164>,
  <0.400693, 0.092671>,
  <0.466514, 0.173913>,
  <0.467217, 6.182593>,
  <0.475763, 6.402549>,
  <0.499466, 6.434699>,
  <0.55782, 6.476649>,
  <0.562807, 6.552554>,
  <0.524704, 6.585672>,
  <0.457678, 6.579173>,
  <0.426528, 6.557851>,
  <0.418717, 6.495204>,
  <0.417139, 6.447301>,
  <0.419983, 6.158729>,
  <0.424715, 0.235475>,
  <0.383882, 0.176002>,
  <0.27453, 0.110966>,
  <0.118861, 0.08883>,
  <-0.001058, 0.085325>
  rotate <90,0,90>
  material {
    Glass
  }
  rotate <1.278929, 1.058263, 0.011812>
  translate  <13.09949, -19.132738, 0.45>
}
union { // full_tt_rack
  object { tt_rack }
  object { Testtube1 }
  object { Testtube2 }
  bounded_by { // Bound00002
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <8.183097, 2.212271, 3.898046>
      translate  <7.17079, -19.070663, 3.333244>
    }
  }
  rotate -31.19239*z
  translate  <13.577315, -8.284816, 0.926022>
}


box { // Backsplash
  <-1, -1, -1>, <1, 1, 1>
  bounded_by { // Bound00011
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale 1.04
    }
  }
  // All transformations fixed
  scale <100.0, 0.5, 2.0>
  translate  <0.0, 2.8, 1.98>
  material {
    Basic_Bench_Top
    // Transform to world space
  }
}


box { // Back_Wall
  <-1, -1, -1>, <1, 1, 1>
  // All transformations fixed
  scale <100.0, 1.0, 60.0>
  translate  <0.0, 4.2, 10.963857>
  material {
    wall_tile_texture
    // Transform to world space
  }
}


box { // Bench_top
  <-1, -1, -1>, <1, 1, 1>
  bounded_by { // Bound00012
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale 1.04
    }
  }
  scale <100.0, 30.0, 1.0>
  translate  <0.046921, -23.473866, -0.5>
  material {
    Basic_Bench_Top
    // Transform to world space
  }
}


#declare Bottle_Cap = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle = difference {
  object { BottleExterior }
  object { BottleVoid }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Basic_Gas
  }
  scale <0.845, 0.845, 0.92>
  translate  <-0.001193, 0.000022, 1.104413>
}
#declare SampleBottle_M_hydrogen = union {
  object { Bottle_Cap }
  object { GlassofSampleBottle }
  object { Bottlefill }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <-0.123421, 6.889412, 6.849014>
}
#declare Bottle_Cap3 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior3 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid3 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle3 = difference {
  object { BottleExterior3 }
  object { BottleVoid3 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill3 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Basic_Gas
  }
  scale <0.845, 0.845, 0.92>
  translate  <-0.001193, 0.000022, 1.104413>
}
#declare SampleBottle_M_helium = union {
  object { Bottle_Cap3 }
  object { GlassofSampleBottle3 }
  object { Bottlefill3 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <17.090252, 6.912822, 6.197312>
}
#declare Period_1 = union {
  box { // Hydrogen
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Gas
    }
    scale <0.49, 0.49, 7.26>
    translate  0.5*z
  }
  box { // Helium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Gas
    }
    scale <0.49, 0.49, 6.63>
    translate  <17.0, 0.0, 0.5>
  }
  object { SampleBottle_M_hydrogen }
  object { SampleBottle_M_helium }
}
#declare Row_1 = union {
  object { Period_1 }
  bounded_by { // Bound00004
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <9.233462, 0.733462, 9.023102>
      translate  <8.5, 0.0, 2.019639>
    }
  }
}
#declare Bottle_Cap2 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior2 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid2 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle2 = difference {
  object { BottleExterior2 }
  object { BottleVoid2 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill2 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group2 = difference {
  object { Bottlefill2 }
  box { // fill_cut_off2
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 20.528214, 0.0>
    translate  <1.509658, 0.404246, 10.006639>
  }
  material {
    Lithium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_lithium = union {
  object { Bottle_Cap2 }
  object { GlassofSampleBottle2 }
  object { bottle_fill_group2 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <-0.106163, 5.906049, 1.851035>
}
#declare Bottle_Cap4 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior4 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid4 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle4 = difference {
  object { BottleExterior4 }
  object { BottleVoid4 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill4 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group3 = difference {
  object { Bottlefill4 }
  box { // fill_cut_off3
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 8.588571, 0.0>
    translate  <1.581276, 0.404246, 9.672424>
  }
  material {
    Beryllium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_beryllium = union {
  object { Bottle_Cap4 }
  object { GlassofSampleBottle4 }
  object { bottle_fill_group3 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <0.97584, 5.889332, 0.752899>
}
#declare Period_2_S = union {
  box { // Lithium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    scale <0.49, 0.49, 2.27>
    translate  <0.0, -1.0, 0.5>
  }
  box { // Beryllium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Beryllium_texture
    }
    scale <0.49, 0.49, 1.19>
    translate  <1.0, -1.0, 0.5>
  }
  object { SampleBottle_M_lithium }
  object { SampleBottle_M_beryllium }
}
#declare Bottle_Cap13 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior13 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid13 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle13 = difference {
  object { BottleExterior13 }
  object { BottleVoid13 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill13 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Fluorine_texture
  }
  scale <0.845, 0.845, 0.92>
  translate  <-0.001193, 0.000022, 1.104413>
}
#declare SampleBottle_M_fluorine = union {
  object { Bottle_Cap13 }
  object { GlassofSampleBottle13 }
  object { Bottlefill13 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <15.946397, 5.877603, 2.542541>
}
#declare Bottle_Cap8 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior8 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid8 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle8 = difference {
  object { BottleExterior8 }
  object { BottleVoid8 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill8 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Basic_Gas
  }
  scale <0.845, 0.845, 0.92>
  translate  <-0.001193, 0.000022, 1.104413>
}
#declare SampleBottle_M_neon = union {
  object { Bottle_Cap8 }
  object { GlassofSampleBottle8 }
  object { Bottlefill8 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <17.048363, 5.85192, 4.603551>
}
#declare Bottle_Cap36 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior36 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid36 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle36 = difference {
  object { BottleExterior36 }
  object { BottleVoid36 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill36 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group28 = difference {
  object { Bottlefill36 }
  box { // fill_cut_off28
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 3.719858, -0.0>
    translate  <1.509658, 0.404246, 10.006639>
  }
  material {
    Boron_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_boron = union {
  object { Bottle_Cap36 }
  object { GlassofSampleBottle36 }
  object { bottle_fill_group28 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <11.952418, 5.859053, 1.584068>
}
#declare Bottle_Cap37 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior37 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid37 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle37 = difference {
  object { BottleExterior37 }
  object { BottleVoid37 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill37 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Oxygen_texture
  }
  scale <0.845, 0.845, 0.92>
  translate  <-0.001193, 0.000022, 1.104413>
}
#declare SampleBottle_M_oxygen = union {
  object { Bottle_Cap37 }
  object { GlassofSampleBottle37 }
  object { Bottlefill37 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <14.9375, 5.872857, 4.974232>
}
#declare Bottle_Cap38 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior38 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid38 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle38 = difference {
  object { BottleExterior38 }
  object { BottleVoid38 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill38 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Basic_Gas
  }
  scale <0.845, 0.845, 0.92>
  translate  <-0.001193, 0.000022, 1.104413>
}
#declare SampleBottle_M_nitrogen = union {
  object { Bottle_Cap38 }
  object { GlassofSampleBottle38 }
  object { Bottlefill38 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <13.950274, 5.856056, 4.495943>
}
#declare Bottle_Cap39 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior39 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid39 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle39 = difference {
  object { BottleExterior39 }
  object { BottleVoid39 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill39 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group29 = difference {
  object { Bottlefill39 }
  box { // fill_cut_off29
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 3.691356, -0.0>
    translate  <1.54912, 0.404246, 10.657765>
  }
  material {
    Carbon_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_carbon = union {
  object { Bottle_Cap39 }
  object { GlassofSampleBottle39 }
  object { bottle_fill_group29 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <12.946506, 5.868678, 4.879157>
}
#declare Period_2_P = union {
  box { // Boron
    <-1, -1, -1>, <1, 1, 1>
    material {
      Boron_texture
    }
    scale <0.49, 0.49, 2.05>
    translate  <12.0, -1.0, 0.5>
  }
  box { // Carbon
    <-1, -1, -1>, <1, 1, 1>
    material {
      Carbon_texture
    }
    scale <0.49, 0.49, 5.33>
    translate  <13.0, -1.0, 0.5>
  }
  box { // Nitrogen
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Gas
    }
    scale <0.49, 0.49, 4.93>
    translate  <14.0, -1.0, 0.5>
  }
  box { // Oxygen
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Gas
    }
    scale <0.49, 0.49, 5.46>
    translate  <15.0, -1.0, 0.5>
  }
  box { // Fluorine
    <-1, -1, -1>, <1, 1, 1>
    material {
      Fluorine_texture
    }
    scale <0.49, 0.49, 2.94>
    translate  <16.0, -1.0, 0.5>
  }
  box { // Neon
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Gas
    }
    scale <0.49, 0.49, 5.04>
    translate  <17.0, -1.0, 0.5>
  }
  object { SampleBottle_M_fluorine }
  object { SampleBottle_M_neon }
  object { SampleBottle_M_boron }
  object { SampleBottle_M_oxygen }
  object { SampleBottle_M_nitrogen }
  object { SampleBottle_M_carbon }
}
#declare Row_2 = union {
  object { Period_2_S }
  object { Period_2_P }
  bounded_by { // Bound00005
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <9.431503, 0.924048, 7.627324>
      translate  <8.289047, -1.074845, 2.436774>
    }
  }
}
#declare Bottle_Cap48 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior48 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid48 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle48 = difference {
  object { BottleExterior48 }
  object { BottleVoid48 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill48 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group38 = difference {
  object { Bottlefill48 }
  box { // fill_cut_off38
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 20.528214, 0.0>
    translate  <1.379003, 0.404246, 8.961397>
  }
  material {
    Sodium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_sodium = union {
  object { Bottle_Cap48 }
  object { GlassofSampleBottle48 }
  object { bottle_fill_group38 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <-0.076472, 4.887342, 3.527497>
}
#declare Bottle_Cap49 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior49 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid49 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle49 = difference {
  object { BottleExterior49 }
  object { BottleVoid49 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill49 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group39 = difference {
  object { Bottlefill49 }
  box { // fill_cut_off39
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <13.471887, 2.631806, 0.630228>
    translate  <1.509658, 0.404246, 10.006639>
  }
  material {
    Magnesium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_magnesium = union {
  object { Bottle_Cap49 }
  object { GlassofSampleBottle49 }
  object { bottle_fill_group39 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <0.984179, 4.864614, 4.236818>
}
#declare Period_3_S = union {
  box { // Sodium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Sodium_texture
    }
    scale <0.49, 0.49, 3.99>
    translate  <0.0, -2.0, 0.5>
  }
  box { // Magnesium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Magnesium_texture
    }
    scale <0.49, 0.49, 4.72>
    translate  <1.0, -2.0, 0.5>
  }
  object { SampleBottle_M_sodium }
  object { SampleBottle_M_magnesium }
}
#declare Bottle_Cap14 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior14 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid14 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle14 = difference {
  object { BottleExterior14 }
  object { BottleVoid14 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill14 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Chlorine_texture
  }
  scale <0.845, 0.845, 0.92>
  translate  <-0.001193, 0.000022, 1.104413>
}
#declare SampleBottle_M_chlorine = union {
  object { Bottle_Cap14 }
  object { GlassofSampleBottle14 }
  object { Bottlefill14 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <15.892893, 4.857256, 2.978209>
}
#declare Bottle_Cap9 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior9 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid9 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle9 = difference {
  object { BottleExterior9 }
  object { BottleVoid9 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill9 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Basic_Gas
  }
  scale <0.845, 0.845, 0.92>
  translate  <-0.001193, 0.000022, 1.104413>
}
#declare SampleBottle_M_argon = union {
  object { Bottle_Cap9 }
  object { GlassofSampleBottle9 }
  object { Bottlefill9 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <16.988408, 4.838677, 3.710065>
}
#declare Bottle_Cap40 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior40 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid40 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle40 = difference {
  object { BottleExterior40 }
  object { BottleVoid40 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill40 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group30 = difference {
  object { Bottlefill40 }
  box { // fill_cut_off30
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 3.719858, -0.0>
    translate  <1.509658, 0.404246, 10.275155>
  }
  material {
    Aluminum_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_aluminum = union {
  object { Bottle_Cap40 }
  object { GlassofSampleBottle40 }
  object { bottle_fill_group30 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <11.966175, 4.863566, 3.516901>
}
#declare Bottle_Cap41 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior41 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid41 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle41 = difference {
  object { BottleExterior41 }
  object { BottleVoid41 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill41 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group31 = difference {
  object { Bottlefill41 }
  box { // fill_cut_off31
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <-0.0, -10.510787, -0.0>
    translate  <1.251622, 0.404246, 10.4367>
  }
  material {
    Silicon_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_silicon = union {
  object { Bottle_Cap41 }
  object { GlassofSampleBottle41 }
  object { bottle_fill_group31 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  rotate 0.46926*z
  translate  <12.883299, 4.853941, 4.234848>
}
#declare Bottle_Cap42 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior42 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid42 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle42 = difference {
  object { BottleExterior42 }
  object { BottleVoid42 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill42 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group32 = difference {
  object { Bottlefill42 }
  box { // fill_cut_off32
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <-0.0, -13.267199, -0.0>
    translate  <1.526861, 0.404246, 10.79795>
  }
  material {
    Phosphourous_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_phosphorus = union {
  object { Bottle_Cap42 }
  object { GlassofSampleBottle42 }
  object { bottle_fill_group32 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <13.932351, 4.844316, 3.645966>
}
#declare Bottle_Cap43 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior43 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid43 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle43 = difference {
  object { BottleExterior43 }
  object { BottleVoid43 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill43 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group33 = difference {
  object { Bottlefill43 }
  box { // fill_cut_off33
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 3.719858, -0.0>
    translate  <1.509658, 0.404246, 10.006639>
  }
  material {
    Sulfur_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_sulfur = union {
  object { Bottle_Cap43 }
  object { GlassofSampleBottle43 }
  object { bottle_fill_group33 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <14.990975, 4.847292, 4.084285>
}
#declare Period_3_P = union {
  box { // Aluminum
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum_texture
    }
    scale <0.49, 0.49, 4.09>
    translate  <12.0, -2.0, 0.5>
  }
  box { // Silicon
    <-1, -1, -1>, <1, 1, 1>
    material {
      Silicon_texture
    }
    scale <0.49, 0.49, 4.71>
    translate  <13.0, -2.0, 0.5>
  }
  box { // Phosphorus
    <-1, -1, -1>, <1, 1, 1>
    material {
      Phosphourous_texture
    }
    scale <0.49, 0.49, 4.14>
    translate  <14.0, -2.0, 0.5>
  }
  box { // Sulfur
    <-1, -1, -1>, <1, 1, 1>
    material {
      Sulfur_texture
    }
    scale <0.49, 0.49, 4.54>
    translate  <15.0, -2.0, 0.5>
  }
  box { // Chlorine
    <-1, -1, -1>, <1, 1, 1>
    material {
      Chlorine_texture
    }
    scale <0.49, 0.49, 3.39>
    translate  <16.0, -2.0, 0.5>
  }
  box { // Argon
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Gas
    }
    scale <0.49, 0.49, 4.14>
    translate  <17.0, -2.0, 0.5>
  }
  object { SampleBottle_M_chlorine }
  object { SampleBottle_M_argon }
  object { SampleBottle_M_aluminum }
  object { SampleBottle_M_silicon }
  object { SampleBottle_M_phosphorus }
  object { SampleBottle_M_sulfur }
}
#declare Row_3 = union {
  object { Period_3_S }
  object { Period_3_P }
  bounded_by { // Bound00006
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <9.452415, 1.037254, 6.868292>
      translate  <8.260123, -2.092782, 2.425754>
    }
  }
}
#declare Bottle_Cap50 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior50 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid50 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle50 = difference {
  object { BottleExterior50 }
  object { BottleVoid50 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill50 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group40 = difference {
  object { Bottlefill50 }
  box { // fill_cut_off40
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <164.147186, -194.368805, 175.96904>
    translate  <1.509658, 0.404246, 10.006639>
  }
  material {
    Potassium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_potassium = union {
  object { Bottle_Cap50 }
  object { GlassofSampleBottle50 }
  object { bottle_fill_group40 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <-0.044141, 3.845026, 2.852364>
}
#declare Bottle_Cap51 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior51 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid51 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle51 = difference {
  object { BottleExterior51 }
  object { BottleVoid51 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill51 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group41 = difference {
  object { Bottlefill51 }
  box { // fill_cut_off41
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <171.511765, -180.332474, 176.843216>
    translate  <1.509658, 0.404246, 10.52926>
  }
  material {
    Calcium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_calcium = union {
  object { Bottle_Cap51 }
  object { GlassofSampleBottle51 }
  object { bottle_fill_group41 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <0.979418, 3.816151, 3.489534>
}
#declare Period_4_S = union {
  box { // Potassium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Potassium_texture
    }
    scale <0.49, 0.49, 3.31>
    translate  <0.0, -3.0, 0.5>
  }
  box { // Calcium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Calcium_texture
    }
    scale <0.49, 0.49, 4.01>
    translate  <1.0, -3.0, 0.5>
  }
  object { SampleBottle_M_potassium }
  object { SampleBottle_M_calcium }
}
#declare Bottle_Cap7 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior7 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid7 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle7 = difference {
  object { BottleExterior7 }
  object { BottleVoid7 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill7 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group6 = difference {
  object { Bottlefill7 }
  box { // fill_cut_off6
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 11.735848>
  }
  material {
    Copper_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_copper = union {
  object { Bottle_Cap7 }
  object { GlassofSampleBottle7 }
  object { bottle_fill_group6 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <9.976782, 3.856513, 2.371907>
}
#declare Bottle_Cap18 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior18 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid18 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle18 = difference {
  object { BottleExterior18 }
  object { BottleVoid18 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill18 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group10 = difference {
  object { Bottlefill18 }
  box { // fill_cut_off10
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 11.735848>
  }
  material {
    Iron__rusty__texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_iron = union {
  object { Bottle_Cap18 }
  object { GlassofSampleBottle18 }
  object { bottle_fill_group10 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <6.953054, 3.856436, 4.250273>
}
#declare Bottle_Cap19 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior19 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid19 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle19 = difference {
  object { BottleExterior19 }
  object { BottleVoid19 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill19 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group11 = difference {
  object { Bottlefill19 }
  box { // fill_cut_off11
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 11.735848>
  }
  material {
    Cobalt_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_cobalt = union {
  object { Bottle_Cap19 }
  object { GlassofSampleBottle19 }
  object { bottle_fill_group11 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <7.950455, 3.849101, 2.698718>
}
#declare Bottle_Cap20 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior20 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid20 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle20 = difference {
  object { BottleExterior20 }
  object { BottleVoid20 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill20 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group12 = difference {
  object { Bottlefill20 }
  box { // fill_cut_off12
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <8.974195, -4.920928, -0.052038>
    translate  <1.639577, 0.404246, 11.735848>
  }
  material {
    Nickel_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_nickel = union {
  object { Bottle_Cap20 }
  object { GlassofSampleBottle20 }
  object { bottle_fill_group12 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <8.953124, 3.852155, 3.490507>
}
#declare Bottle_Cap21 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior21 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid21 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle21 = difference {
  object { BottleExterior21 }
  object { BottleVoid21 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill21 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group13 = difference {
  object { Bottlefill21 }
  box { // fill_cut_off13
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-5.131889, -6.298856, 0.024833>
    translate  <1.639577, 0.404246, 11.735848>
  }
  material {
    Zinc_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_zinc = union {
  object { Bottle_Cap21 }
  object { GlassofSampleBottle21 }
  object { bottle_fill_group13 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <10.966278, 3.841701, 2.546572>
}
#declare Bottle_Cap22 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior22 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid22 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle22 = difference {
  object { BottleExterior22 }
  object { BottleVoid22 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill22 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group14 = difference {
  object { Bottlefill22 }
  box { // fill_cut_off14
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 11.735848>
  }
  material {
    Manganese_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_manganese = union {
  object { Bottle_Cap22 }
  object { GlassofSampleBottle22 }
  object { bottle_fill_group14 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <5.966789, 3.848977, 3.083402>
}
#declare Bottle_Cap23 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior23 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid23 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle23 = difference {
  object { BottleExterior23 }
  object { BottleVoid23 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill23 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group15 = difference {
  object { Bottlefill23 }
  box { // fill_cut_off15
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 11.735848>
  }
  material {
    Chrome_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_chromium = union {
  object { Bottle_Cap23 }
  object { GlassofSampleBottle23 }
  object { bottle_fill_group15 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <4.978909, 3.869373, 3.179134>
}
#declare Bottle_Cap24 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior24 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid24 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle24 = difference {
  object { BottleExterior24 }
  object { BottleVoid24 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill24 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group16 = difference {
  object { Bottlefill24 }
  box { // fill_cut_off16
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <10.792395, -6.421577, 0.872236>
    translate  <1.639577, 0.404246, 11.129546>
  }
  material {
    Vanadium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_vanadium = union {
  object { Bottle_Cap24 }
  object { GlassofSampleBottle24 }
  object { bottle_fill_group16 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <3.947604, 3.848977, 2.221816>
}
#declare Bottle_Cap25 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior25 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid25 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle25 = difference {
  object { BottleExterior25 }
  object { BottleVoid25 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill25 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group17 = difference {
  object { Bottlefill25 }
  box { // fill_cut_off17
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 11.735848>
  }
  material {
    Titanium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_titanium = union {
  object { Bottle_Cap25 }
  object { GlassofSampleBottle25 }
  object { bottle_fill_group17 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <2.982754, 3.848977, 2.732386>
}
#declare Bottle_Cap26 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior26 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid26 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle26 = difference {
  object { BottleExterior26 }
  object { BottleVoid26 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill26 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group18 = difference {
  object { Bottlefill26 }
  box { // fill_cut_off18
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 11.735848>
  }
  material {
    Scandium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_scandium = union {
  object { Bottle_Cap26 }
  object { GlassofSampleBottle26 }
  object { bottle_fill_group18 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <1.884994, 3.869373, 1.711247>
}
#declare Period_4_D = union {
  box { // Scandium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Scandium_texture
    }
    scale <0.49, 0.49, 2.13>
    translate  <2.0, -3.0, 0.5>
  }
  box { // Titanium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Titanium_texture
    }
    scale <0.49, 0.49, 3.2>
    translate  <3.0, -3.0, 0.5>
  }
  box { // Vanadium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Vanadium_texture
    }
    scale <0.49, 0.49, 2.67>
    translate  <4.0, -3.0, 0.5>
  }
  box { // Chromium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Chrome_texture
    }
    scale <0.49, 0.49, 3.63>
    translate  <5.0, -3.0, 0.5>
  }
  box { // Manganese
    <-1, -1, -1>, <1, 1, 1>
    material {
      Manganese_texture
    }
    scale <0.49, 0.49, 3.54>
    translate  <6.0, -3.0, 0.5>
  }
  box { // Iron
    <-1, -1, -1>, <1, 1, 1>
    material {
      Iron__rusty__texture
    }
    scale <0.49, 0.49, 4.68>
    translate  <7.0, -3.0, 0.5>
  }
  box { // Cobalt
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cobalt_texture
    }
    scale <0.49, 0.49, 3.18>
    translate  <8.0, -3.0, 0.5>
  }
  box { // Nickel
    <-1, -1, -1>, <1, 1, 1>
    material {
      Nickel_texture
    }
    scale <0.49, 0.49, 3.95>
    translate  <9.0, -3.0, 0.5>
  }
  box { // Copper
    <-1, -1, -1>, <1, 1, 1>
    material {
      Copper_texture
    }
    scale <0.49, 0.49, 2.81>
    translate  <10.0, -3.0, 0.5>
  }
  box { // Zinc
    <-1, -1, -1>, <1, 1, 1>
    material {
      Zinc_texture
    }
    scale <0.49, 0.49, 3.04>
    translate  <11.0, -3.0, 0.5>
  }
  object { SampleBottle_M_copper }
  object { SampleBottle_M_iron }
  object { SampleBottle_M_cobalt }
  object { SampleBottle_M_nickel }
  object { SampleBottle_M_zinc }
  object { SampleBottle_M_manganese }
  object { SampleBottle_M_chromium }
  object { SampleBottle_M_vanadium }
  object { SampleBottle_M_titanium }
  object { SampleBottle_M_scandium }
}
#declare Bottle_Cap10 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior10 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid10 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle10 = difference {
  object { BottleExterior10 }
  object { BottleVoid10 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill10 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Basic_Gas
  }
  scale <0.845, 0.845, 0.92>
  translate  <-0.001193, 0.000022, 1.104413>
}
#declare SampleBottle_M_krypton = union {
  object { Bottle_Cap10 }
  object { GlassofSampleBottle10 }
  object { Bottlefill10 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <17.003131, 3.871602, 1.751292>
}
#declare Bottle_Cap15 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior15 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid15 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle15 = difference {
  object { BottleExterior15 }
  object { BottleVoid15 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill15 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group7 = difference {
  object { Bottlefill15 }
  box { // fill_cut_off7
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.618644, 0.404246, 11.350276>
  }
  material {
    Bromine_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_bromine = union {
  object { Bottle_Cap15 }
  object { GlassofSampleBottle15 }
  object { bottle_fill_group7 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <15.977018, 3.834282, 1.438056>
}
#declare Bottle_Cap44 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior44 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid44 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle44 = difference {
  object { BottleExterior44 }
  object { BottleVoid44 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill44 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group34 = difference {
  object { Bottlefill44 }
  box { // fill_cut_off34
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 3.719858, -0.0>
    translate  <1.469811, 0.404246, 9.448779>
  }
  material {
    Selenium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_selenium = union {
  object { Bottle_Cap44 }
  object { GlassofSampleBottle44 }
  object { bottle_fill_group34 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <14.934956, 3.876769, 1.802845>
}
#declare Bottle_Cap45 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior45 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid45 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle45 = difference {
  object { BottleExterior45 }
  object { BottleVoid45 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill45 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group35 = difference {
  object { Bottlefill45 }
  box { // fill_cut_off35
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <-0.0, -8.270267, -0.0>
    translate  <1.509658, 0.404246, 9.249544>
  }
  material {
    Arsenic_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_arsenic = union {
  object { Bottle_Cap45 }
  object { GlassofSampleBottle45 }
  object { bottle_fill_group35 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <13.950638, 3.883042, 1.270203>
}
#declare Bottle_Cap46 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior46 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid46 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle46 = difference {
  object { BottleExterior46 }
  object { BottleVoid46 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill46 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group36 = difference {
  object { Bottlefill46 }
  box { // fill_cut_off36
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 3.719858, -0.0>
    translate  <1.476356, 0.404246, 9.607013>
  }
  material {
    Germanium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_germanium = union {
  object { Bottle_Cap46 }
  object { GlassofSampleBottle46 }
  object { bottle_fill_group36 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <12.954525, 3.878444, 1.969549>
}
#declare Bottle_Cap47 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior47 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid47 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle47 = difference {
  object { BottleExterior47 }
  object { BottleVoid47 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill47 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group37 = difference {
  object { Bottlefill47 }
  box { // fill_cut_off37
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <6.885478, -10.047553, -1.206916>
    translate  <1.459705, 0.404246, 9.740222>
  }
  material {
    Gallium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_gallium = union {
  object { Bottle_Cap47 }
  object { GlassofSampleBottle47 }
  object { bottle_fill_group37 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <11.940855, 3.851245, 1.653178>
}
#declare Period_4_P = union {
  box { // Gallium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Gallium_texture
    }
    scale <0.49, 0.49, 2.16>
    translate  <12.0, -3.0, 0.5>
  }
  box { // Germanium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Germanium_texture
    }
    scale <0.49, 0.49, 2.44>
    translate  <13.0, -3.0, 0.5>
  }
  box { // Arsenic
    <-1, -1, -1>, <1, 1, 1>
    material {
      Arsenic_texture
    }
    scale <0.49, 0.49, 1.73>
    translate  <14.0, -3.0, 0.5>
  }
  box { // Selenium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Selenium_texture
    }
    scale <0.49, 0.49, 2.28>
    translate  <15.0, -3.0, 0.5>
  }
  box { // Bromine
    <-1, -1, -1>, <1, 1, 1>
    material {
      Bromine_texture
    }
    scale <0.49, 0.49, 1.87>
    translate  <16.0, -3.0, 0.5>
  }
  box { // Krypton
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Gas
    }
    scale <0.49, 0.49, 2.21>
    translate  <17.0, -3.0, 0.5>
  }
  object { SampleBottle_M_krypton }
  object { SampleBottle_M_bromine }
  object { SampleBottle_M_selenium }
  object { SampleBottle_M_arsenic }
  object { SampleBottle_M_germanium }
  object { SampleBottle_M_gallium }
}
#declare Row_4 = union {
  object { Period_4_S }
  object { Period_4_D }
  object { Period_4_P }
  bounded_by { // Bound00007
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <9.395882, 1.836333, 8.050587>
      translate  <8.341334, -3.108419, 3.623371>
    }
  }
}
#declare Bottle_Cap52 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior52 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid52 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle52 = difference {
  object { BottleExterior52 }
  object { BottleVoid52 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill52 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group42 = difference {
  object { Bottlefill52 }
  box { // fill_cut_off42
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 20.528214, 0.0>
    translate  <1.509658, 0.404246, 10.006639>
  }
  material {
    Rubidium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_rubidium = union {
  object { Bottle_Cap52 }
  object { GlassofSampleBottle52 }
  object { bottle_fill_group42 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <-0.100164, 2.853908, 1.26512>
}
#declare Bottle_Cap53 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior53 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid53 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle53 = difference {
  object { BottleExterior53 }
  object { BottleVoid53 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill53 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group43 = difference {
  object { Bottlefill53 }
  box { // fill_cut_off43
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <-8.306, 0.632121, -0.092282>
    translate  <1.509658, 0.404246, 10.006639>
  }
  material {
    Strontium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_strontium = union {
  object { Bottle_Cap53 }
  object { GlassofSampleBottle53 }
  object { bottle_fill_group43 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <0.97605, 2.847357, 1.566572>
}
#declare Period_5_S = union {
  box { // Rubidium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rubidium_texture
    }
    scale <0.49, 0.49, 1.74>
    translate  <0.0, -4.0, 0.5>
  }
  box { // Strontium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Strontium_texture
    }
    scale <0.49, 0.49, 2.04>
    translate  <1.0, -4.0, 0.5>
  }
  object { SampleBottle_M_rubidium }
  object { SampleBottle_M_strontium }
}
#declare Bottle_Cap6 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior6 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid6 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle6 = difference {
  object { BottleExterior6 }
  object { BottleVoid6 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill6 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group5 = difference {
  object { Bottlefill6 }
  box { // fill_cut_off5
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <5.820583, 8.544947, 0.867774>
    translate  <1.551942, 0.404246, 11.166222>
  }
  material {
    Silver_Texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_silver = union {
  object { Bottle_Cap6 }
  object { GlassofSampleBottle6 }
  object { bottle_fill_group5 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <9.956813, 2.855235, 0.5992>
}
#declare Bottle_Cap27 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior27 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid27 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle27 = difference {
  object { BottleExterior27 }
  object { BottleVoid27 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill27 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group19 = difference {
  object { Bottlefill27 }
  box { // fill_cut_off19
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.56447, 0.404246, 11.134994>
  }
  material {
    Ruthenium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_ruthenium = union {
  object { Bottle_Cap27 }
  object { GlassofSampleBottle27 }
  object { bottle_fill_group19 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <6.972869, 2.83194, 0.956775>
}
#declare Bottle_Cap28 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior28 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid28 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle28 = difference {
  object { BottleExterior28 }
  object { BottleVoid28 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill28 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group20 = difference {
  object { Bottlefill28 }
  box { // fill_cut_off20
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 11.059887>
  }
  material {
    Rhodium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_rhodium = union {
  object { Bottle_Cap28 }
  object { GlassofSampleBottle28 }
  object { bottle_fill_group20 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <7.927471, 2.811544, 0.512681>
}
#declare Bottle_Cap29 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior29 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid29 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle29 = difference {
  object { BottleExterior29 }
  object { BottleVoid29 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill29 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group21 = difference {
  object { Bottlefill29 }
  box { // fill_cut_off21
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 11.2101>
  }
  material {
    Palladium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_palladium = union {
  object { Bottle_Cap29 }
  object { GlassofSampleBottle29 }
  object { bottle_fill_group21 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <8.986252, 2.837043, 0.836656>
}
#declare Bottle_Cap30 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior30 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid30 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle30 = difference {
  object { BottleExterior30 }
  object { BottleVoid30 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill30 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group22 = difference {
  object { Bottlefill30 }
  box { // fill_cut_off22
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 11.134994>
  }
  material {
    Cadmium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_cadmium = union {
  object { Bottle_Cap30 }
  object { GlassofSampleBottle30 }
  object { bottle_fill_group22 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <10.959033, 2.83194, 0.879679>
}
#declare Bottle_Cap31 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior31 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid31 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle31 = difference {
  object { BottleExterior31 }
  object { BottleVoid31 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill31 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group23 = difference {
  object { Bottlefill31 }
  box { // fill_cut_off23
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.621891, 0.404246, 10.615858>
  }
  material {
    Technetium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_technetium = union {
  object { Bottle_Cap31 }
  object { GlassofSampleBottle31 }
  object { bottle_fill_group23 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <5.967809, 2.83194, -0.390954>
}
#declare Bottle_Cap32 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior32 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid32 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle32 = difference {
  object { BottleExterior32 }
  object { BottleVoid32 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill32 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group24 = difference {
  object { Bottlefill32 }
  box { // fill_cut_off24
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 11.059887>
  }
  material {
    Molybdenum_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_molybdenum = union {
  object { Bottle_Cap32 }
  object { GlassofSampleBottle32 }
  object { bottle_fill_group24 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <4.949269, 2.866889, 0.995178>
}
#declare Bottle_Cap33 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior33 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid33 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle33 = difference {
  object { BottleExterior33 }
  object { BottleVoid33 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill33 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group25 = difference {
  object { Bottlefill33 }
  box { // fill_cut_off25
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.404246, 10.98478>
  }
  material {
    Niobium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_niobium = union {
  object { Bottle_Cap33 }
  object { GlassofSampleBottle33 }
  object { bottle_fill_group25 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <3.932431, 2.849414, 0.698057>
}
#declare Bottle_Cap34 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior34 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid34 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle34 = difference {
  object { BottleExterior34 }
  object { BottleVoid34 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill34 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group26 = difference {
  object { Bottlefill34 }
  box { // fill_cut_off26
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.32914, 11.134994>
  }
  material {
    Zirconium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_zirconium = union {
  object { Bottle_Cap34 }
  object { GlassofSampleBottle34 }
  object { bottle_fill_group26 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <2.925538, 2.854166, 1.373726>
}
#declare Bottle_Cap35 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior35 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid35 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle35 = difference {
  object { BottleExterior35 }
  object { BottleVoid35 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill35 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group27 = difference {
  object { Bottlefill35 }
  box { // fill_cut_off27
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <3.060524, 3.017721, 0.458999>
    translate  <1.639577, 0.178926, 10.909673>
  }
  material {
    Yittrium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_yttrium = union {
  object { Bottle_Cap35 }
  object { GlassofSampleBottle35 }
  object { bottle_fill_group27 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <1.946402, 2.888024, 1.153796>
}
#declare Period_5_D = union {
  box { // Yttrium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Yittrium_texture
    }
    scale <0.49, 0.49, 1.64>
    translate  <2.0, -4.0, 0.5>
  }
  box { // Zirconium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Zirconium_texture
    }
    scale <0.49, 0.49, 1.85>
    translate  <3.0, -4.0, 0.5>
  }
  box { // Niobium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Niobium_texture
    }
    scale <0.49, 0.49, 1.17>
    translate  <4.0, -4.0, 0.5>
  }
  box { // Molybdenum
    <-1, -1, -1>, <1, 1, 1>
    material {
      Molybdenum_texture
    }
    scale <0.49, 0.49, 1.48>
    translate  <5.0, -4.0, 0.5>
  }
  box { // Technetium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Technetium_texture
    }
    scale <0.49, 0.49, 0.1>
    translate  <6.0, -4.0, 0.5>
  }
  box { // Ruthenium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Ruthenium_texture
    }
    scale <0.49, 0.49, 1.41>
    translate  <7.0, -4.0, 0.5>
  }
  box { // Rhodium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rhodium_texture
    }
    scale <0.49, 0.49, 0.99>
    translate  <8.0, -4.0, 0.5>
  }
  box { // Palladium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Palladium_texture
    }
    scale <0.49, 0.49, 1.33>
    translate  <9.0, -4.0, 0.5>
  }
  box { // Silver
    <-1, -1, -1>, <1, 1, 1>
    material {
      Silver_Texture
    }
    scale <0.49, 0.49, 1.09>
    translate  <10.0, -4.0, 0.5>
  }
  box { // Cadmium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cadmium_texture
    }
    scale <0.49, 0.49, 1.38>
    translate  <11.0, -4.0, 0.5>
  }
  object { SampleBottle_M_silver }
  object { SampleBottle_M_ruthenium }
  object { SampleBottle_M_rhodium }
  object { SampleBottle_M_palladium }
  object { SampleBottle_M_cadmium }
  object { SampleBottle_M_technetium }
  object { SampleBottle_M_molybdenum }
  object { SampleBottle_M_niobium }
  object { SampleBottle_M_zirconium }
  object { SampleBottle_M_yttrium }
}
#declare Bottle_Cap11 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior11 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid11 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle11 = difference {
  object { BottleExterior11 }
  object { BottleVoid11 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill11 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Basic_Gas
  }
  scale <0.845, 0.845, 0.92>
  translate  <-0.001193, 0.000022, 1.104413>
}
#declare SampleBottle_M_xenon = union {
  object { Bottle_Cap11 }
  object { GlassofSampleBottle11 }
  object { Bottlefill11 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <17.083308, 2.877792, 1.150879>
}
#declare Bottle_Cap16 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior16 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid16 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle16 = difference {
  object { BottleExterior16 }
  object { BottleVoid16 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill16 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group8 = difference {
  object { Bottlefill16 }
  box { // fill_cut_off8
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-2.502192, -5.710674, 0.249138>
    translate  <1.685346, 0.404246, 10.883361>
  }
  material {
    Iodine_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_iodine = union {
  object { Bottle_Cap16 }
  object { GlassofSampleBottle16 }
  object { bottle_fill_group8 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <15.959196, 2.914658, 0.749401>
}
#declare Bottle_Cap58 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior58 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid58 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle58 = difference {
  object { BottleExterior58 }
  object { BottleVoid58 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill58 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group48 = difference {
  object { Bottlefill58 }
  box { // fill_cut_off48
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <7.000885, 8.525481, 1.042957>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Indium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_indium = union {
  object { Bottle_Cap58 }
  object { GlassofSampleBottle58 }
  object { bottle_fill_group48 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <11.956667, 2.861793, 0.34238>
}
#declare Bottle_Cap59 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior59 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid59 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle59 = difference {
  object { BottleExterior59 }
  object { BottleVoid59 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill59 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group49 = difference {
  object { Bottlefill59 }
  box { // fill_cut_off49
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-8.940441, -2.349772, -1.353988>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Tin_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_tin = union {
  object { Bottle_Cap59 }
  object { GlassofSampleBottle59 }
  object { bottle_fill_group49 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <12.966971, 2.861519, 1.109373>
}
#declare Bottle_Cap60 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior60 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid60 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle60 = difference {
  object { BottleExterior60 }
  object { BottleVoid60 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill60 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group50 = difference {
  object { Bottlefill60 }
  box { // fill_cut_off50
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-12.085333, 1.523564, 0.56762>
    translate  <1.551942, 0.404246, 10.662434>
  }
  material {
    Antimony_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_antimony = union {
  object { Bottle_Cap60 }
  object { GlassofSampleBottle60 }
  object { bottle_fill_group50 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <13.963561, 2.886469, 0.495819>
}
#declare Bottle_Cap61 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior61 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid61 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle61 = difference {
  object { BottleExterior61 }
  object { BottleVoid61 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill61 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group51 = difference {
  object { Bottlefill61 }
  box { // fill_cut_off51
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <7.000885, 8.525481, 1.042957>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Tellurium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_tellurium = union {
  object { Bottle_Cap61 }
  object { GlassofSampleBottle61 }
  object { bottle_fill_group51 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <14.971189, 2.911418, 1.154736>
}
#declare Period_5_P = union {
  box { // Indium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Indium_texture
    }
    scale <0.49, 0.49, 0.83>
    translate  <12.0, -4.0, 0.5>
  }
  box { // Tin
    <-1, -1, -1>, <1, 1, 1>
    material {
      Tin_texture
    }
    scale <0.49, 0.49, 1.59>
    translate  <13.0, -4.0, 0.5>
  }
  box { // Antimony
    <-1, -1, -1>, <1, 1, 1>
    material {
      Antimony_texture
    }
    scale <0.49, 0.49, 0.99>
    translate  <14.0, -4.0, 0.5>
  }
  box { // Tellurium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Tellurium_texture
    }
    scale <0.49, 0.49, 1.65>
    translate  <15.0, -4.0, 0.5>
  }
  box { // Iodine
    <-1, -1, -1>, <1, 1, 1>
    material {
      Iodine_texture
    }
    scale <0.49, 0.49, 1.23>
    translate  <16.0, -4.0, 0.5>
  }
  box { // Xenon
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Gas
    }
    scale <0.49, 0.49, 1.62>
    translate  <17.0, -4.0, 0.5>
  }
  object { SampleBottle_M_xenon }
  object { SampleBottle_M_iodine }
  object { SampleBottle_M_indium }
  object { SampleBottle_M_tin }
  object { SampleBottle_M_antimony }
  object { SampleBottle_M_tellurium }
}
#declare Row_5 = union {
  object { Period_5_S }
  object { Period_5_D }
  object { Period_5_P }
  bounded_by { // Bound00008
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <9.461165, 1.812347, 4.952698>
      translate  <8.347229, -4.070928, 3.20467>
    }
  }
}
#declare Bottle_Cap54 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior54 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid54 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle54 = difference {
  object { BottleExterior54 }
  object { BottleVoid54 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill54 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group44 = difference {
  object { Bottlefill54 }
  box { // fill_cut_off44
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 20.528214, 0.0>
    translate  <1.509658, 0.404246, 10.006639>
  }
  material {
    Cesium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_cesium = union {
  object { Bottle_Cap54 }
  object { GlassofSampleBottle54 }
  object { bottle_fill_group44 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <-0.056545, 1.878967, 0.517842>
}
#declare Bottle_Cap55 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior55 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid55 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle55 = difference {
  object { BottleExterior55 }
  object { BottleVoid55 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill55 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group45 = difference {
  object { Bottlefill55 }
  box { // fill_cut_off45
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <172.674606, -184.009491, 177.3293>
    translate  <1.509658, 0.404246, 10.006639>
  }
  material {
    Barium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_barium = union {
  object { Bottle_Cap55 }
  object { GlassofSampleBottle55 }
  object { bottle_fill_group45 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <0.983063, 1.843541, 1.101112>
}
#declare Period_6_S = union {
  box { // Cesium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cesium_texture
    }
    scale <0.49, 0.49, 1.01>
    translate  <0.0, -5.0, 0.5>
  }
  box { // Barium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Barium_texture
    }
    scale <0.49, 0.49, 1.62>
    translate  <1.0, -5.0, 0.5>
  }
  object { SampleBottle_M_cesium }
  object { SampleBottle_M_barium }
}
#declare Bottle_Cap5 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior5 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid5 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle5 = difference {
  object { BottleExterior5 }
  object { BottleVoid5 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill5 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group4 = difference {
  object { Bottlefill5 }
  box { // fill_cut_off4
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <7.000885, 8.525481, 1.042957>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Gold_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_gold = union {
  object { Bottle_Cap5 }
  object { GlassofSampleBottle5 }
  object { bottle_fill_group4 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <9.958482, 1.80107, 0.34659>
}
#declare Bottle_Cap78 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior78 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid78 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle78 = difference {
  object { BottleExterior78 }
  object { BottleVoid78 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill78 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group68 = difference {
  object { Bottlefill78 }
  box { // fill_cut_off68
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <7.000885, 8.525481, 1.042957>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Gold_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_hafnium = union {
  object { Bottle_Cap78 }
  object { GlassofSampleBottle78 }
  object { bottle_fill_group68 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <2.794398, 1.861295, 0.29659>
}
#declare Bottle_Cap72 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior72 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid72 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle72 = difference {
  object { BottleExterior72 }
  object { BottleVoid72 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill72 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group62 = difference {
  object { Bottlefill72 }
  box { // fill_cut_off62
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <7.000885, 8.525481, 1.042957>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Tantalum_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_tantalum = union {
  object { Bottle_Cap72 }
  object { GlassofSampleBottle72 }
  object { bottle_fill_group62 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <3.935, 1.86952, -0.152156>
}
#declare Bottle_Cap71 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior71 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid71 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle71 = difference {
  object { BottleExterior71 }
  object { BottleVoid71 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill71 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group61 = difference {
  object { Bottlefill71 }
  box { // fill_cut_off61
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-7.856738, -0.265137, 1.135876>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Tungsten_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_tungsten = union {
  object { Bottle_Cap71 }
  object { GlassofSampleBottle71 }
  object { bottle_fill_group61 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <4.959651, 1.852796, 0.273577>
}
#declare Bottle_Cap70 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior70 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid70 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle70 = difference {
  object { BottleExterior70 }
  object { BottleVoid70 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill70 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group60 = difference {
  object { Bottlefill70 }
  box { // fill_cut_off60
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <7.000885, 8.525481, 1.042957>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Rhenium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_rhenium = union {
  object { Bottle_Cap70 }
  object { GlassofSampleBottle70 }
  object { bottle_fill_group60 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <5.975754, 1.853069, -0.002574>
}
#declare Bottle_Cap69 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior69 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid69 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle69 = difference {
  object { BottleExterior69 }
  object { BottleVoid69 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill69 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group59 = difference {
  object { Bottlefill69 }
  box { // fill_cut_off59
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <6.876393, 1.673696, 1.031871>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Osmium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_osmium = union {
  object { Bottle_Cap69 }
  object { GlassofSampleBottle69 }
  object { bottle_fill_group59 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <6.971034, 1.853343, 0.687804>
}
#declare Bottle_Cap68 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior68 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid68 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle68 = difference {
  object { BottleExterior68 }
  object { BottleVoid68 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill68 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group58 = difference {
  object { Bottlefill68 }
  box { // fill_cut_off58
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <7.000885, 8.525481, 1.042957>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Iridium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_iridium = union {
  object { Bottle_Cap68 }
  object { GlassofSampleBottle68 }
  object { bottle_fill_group58 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <7.957292, 1.86952, 0.676298>
}
#declare Bottle_Cap67 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior67 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid67 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle67 = difference {
  object { BottleExterior67 }
  object { BottleVoid67 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill67 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group57 = difference {
  object { Bottlefill67 }
  box { // fill_cut_off57
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <7.000885, 8.525481, 1.042957>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Platinum_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_platnium = union {
  object { Bottle_Cap67 }
  object { GlassofSampleBottle67 }
  object { bottle_fill_group57 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <8.954759, 1.861568, 0.837386>
}
#declare Bottle_Cap66 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior66 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid66 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle66 = difference {
  object { BottleExterior66 }
  object { BottleVoid66 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill66 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group56 = difference {
  object { Bottlefill66 }
  box { // fill_cut_off56
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.551942, 0.404246, 11.48636>
  }
  material {
    Mercury_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_mercury = union {
  object { Bottle_Cap66 }
  object { GlassofSampleBottle66 }
  object { bottle_fill_group56 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <10.940125, 1.85389, 0.60726>
}
#declare Period_6_D = union {
  box { // Hafnium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Hafnium_texture
    }
    scale <0.49, 0.49, 0.82>
    translate  <3.0, -5.0, 0.5>
  }
  box { // Tantalum
    <-1, -1, -1>, <1, 1, 1>
    material {
      Tantalum_texture
    }
    scale <0.49, 0.49, 0.31>
    translate  <4.0, -5.0, 0.5>
  }
  box { // Tungsten
    <-1, -1, -1>, <1, 1, 1>
    material {
      Tungsten_texture
    }
    scale <0.49, 0.49, 0.76>
    translate  <5.0, -5.0, 0.5>
  }
  box { // Rhenium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Rhenium_texture
    }
    scale <0.49, 0.49, 0.51>
    translate  <6.0, -5.0, 0.5>
  }
  box { // Osmium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Osmium_texture
    }
    scale <0.49, 0.49, 1.17>
    translate  <7.0, -5.0, 0.5>
  }
  box { // Iridium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Iridium_texture
    }
    scale <0.49, 0.49, 1.15>
    translate  <8.0, -5.0, 0.5>
  }
  box { // Platinium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Platinum_texture
    }
    scale <0.49, 0.49, 1.33>
    translate  <9.0, -5.0, 0.5>
  }
  box { // Gold
    <-1, -1, -1>, <1, 1, 1>
    material {
      Gold_texture
    }
    scale <0.49, 0.49, 0.83>
    translate  <10.0, -5.0, 0.5>
  }
  box { // Mercury
    <-1, -1, -1>, <1, 1, 1>
    material {
      Mercury_texture
    }
    scale <0.49, 0.49, 1.09>
    translate  <11.0, -5.0, 0.5>
  }
  object { SampleBottle_M_gold }
  object { SampleBottle_M_hafnium }
  object { SampleBottle_M_tantalum }
  object { SampleBottle_M_tungsten }
  object { SampleBottle_M_rhenium }
  object { SampleBottle_M_osmium }
  object { SampleBottle_M_iridium }
  object { SampleBottle_M_platnium }
  object { SampleBottle_M_mercury }
}
#declare Bottle_Cap12 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior12 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid12 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle12 = difference {
  object { BottleExterior12 }
  object { BottleVoid12 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill12 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Basic_Gas
  }
  scale <0.845, 0.845, 0.92>
  translate  <-0.001193, 0.000022, 1.104413>
}
#declare SampleBottle_M_radon = union {
  object { Bottle_Cap12 }
  object { GlassofSampleBottle12 }
  object { Bottlefill12 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <17.052181, 1.889744, -0.400138>
}
#declare Bottle_Cap17 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior17 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid17 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle17 = difference {
  object { BottleExterior17 }
  object { BottleVoid17 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill17 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group9 = difference {
  object { Bottlefill17 }
  box { // fill_cut_off9
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-2.466747, 2.460977, 0.24813>
    translate  <1.685346, 0.404246, 10.54985>
  }
  material {
    Astatine_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_astatine = union {
  object { Bottle_Cap17 }
  object { GlassofSampleBottle17 }
  object { bottle_fill_group9 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <15.945657, 1.876689, -0.387708>
}
#declare Bottle_Cap65 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior65 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid65 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle65 = difference {
  object { BottleExterior65 }
  object { BottleVoid65 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill65 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group55 = difference {
  object { Bottlefill65 }
  box { // fill_cut_off55
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <7.000885, 8.525481, 1.042957>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Thallium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_thallium = union {
  object { Bottle_Cap65 }
  object { GlassofSampleBottle65 }
  object { bottle_fill_group55 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <11.94338, 1.852522, 0.354121>
}
#declare Bottle_Cap64 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior64 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid64 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle64 = difference {
  object { BottleExterior64 }
  object { BottleVoid64 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill64 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group54 = difference {
  object { Bottlefill64 }
  box { // fill_cut_off54
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-10.36331, -2.621719, 1.889828>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Lead_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_lead = union {
  object { Bottle_Cap64 }
  object { GlassofSampleBottle64 }
  object { bottle_fill_group54 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <12.957845, 1.86952, 1.067512>
}
#declare Bottle_Cap63 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior63 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid63 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle63 = difference {
  object { BottleExterior63 }
  object { BottleVoid63 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill63 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group53 = difference {
  object { Bottlefill63 }
  box { // fill_cut_off53
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <7.000885, 8.525481, 1.042957>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Bismuth_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_bismuth = union {
  object { Bottle_Cap63 }
  object { GlassofSampleBottle63 }
  object { bottle_fill_group53 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <13.947657, 1.852522, 0.289179>
}
#declare Bottle_Cap62 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior62 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid62 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle62 = difference {
  object { BottleExterior62 }
  object { BottleVoid62 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill62 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group52 = difference {
  object { Bottlefill62 }
  box { // fill_cut_off52
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-12.590596, 0.251274, 1.005102>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Polonium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_polonium = union {
  object { Bottle_Cap62 }
  object { GlassofSampleBottle62 }
  object { bottle_fill_group52 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <14.971189, 1.870615, -0.401901>
}
#declare Period_6_P = union {
  box { // Thallium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Thallium_texture
    }
    scale <0.49, 0.49, 0.83>
    translate  <12.0, -5.0, 0.5>
  }
  box { // Lead
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lead_texture
    }
    scale <0.49, 0.49, 1.54>
    translate  <13.0, -5.0, 0.5>
  }
  box { // Bismuth
    <-1, -1, -1>, <1, 1, 1>
    material {
      Bismuth_texture
    }
    scale <0.49, 0.49, 0.77>
    translate  <14.0, -5.0, 0.5>
  }
  box { // Polonium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Polonium_texture
    }
    scale <0.49, 0.49, 0.1>
    translate  <15.0, -5.0, 0.5>
  }
  box { // Astatine
    <-1, -1, -1>, <1, 1, 1>
    material {
      Astatine_texture
    }
    scale <0.49, 0.49, 0.1>
    translate  <16.0, -5.0, 0.5>
  }
  box { // Radon
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Gas
    }
    scale <0.49, 0.49, 0.1>
    translate  <17.0, -5.0, 0.5>
  }
  object { SampleBottle_M_radon }
  object { SampleBottle_M_astatine }
  object { SampleBottle_M_thallium }
  object { SampleBottle_M_lead }
  object { SampleBottle_M_bismuth }
  object { SampleBottle_M_polonium }
}
#declare Bottle_Cap80 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior80 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid80 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle80 = difference {
  object { BottleExterior80 }
  object { BottleVoid80 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill80 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group70 = difference {
  object { Bottlefill80 }
  box { // fill_cut_off70
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Lanthanum_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_lanthanum = union {
  object { Bottle_Cap80 }
  object { GlassofSampleBottle80 }
  object { bottle_fill_group70 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <1.949987, -1.134555, 0.562007>
}
#declare Bottle_Cap81 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior81 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid81 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle81 = difference {
  object { BottleExterior81 }
  object { BottleVoid81 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill81 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  material {
    Cerium_texture
  }
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group71 = difference {
  object { Bottlefill81 }
  box { // fill_cut_off71
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Cerium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_cerium = union {
  object { Bottle_Cap81 }
  object { GlassofSampleBottle81 }
  object { bottle_fill_group71 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <2.965266, -1.124865, 0.800985>
}
#declare Bottle_Cap82 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior82 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid82 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle82 = difference {
  object { BottleExterior82 }
  object { BottleVoid82 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill82 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group72 = difference {
  object { Bottlefill82 }
  box { // fill_cut_off72
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Praseodymium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_praseodymium = union {
  object { Bottle_Cap82 }
  object { GlassofSampleBottle82 }
  object { bottle_fill_group72 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <3.97224, -1.149266, 0.341299>
}
#declare Bottle_Cap83 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior83 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid83 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle83 = difference {
  object { BottleExterior83 }
  object { BottleVoid83 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill83 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group73 = difference {
  object { Bottlefill83 }
  box { // fill_cut_off73
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Neodymium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_neodymium = union {
  object { Bottle_Cap83 }
  object { GlassofSampleBottle83 }
  object { bottle_fill_group73 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <4.966128, -1.139834, 0.758596>
}
#declare Bottle_Cap84 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior84 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid84 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle84 = difference {
  object { BottleExterior84 }
  object { BottleVoid84 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill84 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group74 = difference {
  object { Bottlefill84 }
  box { // fill_cut_off74
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Promethium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_promethium = union {
  object { Bottle_Cap84 }
  object { GlassofSampleBottle84 }
  object { bottle_fill_group74 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <5.954904, -1.146498, -0.388895>
}
#declare Bottle_Cap85 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior85 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid85 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle85 = difference {
  object { BottleExterior85 }
  object { BottleVoid85 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill85 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group75 = difference {
  object { Bottlefill85 }
  box { // fill_cut_off75
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Samarium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_samarium = union {
  object { Bottle_Cap85 }
  object { GlassofSampleBottle85 }
  object { bottle_fill_group75 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <6.936676, -1.10682, 0.326025>
}
#declare Bottle_Cap86 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior86 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid86 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle86 = difference {
  object { BottleExterior86 }
  object { BottleVoid86 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill86 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group76 = difference {
  object { Bottlefill86 }
  box { // fill_cut_off76
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Europium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_europium = union {
  object { Bottle_Cap86 }
  object { GlassofSampleBottle86 }
  object { bottle_fill_group76 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <7.951304, -1.14455, 0.175654>
}
#declare Bottle_Cap87 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior87 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid87 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle87 = difference {
  object { BottleExterior87 }
  object { BottleVoid87 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill87 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group77 = difference {
  object { Bottlefill87 }
  box { // fill_cut_off77
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Gadolinium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_gadolinium = union {
  object { Bottle_Cap87 }
  object { GlassofSampleBottle87 }
  object { bottle_fill_group77 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <8.954016, -1.131576, 0.485191>
}
#declare Bottle_Cap88 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior88 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid88 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle88 = difference {
  object { BottleExterior88 }
  object { BottleVoid88 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill88 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group78 = difference {
  object { Bottlefill88 }
  box { // fill_cut_off78
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Terbium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_terbium = union {
  object { Bottle_Cap88 }
  object { GlassofSampleBottle88 }
  object { bottle_fill_group78 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <9.968533, -1.126505, 0.049087>
}
#declare Bottle_Cap89 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior89 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid89 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle89 = difference {
  object { BottleExterior89 }
  object { BottleVoid89 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill89 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group79 = difference {
  object { Bottlefill89 }
  box { // fill_cut_off79
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Dysprosium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_dysprosium = union {
  object { Bottle_Cap89 }
  object { GlassofSampleBottle89 }
  object { bottle_fill_group79 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <10.948822, -1.125685, 0.428501>
}
#declare Bottle_Cap90 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior90 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid90 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle90 = difference {
  object { BottleExterior90 }
  object { BottleVoid90 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill90 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group80 = difference {
  object { Bottlefill90 }
  box { // fill_cut_off80
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Holmium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_holimium = union {
  object { Bottle_Cap90 }
  object { GlassofSampleBottle90 }
  object { bottle_fill_group80 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <11.991674, -1.130401, 0.148031>
}
#declare Bottle_Cap91 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior91 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid91 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle91 = difference {
  object { BottleExterior91 }
  object { BottleVoid91 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill91 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group81 = difference {
  object { Bottlefill91 }
  box { // fill_cut_off81
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Erbium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_erbium = union {
  object { Bottle_Cap91 }
  object { GlassofSampleBottle91 }
  object { bottle_fill_group81 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <12.973939, -1.139834, 0.419068>
}
#declare Bottle_Cap92 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior92 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid92 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle92 = difference {
  object { BottleExterior92 }
  object { BottleVoid92 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill92 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group82 = difference {
  object { Bottlefill92 }
  box { // fill_cut_off82
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Thulium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_thulium = union {
  object { Bottle_Cap92 }
  object { GlassofSampleBottle92 }
  object { bottle_fill_group82 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <13.94877, -1.129581, -0.049857>
}
#declare Bottle_Cap93 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior93 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid93 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle93 = difference {
  object { BottleExterior93 }
  object { BottleVoid93 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill93 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group83 = difference {
  object { Bottlefill93 }
  box { // fill_cut_off83
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Ytterbium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_ytterbium = union {
  object { Bottle_Cap93 }
  object { GlassofSampleBottle93 }
  object { bottle_fill_group83 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <14.959479, -1.130401, 0.407518>
}
#declare Bottle_Cap94 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior94 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid94 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle94 = difference {
  object { BottleExterior94 }
  object { BottleVoid94 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill94 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group84 = difference {
  object { Bottlefill94 }
  box { // fill_cut_off84
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Lutetium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_lutetium = union {
  object { Bottle_Cap94 }
  object { GlassofSampleBottle94 }
  object { bottle_fill_group84 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <15.96412, -1.106, -0.059675>
}
#declare Row_6_F = union {
  box { // Lanthanum
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lanthanum_texture
    }
    scale <0.49, 0.49, 1.05>
    translate  <2.0, -8.0, 0.5>
  }
  box { // Cerium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cerium_texture
    }
    scale <0.49, 0.49, 1.28>
    translate  <3.0, -8.0, 0.5>
  }
  box { // Praseodymium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Praseodymium_texture
    }
    scale <0.49, 0.49, 0.82>
    translate  <4.0, -8.0, 0.5>
  }
  box { // Neodymium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Neodymium_texture
    }
    scale <0.49, 0.49, 1.21>
    translate  <5.0, -8.0, 0.5>
  }
  box { // Prometheum
    <-1, -1, -1>, <1, 1, 1>
    material {
      Promethium_texture
    }
    scale <0.49, 0.49, 0.1>
    translate  <6.0, -8.0, 0.5>
  }
  box { // Samarium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Samarium_texture
    }
    scale <0.49, 0.49, 0.92>
    translate  <7.0, -8.0, 0.5>
  }
  box { // Europium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Europium_texture
    }
    scale <0.49, 0.49, 0.67>
    translate  <8.0, -8.0, 0.5>
  }
  box { // Gadolinium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Gadolinium_texture
    }
    scale <0.49, 0.49, 0.98>
    translate  <9.0, -8.0, 0.5>
  }
  box { // Terbium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Terbium_texture
    }
    scale <0.49, 0.49, 0.54>
    translate  <10.0, -8.0, 0.5>
  }
  box { // Dysprosium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Dysprosium_texture
    }
    scale <0.49, 0.49, 1.02>
    translate  <11.0, -8.0, 0.5>
  }
  box { // Holmium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Holmium_texture
    }
    scale <0.49, 0.49, 0.64>
    translate  <12.0, -8.0, 0.5>
  }
  box { // Erbium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Erbium_texture
    }
    scale <0.49, 0.49, 0.91>
    translate  <13.0, -8.0, 0.5>
  }
  box { // Thulium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Thulium_texture
    }
    scale <0.49, 0.49, 0.44>
    translate  <14.0, -8.0, 0.5>
  }
  box { // Ytterbium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Ytterbium_texture
    }
    scale <0.49, 0.49, 0.9>
    translate  <15.0, -8.0, 0.5>
  }
  box { // Lutetium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lutetium_texture
    }
    scale <0.49, 0.49, 0.43>
    translate  <16.0, -8.0, 0.5>
  }
  object { SampleBottle_M_lanthanum }
  object { SampleBottle_M_cerium }
  object { SampleBottle_M_praseodymium }
  object { SampleBottle_M_neodymium }
  object { SampleBottle_M_promethium }
  object { SampleBottle_M_samarium }
  object { SampleBottle_M_europium }
  object { SampleBottle_M_gadolinium }
  object { SampleBottle_M_terbium }
  object { SampleBottle_M_dysprosium }
  object { SampleBottle_M_holimium }
  object { SampleBottle_M_erbium }
  object { SampleBottle_M_thulium }
  object { SampleBottle_M_ytterbium }
  object { SampleBottle_M_lutetium }
}
#declare Row_6 = union {
  object { Period_6_S }
  object { Period_6_D }
  object { Period_6_P }
  object { Row_6_F }
  bounded_by { // Bound00009
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <9.413006, 3.211264, 4.513712>
      translate  <8.331, -6.455117, 3.173994>
    }
  }
}
#declare Bottle_Cap56 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior56 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid56 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle56 = difference {
  object { BottleExterior56 }
  object { BottleVoid56 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill56 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group46 = difference {
  object { Bottlefill56 }
  box { // fill_cut_off46
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <0.0, 14.9643, 0.0>
    translate  <1.636467, 0.404246, 9.392846>
  }
  material {
    Francium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_francium = union {
  object { Bottle_Cap56 }
  object { GlassofSampleBottle56 }
  object { bottle_fill_group46 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <-0.0683, 0.8686, -0.386226>
}
#declare Bottle_Cap57 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior57 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid57 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle57 = difference {
  object { BottleExterior57 }
  object { BottleVoid57 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill57 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group47 = difference {
  object { Bottlefill57 }
  box { // fill_cut_off47
    <-1, -1, -1>, <1, 1, 1>
    material {
      Lithium_texture
    }
    rotate <-190.054855, -177.122589, -183.179504>
    translate  <1.509658, 0.404246, 10.006639>
  }
  material {
    Radium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_radium = union {
  object { Bottle_Cap57 }
  object { GlassofSampleBottle57 }
  object { bottle_fill_group47 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <0.953515, 0.871674, -0.386226>
}
#declare Period_7_S = union {
  box { // Francium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Francium_texture
    }
    scale <0.49, 0.49, 0.1>
    translate  <0.0, -6.0, 0.5>
  }
  box { // Radium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Radium_texture
    }
    scale <0.49, 0.49, 0.1>
    translate  <1.0, -6.0, 0.5>
  }
  object { SampleBottle_M_francium }
  object { SampleBottle_M_radium }
}
#declare Bottle_Cap79 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior79 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid79 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle79 = difference {
  object { BottleExterior79 }
  object { BottleVoid79 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill79 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group69 = difference {
  object { Bottlefill79 }
  box { // fill_cut_off69
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <7.000885, 8.525481, 1.042957>
    translate  <1.551942, 0.404246, 10.749957>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_dubnium = union {
  object { Bottle_Cap79 }
  object { GlassofSampleBottle79 }
  object { bottle_fill_group69 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <2.940812, 0.885199, 0.29659>
}
#declare Bottle_Cap73 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior73 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid73 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle73 = difference {
  object { BottleExterior73 }
  object { BottleVoid73 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill73 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group63 = difference {
  object { Bottlefill73 }
  box { // fill_cut_off63
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <4.341278, 1.033989, 0.987031>
    translate  <1.597757, 0.404246, 10.322347>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_joliotium = union {
  object { Bottle_Cap73 }
  object { GlassofSampleBottle73 }
  object { bottle_fill_group63 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <3.942489, 0.876974, 0.021698>
}
#declare Bottle_Cap74 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior74 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid74 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle74 = difference {
  object { BottleExterior74 }
  object { BottleVoid74 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill74 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group64 = difference {
  object { Bottlefill74 }
  box { // fill_cut_off64
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-0.139642, 0.574189, 0.968756>
    translate  <1.51376, 0.404246, 10.196317>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_rutherfordium = union {
  object { Bottle_Cap74 }
  object { GlassofSampleBottle74 }
  object { bottle_fill_group64 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <4.912094, 0.885199, 0.006411>
}
#declare Bottle_Cap75 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior75 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid75 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle75 = difference {
  object { BottleExterior75 }
  object { BottleVoid75 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill75 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group65 = difference {
  object { Bottlefill75 }
  box { // fill_cut_off65
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-1.992339, -0.366427, 1.10076>
    translate  <1.590124, 0.404246, 10.177226>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_bohrium = union {
  object { Bottle_Cap75 }
  object { GlassofSampleBottle75 }
  object { bottle_fill_group65 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <5.893501, 0.811992, 0.010225>
}
#declare Bottle_Cap76 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior76 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid76 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle76 = difference {
  object { BottleExterior76 }
  object { BottleVoid76 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill76 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group66 = difference {
  object { Bottlefill76 }
  box { // fill_cut_off66
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-5.155789, 0.710659, 0.903362>
    translate  <1.532851, 0.404246, 10.482683>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_hahnium = union {
  object { Bottle_Cap76 }
  object { GlassofSampleBottle76 }
  object { bottle_fill_group66 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <6.902498, 0.88602, 0.029316>
}
#declare Bottle_Cap77 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior77 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid77 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle77 = difference {
  object { BottleExterior77 }
  object { BottleVoid77 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill77 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group67 = difference {
  object { Bottlefill77 }
  box { // fill_cut_off67
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    rotate <-1.393044, 0.608149, 0.954094>
    translate  <1.571033, 0.404246, 10.234499>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_meitnerium = union {
  object { Bottle_Cap77 }
  object { GlassofSampleBottle77 }
  object { bottle_fill_group67 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <7.918899, 0.861344, 0.029316>
}
#declare Period_7_D = union {
  box { // Dubnium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.5>
    translate  <3.0, -6.0, 0.5>
  }
  box { // Joliotium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.5>
    translate  <4.0, -6.0, 0.5>
  }
  box { // Rutherfordium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.5>
    translate  <5.0, -6.0, 0.5>
  }
  box { // Bohrium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.5>
    translate  <6.0, -6.0, 0.5>
  }
  box { // Hahnium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.5>
    translate  <7.0, -6.0, 0.5>
  }
  box { // Meitnerium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.5>
    translate  <8.0, -6.0, 0.5>
  }
  object { SampleBottle_M_dubnium }
  object { SampleBottle_M_joliotium }
  object { SampleBottle_M_rutherfordium }
  object { SampleBottle_M_bohrium }
  object { SampleBottle_M_hahnium }
  object { SampleBottle_M_meitnerium }
}
#declare Bottle_Cap109 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior109 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid109 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle109 = difference {
  object { BottleExterior109 }
  object { BottleVoid109 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill109 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group99 = difference {
  object { Bottlefill109 }
  box { // fill_cut_off99
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Actinium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_actinium = union {
  object { Bottle_Cap109 }
  object { GlassofSampleBottle109 }
  object { bottle_fill_group99 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <1.961658, -2.119674, -0.407784>
}
#declare Bottle_Cap108 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior108 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid108 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle108 = difference {
  object { BottleExterior108 }
  object { BottleVoid108 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill108 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group98 = difference {
  object { Bottlefill108 }
  box { // fill_cut_off98
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Thorium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_thorium = union {
  object { Bottle_Cap108 }
  object { GlassofSampleBottle108 }
  object { bottle_fill_group98 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <2.981216, -2.141307, -0.092207>
}
#declare Bottle_Cap107 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior107 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid107 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle107 = difference {
  object { BottleExterior107 }
  object { BottleVoid107 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill107 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group97 = difference {
  object { Bottlefill107 }
  box { // fill_cut_off97
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Proactinium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_proactinium = union {
  object { Bottle_Cap107 }
  object { GlassofSampleBottle107 }
  object { bottle_fill_group97 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <3.963168, -2.137719, -0.393635>
}
#declare Bottle_Cap106 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior106 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid106 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle106 = difference {
  object { BottleExterior106 }
  object { BottleVoid106 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill106 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group96 = difference {
  object { Bottlefill106 }
  box { // fill_cut_off96
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Uranium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_uranium = union {
  object { Bottle_Cap106 }
  object { GlassofSampleBottle106 }
  object { bottle_fill_group96 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <4.96418, -2.139666, -0.421932>
}
#declare Bottle_Cap105 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior105 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid105 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle105 = difference {
  object { BottleExterior105 }
  object { BottleVoid105 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill105 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group95 = difference {
  object { Bottlefill105 }
  box { // fill_cut_off95
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Neptunium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_neptunium = union {
  object { Bottle_Cap105 }
  object { GlassofSampleBottle105 }
  object { bottle_fill_group95 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <5.961655, -2.14551, -0.42547>
}
#declare Bottle_Cap104 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior104 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid104 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle104 = difference {
  object { BottleExterior104 }
  object { BottleVoid104 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill104 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group94 = difference {
  object { Bottlefill104 }
  box { // fill_cut_off94
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Plutonium_texture
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_plutonium = union {
  object { Bottle_Cap104 }
  object { GlassofSampleBottle104 }
  object { bottle_fill_group94 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <6.957489, -2.129414, -0.429007>
}
#declare Bottle_Cap103 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior103 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid103 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle103 = difference {
  object { BottleExterior103 }
  object { BottleVoid103 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill103 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group93 = difference {
  object { Bottlefill103 }
  box { // fill_cut_off93
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_americium = union {
  object { Bottle_Cap103 }
  object { GlassofSampleBottle103 }
  object { bottle_fill_group93 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <7.967523, -2.152174, -0.429007>
}
#declare Bottle_Cap102 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior102 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid102 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle102 = difference {
  object { BottleExterior102 }
  object { BottleVoid102 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill102 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group92 = difference {
  object { Bottlefill102 }
  box { // fill_cut_off92
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_curium = union {
  object { Bottle_Cap102 }
  object { GlassofSampleBottle102 }
  object { bottle_fill_group92 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <8.951977, -2.140794, -0.432544>
}
#declare Bottle_Cap101 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior101 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid101 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle101 = difference {
  object { BottleExterior101 }
  object { BottleVoid101 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill101 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group91 = difference {
  object { Bottlefill101 }
  box { // fill_cut_off91
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_berkelium = union {
  object { Bottle_Cap101 }
  object { GlassofSampleBottle101 }
  object { bottle_fill_group91 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <9.959294, -2.131362, -0.432544>
}
#declare Bottle_Cap100 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior100 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid100 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle100 = difference {
  object { BottleExterior100 }
  object { BottleVoid100 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill100 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group90 = difference {
  object { Bottlefill100 }
  box { // fill_cut_off90
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_californium = union {
  object { Bottle_Cap100 }
  object { GlassofSampleBottle100 }
  object { bottle_fill_group90 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <10.957486, -2.119981, -0.429007>
}
#declare Bottle_Cap99 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior99 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid99 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle99 = difference {
  object { BottleExterior99 }
  object { BottleVoid99 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill99 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group89 = difference {
  object { Bottlefill99 }
  box { // fill_cut_off89
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_einsteinium = union {
  object { Bottle_Cap99 }
  object { GlassofSampleBottle99 }
  object { bottle_fill_group89 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <11.945015, -2.127466, -0.432544>
}
#declare Bottle_Cap98 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior98 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid98 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle98 = difference {
  object { BottleExterior98 }
  object { BottleVoid98 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill98 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group88 = difference {
  object { Bottlefill98 }
  box { // fill_cut_off88
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_fermium = union {
  object { Bottle_Cap98 }
  object { GlassofSampleBottle98 }
  object { bottle_fill_group88 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <12.964533, -2.140794, -0.436081>
}
#declare Bottle_Cap97 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior97 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid97 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle97 = difference {
  object { BottleExterior97 }
  object { BottleVoid97 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill97 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group87 = difference {
  object { Bottlefill97 }
  box { // fill_cut_off87
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_mendelevium = union {
  object { Bottle_Cap97 }
  object { GlassofSampleBottle97 }
  object { bottle_fill_group87 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <13.973388, -2.14551, -0.436081>
}
#declare Bottle_Cap96 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior96 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid96 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle96 = difference {
  object { BottleExterior96 }
  object { BottleVoid96 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill96 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group86 = difference {
  object { Bottlefill96 }
  box { // fill_cut_off86
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_nobelium = union {
  object { Bottle_Cap96 }
  object { GlassofSampleBottle96 }
  object { bottle_fill_group86 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <14.963789, -2.138846, -0.436081>
}
#declare Bottle_Cap95 = lathe {
  linear_spline
  12  // control points
  <0.001941, 0.383605>,
  <1.975262, 0.379805>,
  <1.976358, 0.014697>,
  <1.992298, -0.000198>,
  <2.000204, 0.008292>,
  <2.000098, 0.04846>,
  <2.000787, 0.402572>,
  <1.995207, 0.459502>,
  <1.975293, 0.481924>,
  <1.950215, 0.49428>,
  <1.900333, 0.500265>,
  <0.000044, 0.497704>
  rotate <90,0,90>
  material {
    bottle_cap
  }
  scale <0.25, 0.25, 1.0>
  translate  3.45*z
}
#declare BottleExterior95 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  translate  1.0*z
}
#declare BottleVoid95 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.85, 0.85, 0.925>
  translate  1.1*z
}
#declare GlassofSampleBottle95 = difference {
  object { BottleExterior95 }
  object { BottleVoid95 }
  material {
    Glass
  }
  hollow
}
#declare Bottlefill95 = lathe {
  linear_spline
  14  // control points
  <-0.008493, -0.002314>,
  <0.273498, 0.000509>,
  <0.387734, -0.000592>,
  <0.466262, 0.000499>,
  <0.504378, 0.049748>,
  <0.507492, 0.246125>,
  <0.503759, 2.039137>,
  <0.506271, 2.22333>,
  <0.507624, 2.322511>,
  <0.472938, 2.391716>,
  <0.400738, 2.428076>,
  <0.34129, 2.434345>,
  <0.336246, 2.667247>,
  <-0.000746, 2.66791>
  rotate <90,0,90>
  scale <0.845, 0.845, 0.92>
  translate  <1.497117, 0.525997, 7.870094>
}
#declare bottle_fill_group85 = difference {
  object { Bottlefill95 }
  box { // fill_cut_off85
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <1.576011, 0.404246, 10.196363>
  }
  material {
    Basic_Metal
  }
  translate  <-1.49831, -0.525975, -6.76568>
}
#declare SampleBottle_M_lawrencium = union {
  object { Bottle_Cap95 }
  object { GlassofSampleBottle95 }
  object { bottle_fill_group85 }
  scale <0.67, 0.67, 1.0>
  rotate <-0.0, -0.0, 0.0>
  translate  <0.049057, -6.875838, 0.0>
  translate  <15.952907, -2.143562, -0.439618>
}
#declare Period_7_F = union {
  box { // Actinium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Actinium_texture
    }
    scale <0.49, 0.49, 0.1>
    translate  <2.0, -9.0, 0.485851>
  }
  box { // Thorium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Thorium_texture
    }
    scale <0.49, 0.49, 0.4>
    translate  <3.0, -9.0, 0.5>
  }
  box { // Proactinium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Proactinium_texture
    }
    scale <0.49, 0.49, 0.1>
    translate  <4.0, -9.0, 0.5>
  }
  box { // Uranium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Uranium_texture
    }
    scale <0.49, 0.49, 0.07>
    translate  <5.0, -9.0, 0.5>
  }
  box { // Neptunium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Neptunium_texture
    }
    scale <0.49, 0.49, 0.065>
    translate  <6.0, -9.0, 0.5>
  }
  box { // Plutonium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plutonium_texture
    }
    scale <0.49, 0.49, 0.064>
    translate  <7.0, -9.0, 0.5>
  }
  box { // Americium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.063>
    translate  <8.0, -9.0, 0.5>
  }
  box { // Curium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.062>
    translate  <9.0, -9.0, 0.5>
  }
  box { // Berkelium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.061>
    translate  <10.0, -9.0, 0.5>
  }
  box { // Californium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.06>
    translate  <11.0, -9.0, 0.5>
  }
  box { // Einsteinium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.059>
    translate  <12.0, -9.0, 0.5>
  }
  box { // Fermium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.058>
    translate  <13.0, -9.0, 0.5>
  }
  box { // Mendelevium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.057>
    translate  <14.0, -9.0, 0.5>
  }
  box { // Nobelium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.056>
    translate  <15.0, -9.0, 0.5>
  }
  box { // Lawrencium
    <-1, -1, -1>, <1, 1, 1>
    material {
      Basic_Metal
    }
    scale <0.49, 0.49, 0.055>
    translate  <16.0, -9.0, 0.5>
  }
  object { SampleBottle_M_actinium }
  object { SampleBottle_M_thorium }
  object { SampleBottle_M_proactinium }
  object { SampleBottle_M_uranium }
  object { SampleBottle_M_neptunium }
  object { SampleBottle_M_plutonium }
  object { SampleBottle_M_americium }
  object { SampleBottle_M_curium }
  object { SampleBottle_M_berkelium }
  object { SampleBottle_M_californium }
  object { SampleBottle_M_einsteinium }
  object { SampleBottle_M_fermium }
  object { SampleBottle_M_mendelevium }
  object { SampleBottle_M_nobelium }
  object { SampleBottle_M_lawrencium }
}
#declare Row_7 = union {
  object { Period_7_S }
  object { Period_7_D }
  object { Period_7_F }
  bounded_by { // Bound00010
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <9.275919, 3.151144, 3.596224>
      translate  <8.323531, -7.503854, 3.390797>
    }
  }
}
union { // Periodic_Table
  object { Row_1 }
  object { Row_2 }
  object { Row_3 }
  object { Row_4 }
  object { Row_5 }
  object { Row_6 }
  object { Row_7 }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <9.603036, 5.787762, 9.411347>
      translate  <8.315306, -4.979785, 2.333371>
    }
  }
  // All transformations fixed
  scale <1.5, 1.5, 1.0>
  translate  <-0.339462, -3.480224, 0.05>
}


