//
//    EMAIL: castlewrks@aol.com
//    NAME: Robert J Becraft
//    TOPIC:  Laboratory
//    COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//    TITLE: "Wizard"
//    COUNTRY: USA
//    WEBPAGE: http://www.angelfire.com/md2/castlewrks 
//             http://www.geocities.com/siliconvalley/labs/6080
//    RENDERER USED:  Povray 3.1g
//    TOOLS USED: Povray (image creation), I_view32 (TGA>JPG conversion), 
//                FastZip98 (zip), Corel Draw for Labels on containers, TW for heightfields
//    RENDER TIME: 9 hours 3 minutes, 56 meg
//    HARDWARE USED: Pentium 400
//    IMAGE DESCRIPTION:
//
//  The following code generates a variety of objects that are incorporated in the picture submitted to the IRTC round
//  known as the "Laboratory".
//
//  An inventory of the objects:
//     An entire Tarot deck flying around the center of the room (78 cards)
//     Two mostly black cauldrons
//     A shelf with jars and similar containers (15 different jars)
//     A shelf with scrolls stacked on it
//     A magic mirror with an active "destination" on it and some magical interferance (cracks)
//     A brass telescope
//     Several crates of brassy/gold junk (Macros generated the contents of the crates)
//     Stacks of books (Macros generate the books and the applied titles, see code below for complete list of titles)
//     A bird-cage and Parrot
//     A fancy legged kitchen type table
//     A leathery-pad-locked chest
//     A radioactive object carrying case (Hmmm... and just what was this wizard doing with that kind of stuff)
//     Ink bottles
//     Feather writing quills
//     A crystal ball
//     Candles (two types), closer candles are macro driven and can generate different wax drip patterns, closer candles do not use media
//     Large jug of "LOVE POTION #9 Concentrate"
//     small vial of "#9" with delivery tag to "9th and Vine"
//     Jar of Lizard Tails, Red
//     Jar with several wands arranged
//     Jar of Eye-O-Newt
//     Jar of Cheshire Cat Teeth
//     Jar of Ambrosia Extract
//     Aluminum can of artist's favorite beverage
//     Chinese food cartons
//     3 shelf types
//     Wizard's desk modeled after the middle age scribe's type desk with adornments
//     A wizard's floppy hat with a star pinned on with a straight pin
//     An active wizard's spell with pentagram and appropriate magical looking effects
//     Stairwell and banister
//     Artzy windows
//     
//    There are a whole pile of image-maps used to generate this picture...
//    (These can be turned off by commenting out the variable "ImageMapOn")
//    ..\graphics\redparrot.gif
//    ..\graphics\brick065.gif (from http://www.grsites.com/textures/)
//    ..\graphics\pepsi.gif (scanned a pepsi can)
//    ..\graphics\warning.gif
//    ..\graphics\love9.gif (corel)
//    ..\graphics\newt.gif (corel)
//    ..\graphics\lizardt.gif (corel)
//    ..\graphics\ches.gif (corel)
//    ..\graphics\ambro.gif (corel)
//    ..\graphics\love9dlt.gif (corel)
//    ..\graphics\hills1.ghf (Terrain Maker)            
//
//    All these graphics are available in a zip file at:
//     http://www.angelfire.com/md2/castlewrks/Wizard/WizardG.zip
//    
//    in addition, I have a directory that contains images for all 78 tarot cards...
//    These can be found all over the net in whatever design suits your designs.    
//    
//
//    DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
//
//    See: http://www.angelfire.com/md2/castlewrks for some of the story.
//

//---------------------------------------------------
 global_settings {
                    max_trace_level 30          // default POV setting is 5 
                    radiosity{count 125
                              distance_maximum 4  //default 3.3
                              error_bound 3.5       //default 4
                             } 
                 //   max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                 }

#include "kolors.inc"   // ken's kolor file
#include "stones1.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"
#include "textures.inc"
#include "../med/brick.inc" 

//#declare SkyOff=off  // uncomment to turn off
//#declare HillsOff=off // uncomment if you don't have the hills1.ghf file 
//#declare ObjectsOff=off 
#declare ImageMapOn=on  // uncomment to turn on, comment out if you don't have the image-maps
//#declare MagicOff=off // if you don't have a deck of tarot cards, uncomment this variable
                                                           
camera {
    location <0,31.5,-6.8> look_at <0,31,0>  // IRTC View       
    
  //  location <0,31.5,-3.8> look_at <0,31,0>  // View of magic effect    
  //  location <0,37,-.1> look_at <1,30,1>  // birdseye view of room  
  //  location <0,100,-40> look_at <0,31,0>   // outside tower way back     
  //  location <0,32,-12> look_at <0,31,0>   // window level, outside        
}
//light_source{<0,38,0> color White*2} // light up top center

light_source{<0,10000,0> color White*2}  // BIG light 
light_source{<0,31.5,0> color White/2 fade_distance 4 fade_power 2} // light in center of spell

light_source{<3,31.5,-1> color White fade_distance 3 fade_power 3 shadowless}  // LAB Light near mirror
light_source{<-6,33,0> color White fade_distance 4 fade_power 3}  // LAB Light on left


#ifndef(SkyOff)
                           
#include "..\med\cloud.inc"       

fog {                                                 // White ground fog
  distance 1950
  colour rgb<0.52, 0.62, 0.72>
  fog_type 2
  fog_offset 45
  fog_alt 3
  turbulence 1.0
  turb_depth 3.0
}
#end // ifndef(SkyOff)

     
#declare WinFlair=difference{
      cylinder{<0,0,-.01><0,0,.01> .1}
      cylinder{<0,0,-.02><0,0,.02> .08}  
      box{<-.11,-.11,-.02><.11,-.035,.02>}
}
#declare WinFlairRim=difference{
      cylinder{<0,0,-.01><0,0,.01> .22}
      cylinder{<0,0,-.02><0,0,.02> .2}  
}         
#declare WinFlair2=union{
   object{WinFlair translate<0,.11,0>}
   object{WinFlair translate<0,.11,0> rotate<0,0,90>}          
   object{WinFlair translate<0,.11,0> rotate<0,0,-90>}    
   object{WinFlair translate<0,.11,0> rotate<0,0,-180>}   
}  
#declare WindowRim=union{
   difference{
      cylinder{<0,0,-.01><0,0,.01> .35}
      cylinder{<0,0,-.02><0,0,.02> .33}  
      box{<-.351,-.351,-.02><.351,0,.02>}
   }                      
   difference{
      cylinder{<0,0,-.01><0,0,.01> .35}
      cylinder{<0,0,-.02><0,0,.02> .33}  
      box{<-.351,-.351,-.02><.351,0,.02>}
      translate<0,-.41,0>
   }   
   difference{
      box{<-.35,0,-.01><.35,-3,.01>}
      box{<-.33,.1,-.02><.33,-2.98,.02>}
   }
   
  #declare X1=-4;
  #while (X1<=.9)
      cylinder{<-.4,X1,0><.4,X1-.6,0> .004 } //texture{T_Brass_1A}}
      cylinder{<-.4,X1-.6,0><.4,X1,0> .004 } //texture{T_Brass_1A}}
      #declare X1=X1+.1;
  #end
   
}        
#declare Window1=union{ 
  object{WindowRim translate<0,-.133,0>}
  object{WinFlair2}
  object{WinFlairRim} 
  
  //object{WindowGlazing}
  texture{pigment{color White}}
}            

#declare Wall=difference{
  box{<-10,0,-.1><10,5,.1>}
  #declare C1=-5;
  #while (C1<=5)
     box{<C1-.35,.25,-.11><C1+.35,3.25,.11>}
     cylinder{<C1,3.25,-.11><C1,3.25,.11> .35}
     #declare C1=C1+1;
  #end
  texture{T_WhiteBrick scale .0625}
} // Wall

#declare ArchTop=difference{
  cylinder{<0,0,-.12><0,0,.42>.48}
  cylinder{<0,0,-.121><0,0,.421> .34}
  box{<-.5,-.5,-.121><.5,0,.421>}
  #declare C1=15;
  #while (C1<360)
    box{<-.01,-.5,-.121><.01,.5,.321> rotate<0,0,C1>}
    #declare C1=C1+30;
  #end
  texture{T_Stone1 scale .25}
}

#declare Col1=union{
  cylinder{<0,0,0><0,.05,0>.2 texture{T_Stone1 scale .25}}             
//  box{<-.2,0,-.2><.2,.05,.2> texture{T_Stone1 scale .25}}
  cylinder{<0,0,0><0,.15,0> .185 }
//  box{<-.185,0,-.185><.185,.15,.185>}
  torus{.15,.035 translate<0,.15,0> texture{T_Brass_1A}}
  cylinder{<0,.15,0><0,2.95,0> .15}
  cylinder{<0,2.95,0><0,3.1,0> .17}
  cylinder{<0,3.1,0><0,3.2,0> .185 texture{T_Stone1 scale .25}}  
//  box{<-.15,3.45,-.15><.15,3.6,.15>}
   texture{T_Stone14 scale .25}
}
#declare WoodDoily=union{
  cylinder{<0,-.025,0><0,0,0> .1}
  cylinder{<0,-.1,0><0,-.075,0> .1}
  cylinder{<0,-.15,0><0,0,0> .075}
  cone{<0,-.35,0>0 <0,-.15,0> .1}
  sphere{<0,-.35,0>.05}
  texture{T_Wood11 scale .2 rotate<90,0,0>}
}
#declare WoodTrussC=difference{
   cylinder{<-.1,0,0><.1,0,0> 1}
   cylinder{<-.11,0,0><.11,0,0> .8}
   box{<-.11,-1.1,-1.1><.11,.1,1.1>}
   box{<-.11,-1.1,-1.1><.11,1.1,0>}
   texture{T_Wood11 scale .15 rotate<45,0,0>}
} 
#declare WoodTruss=union{
  box{<-.15,0,-.15><.15,4,.15> texture{T_Wood11 scale .25 rotate<90,0,0>} }
  box{<-.15,.9,-1.35><.15,1.15,0> texture{T_Wood11 scale .25} } 
  cylinder{<0,1.025,-1.35><0,1.025,-1.40> .12 texture{T_Wood11 scale .25}}
  sphere{<0,1.025,-1.40> .1 texture{T_Wood11 scale .15 rotate<90,0,0>}}     

  box{<-.15,1.9,-2.25><.15,2.15,0> texture{T_Wood11 scale .25}}  
  cylinder{<0,2.025,-2.25><0,2.025,-2.30> .12 texture{T_Wood11 scale .25}}
  sphere{<0,2.025,-2.30> .1 texture{T_Wood11 scale .15 rotate<90,0,0>}}   
  cylinder{<0,2.025,-2.30><0,2.025,-2.45> .05 texture{T_Brass_1A}}
  sphere{<0,2.025,-2.045> .065 texture{T_Brass_1A}}
  
  object{WoodTrussC translate<0,0,-.98>}
  object{WoodTrussC translate<0,1,-2.12>}
  object{WoodDoily translate<0,.9,-1.1>} 
  
  box{<-.55,0,.15><.55,10,.16> texture{T_Wood11 scale .25 rotate<0,0,90>} rotate<-45,0,0> translate<0,2,0>}
  box{<-.11,0,-.15><.11,10,.15> texture{T_Wood11 scale .25 rotate<90,0,0>} rotate<-30,0,0> translate<0,2,-2>}
  box{<-.09,0,-.15><.09,10,.15> texture{T_Wood11 scale .25 rotate<90,0,0>} rotate<-45,0,0> translate<0,2,0>}
}
  
#declare Post1=union{
  cylinder{<0,0,0><0,1.3,0> .1}
  cone{<0,0,0>.13 <0,.2,0> .105}
  cylinder{<0,1.3,0><0,1.4,0> .105}
  sphere{<0,1.45,0>.05}
  texture{T_Brass_1A}
}

#declare Bookshelf=union{
  box{<-.2,0,-1><.2,.1,1>} // base
  box{<-.22,.1,-1><.2,.125,1>}  // bottom shelf
  box{<-.22,.35,-1><.2,.375,1>} // second shelf
  box{<-.22,.7,-1><.2,.725,1>} // third shelf 
  box{<-.22,1,-1><.2,1.025,1>} // Top 
  
  #declare B1=-1;
  #while (B1<1)
    box{<.19,.1,B1><.199,1,B1+.29> texture{T_Wood1 rotate<90,0,0> scale .25}}
    #declare B1=B1+.3;
  #end
  
  box{<-.22,.1,-1.025><.2,1.025,-1> texture{T_Wood1 rotate<90,0,0> scale .25}} // side
  box{<-.22,.1,1><.2,1.025,1.025> texture{T_Wood1 rotate<90,0,0> scale .25}}   // second side
  texture{T_Wood1}
}

#declare TableLeg=union{
  cone{<0,0,0>.05 <0,.65,0> .065 texture{T_Wood1 rotate<90,0,0> scale .25}}
  cylinder{<0,.65,0><0,.75,0> .055 texture{T_Wood1 rotate<90,0,0> scale .25}}
  cylinder{<0,.75,0><0,.85,0> .065 texture{T_Wood1 rotate<90,0,0> scale .25}}
}
#declare TableBrace=union{
  cylinder{<-.45,.45,0><.45,.45,0> .015}
  sphere{<0,.45,0> .035 }
  cone{<-.35,.45,0>.02 <-.05,.45,0> .03 }
  cone{<.05,.45,0>.03 <.35,.45,0> .02 }
 texture{T_Wood1 scale .25}
}

#declare Table=union{
  box{<-.5,.85,-1><.5,1,1> texture{T_Wood1 scale .25}}
  //top
  box{<-.55,1,-1.05><-.255,1.025,1.05> texture{T_Wood1 scale .25 rotate<20,0,0>}}
  box{<-.25,1,-1.05><0,1.025,1.05> texture{T_Wood1 scale .25 rotate<0,0,0>}}
  box{<0.005,1,-1.05><.25,1.025,1.05> texture{T_Wood1 scale .25 rotate<30,0,0>}}
  box{<.255,1,-1.05><.55,1.025,1.05> texture{T_Wood1 scale .25 rotate<50,0,0>}}
  
  // Leg bracing
  
//  cylinder{<-.45,.45,-.95><.45,.45,-.95> .01 texture{T_Wood1 scale .25}}
//  sphere{<0,.45,-.95> .03 texture{T_Wood1 scale .25}}
//  cone{<-.35,.45,-.95>.015 <-.05,.45,-.95> .02 texture{T_Wood1 scale .25}}
//  cone{<.05,.45,-.95>.02 <.35,.45,-.95> .015 texture{T_Wood1 scale .25}}
//  cylinder{<-.45,.45,.95><.45,.45,.95> .01 texture{T_Wood1 scale .25}}
//  sphere{<0,.45,.95> .03 texture{T_Wood1 scale .25}}
//  cone{<                                                                
  object{TableBrace translate<0,0,-.95>}
  object{TableBrace translate<0,0,.95>}
  union{
   cylinder{<0,.45,-.95><0,.45,.95> .015}
   sphere{<0,.45,-.5> .035}
   sphere{<0,.45,.5> .035}
   cone{<0,.45,-.85> .015 <0,.45,-.55> .03}
   cone{<0,.45,-.45> .03  <0,.45,-.05> .03}
   cone{<0,.45,.05>  .03  <0,.45,.45>  .03}
   cone{<0,.45,.55>  .03  <0,.45,.85>  .03}
   texture{T_Wood1 scale .25 rotate<0,90,0>}
  } //union
  
      
  object{TableLeg translate<-.45,0,-.95>}
  object{TableLeg translate<-.45,0,.95>}
  object{TableLeg translate<.45,0,-.95>}
  object{TableLeg translate<.45,0,.95>}
}

#declare DeskBall=union{
  sphere{<0,0,0> .05 texture{T_Ruby_Glass}}
  #declare RO=0;
  #while (RO<=180)
    torus{.05,.005 rotate<90,0,0> rotate<0,RO,0>}
    #declare RO=RO+45;
  #end
  cylinder{<0,.045,0><0,.051,0> .03}
  sphere{<0,.051,0> .025 texture{T_Ruby_Glass}}
}
#declare Desk=union{
  
  box{<-.39,0,-.5><-.38,1.95,.5>} //desk back 
  box{<-.395,0,-.5><-.38,.2,.5> texture{T_Wood16 rotate<0,0,90> scale .2} }    
  box{<-.395,.8,-.5><-.38,1,.5> texture{T_Wood16 rotate<0,0,90> scale .2} }  
  box{<-.395,1.6,-.5><-.38,1.8,.5> texture{T_Wood16 rotate<0,90,0> scale .2} }  
  box{<-.4,1.95,-.5><-.24,2,.5> texture{T_Wood16 rotate<0,0,0> scale .25}}
  box{<-.26,1.8,-.5><-.25,1.95,.5> texture{T_Wood16 rotate<0,0,0> scale .2}}
  #declare CB=-.45;
  #while (CB<=.45)
    cylinder{<-.385,.2,CB><-.385,1.95,CB> .01 texture{T_Wood16 rotate<90,0,0> scale .2}}
    #declare CB=CB+.05;
  #end
    
  //sides
  box{<-.075,0,-.508><.075,1.75,-.49> texture{T_Wood16 rotate<90,0,0> translate<0,0,.1> scale .2}}  
  box{<-.4,0,-.52><-.25,2,-.48> texture{T_Wood16 rotate<90,0,0> scale .25}}
  cylinder{<-.325,.15,-.52><-.325,1.95,-.52> .035 texture{T_Wood16 rotate<90,0,0> scale .25}}
  object{DeskBall translate<-.325,1.975,-.52>}
  box{<.25,0,-.52><.4,1.8,-.48> texture{T_Wood16 rotate<90,0,0> scale .25}}
  box{<.35,0,-.55><.4,1.75,-.48> texture{T_Wood16 rotate<90,0,0> scale .25}} 
  cylinder{<.375,.15,-.515><.375,1.75,-.515> .035 texture{T_Wood16 rotate<90,0,0> scale .25}}  
  object{DeskBall translate<.375,1.775,-.515>}
//  sphere{<.375,1.775,-.515> .05 texture{T_Wood16 rotate<90,0,0> scale .2}}
  box{<-.4,0,-.509><.4,.2,-.49> texture{T_Wood16 rotate<0,90,0> scale .25}}
  box{<-.4,.8,-.509><.4,1,-.49> texture{T_Wood16 rotate<0,90,0> scale .25}}
  box{<-.4,1.6,-.509><.4,1.8,-.49> texture{T_Wood16 rotate<0,90,0> scale .25}}
  box{<-.38,0,-.5><.4,1.8,-.5>}

  box{<-.075,0,.508><.075,1.75,.49> texture{T_Wood16 rotate<90,0,0> translate<0,0,.1> scale .2}}                                
  box{<-.4,0,.52><-.25,2,.48> texture{T_Wood16 rotate<90,0,0> scale .25}}
  cylinder{<-.325,.15,.52><-.325,1.95,.52> .035 texture{T_Wood16 rotate<90,0,0> scale .25}} 
  object{DeskBall translate<-.325,1.975,.52>}  
  box{<.25,0,.52><.4,1.8,.48> texture{T_Wood16 rotate<90,0,0> scale .25}}
  box{<.35,0,.55><.4,1.75,.48> texture{T_Wood16 rotate<90,0,0> scale .25}} 
  cylinder{<.375,.15,.515><.375,1.75,.515> .035 texture{T_Wood16 rotate<90,0,0> scale .25}}
  object{DeskBall translate<.375,1.775,.515>}
//  sphere{<.375,1.775,.515> .05 texture{T_Wood16 rotate<90,0,0> scale .2}}
  box{<-.4,0,.509><.4,.2,.49> texture{T_Wood16 rotate<0,90,0> scale .25}} 
  box{<-.4,.8,.509><.4,1,.49> texture{T_Wood16 rotate<0,90,0> scale .25}}
  box{<-.4,1.6,.509><.4,1.8,.49> texture{T_Wood16 rotate<0,90,0> scale .25}}                                 
  box{<-.38,0,.5><.4,1.8,.5>}  
  
  #declare CA=.2;
  #while (CA<=1.7)
     cylinder{<.375,CA,-.515><.375,CA+.05,-.515> .036 texture{T_Brass_1E}}
     cylinder{<.375,CA,.515><.375,CA+.05,.515> .036 texture{T_Brass_1E}}
     cylinder{<-.325,CA,-.52><-.325,CA+.05,-.52> .036 texture{T_Brass_1E}}
     cylinder{<-.325,CA,.52><-.325,CA+.05,.52> .036 texture{T_Brass_1E}}
     #declare CA=CA+.15;
  #end
  
  union{
    box{<-.42,-.025,-.5><.44,.025,.5> texture{T_Wood16 scale .20 rotate<0,0,0>}}
    box{<.43,-.025,-.35><.45,.045,.35> texture{T_Wood16 scale .20 rotate<0,0,0>}}
    cylinder{<.44,.045,-.35><.44,.045,.35> .01 texture{T_Wood16 scale .20 rotate<0,0,0>}}
    
       rotate<0,0,-23> translate<0,1.7,0>
  } // desktop
  
  // foot rest
  box{<-.28,.65,-.5><.2,.7,.5> texture{T_Wood16 scale .20 rotate<0,0,0>} }  
  cylinder{<.2,.675,-.5><.2,.675,.5>.025 texture{T_Wood16 scale .20 rotate<0,90,0>}}
  
 texture{T_Wood16 rotate<90,0,0> scale .2}
}


#declare Penta1=union{
  box{<-.1,0,-3><.1,0.001,0> rotate<0,18,0> translate<0,0,1.5>}
  box{<-.1,0,-3><.1,0.001,0> rotate<0,-18,0> translate<0,0,1.5>}
} 

#declare Rim=union{
  difference{
    cylinder{<0,0,0><0,.001,0> 1.7}
    cylinder{<0,-.1,0><0,.002,0> 1.5} 
  }
  difference{
    cylinder{<0,0,0><0,.001,0> 1.75}
    cylinder{<0,-.1,0><0,.002,0> 1.7}
    texture{T_Stone21 scale .25}
  }
  difference{
    cylinder{<0,0,0><0,.001,0> 1.5}
    cylinder{<0,-.1,0><0,.002,0> 1.45}
    texture{T_Stone21 scale .25}
  }  
}

#declare Glow_Orange=texture{pigment{color Orange} finish{ambient 10}}
#declare Glow_Yellow=texture{pigment{color Yellow} finish{ambient 10}}
#declare Candle=union{ 
   #ifndef(CandleLite)
      light_source{<0,.13,0> color LightBlue/2 fade_distance 1 fade_power 3}  // Candle Light      
      sphere{<0,.08,0> .008 texture{Glow_Orange}}
      cone{<0,.08,0> .008 <0,.11,0> 0 texture{Glow_Yellow}}
   #end
   cylinder{<0,.071,0> <0,.078,0> .001 texture{pigment{color Black}}}
   cylinder{<0,0,0><0,.071,0> .025 texture{pigment{color Wheat}}} 
}   
#declare Candles=union{
   object{Candle}   
   cylinder{<0,0,0><0,.0015> .03 scale<1,1,2> texture{pigment{color Wheat}} translate<-.001,0,-.003>}
   cylinder{<0,0,0><0,.0015> .03 scale<1.5,1,1> texture{pigment{color Wheat}} translate<-.003,0,-.001>}
} 

#declare Candle_Holder=union{
   object{Candle}
   difference{
      cylinder{<0,0,0><0,.015,0>.01}
      cylinder{<0,0,0><0,.0151,0>.009}
   }
   difference{
      cone{<0,0,0> .03 <0,.005,0> .04}
      cone{<0,0,0> .029 <0,.051,0> .041}
   }
   cylinder{<0,0,0><0,.001,0> .03}
  texture{T_Brass_1D}
}    
#macro FCandle(R1S,CH)

  light_source{<0,.17,0> color Orange/2 fade_distance 2 fade_power 3}

  difference{       
    cylinder{<0,0,0><0,CH,0>.01}       
    sphere{<.005,CH,0> .012}
 //   sphere{<0,.12,0> .0025}
    texture{pigment{color Wheat}}
   }
   
   cylinder{<0,.05,0><0,.06,0> .01025 texture{pigment{color Red}}}
   cylinder{<0,.03,0><0,.04,0> .01025 texture{pigment{color Red}}}
   
   #declare C1=1;
   #declare R1=seed(R1S);
   #while (C1<80)
     #declare RSY=rand(R1)*6+.5;
     #declare RSZ=rand(R1)*.5+.5;
     #declare RSX=rand(R1)*1+.5;
     #declare RYP=rand(R1)*(CH-.01);
     #declare ROY=rand(R1)*35;
     #declare ROZ=rand(R1)*15;
     sphere{<0,0,0> .0025 scale<RSX,RSY,RSZ> rotate<0,0,ROZ> translate<.01,RYP,0> rotate<0,ROY,0> texture{pigment{color Wheat}}}
     #declare C1=C1+1;
   #end

   #declare C1=1;
   #declare R1=seed(R1S/10);
   #while (C1<20)
     #declare RSY=rand(R1)*3+.5;
     #declare RSZ=rand(R1)*2+.5;
     #declare RSX=rand(R1)*2.5+.5;
     #declare RYP=rand(R1)*(CH-.015);
     #declare ROY=rand(R1)*55;
     #declare ROZ=rand(R1)*15;
     sphere{<0,0,0> .0025 scale<RSX,RSY,RSZ> rotate<0,0,ROZ> translate<.01,RYP,0> rotate<0,ROY,0> texture{pigment{color Wheat}}}
     #declare C1=C1+1;
   #end 

   sphere{<0,0,0> .016 scale <1,.06,1> texture{pigment{color Wheat}}} // base of candle
   
   #declare BlobCt=int(rand(R1)*5+5);  // wax around base of candle
   #declare BC=1;
   #while (BC<=BlobCt)
      #declare RX=rand(R1)*.051-.025;
      #declare RZ=rand(R1)*.051-.025;   
      #declare RSY=rand(R1)*.06;
      #declare RSX=rand(R1)*1;
      #declare RSZ=rand(R1)*1;
      #declare ROY=rand(R1)*360;
      #declare RSD=rand(R1)*.015+.0125;      
      sphere{<0,0,0> RSD translate<RSD/2,0,0> scale<RSX,RSY,RSZ> rotate<0,ROY,0> translate<RX-RSD,0,RZ> texture{pigment{color Wheat}}}  // wax around base of candle
      #declare BC=BC+1;
   #end // while      
//   sphere{<0,0,0> .025 scale<2,.05,1> rotate<0,-55,0> translate<0,0,.035> texture{pigment{color Wheat}}}
//   sphere{<0,0,0> .025 scale<.75,.12,2> rotate<0,-45,0> translate<0,0,0> texture{pigment{color Wheat}}}      
   
   cylinder{<0,CH-.02,0> <0,CH,0> .001 texture{pigment{color Black}}}  // candle wick

   difference{  // candle flame
	sphere{0, 0.025  texture{pigment{rgbt <1.0000, 0.5000,0.0000,.85>} } finish{ambient 2.5}} // orange
	
	
	sphere{<0, -0.015, 0>, 0.0175 texture{pigment{rgbt <0.7490, 0.8470, 0.8470,.85>} finish{ambient 1.5}}} // lightblue
	
//	sphere{<0, -0.015, 0>, 0.0175 texture{pigment{rgbt <1.0000, 0.9766, 0.8008,.85>} finish{ambient 1.5}}} // lemonchiffon 
       hollow
       scale<.7, 2.8, .7>
       scale .3
       translate <0, CH+.01, 0>
   } 
#end // end FCandle macro

#declare CandleCluster=union{
   union{FCandle(921,.1)  rotate<0,0,0>  translate<-.04,0,0>}  
   union{FCandle(393,.13) rotate<0,60,0> translate<-.05,0,.03>}
   union{FCandle(156,.12) rotate<0,90,0> translate<0,0,.03>}
}

    

#declare Pentagram=union{
   object{Penta1 rotate<0,0,0>}
   object{Penta1 rotate<0,-72,0>}
   object{Penta1 rotate<0,-144,0>}
   object{Rim}                    
   
   object{Candles translate<0,0,1.6> rotate<0,0,0>}
   object{Candles translate<0,0,1.6> rotate<0,72,0>}
   object{Candles translate<0,0,1.6> rotate<0,-72,0>}
   object{Candles translate<0,0,1.6> rotate<0,144,0>}
   object{Candles translate<0,0,1.6> rotate<0,-144,0>}
   
  texture{T_Stone18 scale .25}
}

//_____________________________________________ Bird Cage
#declare WD=.0035; // cage wire diameter
 
#declare CageTopPart=difference{
    torus{.2,WD rotate<90,0,0>}
    box{<-.21,-.21,-.21><.21,0,.21>}
}  

#declare Cage=union{
   #declare C1=0;
   #while (C1<360)
      object{CageTopPart rotate<0,C1,0>}
      cylinder{<-.2,0,0><-.2,-.4,0> WD rotate<0,C1,0>}
      cylinder{<.2,0,0><.2,-.4,0> WD rotate<0,C1,0>}
      #declare C1=C1+20;
   #end
   torus{.2,WD}
   torus{.2,WD translate<0,-.1,0>}
   torus{.2,WD translate<0,-.2,0>}
   torus{.2,WD translate<0,-.3,0>}
   torus{.195,WD translate<0,.04,0>}
   torus{.178,WD translate<0,.1,0>} 
   torus{.1,WD translate<0,.175,0>}
   torus{.05,WD translate<0,.19,0>} 
   
   difference{  // bottom
     cylinder{<0,-.4,0><0,-.37,0> .2}
     cylinder{<0,-.395,0><0,-.36,0>.195}
   }      
   torus{.025,WD rotate<90,0,0> translate<0,.2,0>} //top ring
} 
#declare WSD=.165;  //stand top diameter
#declare StandTop=difference{
    torus{WSD,.007 rotate<90,0,0>}
    box{<-WSD-.01,-WSD-.01,-WSD-.01><WSD+.01,0,WSD+.01>}
}

#declare Stand=union{
    object{StandTop}
    sphere{<WSD,0,0> .015}
    cone{<WSD,0,0> .005 <WSD,-.2,0> .02}
    cylinder{<WSD,-.2,0><WSD,-2.25,0>.019 texture{T_Wood1 rotate<90,0,0> scale .2}}
    cone{<WSD,-1.95,0>.02<WSD,-2.25,0>.025}
    cone{<WSD,-2.25,0>.18<WSD,-2.3,0> .2}
    
    torus{.025,WD rotate<90,0,0> translate<-WSD-.01,-.025,0>}
}  

#ifdef(ImageMapOn)
  #declare Parrot=box{<0,0,0><1,1,0> 
    texture{pigment{image_map { gif "..\graphics\redparrot.gif" map_type 0 transmit 127, 1.0 once  } scale <.2,.32,1> }} 
  }
#end   

#declare BirdCage=union{
  object{Stand texture{T_Brass_1E}}
  object{Cage translate<-WSD,-.25,0> texture{T_Brass_1A}}
  #ifdef(ImageMapOn)
    object{Parrot translate<-WSD-.081,-.63,-.05>}
  #end
  translate<0,2.25,0>
} 
//_______________________________________________________ END Bird Cage



//_______________________________________________________BOOKS

#macro BookTitle(TY,WX,LZ)
// Global variable is NextTitle Incremented outside this routine and used to determine the next title returned
//#declare NextTitle=10; // for testing purposes

  #switch (NextTitle)
    #case(1) 
        text{ ttf "timrom.ttf","Pure Magic",.1,0 pigment{color Red} scale .05 rotate<0,-90,0> translate<WX+.002,TY/3,-LZ+(LZ*.5)>}
        box{<-WX,0,-LZ+(LZ*.20)><WX+.0023,TY+.0031,-LZ+(LZ*.40)> texture{T_Copper_1A}}
        box{<-WX,0,LZ-(LZ*.20)><WX+.0023,TY+.0031,LZ-(LZ*.40)> texture{T_Copper_1A}}
      #break    
    #case(2)
        box{<WX,TY/4,-LZ+(LZ*.4)><WX+.0022,TY/4*3,LZ-(LZ*.4)> texture{pigment{color Turquoise}}} 
        text{ ttf "timrom.ttf","The Art of Magic",.1,0 pigment{color Blue} scale .05 rotate<0,-90,0> translate<WX+.0022,TY/3,-LZ+(LZ*.5)>}
        box{<-WX,0,-LZ+(LZ*.20)><WX+.0023,TY+.0031,-LZ+(LZ*.30)> texture{pigment{color Turquoise}}}
        box{<-WX,0,LZ-(LZ*.20)><WX+.0023,TY+.0031,LZ-(LZ*.30)> texture{pigment{color Turquoise}}}
      #break     
    #case(3)
        box{<WX,TY/4,-LZ+(LZ*.38)><WX+.0022,TY/4*3,LZ-(LZ*.38)> texture{pigment{color Black}}} 
        text{ ttf "timrom.ttf","Men are From Mars",.1,0 pigment{color Gold} scale .05 rotate<0,-90,0> translate<WX+.0022,TY/3,-LZ+(LZ*.4)>}
        box{<-WX,0,-LZ+(LZ*.20)><WX+.0023,TY+.0031,-LZ+(LZ*.30)> texture{pigment{color Black}}}
        box{<-WX,0,LZ-(LZ*.20)><WX+.0023,TY+.0031,LZ-(LZ*.30)> texture{pigment{color Black}}}
      #break     
    #case(4)
        box{<WX,TY/4,-LZ+(LZ*.38)><WX+.0022,TY/4*3,LZ-(LZ*.38)> texture{pigment{color Gray10}}} 
        text{ ttf "timrom.ttf","Venician Women",.1,0 pigment{color Gold} scale .05 rotate<0,-90,0> translate<WX+.0022,TY/3,-LZ+(LZ*.43)>}
        box{<-WX,0,-LZ+(LZ*.20)><WX+.0023,TY+.0031,-LZ+(LZ*.30)> texture{pigment{color Black}}}
        box{<-WX,0,LZ-(LZ*.20)><WX+.0023,TY+.0031,LZ-(LZ*.30)> texture{pigment{color Black}}}  
      #break
    #case(5)
        box{<WX,TY/4,-LZ+(LZ*.38)><WX+.0022,TY/4*3,LZ-(LZ*.38)> texture{pigment{color Gold}}} 
        text{ ttf "timrom.ttf","Spells",.1,0 pigment{color Black} scale .05 rotate<0,-90,0> translate<WX+.0022,TY/3,-LZ+(LZ*.75)>}
        box{<-WX,0,-LZ+(LZ*.20)><WX+.0023,TY+.0031,-LZ+(LZ*.25)> texture{pigment{color Gold}}}
        box{<-WX,0,-LZ+(LZ*.28)><WX+.0023,TY+.0031,-LZ+(LZ*.30)> texture{pigment{color Gold}}}
        box{<-WX,0,LZ-(LZ*.20)><WX+.0023,TY+.0031,LZ-(LZ*.25)> texture{pigment{color Gold}}}          
        box{<-WX,0,LZ-(LZ*.28)><WX+.0023,TY+.0031,LZ-(LZ*.30)> texture{pigment{color Gold}}}  
      #break        
    #case(6)
        box{<WX,TY/4,-LZ+(LZ*.38)><WX+.0022,TY/4*3,LZ-(LZ*.38)> texture{pigment{color Gold}}} 
        text{ ttf "timrom.ttf","Potions",.1,0 pigment{color Black} scale .05 rotate<0,-90,0> translate<WX+.0022,TY/3,-LZ+(LZ*.75)>}
        box{<-WX,0,-LZ+(LZ*.20)><WX+.0023,TY+.0031,-LZ+(LZ*.25)> texture{pigment{color Gold}}}
        box{<-WX,0,-LZ+(LZ*.28)><WX+.0023,TY+.0031,-LZ+(LZ*.30)> texture{pigment{color Gold}}}
        box{<-WX,0,LZ-(LZ*.20)><WX+.0023,TY+.0031,LZ-(LZ*.25)> texture{pigment{color Gold}}}          
        box{<-WX,0,LZ-(LZ*.28)><WX+.0023,TY+.0031,LZ-(LZ*.30)> texture{pigment{color Gold}}}  
      #break           
    #case(7)
        box{<WX,TY/4,-LZ+(LZ*.38)><WX+.0022,TY/4*3,LZ-(LZ*.38)> texture{pigment{color Gold}}} 
        text{ ttf "timrom.ttf","MetaMagic",.1,0 pigment{color Black} scale .05 rotate<0,-90,0> translate<WX+.0022,TY/3,-LZ+(LZ*.65)>}
        box{<-WX,0,-LZ+(LZ*.20)><WX+.0023,TY+.0031,-LZ+(LZ*.25)> texture{pigment{color Gold}}}
        box{<-WX,0,-LZ+(LZ*.28)><WX+.0023,TY+.0031,-LZ+(LZ*.30)> texture{pigment{color Gold}}}
        box{<-WX,0,LZ-(LZ*.20)><WX+.0023,TY+.0031,LZ-(LZ*.25)> texture{pigment{color Gold}}}          
        box{<-WX,0,LZ-(LZ*.28)><WX+.0023,TY+.0031,LZ-(LZ*.30)> texture{pigment{color Gold}}}  
      #break           
    #case(8)
        box{<WX,TY/4,-LZ+(LZ*.38)><WX+.0022,TY/4*3,LZ-(LZ*.38)> texture{pigment{color Black}}} 
        text{ ttf "timrom.ttf","Black Magic",.1,0 pigment{color Gold} scale .05 rotate<0,-90,0> translate<WX+.0022,TY/3,-LZ+(LZ*.65)>}
        box{<-WX,0,-LZ+(LZ*.20)><WX+.0023,TY+.0031,-LZ+(LZ*.25)> texture{pigment{color Black}}}
        box{<-WX,0,-LZ+(LZ*.28)><WX+.0023,TY+.0031,-LZ+(LZ*.30)> texture{pigment{color Black}}}
        box{<-WX,0,LZ-(LZ*.20)><WX+.0023,TY+.0031,LZ-(LZ*.25)> texture{pigment{color Black}}}          
        box{<-WX,0,LZ-(LZ*.28)><WX+.0023,TY+.0031,LZ-(LZ*.30)> texture{pigment{color Black}}}  
      #break          
    #case(9)
        box{<WX,TY/4,-LZ+(LZ*.28)><WX+.0022,TY/4*3,LZ-(LZ*.28)> texture{pigment{color Turquoise}}} 
        text{ ttf "timrom.ttf","Kamasutra",.1,0 pigment{color Gold} scale .05 rotate<0,-90,0> translate<WX+.0022,TY/3,-LZ+(LZ*.65)>}
      #break    
    #case(10)
        box{<WX,TY/4,-LZ+(LZ*.28)><WX+.00231,TY/4*3,LZ-(LZ*.28)> texture{pigment{color Black}}} 
        text{ ttf "timrom.ttf","Mechanical Drawing",.1,0 pigment{color Gold} scale .05 rotate<0,-90,0> translate<WX+.00231,TY/3,-LZ+(LZ*.32)>}
        box{<-WX,0,-LZ+(LZ*.20)><WX+.0023,TY+.0031,-LZ+(LZ*.25)> texture{pigment{color Black}}}
        box{<-WX,0,-LZ+(LZ*.28)><WX+.0023,TY+.0031,-LZ+(LZ*.30)> texture{pigment{color Black}}}
        box{<-WX,0,LZ-(LZ*.20)><WX+.0023,TY+.0031,LZ-(LZ*.25)> texture{pigment{color Black}}}          
        box{<-WX,0,LZ-(LZ*.28)><WX+.0023,TY+.0031,LZ-(LZ*.30)> texture{pigment{color Black}}}  
      #break                                                      
  #end // switch    
  #declare NextTitle=NextTitle+1;
  #if (NextTitle>10)
     #declare NextTitle=1;
  #end    
#end
                                                                  
#macro Bookit(SS,ThickY)
#declare S1=seed(SS);
//#declare ThickY=rand(S1)*.05+.05;  // book is a min of .05 thick
#declare WideX=rand(S1)*.2+.15;   // min of .15 wide
#declare LengthZ=rand(S1)*.3+.2;  // min of .2 long  
#declare CCover=int(rand(SS)*29)+1;  // color of cover
union{
   box{<-WideX,.003,-LengthZ><WideX-.004,ThickY,LengthZ> texture{pigment{color Wheat}}}
  union{ 
   box{<-WideX-.005,0,-LengthZ-.005><WideX,.0015,LengthZ+.005> }  // covers
   box{<-WideX-.005,ThickY,-LengthZ-.005><WideX,ThickY+.003,LengthZ+.005> }
   
   //box{<WideX,0,-LengthZ-.005><WideX+.0015,ThickY+.003,LengthZ+.005> } //spine
   difference{
     cylinder{<0,ThickY/2,-LengthZ-.005><0,ThickY/2,LengthZ+.005>WideX+.002}
     cylinder{<0,ThickY/2,-LengthZ-.1><0,ThickY/2,LengthZ+.1> WideX-.006}
     box{<-WideX-.1,-WideX-.1,-LengthZ-.1><WideX-.009,WideX+.1,LengthZ+.1>}
     box{<-WideX,ThickY+.003,-LengthZ-.1><WideX+.2,WideX+.1, LengthZ+.1>} // take off top
     box{<-WideX,0,-LengthZ-.1><WideX+.2,-WideX-.1,LengthZ+.1>} //take off bottom
   }  
//   texture{T_Grnt9 scale .05}
//   texture{T_Grnt11 scale .1}
                 
   texture{  //pigment{color 
     #switch (CCover)
       #case(1) T_Grnt1 scale .1 #break
       #case(2) T_Grnt2 scale .1 #break
       #case(3) T_Grnt3 scale .1 #break
       #case(4) T_Grnt4 scale .1 #break
       #case(5) T_Grnt5 scale .1 #break
       #case(6) T_Grnt6 scale .1 #break
       #case(7) T_Grnt7 scale .1 #break
       #case(8) T_Grnt8 scale .1 #break
       #case(9) T_Grnt9 scale .05 #break
       #case(10) T_Grnt10 scale .1 #break
       #case(11) T_Grnt11 scale .1 #break        
       #case(12) T_Grnt12 scale .1 #break
       #case(13) T_Grnt13 scale .1 #break    
       #case(14) T_Grnt14 scale .1 #break    
       #case(15) T_Grnt15 scale .1 #break    
       #case(16) T_Grnt16 scale .1 #break    
       #case(17) T_Grnt17 scale .1 #break    
       #case(18) T_Grnt18 scale .1 #break    
       #case(19) T_Grnt19 scale .1 #break    
       #case(20) T_Grnt20 scale .1 #break    
       #case(21) T_Grnt21 scale .1 #break    
       #case(22) T_Grnt22 scale .1 #break    
       #case(23) T_Grnt23 scale .1 #break    
       #case(24) T_Grnt24 scale .1 #break    
       #case(25) T_Grnt25 scale .1 #break    
       #case(26) T_Grnt26 scale .1 #break    
       #case(27) T_Grnt27 scale .1 #break    
       #case(28) T_Grnt28 scale .1 #break    
       #case(29) T_Grnt29 scale .1 #break    
              
     #end // switch
     }  
//     }} // end texture
  } // union
           
   
   #declare PC=5+int(rand(S1)*10);
   #declare C1=1;
   #while (C1<=PC)
      #declare P1=rand(S1)*.01+.005;
      #declare P2=rand(S1)*.01+.005;
      #declare P3=.003+rand(S1)*(ThickY-.003);
      triangle{<-WideX,P3,LengthZ+.0025><-WideX-P1,P3,-LengthZ-.0025-P2><WideX,P3,-LengthZ-.0025> texture{pigment{color Wheat}}}
      #declare C1=C1+1;
   #end

   #declare PC=5+int(rand(S1)*10);
   #declare C1=1;
   #while (C1<=PC)
      #declare P1=rand(S1)*.01+.005;
      #declare P2=rand(S1)*.01+.005;
      #declare P3=.003+rand(S1)*(ThickY-.003);
      triangle{<-WideX,P3,-LengthZ-.0025><-WideX-P1,P3,LengthZ+.0025+P2><WideX,P3,LengthZ+.0025> texture{pigment{color Wheat}}}
      #declare C1=C1+1;
   #end
   BookTitle(ThickY,WideX,LengthZ)
}
#end // macro Bookit
   
#macro BookStack(Howmany,BS,XX,YY,ZZ)  
//#declare BS=seed(3393); // seed for book stack
//#declare Howmany=10;
  #declare CC1=1;
  #declare S=0; //stack starts at 0
  #while (CC1<=Howmany)
    #declare ThickY=rand(BS)*.05+.05;  // book is a min of .05 thick
    #declare ROY=rand(BS)*60-30;  
    object{Bookit(rand(BS),ThickY) rotate<0,ROY,0> translate<XX,YY+S,ZZ>}
    #declare S=S+ThickY+.003;
    #declare CC1=CC1+1;
  #end
#end // macro BookStack
                                                                
//_______________________________________________________END BOOKS

//_______________________________________________________Mirror
#declare MirrorStandFlower=difference{                               
     cylinder{<0,0,-.0064><0,0,0> .025}
     sphere{<0,0,-.006> .005}
     #declare C1=0;
     #while (C1<=360)
        sphere{<0,.0051,-.006> .005 scale<1,2.5,2> rotate<0,0,C1>}
        #declare C1=C1+30;
     #end
}
#declare MirrorStandDetails=union{
   cylinder{<-.02,0,0><-.02,.3,0> .009}
   cylinder{<0,0,0><0,.3,0> .009}
   cylinder{<.02,0,0><.02,.3,0> .009}
   sphere{<-.02,0,0> .012}
   sphere{<0,0,0> .012}
   sphere{<.02,0,0> .012}
   box{<-.03,-.022,-.014><.03,-.0185,0>}
   sphere{<-.02,.3,0> .012}
   sphere{<0,.3,0> .012}
   sphere{<.02,.3,0> .012}
   box{<-.03,-.022,-.014><.03,-.0185,0> translate<0,.34,0>} 
                               
   object{MirrorStandFlower translate<0,.36,0>}
   object{MirrorStandFlower translate<0,-.06,0>}
   
   texture{T_Wood1 scale .1 rotate<90,0,0>}
}

#declare BrassFit=union{
  box{<-.027,-.01,-.052><.027,.01,.052> texture{T_Brass_1E}}
  cylinder{<0,0,-.053><0,0,.053>.0075 texture{T_Brass_1E}}
  sphere{<0,0,-.053> .007 texture{T_Ruby_Glass}}
}
#declare MirrorRim=union{
   difference{
      cylinder{<0,0,-.05><0,0,.05> .3}
      cylinder{<0,0,-.051><0,0,.051> .25}
      box{<-.31,-.31,-.051><.31,0,.051>} // shave off bottom half
     translate<0,.75,0>
   }
   difference{
      cylinder{<0,0,-.05><0,0,.05> .3}
      cylinder{<0,0,-.051><0,0,.051> .25}
      box{<-.31,0,-.051><.31,.31,.051>} // shave off top half
     translate<0,.25,0>
   }
   box{<-.3,.25,-.05><-.25,.75,.05>}
   box{<.3,.25,-.05><.25,.75,.05>}       
   
    // Mirror glazing
   union{
      cylinder{<0,.75,-.001><0,.75,.001> .25}
      cylinder{<0,.25,-.001><0,.25,.001> .25}
      box{<-.25,.25,-.001><.25,.75,.001>}
     texture{T_Brass_1E}
     texture{ 
           pigment{crackle 
                    color_map {[0.0 rgbt <0.9400, 0.8100,0.9900,.95>]
                               [.015 rgbt <0.9400, 0.8100,0.9900,.85>]
                               [.025 rgbt <1.0,1.0,1.0,1.0>]
                               [1.0 rgbt <1.0,1.0,1.0,1.0>]
                              }
                  } scale .25
          }
         finish{ambient 4.5} 
     #ifdef(ImageMapOn)    
       texture{pigment{image_map{ gif "99vista.gif" map_type 0 once filter all .8 }} scale 1 translate<-.35,0,0>}         
     #end
    } // union for Mirror Glazing

   #declare R1=0;
   #while (R1<=180)
     object{BrassFit translate<.275,0,0> rotate<0,0,R1> translate<0,.75,0>}
     object{BrassFit translate<-.275,0,0> rotate<0,0,R1> translate<0,.25,0>}
     #declare R1=R1+22.5;
   #end   
   #declare H1=.35;
   #while (H1<=.65)
      object{BrassFit translate<-.275,H1,0>}
      object{BrassFit translate<.275,H1,0>}
      #declare H1=H1+.1;
   #end

   #declare R1=11.25;
   #while (R1<=169.75)
     object{MirrorStandFlower translate<.275,0,0> rotate<0,0,R1> translate<0,.75,-.05>}
     object{MirrorStandFlower translate<-.275,0,0> rotate<0,0,R1> translate<0,.25,-.05>}
     #declare R1=R1+22.5;
   #end   
   #declare H1=.4;
   #while (H1<=.6)
      object{MirrorStandFlower translate<-.275,H1,-.05>}
      object{MirrorStandFlower translate<.275,H1,-.05>}
      #declare H1=H1+.1;
   #end     
   
   
 texture{T_Wood1 scale .2 rotate<90,0,0>}
} 

#declare MirrorStandFoot=union{
   box{<-.03,-.02,-.03><.03,.02,.05> rotate<-30,0,0>}  
   sphere{<0,0,-.03> .03 scale <1.4,1,1>}
   sphere{<0,-.01,0> .028 scale <1,1.5,1> rotate<60,0,0> translate<0,0,-.05> rotate<0,30,0>  rotate<-30,0,0>}
   sphere{<0,-.01,0> .028 scale <1,1.5,1> rotate<60,0,0> translate<0,0,-.05> rotate<0,0,0>   rotate<-20,0,0>}
   sphere{<0,-.01,0> .028 scale <1,1.5,1> rotate<60,0,0> translate<0,0,-.05> rotate<0,-30,0> rotate<-30,0,0>}
}
      
#declare MirrorStand=union{
   box{<-.38,.1,-.05><-.32,.6,.05>} 
   cylinder{<-.38,.6,0><-.32,.6,0> .05}   
   cylinder{<-.4,.6,0><-.3,.6,0> .035 texture{T_Brass_1E}}
   difference{
     cylinder{<-.38,0,0><-.32,0,0> .12}
     cylinder{<-.381,0,0><-.31,0,0>.06}
   }
   
   box{<.38,.1,-.05><.32,.6,.05>}
   cylinder{<.38,.6,0><.32,.6,0> .05}                     
   cylinder{<.3,.6,0><.4,.6,0> .035 texture{T_Brass_1E}}
   difference{
     cylinder{<.38,0,0><.32,0,0> .12}
     cylinder{<.381,0,0><.31,0,0> .06}
   }
   
   object{MirrorStandFoot translate<-.35,-.1,-.15>}
   object{MirrorStandFoot rotate<0,180,0> translate<-.35,-.1,.15>}
   object{MirrorStandFoot translate<.35,-.1,-.15>}
   object{MirrorStandFoot rotate<0,180,0> translate<.35,-.1,.15>}   
   
 
   object{MirrorStandDetails translate<-.35,.2,-.05>}
   object{MirrorStandDetails translate<.35,.2,-.05>}  
   
  texture{T_Wood1 scale .2 rotate<90,0,0>}
}
#declare MirrorX=union{
  object{MirrorRim rotate<10,0,0> translate<0,0,-.1>}
  object{MirrorStand}                                                                      
} 
//_______________________________________________________END Mirror


#declare FirePlaceArch=difference{
    cylinder{<0,0,-.12><0,0,.12>1.05}
    cylinder{<0,0,-.121><0,0,.121> .74}
    box{<-1.1,-1.1,-.121><1.1,0,.121>}
    #declare C1=15;
    #while (C1<360)
      box{<-.01,-1.1,-.121><.01,1.1,.121> rotate<0,0,C1>}
      #declare C1=C1+30;
    #end
    texture{T_Stone1 scale .25}
}    
#declare FirePlace=union{
  difference{
     box{<-1,0,-1><1,10,1>}
     box{<-.75,.25,-1.1><.75,1.75,.5>}  // firebox
     cylinder{<0,1.75,-1.1><0,1.75,.5>.75}
    #ifdef(ImageMapOn)
     texture{pigment{image_map { gif "..\graphics\brick065.gif" map_type 0 } scale <2,2,1> }}     
    #else
     texture{T_MixBrick scale .0325}
    #end //ifdef(ImageMapOn)
  } // difference
  
  object{FirePlaceArch translate<0,1.75,-.95>}
  
  box{<-1.5,0,-1.75><1.5,.24,1> texture{T_WhiteBrick scale .0625}}
  box{<-1.5,.2,-1.75><1.5,.245,1> 
            texture{checker texture{T_Stone1 scale .25},texture{T_Stone14 
              scale .25} scale .5 rotate<0,45,0>} 
     }       
}
#declare FirePlaceScreenSun=union{
     cylinder{<0,0,-.005><0,0,.005> .085}
     torus{.15, .01 rotate<90,0,0>}
     #declare C1=0;
     #while (C1<=360)
        cylinder{<0,0,0><0,.15,0> .0085 rotate<0,0,C1>}
        #declare C1=C1+20;
     #end
}
#declare FirePlaceScreenPanel=union{ 
    object{FirePlaceScreenSun translate<0,.2,0>}
    object{FirePlaceScreenSun translate<0,.5,0>}
    object{FirePlaceScreenSun translate<0,.8,0>} 
    object{FirePlaceScreenSun translate<0,1.1,0>}
    
    difference{
      cylinder{<0,0,-.005><0,0,.005> .17}
      cylinder{<0,0,-.0051><0,0,.0051> .14}
      box{<-.18,-.18,-.0051><.18,0,.0051>}
      translate<0,1.1,0>  // move up into position
    }
    box{<-.17,.05,-.005><-.14,1.1,.005>}
    box{<.17,.05,-.005><.14,1.1,.005>}
    box{<-.17,.05,-.005><.17,.085,.005>}
    
    sphere{<-.15,.025,0> .035}
    sphere{<.15,.025,0> .035}
    
    texture{T_Brass_1E}
}

#declare FirePlaceScreen=union{
    object{FirePlaceScreenPanel rotate<0,45,0> translate<-.25,0,0>}
    object{FirePlaceScreenPanel rotate<0,-45,0> translate<-.5,0,0>}
    object{FirePlaceScreenPanel rotate<0,45,0> translate<0,0,0>}
    object{FirePlaceScreenPanel rotate<0,-45,0> translate<.25,0,0>}  
    object{FirePlaceScreenPanel rotate<0,45,0> translate<.5,0,0>}
    scale 1.5
}   

#declare Pepsi=union{  
   difference{
      union{
         cylinder{<0,0,0><0,.55,0> .15
          #ifdef(ImageMapOn)
            texture{pigment{image_map { gif "..\graphics\pepsi.gif" map_type 2} translate<0,0,0> rotate<0,-20,0> scale <.10,.55,.20>}}
          #else
            texture{pigment{color Blue}}
          #end
         }
         cylinder{<0,.55,0><0,.565,0> .14 }
       }
      cylinder{<0,.53,0><0,.5651,0>.13 }
       texture{pigment{color Gray40} finish{F_Glass4}}
    }
   difference{
      union{
         cylinder{<-.08,0,0><-.08,.01,0>.1}
         cylinder{<.08,0,0><.08,.01,0>.1}
         box{<-.08,0,-.1><.08,.01,.1>}
      }
      cylinder{<0,-.01,0><0,.011,0> .05 scale<.9,1,1.6> translate<-.085,0,0>}
      cylinder{<0,-.01,0><0,.011,0> .05 scale<.9,1,1.6> translate<.08,0,0>} 
      texture{pigment{color Gray40} finish{F_Glass4}} 
      scale .40
      rotate<0,0,-30> translate<-.031,.56,0>
    }
    
    cylinder{<0,0,0><0,.001,0>.025 scale<1.5,1,2.5> translate<.06,.53,0> texture{pigment{color Black}}} 
    scale .2
} // pepsi can

#declare RadBox=union{
   superellipsoid { <.25, .25>
    pigment { Gray40 } 
    scale .125
  }
  box{<-.125,-.005,-.125><.125,-.001,.125> texture{pigment{color Silver}}} 
  box{<-.125,.005,-.125><.125,.001,.125> texture{pigment{color Silver}}}  
  box{<0,0,0><1,1,.001>
     #ifdef(ImageMapOn)
       texture{pigment{image_map { gif "..\graphics\warning.gif" map_type 0} translate<0,0,0> rotate<0,0,0> scale <1,1,1>}}     
     #else
       texture{pigment{color Red}}
     #end
     scale .09 translate<-.05,.01,-.125>}
}

#declare Love9=union{
    
    sphere{<0,0,0> .05  scale<1.5,1,1>
          texture{pigment{color Wheat}}
          #ifdef(ImageMapOn)
            texture{pigment{image_map { gif "..\graphics\love9.gif" map_type 1 transmit 0, 1.0 once } rotate<0,-90,0> }}
          #end
    }    
 
    cone{<0,.04,0>.015<0,.1,0>.01  }  
    torus{.01 .005 translate<0,.1,0>}
    torus{.015 .005 rotate<90,0,0> translate<-.015,.06,0>}
    torus{.015 .005 rotate<90,0,0> translate<.015,.06,0>}
    cylinder{<0,-.05,0><0,0,0> .03}   // base of bottle  
    cone{<0,.1,0> .008 <0,.12,0> .01 texture{Cork scale .01}} 

   texture{pigment{color Wheat}}    
}      

#declare Newt=union{
    torus{.045 .005}
    cylinder{<0,.0021,0><0,.05,0> .05  
          texture{pigment{color SlateGray}}
          #ifdef(ImageMapOn)
            texture{pigment{image_map { gif "..\graphics\newt.gif" map_type 2 transmit 0, 1.0 once  } scale .05 rotate<0,-110,0> }}
          #end
    }
    cylinder{<0,.05,0><0,.06,0>.045}
    cylinder{<0,.06,0><0,.07,0>.046}
    cone{<0,.07,0>.04 <0,.08,0> .045 texture{Cork scale .01}}
    
    texture{pigment{color SlateGray}}    
}
#declare Tails=union{
    difference{
      union{
        torus{.045 .005}
        torus{.03 .0005 translate<0,.13,0>}
        torus{.03 .0005 translate<0,.125,0>}
        cone{<0,.1,0>.05 <0,.12,0> .03} 
        cone{<0,.12,0>.03 <0,.13,0> .03}
        cylinder{<0,.05,0><0,.1,0> .05  
          #ifdef(ImageMapOn)
             texture{pigment{image_map { gif "..\graphics\lizardt.gif" map_type 2 transmit 0, 1.0 once  } scale .05 rotate<0,-90,0> translate<0,.05,0> }}
          #else
             texture{T_Old_Glass}
          #end
        }                      
        cylinder{<0,.0021,0><0,.06,0> .05}
        } // union     
      cone{<0,.1,0>.049 <0,.12,0> .029}
      cone{<0,.12,0>.029 <0,.131,0> .029}
      cylinder{<0,.0031,0><0,.101,0> .049}
    texture{T_Old_Glass}
    } //difference 
    
    #declare C1=0;
    #declare TR=seed(383);
    #while (C1<100)
       #declare RX=rand(TR)*.035;
       #declare RZ=rand(TR)*.035;
       #declare RY=rand(TR)*.03;
       #declare RX1=rand(TR)*-.035;
       #declare RZ1=rand(TR)*-.035;
       #declare RY1=rand(TR)*.03;
       cone{<RX,RY,RZ>.002<RX1,RY1,RZ1>.001 texture{pigment{color Orange}}}
       #declare C1=C1+1;
    #end
      
}// tails

#declare Cheshire=union{
    torus{.045 .005}
    cylinder{<0,.0021,0><0,.075,0> .05  
          texture{pigment{color Gray}}  
          #ifdef(ImageMapOn)
            texture{pigment{image_map { gif "..\graphics\ches.gif" map_type 2 transmit 0, 1.0 once  } scale .08 rotate<0,-110,0> }}
          #end
    }
    cylinder{<0,.075,0><0,.08,0>.045}
    cylinder{<0,.08,0><0,.09,0>.046}
    cone{<0,.09,0>.04 <0,.10,0> .045 texture{Cork scale .01}}
    
    texture{pigment{color Gray}}    
}
 
#declare Ambrosia=union{
    torus{.045 .005}
    cylinder{<0,.0021,0><0,.075,0> .05  
          texture{pigment{color Turquoise}}
          #ifdef(ImageMapOn)
            texture{pigment{image_map { gif "..\graphics\ambro.gif" map_type 2 transmit 0, 1.0 once  } scale .08 rotate<0,-110,0> }}
          #end
    }
    cone{<0,.075,0>.05<0,.08,0>.025}
    cylinder{<0,.08,0><0,.09,0>.026}
    cone{<0,.09,0>.02 <0,.10,0> .022 texture{Cork scale .01}}
    
    texture{pigment{color Turquoise}}    
} 
#declare Tag=difference{
  box{<0,0,0><1,1,0>
    #ifdef(ImageMapOn)
      texture{pigment{image_map { gif "..\graphics\love9dlt.gif" map_type 0 transmit 0, 1.0 once  } scale <.065,.045,1> rotate<0,0,0> }} 
    #else
      texture{pigment{color Wheat}}
    #end
   }
  cylinder{<.08,.5,-.1><.08,.5,.1> .05 scale <.065,.045,1>}
}
#declare Love9Small=union{
    cylinder{<0,0,0><0,.02,0> .025}
    cone{<0,.02,0>.025 <0,.045,0> .01}
    cylinder{<0,.045,0><0,.05,0> .01}
    torus{.01 .0005 translate<0,.05,0>} 
    cone{<0,.05,0> .007 <0,.06,0> .009 texture{Cork scale .05}}
    torus{.011,.0005   texture{pigment{color Red}} translate<0,.047,0>}
    torus{.011,.0005   texture{pigment{color Red}} rotate<0,0,10> translate<0,.048,0>}
    cone{<.011,.047,0> .0005 <.02,.035,-.015> .0005 texture{pigment{color Red}}}
    cone{<.005,.047,.011> .0005 <.02,.035,-.014> .0005 texture{pigment{color Red}}}
    
    text{ ttf "timrom.ttf","#9",.1,0 pigment{color Gold} scale <.025,.025,.05> rotate<0,0,0> translate<-.01,.0025,-.0251>}                
    object{Tag rotate<45,0,0> rotate<0,0,-30> translate<.009,.020,-.029>}
  texture{pigment{color Wheat}}
} 

#declare Star=union{
   #declare C1=0;
   #while (C1<=360)
    
     box{<0,0,0><.05,.05,.001> rotate<0,0,45> scale<1,2,1> translate<0,-.017,0> rotate<0,0,C1>}
     #declare C1=C1+72;
   #end
   union{ // pin                          
     sphere{<.04,.05,-.02> .01 texture{pigment{color Red}}}
     cone{<.01,.04,0>.0025<.04,.05,-.02>.0025}
     cone{<-.02,.02,0>.0025<-.05,.02,-.02>.0015}
     texture{pigment{color Silver}}
   }
   texture{pigment{color Wheat}}
   scale .5
}
   
#declare WizHat=union{
   cone{<0,0,0>.125<0,.25,0>.08}
   sphere{<0,.25,0> .08}
   cone{<0,.25,0>.08 <.3,.2,0> .02}
   sphere{<.3,.2,0> .02}
   cone{<.3,.2,0> .02 <.35,.15,0> 0}
   cylinder{<0,0,0><0,.005,0> .15}
   torus{.15,.006}
   
   object{Star rotate<18.5,0,0> translate<0,.1,-.115> }
   
   texture{pigment{color DarkBlue}  normal { bumps 0.8  scale < .015, 0.085, 0.005 > }}
}   

#declare Star2=union{
   #declare C1=0;
   #while (C1<=360)
    
     box{<0,0,0><.05,.05,.001> rotate<0,0,45> scale<1,2,1> translate<0,-.017,0> rotate<0,0,C1>}
     #declare C1=C1+72;
   #end
   texture{pigment{color Wheat}}
   scale .5
}
                                      
#declare Wand1=union{
   cylinder{<0,-.14,0><0,.14,0> .005 texture{pigment{color Gray10}}}
   cylinder{<0,-.18,0><0,.18,0> .0049 texture{pigment{color White}}}  
   translate<0,.18,0>
}
#declare Wand2=union{
   cylinder{<0,-.14,0><0,.14,0> .0035 texture{pigment{color Red}}}
   cone{<0,.14,0> .0035 <0,.18,0> .004 texture{T_Brass_1E}}
   translate<0,.14,0>
}
#declare Wand3=union{
   cylinder{<0,-.14,0><0,.14,0> .0045 texture{pigment{color Turquoise}}}
   cone{<0,.14,0> .0045 <0,.17,0>.003 texture{pigment{color Turquoise}}}
   torus{.0055 .005 translate<0,.14,0> texture{T_Brass_1E}}
   torus{.0055 .005 translate<0,.154,0> texture{T_Brass_1E}}
   torus{.0055 .005 translate<0,.168,0> texture{T_Brass_1E}}
   translate<0,.14,0>
}                            
#declare Wand4=union{
   cylinder{<0,-.14,0><0,.12,0> .0045 texture{T_Wood1 rotate<90,0,0> scale .005}}
   cone{<0,.12,0>.0045 <0,.14,0> .004 texture{T_Wood1 rotate<90,0,0> scale .005}}
   object{Star2 scale .35 translate<0,.15,0> texture{pigment{Gold}}}
   translate<0,.14,0>
} 
#declare Wand5=union{
   cone{<0,-.16,0> .005 <0,0,0> .003}
   cone{<0,0,0> .003 <0,.16,0> .005}
   texture{pigment{color Yellow}}
   translate<0,.16,0>
} 
#declare Forkh=union{
  difference{
    union{
      cone{<0,-.1,0>.01 <0,0,0> .005}
      sphere{<0,-.1,0>.01}
     }
     box{<-.02,-.11,.005><.02,.01,.02>}
     box{<-.02,-.11,-.02><.02,.01,-.005>}
   }
   difference{
     sphere{<0,.01,0> .02} 
     cylinder{<-.021,.01,0><.021,.01,0> .015}
     box{<-.022,-.011,-.005><.022,.03,-.035>}
     cylinder{<-.02,0,-.05><-.02,0,.05> .015}
     cylinder{<.02,0,-.05><.02,0,.05> .015} 
     scale <1,1,.25>
     translate<0,.01,-.005>
   }
   box{<-.011,.033,-.0045><-.007,.075,0>}
   box{<.011,.033,-.0045><.007,.075,0>}
   box{<-.002,.033,-.0045><.002,.07,0>}
   texture{pigment{color Silver}}
   translate<0,.1,0>
}  

#declare WandJar=difference{
  union{
   cylinder{<0,.1,0><0,.08,0> .04}
   torus{.04 .001 translate<0,.09,0>}
   torus{.04 .001 translate<0,.095,0>}
   torus{.04 .001 translate<0,.1,0>}
   cone{<0,.08,0>.04<0,.07,0> .06}
   torus{.05 .01 translate<0,.07,0>}
   cylinder{<0,.01,0><0,.07,0> .06}
   torus{.05 .01 translate<0,.01,0>}     
  }
   cylinder{<0,.11,0><0,.08,0> .0395}
   cone{<0,.08,0>.0395<0,.07,0> .0595}
   torus{.0495 .0095 translate<0,.07,0>}
   cylinder{<0,.012,0><0,.07,0> .0595}
   torus{.0495 .0095 translate<0,.01,0>}        
  texture{T_Old_Glass}
}


#declare WandArray=union{
  object{WandJar translate<0,0,0>} 
  object{Wand1 rotate<-5,0,5> translate<0,0,.05>}
  object{Wand2 rotate<0,0,0> translate<.015,0,.035>}
  object{Wand1 rotate<0,0,-40> translate<-.05,0,0>}
  object{Wand3 rotate<0,0,20> translate<.01,0,.03>}  
  object{Wand4 rotate<0,0,-10> translate<0,0,.03>}
  object{Wand5 rotate<0,0,40> translate<.05,0,.01>}
  object{Forkh rotate<0,0,-8> translate<-0.02,0,0.03>}
} 
//-------------------------------- Chinese Food Box
#declare CFH=.10;

#declare CFBoxSide=union{
   triangle{<-.04,0,0><.04,0,0><-.06,CFH,0>}
   triangle{<.04,0,0><-.06,CFH,0><.06,CFH,0>}
}

#declare CFBoxEnd=union{
   triangle{<.04,0,-.03><.04,0,.03><.06,CFH,-.03>}
   triangle{<.04,0,.03><.06,CFH,-.03><.06,CFH,.03>}
   
   triangle{<.04,0,-.03><.04,0,.03><.054,CFH/2,0>}
   triangle{<.06,CFH-.005,-.03><.06,CFH-.005,.03><.054,CFH/2,0>}
}

#declare CFBoxEndFlap=union{
   triangle{<0,0,-.03><0,0,.03><0,.05,.025>}
   triangle{<0,0,-.03><0,.05,.025><0,.05,-.025>}
}
#declare CFBoxSideFlap=union{
   triangle{<-.06,0,0><.06,0,0><.045,.035,0>}
   triangle{<-.06,0,0><.045,.035,0><-.045,.035,0>} 
   triangle{<-.025,.035,0><-.02,.045,0><.02,.045,0>}
   triangle{<-.025,.035,0><.02,.045,0><.025,.037,0>}
   triangle{<-.025,.035,0><0,.038,0><0,.035,0>}
}    
#declare CFHandle=union{
   cylinder{<-.065,-.01,0><-.063,.05,0>.001}
   cylinder{<.065,-.01,0><.063,.05,0> .001}
   cylinder{<-.065,.051,0><.065,.051,0> .001}
   sphere{<-.063,.05,0> .001}
   sphere{<.063,.05,0> .001}
   sphere{<-.065,-.01,0> .001}
   sphere{<.065,-.01,0,> .001}
   cylinder{<-.065,-.01,0><-.06,0,0>.001}
   cylinder{<.06,-.01,0><.065,0,0> .001}
   texture{T_Copper_1A}
}


#declare CFBox=union{
   object{CFHandle rotate<-60,0,0> translate<0,CFH-.01,0>}
   object{CFBoxEnd}
   object{CFBoxEnd rotate<0,180,0>}
   object{CFBoxSide translate<0,0,-.03>}
   object{CFBoxSide translate<0,0,.03>}
   object{CFBoxEndFlap translate<-.06,CFH,0>}
   object{CFBoxEndFlap rotate<0,0,-20> translate<.06,CFH,0>}
   object{CFBoxSideFlap rotate<0,180,0> rotate<60,0,0> translate<0,CFH,-.03>}
   object{CFBoxSideFlap rotate<-10,0,0> translate<0,CFH,.03>}       
   texture{pigment{color White}}
}
//------------------------------ END Chinese Food Box

//------------------------------ Crystal Ball

#declare CrystalBall=union{
   sphere{<0,.11,0> .1 texture{T_Glass2}}
   union{
     cone{<0,0,0>.08<0,.03,0> .07}
     torus{.08 .003}
     torus{.07 .003 translate<0,.03,0>}
     texture{T_Brass_1E}
    }
}   
//------------------------------ END Crystal Ball

//------------------------------ Ink Bottle

#declare Ink=union{
  cone{<0,.004,0>.033<0,.03,0> .03}
  torus{.028,.005}
  torus{.025,.005 translate<0,.03,0>}
  cone{<0,.03,0> .028 <0,.05,0> .015}
  torus{.015,.0025 translate<0,.05,0>}
  cone{<0,.05,0> .01 <0,.06,0> .013 texture{Cork scale .025}}
  texture{pigment{color Gray60} }
}
//------------------------------------------------------------ END Ink Bottle      
                 
//------------------------------------------------------------ Feather Quill                 
#declare FSL=.03;
#declare FANG=-8;                 
#declare Feather1=union{
  cone{<0,0,0>.001<0,FSL,0>.0013}
  #declare C1=0;
  #while (C1<=FSL)
      cone{<0,C1,0>.0005 <-FSL,C1+FSL-.01,0> .00025}
      cone{<0,C1,0>.0005 <FSL,C1,0> .00025}
      #declare C1=C1+.0025;
  #end
}
#declare Feather2=union{
   object{Feather1}
   object{Feather1  scale .9 rotate<0,0,FANG> translate<0,FSL,0>}
}
#declare Feather3=union{
   object{Feather1}
   object{Feather2 scale .9 rotate<0,0,FANG> translate<0,FSL,0>}
}
#declare Feather4=union{
   object{Feather1}
   object{Feather3 scale .9 rotate<0,0,FANG> translate<0,FSL,0>}
}
#declare Feather5=union{
   object{Feather1}
   object{Feather4 scale .9 rotate<0,0,FANG> translate<0,FSL,0>}
}
#declare Feather6=union{
   object{Feather1}
   object{Feather1 scale .9 translate<0,FSL,0>}
   object{Feather1 scale .8 translate<0,FSL*2-.001,0>}
   object{Feather5 scale .7 translate<0,FSL*3-.004,0>}
}
#declare Feather7=union{
   object{Feather1}
   object{Feather6 rotate<0,0,FANG> translate<0,FSL,0>}
}  
#declare Feather8=union{
   object{Feather1}
   object{Feather7 rotate<0,0,FANG> translate<0,FSL,0>}
}
#declare Feather9=union{
   object{Feather1}
   object{Feather8 rotate<0,0,FANG> translate<0,FSL,0>}
}
#declare Feather0=union{
   object{Feather1}
   object{Feather9 rotate<0,0,FANG> translate<0,FSL,0>}
}
#declare Feather=union{
   cone{<0,0,0> .002 <0,FSL,0> .0013}
   cone{<.001,0,0> .0015 <0,FSL,0> .0013}
   cylinder{<0,0,0><0,-.01,0> .003 texture{T_Brass_1E}}
   cone{<0,-.01,0> .003 <0,-.03,0> 0 texture{T_Brass_1E}}
   object{Feather0 rotate<0,0,FANG> translate<0,FSL,0>}
} 
//------------------------------------------------------------------ END Feather Quill defs

//------------------------------------------------------------------ TELESCOPE Defs
#declare TelescopeTube=union{
   cylinder{<0,0,0><-.05,0,0> .025}
   cone{<-.05,0,0> .03 <-.1,0,0> .025 texture{pigment{color Gray10}}}
   
   sphere{<0,0,0> .03}
   cylinder{<0,0,0><0,.12,0> .025 }
   cone{<0,.12,0> .028 <0,.25,0> .03} 
   
   cylinder{<0,.14,-.065><0,.14,.065>.01}  // adjustment knobs
   union{
     cylinder{<0,.14,-.06><0,.14,-.04>.034 }
     cylinder{<0,.14,-.062><0,.14,-.06>.02}
     cylinder{<0,.14,.04><0,.14,.06> .034 } 
     cylinder{<0,.14,.06><0,.14,.062>.02}
    texture{pigment{color Gray10} }
    } 
   
   cone{<0,.25,0> .036 <0,.75,0> .05}
   
   difference{
     cone{<0,.75,0> .056 <0,.85,0> .06}
     cone{<0,.75,0> .055 <0,.851,0> .059 texture{pigment{color Black}}}
   }
  
   texture{T_Brass_1E}
} 
#declare TelescopeLeg=union{
   box{<0,0,-.02><.05,.02,.02>}
   cylinder{<.05,0,0><.05,.02,0> .02}
   cylinder{<0,0,0><0,.02,0> .02}
   cylinder{<.025,-.02,-.02><.025,-.02,-.015> .02}
   cylinder{<.025,-.02,.015><.025,-.02,.02> .02}
   cylinder{<.025,-.02,-.025><.025,-.02,.025> .005} // pin
   union{
      cylinder{<0,0,0><0,-.35,0> .02}   
      cylinder{<0,-.33,-.01><0,-.33,.03> .002}
      cylinder{<-.005,-.33,.04><.005,-.33,.04> .01}
      cylinder{<0,-.35,0> <0,-.65,0> .015 texture{T_Wood1 rotate<90,0,0> scale .05}  }
      cylinder{<0,-.65,0> <0,-.7,0> .016 texture{pigment{color Gray10}}}
      rotate<0,0,-30> translate<.025,-.02,0>
   } // union
   texture{T_Brass_1E}
}
     
#declare TelescopeStand=union{
   difference{
     cylinder{<-.02,0,0><.02,0,0> .05}
     cylinder{<-.021,0,0><.021,0,0> .045} 
     box{<-.021,.02,-.051><.021,.051,.051>} // cut off top
     texture{T_Brass_1E}                               
    }//difference
   cylinder{<0,.01,-.052><0,.01,.052> .01} // swivel axel for tube 
   cylinder{<0,-.048,0><0,-.055,0> .015}
   cylinder{<0,-.055,0><0,-.10,0> .025}
   cylinder{<0,-.065,0><0,-.075,0> .026 texture{T_Brass_1E}}
   object{TelescopeLeg translate<-.054,-.09,0> rotate<0,0,0>}
   object{TelescopeLeg translate<-.054,-.09,0> rotate<0,120,0>}
   object{TelescopeLeg translate<-.054,-.09,0> rotate<0,-120,0>} 
   texture{pigment{color Gray10}}
}

#declare Telescope=union{
  object{TelescopeTube translate<0,-.4,0> rotate<0,0,-70> translate<0,.02,0>}
  object{TelescopeStand}
  translate<0,.71,0>
}     
//------------------------------------------------------END Telescope

//-----------------------------------------------------Jar shelf and components
#declare Jar1=union{
    torus{.07,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.1,0> .08}
    torus{.07,.01 translate<0,.08,0>}
    cone{<0,.1,0> .08 <0,.14,0> .04}
    cylinder{<0,.14,0><0,.15,0> .04} 
    torus{.04,.0051 translate<0,.15,0>}
    cone{<0,.15,0>.035 <0,.17,0> .038 texture{Cork scale .05}}
   texture{pigment{color Gray50}}
}
#declare Jar2=union{
    torus{.07,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.15,0> .08}
    torus{.07,.01 translate<0,.14,0>}
    cone{<0,.15,0> .08 <0,.18,0> .04}
    cylinder{<0,.18,0><0,.20,0> .04} 
    torus{.04,.0051 translate<0,.20,0>}
    cone{<0,.20,0>.035 <0,.22,0> .038 texture{Cork scale .05}}
   texture{pigment{color Gray60}}
}
#declare Jar3=union{
    torus{.05,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.15,0> .06}
    torus{.05,.01 translate<0,.14,0>}
    cone{<0,.15,0> .06 <0,.18,0> .04}
    cylinder{<0,.18,0><0,.20,0> .04} 
    torus{.04,.0051 translate<0,.20,0>}
    cone{<0,.20,0>.035 <0,.22,0> .038 texture{Cork scale .05}}
   texture{pigment{color Gray60}}
}
#declare Jar4=union{
    torus{.05,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.15,0> .06}
    torus{.05,.01 translate<0,.14,0>}
    cone{<0,.15,0> .055 <0,.18,0> .04 texture{pigment{color Wheat}}}
    cylinder{<0,.18,0><0,.20,0> .04 texture{pigment{color Wheat}}} 
    torus{.04,.0051 translate<0,.20,0> texture{pigment{color Wheat}}}
    cone{<0,.20,0>.035 <0,.22,0> .038 texture{Cork scale .05}}
   texture{pigment{color Gray60}}
}              
#declare Jar5=union{
    object{Jar3}
    torus{.015 .005 rotate<90,0,0> translate<.05,.16,0>}
    torus{.015 .005 rotate<90,0,0> translate<-.05,.16,0>} 
   texture{pigment{color Gray60}}
}                                 
#declare Jar6=union{
    torus{.07,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.1,0> .08}
    torus{.07,.01 translate<0,.08,0>}
    cone{<0,.1,0> .08 <0,.14,0> .04}
    cylinder{<0,.14,0><0,.15,0> .04} 
    torus{.04,.0051 translate<0,.15,0>}
    cone{<0,.15,0>.035 <0,.17,0> .038 texture{Cork scale .05}}
   texture{T_Green_Glass}
}
#declare Jar7=union{
    torus{.07,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.15,0> .08}
    torus{.07,.01 translate<0,.14,0>}
    cone{<0,.15,0> .08 <0,.18,0> .04}
    cylinder{<0,.18,0><0,.20,0> .04} 
    torus{.04,.0051 translate<0,.20,0>}
    cone{<0,.20,0>.035 <0,.22,0> .038 texture{Cork scale .05}}
   texture{T_Green_Glass}
}
#declare Jar8=union{
    torus{.05,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.15,0> .06}
    torus{.05,.01 translate<0,.14,0>}
    cone{<0,.15,0> .06 <0,.18,0> .04}
    cylinder{<0,.18,0><0,.20,0> .04} 
    torus{.04,.0051 translate<0,.20,0>}
    cone{<0,.20,0>.035 <0,.22,0> .038 texture{Cork scale .05}}
   texture{T_Green_Glass}
}
#declare Jar9=union{
    torus{.05,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.15,0> .06}
    torus{.05,.01 translate<0,.14,0>}
    cone{<0,.15,0> .055 <0,.18,0> .04 texture{pigment{color Wheat}}}
    cylinder{<0,.18,0><0,.20,0> .04 texture{pigment{color Wheat}}} 
    torus{.04,.0051 translate<0,.20,0> texture{pigment{color Wheat}}}
    cone{<0,.20,0>.035 <0,.22,0> .038 texture{Cork scale .05}}
   texture{T_Green_Glass}
}              
#declare Jar10=union{
    object{Jar8}
    torus{.015 .005 rotate<90,0,0> translate<.05,.16,0>}
    torus{.015 .005 rotate<90,0,0> translate<-.05,.16,0>} 
   texture{T_Green_Glass}
}
#declare Jar11=union{
    torus{.07,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.1,0> .08}
    torus{.07,.01 translate<0,.08,0>}
    cone{<0,.1,0> .08 <0,.14,0> .04}
    cylinder{<0,.14,0><0,.15,0> .04} 
    torus{.04,.0051 translate<0,.15,0>}
    cone{<0,.15,0>.035 <0,.17,0> .038 texture{Cork scale .05}}
   texture{T_Ruby_Glass}
}
#declare Jar12=union{
    torus{.07,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.15,0> .08}
    torus{.07,.01 translate<0,.14,0>}
    cone{<0,.15,0> .08 <0,.18,0> .04}
    cylinder{<0,.18,0><0,.20,0> .04} 
    torus{.04,.0051 translate<0,.20,0>}
    cone{<0,.20,0>.035 <0,.22,0> .038 texture{Cork scale .05}}
   texture{T_Ruby_Glass}
}
#declare Jar13=union{
    torus{.05,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.15,0> .06}
    torus{.05,.01 translate<0,.14,0>}
    cone{<0,.15,0> .06 <0,.18,0> .04}
    cylinder{<0,.18,0><0,.20,0> .04} 
    torus{.04,.0051 translate<0,.20,0>}
    cone{<0,.20,0>.035 <0,.22,0> .038 texture{Cork scale .05}}
   texture{T_Ruby_Glass}
}
#declare Jar14=union{
    torus{.05,.01 translate<0,.01,0>}
    cylinder{<0,.01,0><0,.15,0> .06}
    torus{.05,.01 translate<0,.14,0>}
    cone{<0,.15,0> .055 <0,.18,0> .04 texture{pigment{color Wheat}}}
    cylinder{<0,.18,0><0,.20,0> .04 texture{pigment{color Wheat}}} 
    torus{.04,.0051 translate<0,.20,0> texture{pigment{color Wheat}}}
    cone{<0,.20,0>.035 <0,.22,0> .038 texture{Cork scale .05}}
   texture{T_Ruby_Glass}
}              
#declare Jar15=union{
    object{Jar13}
    torus{.015 .005 rotate<90,0,0> translate<.05,.16,0>}
    torus{.015 .005 rotate<90,0,0> translate<-.05,.16,0>} 
   texture{T_Ruby_Glass}
}


#declare Bookshelf2=union{
  box{<-.2,0,-.5><.2,.1,.5>} // base
  box{<-.22,.1,-.5><.2,.125,.5>}  // bottom shelf
  box{<-.22,.35,-.5><.2,.375,.5>} // second shelf
  box{<-.22,.7,-.5><.2,.725,.5>} // third shelf 
  box{<-.22,1,-.5><.2,1.025,.5>} // Top 
  
  #declare B1=-.5;
  #while (B1<.5)
    box{<.19,.1,B1><.199,1,B1+.19> texture{T_Wood1 rotate<90,0,0> scale .25}}
    #declare B1=B1+.2;
  #end
  
  box{<-.22,.1,-.525><.2,1.025,-.5> texture{T_Wood1 rotate<90,0,0> scale .25}} // side
  box{<-.22,.1,.5><.2,1.025,.525> texture{T_Wood1 rotate<90,0,0> scale .25}}   // second side
  texture{T_Wood1}
}

#declare FullShelf2=union{
   object{Bookshelf2 rotate<0,-90,0>}
                         
   object{Jar4 translate<.25,.125,-.01>}
   object{Jar13 translate<.35,.125,-.03>} 
   object{Jar2 translate<.40,.125,-.13>}                        
   object{Jar1 translate<.15,.125,-.04>}            
   object{Jar14 translate<0,.125,0>} 
   object{Jar10 translate<-.16,.125,-.09>}     
   object{Jar5 translate<-.35,.125,-.06>}
   object{Jar1 translate<-.4,.125,-.1>}

   object{Jar4 translate<.25,.375,-.08>}
   object{Jar12 translate<-.35,.375,-.03>} 
   object{Jar2 translate<.43,.375,-.04>}                        
   object{Jar1 translate<.1,.375,-.04>}
   object{Jar6 translate<.20,.375,.05>}            
   object{Jar7 translate<0,.375,-.04>} 
   object{Jar8 translate<-.20,.375,.045>}
                                        
   object{Jar4 translate<-.25,.725,-.08>}
   object{Jar11 translate<.35,.725,-.03>} 
   object{Jar2 translate<-.43,.725,-.04>}                        
   object{Jar1 translate<-.1,.725,-.04>}
   object{Jar6 translate<-.20,.725,.05>}            
   object{Jar7 translate<0,.725,-.04>} 
   object{Jar15 translate<.20,.725,.045>}
}
//------------------------------------------------------ END JAR Shelf and components defs

//------------------------------------------------------ SCROLL Shelf and components
#declare Bookshelf3=union{
  box{<-.2,0,-.5><.2,.1,.5>} // base
  box{<-.22,.1,-.5><.2,.125,.5>}  // bottom shelf
  box{<-.22,.35,-.5><.2,.375,.5>} // second shelf
  box{<-.22,.7,-.5><.2,.725,.5>} // third shelf 
  box{<-.22,1,-.5><.2,1.025,.5>} // Top 
  
  #declare B1=-.5;
  #while (B1<.5)
    box{<.19,.1,B1><.199,1,B1+.19> texture{T_Wood1 rotate<90,0,0> scale .25}}
    #declare B1=B1+.2;
  #end
  
  union{
    box{<-.22,.1,-.525><.2,1.025,-.5> } // side
    box{<-.22,.1,-.25><.2,1.025,-.275> }
    box{<-.22,.1,-.0125><.2,1.025,.0125> }
    box{<-.22,.1,.25><.2,1.025,.275> }
    box{<-.22,.1,.5><.2,1.025,.525> }   // second side
   texture{T_Wood1 rotate<90,0,0> scale .25}
  }  
  texture{T_Wood1}
}                                                                 

#declare Scroll1=union{
    difference{
      union{
        cone{<0,0,0>.02 <-.1,0,0>.025}
        cone{<-.1,0,0>.025<-.101,0,0> .025 texture{pigment{color Gold} finish{F_MetalA}}}
        cone{<0,0,0>.02 <.1,0,0> .028}
        cone{<.1,0,0> .028 <.101,0,0> .028 texture{pigment{color Gold} finish {F_MetalA}}}
      }
      cone{<0,0,0>.019995 <-.11,0,0>.024995}
      cone{<0,0,0>.019995 <.11,0,0> .027995}
    } // difference
}

#declare Scroll=union{
  object{Scroll1 }         
  object{Scroll1 scale<1.01,.9,.9> translate<0,.001,0> }       
  object{Scroll1 scale<1.02,.82,.8> translate<0,-.001,0> }
  object{Scroll1 scale<1.03,.7,.73> translate<0,-.001,0> }  
  object{Scroll1 scale<1.04,.65,.6> translate<0,-.001,0> }  
  object{Scroll1 scale<1.05,.51,.45> translate<0,-.001,0> }
  object{Scroll1 scale<1.06,.42,.4> translate<0,-.001,0> }  
  object{Scroll1 scale<1.07,.35,.32> translate<0,-.001,0> }  
  object{Scroll1 scale<1.08,.2,.21> translate<0,-.001,0> }
  cylinder{<-.01,0,0><.01,0,0> .0201 texture{pigment{color Brown}}}
  triangle{<.01,.022,-.0028><.1,.025,.001><.1,.021,-.025>} // page corner     
  triangle{<-.01,.022,-.0025><-.1,.025,.001><-.1,.021,-.02>} // page corner  
   rotate<0,0,0>  texture{pigment{color PaleGoldenrod}}
}   // union
                
#declare Scroll_Stack=union{
   object{Scroll scale <1,.65,1>}
   object{Scroll rotate<45,0,0> scale <1,.7,1>  translate<-.0125,0,-.06>}
   object{Scroll rotate<-35,0,0> scale <1,.64,1> translate<0,0,.061>}
   
   object{Scroll rotate<10,0,0> scale <1,.55,1> translate<-.015,.03,.035>}
   object{Scroll rotate<-15,0,0> scale <1,.65,1> translate<-.014,.03,-.035>}
   
   object{Scroll translate<0,.06,-.01>} 
   scale 1.5
}

#declare ScrollShelf=union{
  object{Bookshelf3}
  object{Scroll_Stack translate<.075,.145,.125> }                                        
  object{Scroll_Stack translate<.125,.145,-.125> }
  object{Scroll_Stack translate<.075,.145,-.375>}
  object{Scroll_Stack rotate<90,0,0> translate<.12,.25,-.38>}
  
  object{Scroll_Stack scale <1,1.1,1> translate<.13,.395,-.125> } 
  object{Scroll_Stack translate<.1,.395,.125> }
  object{Scroll_Stack rotate<90,0,0> translate<.08,.51,.13>}
  
  object{Scroll_Stack translate<.13,.745,-.125> }
  object{Scroll_Stack translate<.12,.745,.375>}  
  
 rotate<0,0,0>
}                                          
//----------------------------------------------------------- END Scrolls and shelf defs                                                                                
                                                                                
//----------------------------------------------------------- Railing components
#declare StairRailColumn=union{
   cylinder{<0,0,0><0,.05,0> .05}
   torus{.05 .005 translate<0,.05,0> texture{T_Brass_1E}}
   cylinder{<0,.05,0><0,.075,0> .04}
   cone{<0,.075,0> .025 <0,.3,0> .05}
   cone{<0,.3,0> .05 <0,.525,0> .025}   
   cylinder{<0,.525,0><0,.55,0> .04}
   torus{.05,.005 translate<0,.55,0> texture{T_Brass_1E}}
   cylinder{<0,.55,0><0,.6,0> .05}
  texture{T_Stone1}
   
}                               

#declare TWW=7;  // tower radius
#declare StairRailTop=difference{
    intersection{ // stair difference
     cylinder{<0,0,0><0,.06,0> TWW-2.3 }
     box{<-TWW/4+.25,0,TWW/2><TWW/4,.06,TWW+.1> rotate<0,40,0>}
    }
    cylinder{<0,-.1,0><0,.081,0> TWW-2.45}
   texture{T_Stone1}
}
//------------------------------------------------------------- END Railing segment
 
// ------------------------------------------------------------ TRUNK Defs 
#declare Trunk_Lock=union{
   torus{ .025,.0075  rotate<90,0,0> translate<0,.055,0>}
   difference{
     union{
       cylinder{<0,0,-.02><0,0,.02> .05} // lock bottom
       cylinder{<0,0,-.015><0,0,.015> .06 texture{pigment{color Gray20}}}
     }
     cylinder{<0,0,-.021><0,0,.021> .01} // cut keyhole
     box{<-.006,-.025,-.021><.006,0,.021>}
   } 
   cylinder{<0,0,-.015><0,0,.015> .0035 texture{pigment{color Silver}}}
   sphere{<0,0,-.015> .0035 texture{pigment{color Silver}}} 
   #declare C1=0;
   #while (C1<=360)
     sphere{<0,.04,-.02> .005 rotate<0,0,C1>}
     #declare C1=C1+30;
   #end
  texture{pigment{color Gray40}}
}
 
#declare Trunk_Latch=union{
   box{<-.025,-.01,-.012><.025,-.05,-.010>}
   box{<-.025,.01,-.012><.025,.05,-.010>}
   torus{.02 .005 rotate<0,0,90> translate<0,-.025,0>}    
   object{Trunk_Lock rotate<50,0,0> rotate<0,0,10> translate<.003,-.065,-.073>}
   cylinder{<-.026,.05,-.01><-.013,.05,-.01> .0075}
   cylinder{<-.011,.05,-.01><.011,.05,-.01> .0075}
   cylinder{<.013,.05,-.01><.026,.05,-.01> .0075}
         
   difference{
     box{<-.025,-.048,-.013><.025,.048,-.015>}
     box{<-.0075,-.045,-.012><.0075,-.005,-.016>}  
   }  
} 
#declare Trunk_Handle=union{
   box{<-.02,-.02,-.1><.02,.02,.1>}
   box{<.02,-.02,-.1><.05,.02,-.075>}
   box{<.02,-.02,.075><.05,.02,.1>}
  texture{pigment{color DarkBrown}}
}
#declare Trunk=union{
   box{<-.75,0,-.5><.75,.5,.5>}
   box{<-.751,.5,-.501><.751,.51,.501> texture{pigment{color Black}}}
   cylinder{<-.75,.5,0><.75,.5,0>.5}


   object{Trunk_Handle translate<-.8,.35,0>}
   object{Trunk_Handle rotate<0,180,0> translate<.8,.35,0>}
                                
   union{                                
   object{Trunk_Latch scale 2 translate<-.35,.5,-.5>}
   object{Trunk_Latch scale 2 translate<.35,.5,-.5>}
     box{<-.6,0,-.51><-.45,.49,.51>}
     box{<.45,0,-.51><.6,.49,.51>}   
     cylinder{<-.6,.5,0><-.45,.5,0> .51}
     cylinder{<.45,.5,0><.6,.5,0> .51 }    
   
    texture{pigment{color Gold} finish{F_MetalA} normal{ bumps 0.8 scale .01}}
    } // union  
    
 texture{pigment{crackle 
                 color_map{ [0.0 color DarkBrown]
                            [0.1 color MediumWood]
                            [0.75 color DarkBrown]
                            [0.95 color Chocolate]
                            [1.0 color Goldenrod]
                          } 
                 scale .2
                }  
         normal { bumps 1 scale .01}
        }
} // Trunk                                                                       
//----------------------------------------------------------- END Trunk


//------------------------------------------------------------ Crate and Contents 

#declare WoodCrate1=union{
   box{<-.15,0,-.17><-.1,.015,.17>}
   box{<.15,0,-.17><.1,.015,.17>}          
   
   box{<-.25,.015,.07><.25,.025,.15>}
   box{<-.25,.015,-.05><.25,.025,.05>}
   box{<-.25,.015,-.15><.25,.025,-.07>}
}
#declare WoodCrateEnd=union{
   box{<-.005,.015,-.15><.005,.095,.15>}
   box{<-.005,.115,-.15><.005,.215,.15>}
   box{<-.005,.235,-.15><.005,.315,.15>}
  texture{T_Wood11 scale .05 rotate<0,90,0>} 
}

#declare WoodCrate=union{
   object{WoodCrate1}
   object{WoodCrate1 rotate<-90,0,0> translate<0,.17,.17>}
   object{WoodCrate1 rotate<90,0,0> translate<0,.17,-.17>}
   object{WoodCrateEnd translate<.25,0,0>}    
   object{WoodCrateEnd translate<-.25,0,0>}
  texture{T_Wood11 scale .05} 
}

#macro Contents(OC,SS,RXM,RYM,RZM)

//union{
 //  #declare OC=100;
   #declare CO=1; 
   #declare RS=seed(SS);
   #while (CO<=OC)
      #declare R1=int(rand(RS)*8)+1;
      #declare RX=rand(RS)*RXM-RXM/2;
      #declare RZ=rand(RS)*RZM-RZM/2;
      #declare RY=rand(RS)*RYM/2+RYM/3*2;
      #declare ROX=rand(RS)*360;
      #declare ROY=rand(RS)*360;
      #declare ROZ=rand(RS)*360;
      #declare ROD=rand(RS)*(.250-max(abs(RX),abs(RZ)))/2;
      #declare ROH=rand(RS)*(.250-max(abs(RX),abs(RZ)));
      #declare ROW=rand(RS)*(.250-max(abs(RX),abs(RZ)));
      #switch (R1)
        #case (1)
           cylinder{<0,0,0><0,ROH,0> ROD texture{pigment{color Gold1} finish{F_MetalA}} rotate<ROX,ROY,ROZ> translate<RX,RY,RZ>}
        #break       
        #case (2)
           union{
             cylinder{<0,0,0><0,ROH,0> ROD }
             cylinder{<0,ROH,0><0,ROH+.01,0> ROD/2}
            texture{pigment{color Gold1} finish{F_MetalA}} rotate<ROX,ROY,ROZ> translate<RX,RY,RZ>
           }  
        #break        
        #case (3)
           difference{
             cylinder{<0,0,0><0,ROD,0> ROH } 
             cylinder{<0,0,0><0,ROD+.01,0> ROH-.005 }
            texture{pigment{color Gold4} finish{ F_MetalB}} 
            rotate<ROX,ROY,ROZ> translate<RX,RY,RZ>
           } 
        #break
        #case (4)
           difference{
             cylinder{<0,0,0><0,ROD,0> ROH } 
             cylinder{<0,0,0><0,ROD+.01,0> ROH-.005 }
             #declare COY=0;
             #while (COY<=360)
                cylinder{<-ROH+.01,ROD,0><ROH+.01,ROD,0> .01 rotate<0,COY,0>}
                #declare COY=COY+20;
             #end
            texture{pigment{color Gold4} finish{ F_MetalB}} 
            rotate<ROX,ROY,ROZ> translate<RX,RY,RZ>
           } 
        #break        
        #case (5)
           box{<0,0,0><ROD,ROH,ROD> texture{T_Brass_1E} rotate<ROX,ROY,ROZ> translate<RX,RY,RZ>}
        #break
        #case (6)
           sphere{<0,0,0> ROD texture{pigment{color Gold4} finish{F_MetalC}}  translate<RX,RY,RZ>}
        #break               
        #case (7)
           sphere{<0,0,0> ROD texture{pigment{color Gold4} finish{F_MetalC}}  translate<RX,RY,RZ>}
           #declare COY=0;
           #while (COY<=360)
              torus{ROD+.005, .005 rotate<90,0,0> rotate<0,COY,0>}
              #declare COY=COY+45;
           #end
        #break         
        #case (8)
           difference{
              cone{<0,0,0> ROD <0,ROH,0> ROW }
              cone{<0,0,0> ROD-.005 <0,ROH+.01,0> ROW-.005}
             texture{pigment{color Gold3} finish{F_MetalD}} rotate<ROX,ROY,ROZ> translate<RX,RY,RZ>
           }
        #break
      #end
     #declare CO=CO+1;
   #end
  bounded_by { box { <-RXM/2,0,-RZM/2>, <RXM/2,max(RYM,.1)*20,RZM/2> } }
  clipped_by { bounded_by }  
  texture{pigment{color Gold5}}
//}
#end // Crate Contents    
  
#declare Crates=union{
  object{WoodCrate}   
  union{Contents(100,492,.5,.20,.30) translate<0,0,0>} 

  object{WoodCrate  rotate<0,0,0> translate<-.65,0,-.4>}
  union{Contents(150,498,.5,.25,.30) translate<-.65,0,-.4>}

  object{WoodCrate  rotate<0,40,0> translate<.55,0,-.3>}
  union{Contents(125,494,.5,.25,.30) rotate<0,40,0> translate<.55,0,-.3>}

  union{Contents(40,10,.5,.001,.5) rotate<0,0,0> translate<0,0,-.5>}
}

                                     
//---------------------------------------------------- End Crate and Contents                                                               
                                                                
//----------------------------------------------------Cauldron 

#declare Cauldron=union{
  
  union{
   difference{
     union{
       sphere{<0,0,0> .25}
       cone{<0,.21,0> .17 <0,.255,0> .2}
     }
     sphere{<0,0,0> .24}
     cone{<0,.2,0> .15 <0,.261,0> .19}
    translate<0,.26,0>
   }
   torus{.15 .021 translate<0,.45,0> } 
   torus{.245 .01 translate<0,.235,0>} // middle seam

  union{  
    #declare C1=0;
    #while (C1<=360)
      sphere{<0,0,0> .01 translate<.17,.445,0> rotate<0,C1,0>} // around neck
      sphere{<0,0,0> .01 translate<.245,.245,0> rotate<0,C1,0>}
      sphere{<0,0,0> .01 translate<.245,.225,0> rotate<0,C1+5,0>}
      #declare C1=C1+10;
    #end
   //texture{pigment{color Gold2} finish{F_MetalD}}
  }
   
   // handles
   torus{.05 .02 rotate<0,0,-45> translate<.24,.32,0> }
   torus{.05 .02 rotate<0,0,45> translate<-.24,.32,0> }
   scale <1,.75,1>
  }  
  
  cone{<0,.15,0> .035 <.13,0,0> .01 translate<.05,0,0>}                 //legs
  cone{<0,.15,0> .035 <.13,0,0> .01 translate<.05,0,0> rotate<0,120,0>}
  cone{<0,.15,0> .035 <.13,0,0> .01 translate<.05,0,0> rotate<0,-120,0>}
  

 texture{pigment{color Gray20}}
}
//------------------------------------------------ End Cauldron
  

//-------------------------------------------------------- 
//-------------------------------------- Begin Main Layout
//--------------------------------------------------------
 

#declare Lab2=union{
  difference{
   cylinder{<0,-30,0><0,10,0> TWW}
   cylinder{<0,-30.1,0><0,10.1,0> TWW-.4}
   #declare C1=20;
   #while (C1<=340)
     box{<-.35,.25,TWW-.5><+.35,3.25,TWW+.1> rotate<0,C1,0>}
     cylinder{<0,3.25,TWW-.5><0,3.25,TWW> .35 rotate<0,C1,0>}      
     #declare C1=C1+10;
   #end
  }
  
  #declare C1=15;
  #while (C1<=335)         
    object{Window1 translate<0,3.4,TWW-.2> rotate<0,C1+5,0>} 
    object{Col1 translate<0,0,TWW-.5> rotate<0,C1,0>}
    object{WoodTruss translate<0,3.2,TWW-.65> rotate<0,C1,0>}
    object{ArchTop translate<0,3.3,TWW-.61> rotate<0,C1+5,0>}
    #declare C1=C1+10;
  #end
  // add odd set at end
  object{Col1 translate<0,0,TWW-.5> rotate<0,345,0>}
  object{WoodTruss translate<0,3.2,TWW-.65> rotate<0,345,0>}    
  object{WoodTruss translate<0,3.2,TWW-.65> rotate<0,355,0>} // fireplace truss 1
  object{WoodTruss translate<0,3.2,TWW-.65> rotate<0,5,0>}   // fireplace truss 2   
                             
  union{                             
    difference{ // stair difference
     cylinder{<0,-.1,0><0,0,0> TWW-.3 }
     box{<-TWW/4,-.11,TWW/2><TWW/4,.01,TWW+.1> rotate<0,40,0>}
    }
    difference{
     cylinder{<0,-.1,0><0,0,0> TWW-.3}
     cylinder{<0,-.11,0><0,.1,0> TWW-.85}
    }
    cylinder{<0,-.1,0><0,0,0> TWW-2.35}     
      
   texture{checker texture{T_Stone1 scale .25},texture{T_Stone14 scale .25} scale .5 rotate<0,45,0>}
  } // floor 
  
  //stair rails...
  #declare CR=22.5;
  #while (CR<=62.5)
    object{StairRailColumn translate<0,0,TWW-2.4> rotate<0,CR,0>}
    #declare CR=CR+3;
  #end
  //object{StairRailColumn translate<0,0,TWW-2.4> rotate<0,32.5,0>}
  //object{StairRailColumn translate<0,0,TWW-2.4> rotate<0,42.5,0>}
  //object{StairRailColumn translate<0,0,TWW-2.4> rotate<0,52.5,0>}
  //object{StairRailColumn translate<0,0,TWW-2.4> rotate<0,62.5,0>}
  object{StairRailTop translate<0,.6,0> }//rotate<0,22.5,0>}                                         
                                         
  object{Pentagram translate<0,0,0>} 
  object{FirePlace translate<0,0,TWW-1>}

  object{FirePlaceScreen translate<0,.245,TWW-2.2>}
                                                         
  object{Cauldron rotate<0,30,0> translate<0,0,0>}                                                         
                                                         

  object{MirrorX scale 2 rotate<0,60,0> translate<3.25,.30,-1 >}
  object{Telescope translate<2.8,0,-1.15>}
  
#ifndef(ObjectsOff) // if defined, turns off this section of objects
 

   
  union{
    object{FullShelf2 rotate<0,-10,0> translate<-.65,0,0>} 
    object{ScrollShelf rotate<0,-80,0> translate<.5,0,0>}
   rotate<0,35,0> translate<2.4,0,3.15>
  }             
  
  object{Cauldron rotate<0,30,0> translate<.9,0,3.45>}
  

  object{Table rotate<0,90,0> translate<-2.4,0,3.2>}
    #declare NextTitle=1;
    #declare BS=seed(99);  // Books on table
    BookStack(5,BS,-2.2,1.025,3.1)
    BookStack(8,BS,-2.95,1.025,3)
    BookStack(8,BS,-1.7,1.025,3.3)    
    
    object{RadBox rotate<0,35,0> translate<-1.7,.125,1.75>}  // under table  
    object{Trunk scale .75 rotate<0,-35,0> translate<-2.5,0,2>}


 union{  // desk and objects on the desk  
     object{Desk} 
     object{CrystalBall translate<-.3,2,-.1>}
     object{Ink translate<-.26,2,.4>}
     object{Ink translate<-.27,2,.43>}
     object{Ink translate<-.26,2,.35>}
     object{Feather translate<-.26,2.01,.35> texture{pigment{color Red}}}
     object{Feather rotate<0,180,0> translate<-.25,2.01,.43> texture{pigment{color White}}}
    rotate<0,125,0> translate<-1.75,0,-3.5>
   }// union
 
    object{WizHat translate<-1.15,1.23,-3.85>}
    object{CFBox rotate<0,-35,0> translate<-.85,0,-4.1>}   
    object{CFBox rotate<-90,0,0> rotate<0,-30,0> translate<-.67,.04,-4.13>}
     
    #declare NextTitle=1;
    #declare BS=seed(93);
    BookStack(15,BS,-1.15,0,-3.85)
    #declare BS=seed(7993);
    BookStack(5,BS,-1.55,0,-4.5)   
  

 
  object{BirdCage rotate<0,180,0> translate<-.75,0,-3.5>}


  object{Crates translate<2.4,0,-2>}
  
  object{Bookshelf rotate<0,90,0> translate<1,0,-5.9>} // one close to camera
    object{Pepsi rotate<0,17,0> translate<.53,1.025,-5.95>} 
    object{WandArray translate<.41,1.025,-5.75>}  
    object{Cheshire  rotate<0,20,0> translate<.35,1.025,-5.95>}
    object{Ambrosia rotate<0,15,0> translate<.5,1.025,-5.85>}
    object{Tails rotate<0,30,0> translate<.23,1.025,-5.75>}
    object{Newt rotate<0,40,0> translate<.25,1.025,-5.9>}
    object{Love9 translate<.13,1.05,-5.8>}   
    object{Love9Small rotate<0,30,0> translate<.15,1.0235,-5.97>}
    object{CandleCluster translate<.06,1.025,-5.99>} 
#end //ifndef(ObjectsOff)    
    
  
  texture{T_GrayBrick scale .0625 rotate<0,90,0>}
  
}      

                              
cylinder{<0,-.01,0><0,0,0> 5000 texture{pigment{color Khaki}}}  // ground 
                              
object{Lab2 translate<0,30,0>}




#ifndef(HillsOff) 
#declare GL=-2; 
  object {   //   Hills 
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Gray80 } }
                 scale < 1600, 123, 1600 >   translate < -800, 0, -800>
                 rotate<0,0,0> translate<0,0,3700>
  }                                          
  object {   //   Hills 
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Gray80 } }
                 scale < 1600, 153, 1600 >   translate < -800, 0, -800>
                 rotate<0,0,0> translate<-1400,0,3500>
  }          
  object {   //   Hills
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Gray80 } }
                 scale < 1600, 135, 1600 >   translate < -800, 0, -800>
                 rotate<0,90,0> translate<1500,0,3100>
  }                                          
  object {   //   Hills
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Khaki } }
                 scale < 1600, 34, 1600 >   translate < -800, 0, -800>
                 rotate<0,50,0> translate<-900,0,1200>
  }          
  object {   //   Hills
                height_field { gif  "../graphics/hills1.ghf" }
                texture { pigment { color Khaki } }
                 scale < 1600, 32, 1600 >   translate < -800, 0, -800>
                 rotate<0,60,0> translate<890,GL,1200>
  }


  
#end // ifndef(HillsOff)            


#ifndef(MagicOff)
//   Add in Flying Tarot Deck and magic balls
#include "../garden/tarot.inc"
 
union{ 
#declare RS=seed(588);
#declare NC=78;
#declare C1=1;
#while (C1<=NC)
  #declare ROX=rand(RS)*360;
  #declare ROY=rand(RS)*360;
  #declare ROY2=rand(RS)*360;
  #declare ROZ=rand(RS)*360;
  #declare ROD=rand(RS)*2.5+.5;
  #declare ROH=rand(RS)*.25+1;
  object{
  #switch (C1)
     #case (1) R01 #break
     #case (2) R02 #break
     #case (3) R03 #break
     #case (4) R04 #break
     #case (5) R05 #break
     #case (6) R06 #break
     #case (7) R07 #break                              
     #case (8) R08 #break
     #case (9) R09 #break
     #case (10) R10 #break          
     #case (11) R11 #break
     #case (12) R12 #break
     #case (13) R13 #break
     #case (14) R14 #break
     #case (15) R15 #break
     #case (16) R16 #break
     #case (17) R17 #break                              
     #case (18) R18 #break
     #case (19) R19 #break
     #case (20) R20 #break      
     #case (21) R21 #break
     #case (22) R22 #break
     #case (23) R23 #break
     #case (24) R24 #break
     #case (25) R25 #break
     #case (26) R26 #break
     #case (27) R27 #break                              
     #case (28) R28 #break
     #case (29) R29 #break
     #case (30) R30 #break 
     #case (31) R31 #break
     #case (32) R32 #break
     #case (33) R33 #break
     #case (34) R34 #break
     #case (35) R35 #break
     #case (36) R36 #break
     #case (37) R37 #break                              
     #case (38) R38 #break
     #case (39) R39 #break
     #case (40) R40 #break            
     #case (41) R41 #break
     #case (42) R42 #break
     #case (43) R43 #break
     #case (44) R44 #break
     #case (45) R45 #break
     #case (46) R46 #break
     #case (47) R47 #break                              
     #case (48) R48 #break
     #case (49) R49 #break
     #case (50) R50 #break      
     #case (51) R51 #break
     #case (52) R52 #break
     #case (53) R53 #break
     #case (54) R54 #break
     #case (55) R55 #break
     #case (56) R56 #break
     #case (57) R57 #break                              
     #case (58) R58 #break
     #case (59) R59 #break
     #case (60) R60 #break                              
     #case (61) R61 #break
     #case (62) R62 #break
     #case (63) R63 #break
     #case (64) R64 #break
     #case (65) R65 #break
     #case (66) R66 #break
     #case (67) R67 #break                              
     #case (68) R68 #break
     #case (69) R69 #break
     #case (70) R70 #break      
     #case (71) R71 #break
     #case (72) R72 #break
     #case (73) R73 #break
     #case (74) R74 #break
     #case (75) R75 #break
     #case (76) R76 #break
     #case (77) R77 #break                              
     #case (78) R78 #break          
  #end // switch
   scale 2   
   rotate<ROX,ROY,ROZ>
   translate<0,ROH,ROD>
   rotate<0,ROY2,0>
   translate<0,0,0>
   }
//#warning concat("Value is:",str(C1,5,0),"\n")
   
  #declare C1=C1+1;
#end 

#declare RSS=seed(393);
#declare S1=1;
#while (S1<40)
  #declare RX=rand(RSS)*.75-.325;
  #declare RY=rand(RSS)*.75-.325;
  #declare RZ=rand(RSS)*.75-.325;
  #declare RSZ=rand(RSS)*.15+.01;
  #declare CX=rand(RSS);
  #declare CY=rand(RSS);
  #declare CZ=rand(RSS);
  sphere{<RX,RY+1,RZ> RSZ          texture{ 
           pigment{crackle 
                    color_map {[0.0 rgbt <CX,CY,CZ,.95>]
                               [.05 rgbt <CX,CY,CZ,.85>]
                               [.1 rgbt <1.0,1.0,1.0,1.0>]
                               [1.0 rgbt <1.0,1.0,1.0,1.0>]
                              }
                  } scale .025
          } finish{ambient 2.5}
          }
  #declare S1=S1+1;
#end    

#declare RSS=seed(93);
#declare S1=1;
#while (S1<70)
  #declare RX=rand(RSS)*.25-.125;
  #declare RY=rand(RSS)*2-1;
  #declare RZ=rand(RSS)*.25-.125;
  #declare RSZ=rand(RSS)*.075+.01;
  #declare CX=rand(RSS);
  #declare CY=rand(RSS);
  #declare CZ=rand(RSS);
  sphere{<RX,RY,RZ> RSZ 
         texture{ 
           pigment{crackle 
                    color_map {[0.0 rgbt <CX,CY,CZ,.95>]
                               [.05 rgbt <CX,CY,CZ,.85>]
                               [.1 rgbt <1.0,1.0,1.0,1.0>]
                               [1.0 rgbt <1.0,1.0,1.0,1.0>]
                              }
                  } scale .05
          }
         finish{ambient 2.5}
         }
  #declare S1=S1+1;
#end 

//  #declare RXS=seed(55);
//  #declare S1=1;
//  #while (S1<10)
//   #declare RY=rand(RXS)*2+.25;
//   #declare RX=rand(RXS)*.5-.25;
 
//   #declare R1X=rand(RXS)*.5-.25;
//   #declare R1Y=rand(RXS)*.5-.25;
//   #declare R1Z=rand(RXS)*.5-.25;         
 
//   #declare R2X=rand(RXS)*.5-.25;
//   #declare R2Y=rand(RXS)*.5-.25;
//   #declare R2Z=rand(RXS)*.5-.25;
 
//   #declare R3X=rand(RXS)*.5-.25;
//   #declare R3Y=rand(RXS)*.5-.25;
//   #declare R3Z=rand(RXS)*.5-.25;

//   #declare R4X=rand(RXS)*.5-.25;
//   #declare R4Y=rand(RXS)*.5-.25;
//   #declare R4Z=rand(RXS)*.5-.25;
   
//   #declare BD=rand(RXS)*.005+.005;       
 
//   union{             
//     cone{<RX,RY,0> BD <RX+R1X,RY+R1Y,R1Z> 0}
//     cone{<RX,RY,0> BD <RX+R2X,RY+R2Y,R2Z> 0}
//     cone{<RX,RY,0> BD <RX+R3X,RY+R3Y,R3Z> 0}
//     cone{<RX,RY,0> BD <RX+R4X,RY+R4Y,R4Z> 0}
//  
//     texture{pigment{color rgbt <1,1,1,.75>} }
//     finish{ambient 2.5}
//   }                                                         
//  #declare S1=S1+1;
// #end  
                                                         
 translate<0,31,0>
}

#end //ifndef(MagicOff)