//
//
//   ASand.POV
//   Author:  Matthew C. Harber (WebSpinner@InfiniteThread.com)
//   Web Prescence:  www.InfinteThread.com, members.aol.com/mcharber
//   Description:  IRTC (Interactive Ray-Tracing Competition) entry,
//     submitted for stills topic "Contrast", 31 December 2000.
//     Desolate, dry, sandy place with a cool, wet pool stuck right in the
//     middle of it all.  Mirage?  Who knows.  Only one way to find out ...
//   Construction:  All coding done on the bare metal - in DOS edit.  No 
//     modelers.  Uses a ground fog.  The buttes are from the same height
//     field, scaled, translated, rotated differently.  The rocks are 
//     randomly generated and placed spheres with another concave height
//     field subtracted from them four times (top, bottom, left, right) to
//     give them the shard appearance.  The sand dunes are yet another height
//     field generated with the waves pattern, scaled and textured as needed.
//     The lens flare comes from Chris Colefax's LENSFLAR.INC include file.
//     I used WOOD11 from POVLAB.INC for the chair frame, all other textures
//     are defined here.  There is also a light source down in the pool to
//     make it glow.
//   Files used:
//     ASand.pov   - This file.  Main scene source file.
//     ht3_img.tga - Height field for dunes.  Built at really high resolution.
//     sph2.tga    - Basic height field, modified to be darker at center.
//     butte2.tga  - Height field modified to contain high spots (white).
//
//
#include "colors.inc"
#include "shapes.inc"
#include "povlab.inc"

// Flags:  Show specific features 
#declare FlagFog    = 1;
#declare FlagRocks  = 1;
#declare FlagButte  = 1;
#declare FlagFlare  = 1;
#declare FlagDunes  = 1;
#declare FlagClouds = 1;
#declare FlagPool   = 1;
#declare FlagAcc    = 1;

// Textures, etc 
#declare TxtSand = texture { pigment { color rgb < 0.85, 0.70, 0.45 > }
  normal { bumps 1.5 turbulence 0.30 scale < 2.0, 1.0, 2.0 > }
  finish { specular 0.50 roughness 0.50 ambient 0.30 diffuse 0.50 }
  rotate < 0, 45, 0 > 
  }

#declare TxtRock = texture { pigment { gradient y turbulence 0.50
    color_map {
      [ 0.00 color rgb < 0.80, 0.55, 0.30 > ]
      [ 0.40 color rgb < 0.80, 0.55, 0.30 > ]
      [ 0.60 color rgb < 0.80, 0.30, 0.30 > ]
      [ 0.80 color rgb < 0.80, 0.75, 0.50 > ]
      [ 1.00 color rgb < 0.80, 0.80, 0.50 > ]
      }
    scale < 1, 0.40, 1 > rotate < 0, 0, 20 >
    }
  normal { wrinkles 3.00 turbulence 0.80 octaves 8 scale 0.25 }
  }

#declare TxtClouds = texture { pigment { bozo turbulence 0.90
    color_map {
      [ 0.00  color rgb  < 0.65, 0.70, 0.65 > ]
      [ 0.20  color rgb  < 0.90, 0.85, 0.85 > ]
      [ 0.50  color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
      [ 1.001 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
      }
    }
  scale 300 finish { ambient 0.50 diffuse 0.70 }
  }

#declare TxtPool  = texture { pigment { rgb < 0.80, 0.80, 1.00 > }
  finish { ambient 0.25 diffuse 0.80 } }
#declare TxtWater = texture { pigment { rgbt < 0.25, 1.0, 1.0, 0.60 > }
  finish { reflection 0.15 ambient 0.25 }
  normal { ripples 1 turbulence 0.50 scale < 0.66, 0.50, 0.66 >
    translate < -8, 0, -4 > }
  }
#declare IntWater = interior { ior 1.33 }

#declare UmbTrans = 0.35;
#declare PigRed = pigment { rgbt < 1.0, 0.0, 0.0, UmbTrans > }
#declare PigWht = pigment { rgbt < 1.0, 1.0, 1.0, UmbTrans > }
#declare TxtUmb = texture { pigment { radial frequency 8
    pigment_map { [ 0.5 PigRed ] [ 0.5 PigWht ] }
    }
  finish { ambient 0.50 diffuse 0.90 }
  }

#declare TxtFrame = texture { WOOD11 }
#declare TxtSeat  = texture { pigment { rgb < 0.00, 0.75, 0.00 > } }

// Camera and light source(s) 
light_source { < 0, 500, -1000 > Gray40 shadowless }

#declare camera_location = < 0, 5, -10 >;
#declare camera_look_at  = < 0, 2, 200 >;
camera { location camera_location look_at camera_look_at }

// Rendered objects 
sky_sphere { pigment { gradient y color_map {
      [ 0.00 color rgb < 1.00, 0.80, 0.60 > ]
      [ 1.00 color rgb < 0.60, 0.10, 0.15 > ]
      }
    scale 2 translate -1
    }
  }

#if ( FlagFog )
  #declare FogHt = 3;
  fog { distance 35 color rgbt < 0.90, 0.70, 0.60, 0.005 >
    fog_type 2 fog_offset FogHt fog_alt FogHt
    turbulence 0.8 turb_depth 0.8
    }
#end

#if ( FlagRocks )
  #declare RkNum    = 400;
  #declare RkHMin   = 0.25;
  #declare RkHMax   = 2.50;
  #declare RkSeed   = seed( 10 );
  #declare RkScl    = < 1.00, 0.60, 1.00 >;
  #declare RkMaxRot = 80;
  #declare RkHtFld = height_field { tga "sph2.tga" smooth
    translate < -0.5, -0.5, -0.5 > scale < 4.0, 1.20, 4.0 > }
  #declare RkObj = difference {
    sphere { 0, 0.85 }
    object { RkHtFld }
    object { RkHtFld scale < 1, -1, 1 > }
    object { RkHtFld scale < 1, 1.5, 1 > rotate  90*x }
    object { RkHtFld scale < 1, 1.5, 1 > rotate -90*x }
    }
  #while ( RkNum > 0 )
    #declare RkRad  = (rand( RkSeed ) * RkHMax) + RkHMin;
    #declare RkX    = (rand( RkSeed ) - 0.50) * 125;
    #declare RkZ    = (rand( RkSeed ) - 0.25) * 200;
    #declare RkHS   = 0.50 + ((rand( RkSeed ) - 0.50) * 0.35);
    #declare RkRotX = (rand( RkSeed ) - 0.50) * RkMaxRot;
    #declare RkRotY = (rand( RkSeed ) - 0.50) * RkMaxRot;
    #declare RkRotZ = (rand( RkSeed ) - 0.50) * RkMaxRot;
    object { RkObj scale RkRad texture { TxtRock }
      rotate < RkRotX, RkRotY, RkRotZ > translate < RkX, 0, RkZ >
      }
    #declare RkNum = RkNum - 1;
  #end
#end

#if ( FlagButte )
  #declare Butte = height_field { tga "butte2.tga" smooth
    translate < -0.5, -0.5, -0.5 > scale < 60, 35, 60 > }
  merge {
    object { Butte rotate -30*y scale < 1.50, 1.00, 1.50 >
      translate < 35, 0, 090 > }
    object { Butte scale < 0.90, 1.50, 0.95 > rotate -200*y
      translate < -100, 0, 200 > }
    texture { TxtRock scale 7 }
    }
#end

#declare flare_position   = < 275, 125, 500 >;
#declare flare_type       = 5;
#declare flare_size       = 0.50;
#declare flare_brightness = 0.75;
#declare flare_colour     = < 0.95, 0.80, 0.60 >;
#if ( FlagFlare )
  #include "lensflar.inc"
#end
light_source { flare_position flare_colour }

#if ( FlagClouds )
  plane { -y, -500 texture { TxtClouds } }
#end

#declare PoolLn  = 4.00;
#declare PoolWd  = 4.00;
#declare PoolHt  = 0.75;
#declare PoolScl = 0.92;
#if ( FlagPool )
  #declare PoolCyl = cylinder { < 0, -PoolHt, 0 >, < 0, PoolHt, 0 >, PoolWd }
  #declare PoolBasic = merge {
    object { PoolCyl translate -PoolLn*x }
    object { PoolCyl translate  PoolLn*x }
    box { < -PoolLn, -PoolHt, -PoolWd >, < PoolLn, PoolHt, PoolWd > }
    }
  #macro PoolDelt( )
    rotate -30*y translate < 3, 0, 12 >
  #end
  #declare PoolIn = object { PoolBasic scale < PoolScl, 2, PoolScl > }
  #declare Pool = merge {
    difference { object { PoolBasic } object { PoolIn } }
    object { PoolIn translate -0.60*2*PoolHt*y hollow
      texture { TxtWater } interior { IntWater } }
    light_source { 0 White }
    }
  object { Pool PoolDelt() texture { TxtPool } }
#end

#if ( FlagDunes )
  difference {
    height_field { tga "ht3_img.tga" smooth scale < 25, 0.19, 40 >
      translate < -12, -0.05, -10 > scale 8 texture { TxtSand } }
    #if ( FlagPool )
      object { PoolIn PoolDelt() texture { TxtPool } }
    #end
    }
#end

#if ( FlagAcc )
  #declare UmbHt   = 5.00;
  #declare UmbPRad = 0.10;
  #declare UmbRad  = 1.50;
  #declare UmbDifCyl = cylinder { < -UmbRad, 0, 0 >, < UmbRad, 0, 0 >,
    UmbRad*0.175 scale < 1, 0.50, 1 > }
  #declare Umbrella = merge {
    cylinder { 0, < 0, UmbHt, 0 >, UmbPRad texture { Soft_Silver } }
    difference {
      sphere { 0, UmbRad } sphere { 0, UmbRad translate -0.01*y }
      plane { y, 0 }
      merge {
        object { UmbDifCyl rotate 000*y }
        object { UmbDifCyl rotate 022*y }
        object { UmbDifCyl rotate 045*y }
        object { UmbDifCyl rotate 067*y }
        object { UmbDifCyl rotate 090*y }
        object { UmbDifCyl rotate 112*y }
        object { UmbDifCyl rotate 135*y }
        object { UmbDifCyl rotate 167*y }
        rotate 11*y
        }
      scale < 1.75, 1.00, 1.75 >
      texture { TxtUmb } translate ((UmbHt*0.95)-UmbRad)*y
      }
    cone { 0, UmbRad*0.25 0.04*UmbHt*y, UmbPRad pigment { Black }
      translate UmbHt*0.95*y }
    }
  #declare ChHt  = UmbHt * 0.60;
  #declare ChHt2 = ChHt * 0.50;
  #declare ChWd  = UmbRad * 0.50;
  #declare ChDp  = UmbRad * 0.60;
  #declare ChDp2 = 0; /*((ChHt2 / ChHt) * ChDp * 2)*/
  #declare ChRad = UmbPRad * 0.80;
  #declare ChFrame = merge { 
    cylinder { < -ChDp, ChHt, -ChWd >, < ChDp, 0, -ChWd >, ChRad }
    cylinder { < -ChDp, ChHt,  ChWd >, < ChDp, 0,  ChWd >, ChRad }
    cylinder { < -ChDp, 0, -ChWd >, < ChDp, ChHt2, -ChWd >, ChRad }
    cylinder { < -ChDp, 0,  ChWd >, < ChDp, ChHt2,  ChWd >, ChRad }
    cylinder { < -ChDp, ChHt, -ChWd >, < -ChDp, ChHt,  ChWd >, ChRad }
    cylinder { < ChDp, ChHt2, -ChWd >, < ChDp, ChHt2,  ChWd >, ChRad }
    sphere { < -ChDp, ChHt, -ChWd >, ChRad }
    sphere { < -ChDp, ChHt,  ChWd >, ChRad }
    sphere { < ChDp, ChHt2, -ChWd >, ChRad }
    sphere { < ChDp, ChHt2,  ChWd >, ChRad }
    cylinder { < 0, ChHt2, -ChWd >, < 0, ChHt2,  ChWd >, ChRad }
    }
  #declare StTh = 0.01;
  #declare StLen = vlength( < -ChDp, ChHt, -ChWd > - < 0, ChHt2, -ChWd > );
  #declare StAng = degrees( acos( ChDp / StLen ) );
  #declare Seat = merge {
    box { < 0, ChHt2, -ChWd > < ChDp, ChHt2+StTh, ChWd > }
    box { < -StLen, 0, -ChWd > < 0, StTh, ChWd >
      rotate -StAng*z translate ChHt2*y }
    }
  #declare Chair = merge {
    object { ChFrame texture { TxtFrame scale 0.25 } } 
    object { Seat texture { TxtSeat } }
    }
  object { Chair scale 0.66 /*rotate -5*z*/ rotate 15*y
    translate < -6.5, 0.40, 13 > }
  object { Umbrella scale 0.75 rotate < 10, 0, 20 > translate < -6, 0, 16 > }
#end
