#version unofficial megapov 0.5;

#include "colors.inc"
#include "woods.inc"


#declare Place_ecran = on;
#declare Use_screen_light = on;
#declare Use_area = on;
#declare Nb_area = 7;
#declare Adap_area = 2;
#declare Place_clavier = on;
#declare Use_rad = on;
#declare Rad_count = 120;
#declare Rad_error = .1;
#declare Simul_env_rad = on;
#declare Use_media_screen = on;
#declare ep_feuille = 0.04;
#declare Place_main = on;
#declare Place_crayons = on;

//===================================
//===================================
//	SETTINGS
//===================================
//===================================
global_settings {
	max_trace_level 80
	max_intersections 128
	adc_bailout 0.05
#if (Use_rad)
	ini_option "+QR"
	assumed_gamma 1.7
	radiosity{
		count Rad_count
		nearest_count 4
		error_bound Rad_error
		recursion_limit 1
		brightness 1.3

		pretrace_start  .05
		pretrace_end  .005

		low_error_factor .5
		gray_threshold 0.0
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.05
	}
#end
}

#if (Use_rad)
#default { texture { finish { ambient 0 diffuse 1 } } }
#else
#default { texture { finish { ambient .3 diffuse .7 } } }
#end



//===================================
//	LIGHTS
//===================================
#if (Use_rad)
/*
light_source {
	50*y +10*z -50*x, color rgb<1,1,.95>*1.0
	spotlight
	radius 40
	falloff 50
	tightness 5
	point_at <-20,150,-20>
}
*/

// Simulation du corps de l'halogene
/*
disc { 0 , y , 8
	pigment { rgb 0 }
	rotate -z*10
	rotate -y*10
	translate <60,80,60>
}
*/

#else

light_source {
	145*y -10*z -20*x, color rgb<1,1,.95>*1.0
	spotlight
	radius 40
	falloff 50
	tightness 5
	point_at <50,0,-30>
}
light_source {
	1*y -40*z, color rgb<1,1,.95>*0.2
	shadowless
}
#end

#if ((Use_screen_light) & (Place_ecran))
light_source {
	<0, 27, 1>, color rgb <.90,.95,1>*0.95
	spotlight
	radius 80
	falloff 89
	tightness 1
	point_at <0, 27, -10>
#if (Use_area)
	area_light 44*x, 29*y, Nb_area, Nb_area
	jitter
	adaptive Adap_area
#end
}
#end

//===================================
//	CAMERA
//===================================
camera {
	location <15, 25, -60>
	right x*4/3
	up y
	angle 30
//	angle 50
	look_at <21,11,0>
//	look_at <100,150,100>
}


//==========================
// MURS AUTOUR
//==========================
#declare T_Mur = texture {
	pigment { rgb <1,.95,.90> }
	finish { ambient 0 diffuse 1 }
}

#declare CX = -50;
#declare CY =  25;
#declare CZ =-100;

#declare LX = 300;
#declare LY = 250;
#declare LZ = 400;


#if (Use_rad)
	#if (Simul_env_rad)
		#declare Rad_level = 1.1;
	#else
		#declare Rad_level = .8;
	#end
#end
// derriere
box { <-200, -100, -300>, <100, 150, -310>
#if (Simul_env_rad)
	texture {
		pigment {
			image_map { png "env_derriere" once }
			translate -.5*x -.5*y
			scale <-1,1,1>
			scale <LX, LY,1>
			translate <CX, CY, 0>
		}
		finish { ambient Rad_level }
	}
#else
	texture {
		T_Mur
		#if (Use_rad)
		finish { ambient .45*Rad_level }
		#end
	}
#end
}
// devant
box { <-200, -100, 100>, <100, 150, 110>
#if (Simul_env_rad)
	texture {
		pigment {
			image_map { png "env_devant" once }
			translate -.5*x -.5*y
			scale <LX, LY,1>
			translate <CX, CY, 0>
		}
		finish { ambient Rad_level }
	}
#else
	texture {
		T_Mur
		#if (Use_rad)
		finish { ambient .25*Rad_level }
		#end
	}
#end
}
// droite
box { < 100, -100, -300>, <110, 150, 110>
#if (Simul_env_rad)
	texture {
		pigment {
			image_map { png "env_droite" once }
			translate -.5*x -.5*y
			rotate 90*y
			scale <1, LY, LZ>
			translate <0, CY, CZ>
		}
		finish { ambient Rad_level }
	}
#else
	texture {
		T_Mur
		#if (Use_rad)
		finish { ambient .65*Rad_level }
		#end
	}
#end
}
// gauche
box { <-210, -100, -300>, <-200, 150, 110>
#if (Simul_env_rad)
	texture {
		pigment {
			image_map { png "env_gauche" once }
			translate -.5*x -.5*y
			rotate -90*y
			scale <1, LY, LZ>
			translate <0, CY, CZ>
		}
		finish { ambient Rad_level }
	}
#else
	texture {
		T_Mur
		#if (Use_rad)
		finish { ambient .35*Rad_level }
		#end
	}
#end
}
// plafond
box { <-200, 150, -300>, < 100, 160, 110>
#if (Simul_env_rad)
	texture {
		pigment {
			image_map { png "env_plafond" once }
			translate -.5*x -.5*y
			scale <LX, LZ,1>
			rotate -90*x
			translate <CX, 0, CZ>
		}
		finish { ambient Rad_level }
	}
#else
	texture {
		T_Mur
		#if (Use_rad)
		finish { ambient .55*Rad_level }
		#end
	}
#end
}


//===================================
//===================================
//	TABLE
//===================================
//===================================
box { <-100, 0, -20>, <100, 5, 99.6>
	texture { T_Wood22 translate 10*x - 3*y scale 30 }
}

//===================================
//===================================
//	ECRAN
//===================================
//===================================

#declare T_Ecran = texture {
	pigment { Wheat+<0,0,.02> }
	normal { granite .1 scale .01 }
	finish { phong .1 phong_size 10 brilliance .8 }
}

#declare T_Led_Verte = texture {
	pigment { color rgb<.4,1,.6> }
	finish { ambient 1.2 diffuse 0 }
}


#if (Place_ecran)
union {
	// arriere
	box { <-22, 12, 10>, <22, 43, 50> }

	// contours
	difference {
		box { <22, 10, -.3>, <25, 45, 10> }
		superellipsoid { <.5,.1> rotate z*45 scale <1.5,1,.5>/sqrt(2) translate <23,11.5, 0> }
	}
	box { <-25, 10, -.3>, <-22, 45, 10> }
	box { <-25, 42, -.3>, <25, 45, 10> }
	difference {
		box { <-25, 10, -.3>, <25, 13, 10> }
		text {
			ttf "arialn.ttf",
			"CONTRAST", .2, 0
			align_center
			scale <.5,.7,1>
			translate -.4*z
			translate 19*x + 10.5*y
			pigment { rgb 0 }
		}
		superellipsoid { <.5,.1> rotate z*45 scale <1.5,1,.5>/sqrt(2) translate <23,11.5, 0> }
	}
	sphere { <25,10,0>, .3 }
	cylinder { <25,10,0>, <25,40,0>, .3 }
	cylinder { <-25,10,0>, <25,10,0>, .3 }

	// socle
	union {
		box { <-17.5, .1, 4.5>, <17.5, 1, 35.5> }
		box { <-17, 1, 5>, <17, 1.5, 35> }
		sphere { <-17, 1, 5>, .5 }
		sphere { < 17, 1, 5>, .5 }
		sphere { <-17, 1, 35>, .5 }
		sphere { < 17, 1, 35>, .5 }
		cylinder { <-17, 1, 5>, < 17, 1, 5>, .5 }
		cylinder { <-17, 1, 35>, < 17, 1, 35>, .5 }
		cylinder { <-17, 1, 5>, <-17, 1, 35>, .5 }
		cylinder { < 17, 1, 5>, < 17, 1, 35>, .5 }
		cone { <0, 1.5, 20>, 13, <0, 2.5, 20>, 11 }
		intersection {
			sphere { 0, 35 translate 32*y }
			box { <-20, -.1, -20>, <20, 3.5, 20> }
			translate <0, 2, 20>
		}
		translate y*5 + 5*z
	}
	superellipsoid { <.5,.05> rotate z*45 scale .97*<1.5,1,.1>/sqrt(2) translate <23,11.5, -.05> }
	sphere  { 0, .1 translate <23,11.5, -.15> texture {T_Led_Verte} }
	texture { T_Ecran }
}


union {
	triangle { 0, x, x+y }
	triangle { 0, y, x+y }
	texture {
		pigment {
			image_map { png "win98" once interpolate 2 filter 0,1 }
		}
		normal { wrinkles .3 scale .3 }
		finish { specular .3 roughness .005 }
	}
	scale <2,2*108/74,1>
	translate 22.5*x + 13.5*y -.3001*z
}

// molette
intersection {
	union {
		cylinder { 0, 1*z, 2 }
		#local i=0;
		#while (i<20)
			cylinder { 0, 1*z, .05
				translate -2*y
				rotate (-40+4*i)*z
			}
			#local i=i+1;
		#end
	}
	box { <-2.1, -2.1, -.1>, <2.1, 0, 2.1> }
	translate 19*x + 11.3*y + .3*z
	texture { T_Ecran }
}


// tube cathodique
#if (Use_media_screen)

box{-.5,.5
	hollow
	texture{pigment{rgbt 1 }}
	interior{
		media{
			emission 8
			method 2
			intervals 2
			samples 1, 3
			density {
				image_map{ png "screen" once }
				translate -.5
			}
		}
	}
	no_shadow
	translate .5*y
	scale <22*1.99, 22*1.99*864/1152, .09>
	translate <0, 13, 1>
}

box{-.5,.5
	hollow
	texture{
		pigment{
			image_map{ png "screen" interpolate 2 once }
			translate -.5
		}
		finish{ ambient .8 diffuse 0 }
	}
	no_shadow
	translate .5*y
	scale <22*1.99, 22*1.99*864/1152, .01>
	translate <0, 13, 1.1>
}

#else
box { <-22, 13, 1>, <22, 37, 1.01>
	texture {
		pigment {
			image_map { png "screen" once interpolate 2 }
			translate -.5*x
			scale <22*1.98, 22*1.99*864/1152, 1>
			translate 13.1*y
		}
		finish { ambient 1.2 diffuse 0 reflection_min .1 reflection_max .5 }
	}
	hollow
	no_shadow
}
#end

box{-.5,.5
	hollow
	pigment{ rgb 0 }
	no_shadow
	translate .5*y
	scale <22*2, 22*2*864/1152, .01>
	translate <0, 13, 1.101>
}


#end //if (Place_ecran)


//===================================
//===================================
//	CLAVIER (celui de J.V.PIQUERES)
//===================================
//===================================
#if (Place_clavier)

#include "keyboard.inc"
object {
	keyboard
	translate 5.55*y - 7*z - x
}

#end // if (Place_clavier)

//===================================
//===================================
//	TAPIS DE SOURIS, SOURIS, MAIN
//===================================
//===================================

#declare T_Souris = texture {
		pigment { color rgb<.98, .96, .92> }
		normal { granite .1 scale .01 }
		finish { phong .1 phong_size 10 brilliance .8 }
}

#declare T_DessusTapis = texture {
	pigment { color rgb <.1,.2,.5> }
	normal { quilted control0 1 control1 1 cubic_wave scale <.05, 100, .5>*2 }
	finish { phong .5 phong_size 40 }
}

#declare T_DessousTapis = texture {
	pigment {
		spotted
		warp { turbulence .2 octaves 2 }
		scale .1
		color_map {
			[.7 color rgb .3 ]
			[.7 color rgb .7 ]
		}
	}
	normal { bozo .2 scale .05 }
	finish { brilliance .7 }
}

union {
	box { <-12.5, 0, -10>, <12.5, .5, 10> }
	box { <-12, 0, -10.5>, <12, .5, 10.5> }
	cylinder { <-12, 0, -10>, <-12, .5, -10>, .5 }
	cylinder { < 12, 0, -10>, < 12, .5, -10>, .5 }
	cylinder { <-12, 0,  10>, <-12, .5,  10>, .5 }
	cylinder { < 12, 0,  10>, < 12, .5,  10>, .5 }
	texture {
		planar
		scale <1, .5, 1>
		texture_map {
			[ 0.1 T_DessusTapis ]
			[ 0.1 T_DessousTapis ]
		}
	}
	rotate -y*8
	translate <37,5.01,-5>
}


#declare Base_Souris = difference {
	blob {
		threshold .2
		cylinder { <0,-.2,-2>, <0,.5/.9,-2>, 4, 1 scale <1,.9,1.5> rotate -y*10 }
		cylinder { <-.2,-.2, 1>, <-.2,.5/.9, 1>, 4, .8 scale <1,.7,1.5> }
	}
	plane { y, 0 }
}

#declare Souris_Corps = union {
	difference {
		object { Base_Souris }
		plane {  y,   0 }
		plane { -y, -.4 }
	}
	object { Base_Souris scale <.95,.99,.95> texture { T_Souris pigment { color rgb<.98, .96, .92>*.8 } }}
	difference {
		object { Base_Souris }
		plane { y, .5 }
		box { <-6, .7, 2>, <6, 3, 8> }
	}
	intersection {
		object { Base_Souris scale <1.00, 1, 1.02> }
		box { <-6, .8, 2.1>, <-.54, 3, 8> }
	}
	intersection {
		object { Base_Souris scale <1.00, 1, 1.02> }
		box { <-.46, .8, 2.1>, <6, 3, 8> }
	}
}


#if (Place_main)
#include "main.inc"
#end
union {
	object { Souris_Corps texture { T_Souris } }
	#if (Place_main)
	object { Main rotate -z*10 rotate -x*5 rotate y*13 translate <-4.7,-7,-2.1> }
	#end
	rotate -y*24
	translate <32, 5.02+.5, -2>
//	translate <18, 5.01, 0>
}


#local pt1 = <0, .2, 2>;
#local pt1 = vrotate(pt1, <0, -24, 0>);
#local pt1 = pt1 + <32, 5.02+.5, -2>;
#local pt2 = <0, .2, 4>;
#local pt2 = vrotate(pt2, <0, -24, 0>);
#local pt2 = pt2 + <32, 5.02+.5, -2>;
#local pt3 = <0, .2, 8>;
#local pt3 = vrotate(pt3, <0, -24, 0>);
#local pt3 = pt3 + <32, 5.02+.5, -2>;

sphere_sweep {
	catmull_rom_spline_sphere_sweep
	9,
	pt1, .2
	pt2, .2
	pt3, .2
	<30, 5.3, 12>, .2
	<25, 5.2, 15>, .2
	<30, 5.3, 27>, .2
	<21, 5.2, 35>, .2
	<15, 5.2, 50>, .2
	<08, 5.2, 80>, .2
	texture { T_Ecran scale .1 }
}

//===================================
//===================================
//	RANGE-CRAYONS
//===================================
//===================================

#include "crayons.inc"

#declare T_Dore = texture {
	pigment { color rgb <1,.9,.6> }
	finish { specular .5 roughness .01 metallic reflection .2 reflect_metallic }
}

#declare T_Metal = texture {
	pigment { color rgb <.6,.6,.57> }
	normal { dents scale 1.2 }
	finish { specular .5 roughness .01 metallic reflection .3 reflect_metallic }
}

#declare TexCenC = texture { pigment { color rgb .1 } }
#declare TexMilC = texture {
	pigment {
		spotted
		warp { turbulence .2 octaves 2 }
		scale <5,1,1>*.1
		color_map {
			[0.55 color rgb <1, .7, .3>]
			[0.75 color rgb <1, .7, .3>*.7]
		}
	}
}

#declare TexExtC = array[4]

#declare TexExtC[0] = texture {
	pigment { color rgb<.3, 1, .5>*.8 }
	normal { dents .5 scale .3 slope_map {[0 <0,3>] [.4 <.9,2>] [.5 <1,0>]} }
}
#declare TexExtC[1] = texture {
	pigment { color rgb<1, .5, .3>*.8 }
	normal { dents .5 scale .3 slope_map {[0 <0,3>] [.4 <.9,2>] [.5 <1,0>]} }
}
#declare TexExtC[2] = texture {
	pigment { color rgb<.3, .5, 1>*.8 }
	normal { dents .5 scale .3 slope_map {[0 <0,3>] [.4 <.9,2>] [.5 <1,0>]} }
}
#declare TexExtC[3] = texture {
	pigment { color rgb<.9, .7, .3>*.8 }
	normal { dents .5 scale .3 slope_map {[0 <0,3>] [.4 <.9,2>] [.5 <1,0>]} }
}
#declare TexBicTr = texture {
	pigment { color rgbf <1,1,1,.97> }
	finish { specular .5 roughness .005 }
}
#declare CoulBic = array[2]
#declare CoulBic[0] = <.05,.05,.05>;
#declare CoulBic[1] = <.1,.2,.7>;

//===================================
//	TEXTURE ETOILES ET LUNES
//===================================
// etoile
#declare obj1 = union {
	intersection {
		box { -.4, .4 translate .2*y }
		box { -.4, .4 translate .2*y rotate z*120 }
		box { -.4, .4 translate .2*y rotate -z*120 }
	}
	intersection {
		box { -.4, .4 translate -.2*y }
		box { -.4, .4 translate -.2*y rotate z*120 }
		box { -.4, .4 translate -.2*y rotate -z*120 }
	}
	scale .3
}
// lune
#declare obj2 = difference {
	cylinder { <0,0,-10>, <0,0,10>, 2 translate 3.5*x }
	cylinder { <0,0,-10>, <0,0,10>, 2.5 translate 5.0*x }
	scale .05
}

#macro Pig2(rot)
#local stl = seed(12*rot);
#local obj = object {
	#if (rand(stl) > .4)
		obj1
	#else
		obj2
	#end
	rotate  z*rot
	translate (-.4+.8*rand(stl))*x
	rotate  z*rot
}
	// definition du pigment
	object {
		obj
		color rgb <.15,.15,.4>, color rgb <1,.9,.6>
	}
	translate .5*x + .5*y
	warp { repeat x }
	warp { repeat y }
#end

#declare st_p = seed(352);
#declare PigEtoiles = pigment {
	pigment_pattern {
		cells
		translate -z*.5 + 100*y + 100*x
	}
	pigment_map {
		#local rot = 360*rand(st_p);
		[0.05 Pig2(rot)]
	#local i=0.05;
	#while (i<.95)
		#local rot = 360*rand(st_p);
		[i Pig2(rot)]
		#local i=i+.05;
		[i Pig2(rot)]
	#end
		#local rot = 360*rand(st_p);
		[0.95 Pig2(rot)]
	}
	scale <3, 3, 2000>
}


#declare T_Etoiles = texture {
	pigment { PigEtoiles scale <1/20*pi,1,1> warp { cylindrical dist_exp 1} }
//	pigment { checker color rgb 0, color rgb 1 scale <1/10*pi,1,1> warp { cylindrical dist_exp 1} }
	normal { dents .4 scale 3 }
	finish { specular .3 roughness .01 metallic reflection .2 reflect_metallic }
}

union {
	torus { 4, .1 translate .1*y texture { T_Dore }}
	difference {
		cylinder { .1*y, 10*y, 4 }
		cylinder { .2*y, 10.1*y, 3.9 }
		texture {
			pigment_pattern {
				cylindrical
				scale <4,1,4>
			}
			texture_map {
				[ 0.0001 T_Etoiles ]
				[ 0.0001 T_Metal ]
			}
		}
	}
	torus { 4, .1 translate 10*y texture { T_Dore }}
	
	
#if (Place_crayons)
	
	#local stc1=seed(3621);
	#local stc2=seed(8412);
	#local stc3=seed(1234);
	#local stc4=seed(4321);
	#local i=0;
	#while (i<360)
		#if (rand(stc1) > .55 )
			// crayon bic
			object {
				Crayon_Bic(CoulBic[mod(floor(rand(stc3)*20),2)], TexBicTr, 1.4, 3211, off)
				#if (rand(stc4) >.5)
					rotate z*180
					translate 14.5*y
				#end
				translate -(.5*sin(radians(30))+.1)*x - 10*y
				rotate -z*(15+10*rand(stc2))
				translate 3.9*x + 10*y
				rotate i*y
			}
		#else
			// crayon de bois
			#if (rand(stc2)>.5)
				#local mal_taille=on;
			#else
				#local mal_taille=off;
			#end
			object {
				Crayon_Bois(11+7*rand(stc1), .4, 10+6*rand(stc1), 7, 60, TexCenC, TexMilC, TexExtC[floor(rand(stc1)*4)], int(9875*rand(stc1)), mal_taille)
				translate -.4*x - 10*y
				rotate -z*(15+10*rand(stc1))
				translate 3.9*x + 10*y
				rotate i*y
			}
		#end
		#local i=i+15+25*rand(stc2);
	#end

	#local i=0;
	#while (i<360)
		#if (rand(stc1) > .55 )
			// crayon bic
			object {
				Crayon_Bic(CoulBic[mod(floor(rand(stc3)*20),2)], TexBicTr, 1.4, 3211, off)
				#if (rand(stc4) >.5)
					rotate z*180
					translate 14.5*y
				#end
				translate -(.5*sin(radians(30))+.1)*x - 10*y
				rotate -z*(5+10*rand(stc2))
				translate 2.9*x + 10*y
				rotate i*y
			}
		#else
			// crayon de bois
			#if (rand(stc2)>.5)
				#local mal_taille=on;
			#else
				#local mal_taille=off;
			#end
			object {
				Crayon_Bois(11+7*rand(stc1), .4, 10+6*rand(stc1), 7, 60, TexCenC, TexMilC, TexExtC[floor(rand(stc1)*4)], int(9875*rand(stc1)), mal_taille)
				translate -.4*x - 10*y
				rotate -z*(5+10*rand(stc1))
				translate 2.9*x + 10*y
				rotate i*y
			}
		#end
		#local i=i+25+35*rand(stc2);
	#end

#end

	translate <38, 5.01, 18>
}

//===================================
//===================================
//	DOSSIERS DANS LE FOND
//===================================
//===================================

#include "dossier.inc"

// Pile_Dossiers(t_feuille, t_pochette, hauteur, max_rot, st)

#local std = seed(3621);
object {
	Pile_Dossiers(<21, ep_feuille, 29.7>, <25, 5, 31>, 40, 15, std, off)
	translate <32, 5.01, 46>
}
