#version unofficial megapov 0.5;

#include "colors.inc"
#include "woods.inc"


#declare Use_rad = on;
#declare Use_area = on;
#declare Place_ecran = off;

#declare Rendu_mur = 4;
//===================================
//===================================
//	SETTINGS
//===================================
//===================================
global_settings {
	max_trace_level 10
	adc_bailout 0.1
#if (Use_rad)
	ini_option "+QR"
	assumed_gamma 1.0
	radiosity{
		count 100
		nearest_count 4
		error_bound .1
		recursion_limit 4
		brightness 1.5

		pretrace_start  .1
		pretrace_end  .01

		low_error_factor .5
		gray_threshold 0.0
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.05
	}
#end
}

#if (Use_rad)
#default { texture { finish { ambient 0 diffuse 1 } } }
#else
#default { texture { finish { ambient .3 diffuse .7 } } }
#end


//===================================
//	LIGHTS
//===================================
#if (Use_rad)

light_source {
	<60, 80, 60>, color rgb<1,1,.98>*1.2
	spotlight
	radius 80
	falloff 89
	tightness 5
	point_at <75,130,75>
}

#else

light_source {
	145*y -10*z, color rgb<1,1,.95>*1.0
	spotlight
	radius 40
	falloff 50
	tightness 5
	point_at <50,0,-30>
}
light_source {
	1*y -40*z, color rgb<1,1,.95>*0.2
	shadowless
}
#end
//===================================
//	CAMERA
//===================================

#declare CX = -50;
#declare CY =  25;
#declare CZ =-100;

#declare LX = 300;
#declare LY = 250;
#declare LZ = 400;

#switch (Rendu_mur)

#case (0)
camera {
	location <CX-LX/4, CY+LY/4, CZ-LY/4>
	right x*4/3
	up y
	angle 60
	look_at <CX+LX/4, CY, CZ+LY/4>
}
#break


// derriere
#case (1)
camera {
	orthographic
	location <CX, CY, CZ>
	direction -z
	right x*LX
	up y*LY
}
#break

// devant
#case (2)
camera {
	orthographic
	location <CX, CY, CZ>
	direction z
	right x*LX
	up y*LY
}
#break

// droite
#case (3)
camera {
	orthographic
	location 0
	direction z
	right x*LZ
	up y*LY
	rotate y*90
	translate <CX, CY, CZ>
}
#break


// gauche
#case (4)
camera {
	orthographic
	location 0
	direction z
	right x*LZ
	up y*LY
	rotate -y*90
	translate <CX, CY, CZ>
}
#break

// plafond
#case (5)
camera {
	orthographic
	location 0
	direction z
	right x*LX
	up y*LZ
	rotate -x*90
	translate <CX, CY, CZ>
}
#break

#else

#end

//==========================
// MURS AUTOUR
//==========================
#declare T_Mur = texture {
	pigment { rgb <1,.98,.95> }
	finish { ambient 0 diffuse 1 brilliance .5 }
}

// derriere
box { <-200, -100, -300>, <100, 150, -310>
	texture {
		T_Mur
	}
}
// devant
box { <-200, -100, 100>, <100, 150, 110>
	texture {
		T_Mur
	}
}
// droite
box { < 100, -100, -300>, <110, 150, 110>
	texture {
		T_Mur
	}
}
// gauche
box { <-210, -100, -300>, <-200, 150, 110>
	texture {
		T_Mur
	}
}
// plafond
box { <-200, 150, -300>, < 100, 160, 110>
	texture {
		T_Mur
	}
}

// sol
box { <-200, -110, -300>, < 100, -100, 110>
	texture {
		T_Mur
	}
}


//===================================
//===================================
//	TABLE
//===================================
//===================================

/*
box { <-100, 0, -20>, <100, 5, 99.6>
	texture { T_Wood22 translate 10*x - 3*y scale 30 }
}
*/

#if (Place_ecran)
//===================================
//===================================
//	ECRAN
//===================================
//===================================
#declare T_Ecran = texture {
		pigment { Wheat+<0,0,.02> }
		normal { granite .1 scale .01 }
		finish { phong .1 phong_size 10 brilliance .8 }
}

union {
	// arriere
	box { <-22, 12, 10>, <22, 43, 50> }

	// contours
	box { <22, 10, -.3>, <25, 45, 10> }
	box { <-25, 10, -.3>, <-22, 45, 10> }
	box { <-25, 42, -.3>, <25, 45, 10> }
	difference {
		box { <-25, 10, -.3>, <25, 13, 10> }
		text {
			ttf "arialn.ttf",
			"CONTRAST", .2, 0
			align_center
			scale <.5,.7,1>
			translate -.4*z
			translate 19*x + 10.5*y
			pigment { rgb 0 }
		}
	}
	sphere { <25,10,0>, .3 }
	cylinder { <25,10,0>, <25,40,0>, .3 }
	cylinder { <-25,10,0>, <25,10,0>, .3 }

	// socle
	union {
		box { <-17.5, .1, 4.5>, <17.5, 1, 35.5> }
		box { <-17, 1, 5>, <17, 1.5, 35> }
		sphere { <-17, 1, 5>, .5 }
		sphere { < 17, 1, 5>, .5 }
		sphere { <-17, 1, 35>, .5 }
		sphere { < 17, 1, 35>, .5 }
		cylinder { <-17, 1, 5>, < 17, 1, 5>, .5 }
		cylinder { <-17, 1, 35>, < 17, 1, 35>, .5 }
		cylinder { <-17, 1, 5>, <-17, 1, 35>, .5 }
		cylinder { < 17, 1, 5>, < 17, 1, 35>, .5 }
		cone { <0, 1.5, 20>, 13, <0, 2.5, 20>, 11 }
		intersection {
			sphere { 0, 35 translate 32*y }
			box { <-20, -.1, -20>, <20, 3.5, 20> }
			translate <0, 2, 20>
		}
		translate y*5 + 5*z
	}
	
	texture { T_Ecran }
}



#end //if (Place_ecran)


