// *** THAT'S MEGAPOV CODE ***
#version unofficial MegaPov 0.5;


#macro roundedbox(long, haut, larg, R)

union {
	box { <-long, -haut+R, -larg+R>, <long, haut-R, larg-R> }
	box { <-long+R, -haut, -larg+R>, <long-R, haut, larg-R> }
	box { <-long+R, -haut+R, -larg>, <long-R, haut-R, larg> }
	sphere { <-long+R, -haut+R, -larg+R>, R }
	sphere { <-long+R, -haut+R,  larg-R>, R }
	sphere { <-long+R,  haut-R, -larg+R>, R }
	sphere { <-long+R,  haut-R,  larg-R>, R }
	sphere { < long-R, -haut+R, -larg+R>, R }
	sphere { < long-R, -haut+R,  larg-R>, R }
	sphere { < long-R,  haut-R, -larg+R>, R }
	sphere { < long-R,  haut-R,  larg-R>, R }
	cylinder { <-long+R, -haut+R, -larg+R>, < long-R, -haut+R, -larg+R>, R }
	cylinder { <-long+R,  haut-R, -larg+R>, < long-R,  haut-R, -larg+R>, R }
	cylinder { <-long+R, -haut+R,  larg-R>, < long-R, -haut+R,  larg-R>, R }
	cylinder { <-long+R,  haut-R,  larg-R>, < long-R,  haut-R,  larg-R>, R }
	cylinder { <-long+R, -haut+R, -larg+R>, <-long+R, -haut+R,  larg-R>, R }
	cylinder { < long-R, -haut+R, -larg+R>, < long-R, -haut+R,  larg-R>, R }
	cylinder { <-long+R,  haut-R, -larg+R>, <-long+R,  haut-R,  larg-R>, R }
	cylinder { < long-R,  haut-R, -larg+R>, < long-R,  haut-R,  larg-R>, R }
	cylinder { <-long+R, -haut+R, -larg+R>, <-long+R,  haut-R, -larg+R>, R }
	cylinder { < long-R, -haut+R, -larg+R>, < long-R,  haut-R, -larg+R>, R }
	cylinder { <-long+R, -haut+R,  larg-R>, <-long+R,  haut-R,  larg-R>, R }
	cylinder { < long-R, -haut+R,  larg-R>, < long-R,  haut-R,  larg-R>, R }
}
#end

#declare keyboard=
union{
 difference{
  object { roundedbox(1, .1, 1, .05)
    scale <23.5,.6/.1,7.5>
  }
  object { roundedbox(1,.3,1,.05)
   scale <23,.6/.3,7>
   translate .1*y
  }
  texture{pigment{Wheat+<0,0,.02>} normal{granite .1 scale .2}}
  translate -.5*y
 }
 height_field{
  png "hf_kbsp_blur"
  water_level .1
  //smooth
  translate -.5
  texture{
   pigment{
    image_map{ png "im_kbfr" interpolate 2 }
    translate -.5
    rotate 90*x
   }
  }
  scale <23*2,2,14>
  translate -.4*y
 }
 height_field{
  png "hf_kbsp_hole"
  water_level .1
  translate -.5
  texture{pigment{Wheat} normal{granite .1 scale .2}}
  scale <23*2,.1,14>
  translate -.05*y
 }
 box{-.5,.5
  hollow
  texture{pigment{Clear}}
  interior{
   media{
    emission 1
    intervals 10
    samples 1, 10
    density {
     boxed
     color_map {
       [0.0 Green*2]
       [1.0 Green]
     }
    }
   }
  }
  scale <8,.2,1.6>
  translate <18.1,-.3,6>
 }
 difference{
  box{-.5,.5}
  box{<-.4,-.6,-.4>,<-.3,.6,-.2>}
  box{<-.05,-.6,-.4>,<.05,.6,-.2>}
  hollow
  texture{
   pigment{image_map{tga "im_kbsp_leds"}}
   translate -.5
   rotate 90*x
  }
  scale <8.01,.05,1.7>
  translate <18.1,-.2,5.9>
 }
 translate 7.5*z
 rotate -x*7
 translate -7.5*z
 translate .5*y
}
