
#version unofficial MegaPov 0.6;

#declare Chain_Tex = texture{pigment{Black}}
            
#declare Metal_Tex = texture{pigment{Black}}
            
#declare Link = union{
    #declare Chain_End = difference{torus{.75,.25 rotate x*-90}box{<-1.5,-1.5,-.5> <1.5,0,.5> }texture{Chain_Tex}}
    #declare Chain_Side = cylinder{x*-1,x*1,.25 texture{Chain_Tex}}
        object{Chain_End rotate z*-90 translate x*1} 
        object{Chain_End rotate z*90 translate x*-1}
        object{Chain_Side translate y*.75} 
        object{Chain_Side translate y*-.75}
}

$ Chain = union{

$ Start_Point = -50;
$ End_Point = 80 ;
$ Ang = 0;
$ C=Start_Point;

#while(C<End_Point)

  #if(mod(C,2)=0)
    object{Link translate x*C }
  #else
    object{Link translate x*C rotate x*-90 }
  #end
    $ C=C+3; 
     
#end 
}

#include"skeleton.inc"
#include"skull2.inc"

#declare Eye = 
	sphere{0,.5 pigment{rgbf<1,1,1,1>}
	interior{
		media{
		    emission rgb <500,0,0>
		    intervals 10
		      density {
		      	spherical color_map{ 
		      	[0 rgb 0]
		      	[ .75 rgb .25]
		      	[.9 rgb .5]
		      	[1 rgb 1]}
		      	scale .1
			}
		 }
	  }
	  hollow
	}	

#declare SkullLamp = union{
	object{Skull rotate y*180 pigment{rgb 5}finish{ambient -0.001 diffuse .125 phong .25 phong_size 100}scale 10}
	object{Eye translate<-.0775,6.475,-.325>}
	object{Eye translate<.145,6.475,-.325>}
}	

#declare RingOfSkulls = union{
	#declare C=25;
	
		#while(C<385)
		
			object{SkullLamp rotate y*180 
				translate z*1.3
					rotate y*C
					}
			#declare C=C+45;
			
		#end
		}
	

#declare Lamp = union{
	object{Skeleton pigment{rgb 5}finish{ambient -0.001 diffuse .125 phong .25 phong_size 100}scale 10}
	object{RingOfSkulls translate y*-2.9}
	torus{1.55,.05 
		texture{Metal_Tex}
				translate y*3.3
				}
	object{Chain scale .05 rotate z *90 translate <-.2,8.7,0>}
	object{cylinder{y*0,y*.1,.25 texture{Metal_Tex}rotate z*-25 translate<-.075,5.95,0> }}			
	}

	
