
#version unofficial MegaPov 0.6;
/*
#include "colors.inc"
#include"reg3Dpolygon.inc"

global_settings
{
  assumed_gamma 1.0
  max_trace_level 20
}

//#declare RndNum = seed(tick_count)

// ----------------SCENE------------------
#declare Image_Length = 480;
#declare Image_Height = 640;

camera
{
  location  <0.0, 1, -15.0>
  //location  <0.0, 25, 0.0>
  direction 1.5*z
  right Image_Length/Image_Height*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y turbulence .3 lambda 3
    color_map { [0.0 color rgb <0,.45,.65>] [1.0 color rgb 1] }
  }
}

light_source{<100, 100,-100> color rgb<1,1,.875>}
*/

//#include"skull2.inc"

#declare Claw=union{
#declare Rad = 1;
#declare RInc=.0125;
#declare Angle = 0;

   #while(Rad>0)
   sphere{0,Rad 
        translate<Rad+(RInc*150),0,0>
             rotate z*-Angle
             }
        #declare Rad = Rad - RInc;
        #declare Angle = Angle - 2;
       
   #end                    
             
}

#declare C=0;

#declare Foot = union{
#while(C<360)
        object{Claw
                translate<-3,0,0> 
            rotate z*30
                scale<1,1,1>*3
                    rotate y*C
        }
#declare C=C+45;
#end
}
	  
// isosurface pattern

$ AFunction2 =
function { pigment { agate color_map { [ 0 rgb 0 ] [ 1 rgb 1 ]} turbulence .3  } }// was agate


$ MidOfASquare3 =    // columns
function {
  AFunction2(
    3*(floor(x^2) + 0.5),
    3*(y + 1*noise3d(x, y, z)),     
    3*(floor(z^2) + 0.5)
  )
}

// basic isosurfaces

// cube
#declare BF=function{y-1}

// cylinder
#declare ZCyl=function{sqrt(x^2+y^2)-.01}  
#declare XCyl=function{sqrt(y^2+z^2)-.01}
#declare Col=function{sqrt(x^2+z^2)-.4} //col
 
$ Column =
isosurface {
  function {
    Col(x, y, z)
    -0.15*MidOfASquare3(x, y/3, z)
    + y*(0.03 + 0.03*noise3d(4*x + 3, 0, 1*z))
  }
  sign 1
  accuracy .025  //was.01
  max_gradient 10
  method 2
  contained_by { box{<-1,0,-1>,<1,7.4975,1> } } 
}

#declare IP = difference{
        box{<-.5,0,-.5>,<.5,1,.5>}
        cylinder{z*-.6,z*.6,1.2 translate x*-1.3}
        cylinder{z*-.6,z*.6,1.2 translate x*1.3}
        cylinder{x*-.6,x*.6,1.2 translate z*-1.3}        
        cylinder{x*-.6,x*.6,1.2 translate z*1.3}
        }

#declare Boss = union{
object{IP}
sphere{<-.55,1.1,-.55> .1} 
sphere{<.55,1.1,-.55> .1}
sphere{<-.55,1.1,.55> .1}
sphere{<.55,1.1,.55> .1}    
//lower
sphere{<-.5,.9,-.5> .05} 
sphere{<.5,.9,-.5> .05}
sphere{<-.5,.9,.5> .05}
sphere{<.5,.9,.5> .05}

cylinder{x*-.55,x*.55,.1 translate<0,1.1,-.55>}
cylinder{x*-.55,x*.55,.1 translate<0,1.1,.55>}
cylinder{z*-.55,z*.55,.1 translate<-.55,1.1,0>}
cylinder{z*-.55,z*.55,.1 translate<.55,1.1,0>}  
//lower
cylinder{x*-.5,x*.5,.05 translate<0,.9,-.5>}
cylinder{x*-.5,x*.5,.05 translate<0,.9,.5>}
cylinder{z*-.5,z*.5,.05 translate<-.5,.9,0>}
cylinder{z*-.5,z*.5,.05 translate<.5,.9,0>}
box{<-.5,1,-.5><.5,1.2,.5>}
}

#declare Pillar = union{

object{Column}
//object{Skull rotate y*90 scale 6 translate<.125,3.25,.0250>} 
//object{Skull rotate y*-90 scale 6 translate<-.125,3.25,.075>} 

//object{Skull rotate y*180 scale 6 translate<0,3.25,-.1>} 
//object{Skull rotate y*180 scale 6 translate<0,3.25,.1>}

object{Foot scale .1 translate y*-.1 }

torus{2.75,1 
  pigment{rgb<1,1,0>} 
    normal{radial 3 frequency 36 scallop_wave}
      finish{ambient -.0001 phong 1 phong_size 10 specular .25 reflection .5 metallic}
         scale <.355,.55,.355> 
         translate y*-.45 
         }

}

//object{Pillar translate y*-3 }

