//DBsTiles.pov
//By David Bridge. December 2000
//IRTC competition -- Contrast

global_settings
{
  max_trace_level 25
}

#declare db1=seed(55);

camera {  
  location  <      10.000,      -25.00,      18.00>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34707,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00000    // Vertical      22.500
  look_at   <      10.000,      -12.000,       0.000>
}


light_source
{
  <0.0, 0.0, 20.0>
  color rgb <1.000, 1.000, 1.000>
}

#include "TheShape.inc"

#declare x_axis=0; 
#declare y_axis=0;
                  
#while (y_axis<10)                  
  
  #while (x_axis<10)  
  
    object
    {

      TheShape

      #declare rpig=rand(db1);
      #declare gpig=rand(db1);
      #declare bpig=rand(db1);
      
      #declare maincolour=rgb<rpig, gpig, bpig>;
      #declare dullhue=rgb<rpig-0.2, gpig-0.2, bpig-0.2>;
      #declare highhue1=rgb<rpig+0.2, gpig+0.2, bpig+0.2>;
      #declare highhue2=rgb<rpig+0.4, gpig+0.4, bpig+0.4>;
              
      texture
      {      
         pigment
         {
            crackle
            color_map
            {
               [ 0.00 dullhue   ] 
               [ 0.20 maincolour]
               [ 0.60 maincolour]
               [ 0.80 highhue1  ]
               [ 1.00 highhue2  ]
            }
         }      
         normal
         {
            crackle , 0.75
         }      
         finish
         {
            ambient 0.3
            diffuse 0.7
            specular 0.9
            roughness 0.025
            metallic 1.0
            reflection 0.25
            irid
            {
               0.2
               thickness 0.5
               turbulence <2.0, 2.0, 2.0>               
            }
         }      

         //rotate x*rand(db1)*360
         //rotate y*rand(db1)*360
         rotate z*rand(db1)*360
         
         translate x*rand(db1)*25
         translate y*rand(db1)*25
         //translate z*rand(db1)*25

      }
      
      scale <1.0, 1.0, 0.1>
      translate x*x_axis*2
      translate y*y_axis*-2

    }    

    #declare x_axis = x_axis+1;
    
  #end             
                          
  #declare y_axis = y_axis+1;  
  #declare x_axis=0;    
  
#end

