/*
 *	"Fiat Lux"
 *
 *	Entry for the IRTC round "Contrast"
 *	Copyright 2000 Mark Wagner
 *	Rendered using MegaPOV 0.5a
 */
 
/* Render time on a 400Mhz AMD K6-II : 35 minutes at 800x600, AA 0.3 */
 
#version unofficial MegaPOV 0.5;

#include "colors.inc"
#include "textures.inc"

#declare cm = 1;			/* 1 POV unit = 1 inch */
#include "units.inc"		/* www.geocities.com/Rengaw03/Pov-Ray.html */
#include "spectrum.inc"		/* From SkyPOV */

#declare phd = .25;
global_settings{
	assumed_gamma 1.0 
	max_trace_level 20

	photons{
		spacing 0.04*phd*cm
		gather 10, 20
		expand_thresholds .2,10
		autostop 0
//		radius .1*cm
		load_file "prism.pht"
	}
}

light_source{
	<1000,100,0>*cm
	rgb <1,1,1>
	create_spectrum(100, 1)
}

/* Ground */
plane{y, 0
	pigment{rgb 1}
	finish{
		ambient 0
		diffuse 1
	}
}

/* Slit for blocking light */
union{
	box{<20,-5, 0.8>*cm,<21,15+5, 100>*cm}
	box{<20,-5,-0.3>*cm,<21,15+5,-250>*cm}
	box{<20,9.5,1>*cm,  <21,15+5,-1>*cm}
	pigment{rgb 1}
	finish{ambient 0 diffuse 1}
}

/* Prism */
intersection{
	box{<-1,0,-2>*cm, <2,8,2>*cm }
	box{<-1,0,-2>*cm, <2,8,2>*cm rotate y*120}
	box{<-1,0,-2>*cm, <2,8,2>*cm rotate y*240}
	photons {
		target
		refraction on
		reflection on
		ignore_photons
	}
	pigment{rgbt <1,1,1,1>}
	interior{
		ior 1.33
		dispersion 1.2
		disp_nelems 255
	}
//	rotate y*(.80)*120
	translate z*.85*cm
}



#declare Top = camera{
	location y*1000*cm
	look_at 0
	angle 10
}

#declare Scene = camera{
	location <-30,15+5,30>*cm
	look_at <0,5,0>*cm
}

camera{Scene}

