//Standard include files
#include "colors.inc"
#include "textures.inc"
#include "stoneold.inc"
#include "stones.inc"
#include "woods.inc"
#include "metals.inc"
#include "golds.inc"
#include "glass.inc"

global_settings { max_trace_level 40 }
//--------------------------------------------------------------------------------------------------------------------
camera
{
  location  <0.0,1,-2.8> // position of camera <X Y Z>
  up<0,1,0>
  right<1,0,0>
  look_at <0,1,10>
}
//--------------------------------------------------------------------------------------------------------------------
#declare Y = -0.2;
#while (Y<2.2)
 light_source
 {
   0*x // light's position (translated below)
   color rgb 0.7  // light's color
   translate <0, Y,0.7>
 }
 #declare Y = Y+0.2;
#end 

light_source
{
  0*x // light's position (translated below)
  color rgb 2// light's color
  translate <0, 0.7,1.7>
}
//--------------------------------------------------------------------------------------------------------------------
sky_sphere
{
  pigment{color White}
}
#declare Random = seed(7)

#macro Ice_Texture(Random)
 texture
 {
  pigment{color rgbf<0.5+rand(Random)/5,0.8+rand(Random)/5,1-rand(Random)/10,1>}
  finish
  {
   diffuse 0.9
   reflection 0.05
   brilliance 7
  }
 }
#end 


#macro Fire_Texture(Random,Transparenz)
 texture
 {
  pigment{color rgbf<1-rand(Random)/10,0.15+rand(Random)/10,rand(Random)/10,Transparenz>}
  normal
  {   
    quilted scale 1-rand(Random)/4 
  }
  finish
  {
   diffuse 0.9
   ambient 0.5
   reflection 0.2
   brilliance 2
  }
 }
#end

#macro Triangle_SplitF(point1,point2,point3,Nesting,Transparenz)
  #if(Nesting<15)
   #if(vlength(point1-point2)>vlength(point2-point3))
    #if(vlength(point1-point2)>vlength(point1-point3))
     #local point4 = point1 + (0.4+rand(Random)*0.2)*(point2-point1);
     Triangle_SplitF(point1,point3,point4,Nesting+1,Transparenz)
     Triangle_SplitF(point2,point3,point4,Nesting+1,Transparenz)
    #else
     #local point4 = point1 + (0.4+rand(Random)*0.2)*(point3-point1);
     Triangle_SplitF(point1,point2,point4,Nesting+1,Transparenz)
     Triangle_SplitF(point2,point3,point4,Nesting+1,Transparenz)
    #end
   #else
    #if(vlength(point2-point3)>vlength(point1-point3))
     #local point4 = point2 + (0.4+rand(Random)*0.2)*(point3-point2);
     Triangle_SplitF(point1,point3,point4,Nesting+1,Transparenz)
     Triangle_SplitF(point2,point1,point4,Nesting+1,Transparenz)
    #else
     #local point4 = point1 + (0.4+rand(Random)*0.2)*(point3-point1);
     Triangle_SplitF(point1,point2,point4,Nesting+1,Transparenz)
     Triangle_SplitF(point2,point3,point4,Nesting+1,Transparenz)
    #end
   #end  
 #else
  triangle{point1,point2,point3 Fire_Texture(Random,Transparenz)}
 #end
#end

Triangle_SplitF(<-10,-10,5>,<10,-10,5>,<10,10,5>,0,0)
Triangle_SplitF(<-10,-10,5>,<-10,10,5>,<10,10,5>,0,0)


#macro Tetraeder(point1,point2,point3,point4,Texture)
mesh
{
 triangle{point1,point2,point3 texture{Texture}}
 triangle{point1,point2,point4 texture{Texture}}
 triangle{point1,point4,point3 texture{Texture}}
 triangle{point4,point2,point3 texture{Texture}}
} 
#end


#macro Tetraeder_Split(point1,point2,point3,point4,Nesting)
  #if(Nesting<12)
   #local vl12 = vlength(point1-point2);
   #local vl13 = vlength(point1-point3);
   #local vl14 = vlength(point1-point4);
   #local vl23 = vlength(point2-point3);
   #local vl24 = vlength(point2-point4);
   #local vl34 = vlength(point3-point4);
   #if(vl12>=vl13 & vl12>=vl14 & vl12>=vl23 & vl12 >= vl24 & vl12 >= vl34)
    #local point1a = point1;
    #local point2a = point2;
    #local point3a = point3;
    #local point4a = point4;
   #else
    #if(vl13>=vl14 & vl13>=vl23 & vl13 >= vl24 & vl13 >= vl34)
     #local point1a = point1;
     #local point2a = point3;
     #local point3a = point2;
     #local point4a = point4;
    #else
     #if(vl14>=vl23 & vl14 >= vl24 & vl14 >= vl34)
      #local point1a = point1;
      #local point2a = point4;
      #local point3a = point2;
      #local point4a = point3;
     #else
      #if(vl23 >= vl24 & vl23 >= vl34)
       #local point1a = point2;
       #local point2a = point3;
       #local point3a = point1;
       #local point4a = point4;
      #else 
       #if(vl24 >= vl34)
        #local point1a = point2;
        #local point2a = point4;
        #local point3a = point1;
        #local point4a = point3;
       #else
        #local point1a = point3;
        #local point2a = point4;
        #local point3a = point1;
        #local point4a = point2;
       #end
      #end
     #end
    #end
   #end     

   #local point5a = point1a + (0.4+0.2*rand(Random))*(point2a-point1a);
   Tetraeder_Split(point1a,point4a,point3a,point5a,Nesting+1)
   Tetraeder_Split(point2a,point4a,point3a,point5a,Nesting+1)
 #else
  Tetraeder(point1,point2,point3,point4,Ice_Texture(rand(Random)))
 #end 

#end

/*#macro Pyramide(point1,point2,point3,point4,point5)
 Tetraeder_Split(point1,point2,point3,point5,0) 
 Tetraeder_Split(point3,point4,point1,point5,0) 
#end*/  

//Pyramide(<-0.8,0,-0.8>,<-0.8,0,0.8>,<0.8,0,0.8>,<0.8,0,-0.8>,<0,2.4,0>)
Tetraeder_Split(<-0.8,0,-0.8>,<0.8,0,-0.8>,<0,2.4,0>,<0,0,-0.7>,0)
Tetraeder_Split(<-0.8,0,0.8>,<0.8,0,0.8>,<0,2.4,0>,<0,0,0.7>,0)
Tetraeder_Split(<-0.8,0,-0.8>,<-0.8,0,0.8>,<0,2.4,0>,<-0.7,0,0>,0)
Tetraeder_Split(<0.8,0,-0.8>,<0.8,0,0.8>,<0,2.4,0>,<0.7,0,0>,0)

triangle{<-1.45,-0.8,0.8>,<1.45,-0.8,0.8>,<0,2.8,0.8> pigment{color White}}
