// Fichier:     Tiananmen.pov
// Par:         Franois Labrque
// Cration:    3 Nov 2000
// Modif:       28 Dec 2000

// A mois d'indications contraires, 1 unit = 1 pied.

// ----------------------------
// -------- Dfinitions -------
// ----------------------------
#version unofficial megapov 0.6;
#declare Use_Rad = 1;
//#declare Textures_Rapides = 1;

// ----------------------------
// ---- paramtres globaux ----
// ----------------------------
global_settings {
    assumed_gamma 1.0
    max_trace_level 50
    #if (Use_Rad)
        ini_option "+QR"
        radiosity{
            count 100
            nearest_count 5
            error_bound .5
            recursion_limit 1
            brightness 1.0
            pretrace_start  .1
            pretrace_end  .02
            low_error_factor .5
            gray_threshold 0.0
            minimum_reuse 0.015
            normal on
            max_sample 1
        }
        post_process {
            focal_blur { 200, 50, 15, 0 }
        }
    #end
}


// ----------------------------
// -------- Librairies --------
// ----------------------------

#include "tiananmen.inc"

// --------------------------
// ---------- Scene ---------
// --------------------------

sphere { < 0, 0, 0 > 2000 texture { pigment { color BleuCiel } finish { F_Mat } } }

camera { 
    location < 125, 55, -375 >
    look_at < 0, 0, 50 >
    angle 5
}
    
light_source { < -300, 1000, 10 > color Blanc }

plane { y, 0 texture { T_Route } }
object { Homme rotate y*10 }
object { Lampadaire translate < 50, 4, -120 > }
object { Tank( 0, 90, 0, 15, < 1, 1, 1 > ) translate < 0, 0, 20 > }
object { Tank( 0, 0, 0, 10, < -2, -2, -2 > ) translate < 0, 0, 50 > }
object { Tank( 0, 0, 0, 15, < 0, 0, 0 > ) rotate < 0, -10, 0 > translate < -2, 0, 80 > }
object { Tank( 0, 0, 0, 10, < 5, -5, 0 > ) translate < -5 , 0, 120 > }
box {  //Imitation d'ombrage de branche
    < -100, 40, 0 >
    < -60, 41, 300 > 
    texture { T_Poussiere scale < 10, 1, 5 > }
    texture { T_Poussiere scale 0.1 }
}