#version unofficial MegaPov 0.5;

#macro PerceGrille (LX,LZ,PX,PZ,Ep)
 #local TempObj=
 union {
  difference {
   box {<0,0,-LZ/2>,<LX/2,Ep,LZ/2>}
   box {<-1,-1,-PZ/2>,<PX/2,Ep*2,PZ/2>}
   cylinder {<PX/2,-1,0>,<PX/2,Ep*2,0>,PZ/2}
  }                                 
  cylinder {<0,Ep/2,-PZ/2>,<PX/2,Ep/2,-PZ/2>,Ep/2}
  cylinder {<0,Ep/2,PZ/2>,<PX/2,Ep/2,PZ/2>,Ep/2}
  torus {PZ/2 Ep/2 clipped_by {plane {x,0 inverse}} translate <PX/2,Ep/2,0>}
 }
 union {
  object {TempObj}
  object {TempObj scale <-1,1,1>}
 }
#end

#declare MorceauGrille = object {PerceGrille (4,1,3,.3,.05)}

#declare BoutonPower = union {
cylinder {<0,0,0>,<0,.3,0>,.8}
torus {.7 .1 scale <1,.3,1> translate y*.3}
cylinder {<0,0,0>,<0,.6,0>,.6}
sphere {0,.6 scale <1,.3,1> translate y*.6}
text {ttf "arial","POWER",.1,0 align_center 
      scale .5 rotate <90,-90,0> translate <1.5,.02,0> pigment {Black}}
pigment {Gray20}
finish {phong .9}
}

#macro Bouton (Texte)
 union {
cylinder {<0,0,0>,<0,.3,0>,.8}
torus {.7 .1 scale <1,.3,1> translate y*.3}
cylinder {<0,0,0>,<0,.6,0>,.6}
sphere {0,.6 scale <1,.3,1> translate y*.6}
text {ttf "arial",Texte,.1,0 align_center 
      scale .5 rotate <90,-90,0> translate <1.5,.02,0> pigment {Black}}
pigment {Gray30}
finish {phong .9}
}
#end

#declare AmpliComplet=
union {
  box {<30,1.5,-20>,<30.3,10,20>}
  box {<0,.3,-20>,<-.3,0,20> rotate z*45 translate <30.3,10,0>}
  box {<0,.3,-20>,<-.3,0,20> rotate z*45 translate <30.3,1.5,0>}
  object {RoundedBox (<30,1.8,-19.8>,<0,9.8,-17>,.1)}
  object {RoundedBox (<30,1.8,17>,<0,9.8,19.8>,.1)}
  object {RoundedBox (<30,1.8,17>,<28,9.8,-17>,.1)}
  object {RoundedBox (<0,1.8,17>,<8,9.8,-17>,.1)}
   #declare I=0;
    #while (I < 34)
       object {MorceauGrille translate <26,9.75,-16.5+I>}
       object {MorceauGrille translate <22,9.75,-16.5+I>}
       object {MorceauGrille translate <18,9.75,-16.5+I>}       
       object {MorceauGrille translate <14,9.75,-16.5+I>}       
       object {MorceauGrille translate <10,9.75,-16.5+I>}       
    #declare I=I+1;
    #end
  object {BoutonPower rotate z*-90 translate <30.3,5,-17>}
 object {Bouton ("PHONO") scale .8 rotate z*-90 translate <30.3,5,-12>}    
 object {Bouton ("TUNER") scale .8 rotate z*-90 translate <30.3,5,-10>}    
 object {Bouton ("TAPE") scale .8 rotate z*-90 translate <30.3,5,-8>}
 object {Bouton ("AUX") scale .8 rotate z*-90 translate <30.3,5,-6>}        
 text {ttf "arial","DNA",.1,0 align_center rotate y*-90 translate <30.4,8,-17> pigment {White}}
 box {<30.3,9,-18>,<30.35,7,-16> translate y*-.1 pigment {Gray30}}
  pigment {Gray70}
  normal {bumps .02 scale .1}
  finish {phong .9}
    }
