#version unofficial MegaPov 0.5;

#declare Rose = color rgb <1.000,0.529,0.667>;
#declare FondLCD = rgb <0.882,0.886,0.792>;

#declare Boitier = 
blob {
 threshold .5
 sphere {<0,0,0>,10,1 scale <1,.3,1> translate y*1.2} 
 sphere {<0,0,0>,10,1 scale <1,.3,1> translate y*-1.5} 
 sphere {<0,0,0>,7,.5 scale <1,.5,1> translate <-3,-1,4>} 
 sphere {<20,0,20>,25,-1} 
 sturm
 scale <1,.5,1>
//pigment {checker color Rose color Rose*.9}
pigment {Rose}
finish {phong .9}
}

#declare PlayPause = difference {
intersection {
 plane {x,1}
 plane {x,1 rotate y*-120}
 plane {x,1 rotate y*120}
 plane {y,1}
 plane {y,0 inverse}
 rotate y*90
 }
 box {<.5,.5,-.2>,<-.5,2,-.5>}
 box {<.5,.5,.2>,<-.5,2,.5>}
 scale <.5,.2,.5>*.8
 rotate y*-90
 //pigment {Red}
}

#declare Track1=
union {
intersection {
 plane {x,1}
 plane {x,1 rotate y*-120}
 plane {x,1 rotate y*120}
 plane {y,1}
 plane {y,0 inverse}
 rotate y*90
 translate z*1
 }
 box {<1.6,0,-.8>,<-1.6,1,-1.5>}
 scale <.2,.1,.2>*.7
 rotate y*-90
}

#declare Track2=object {Track1 rotate y*180}
#declare Stop = box {<-1,0,-1>,<1,1,1> 
                     scale <.2,.1,.2>}

#macro BoutonRond (Rayon,Haut,Bombe,Anneau,Inscription)
union {
cylinder {<0,0,0>,<0,Haut,0>,Rayon}
sphere {0,Rayon scale <1,Bombe,1> translate y*Haut}
object {Inscription translate y*Haut}
torus {Rayon+Anneau Anneau}
pigment {Rose} finish {phong .7}
}
#end

#macro Reorient(Axis1,Axis2) 
  #local vX1=vnormalize(Axis1); 
  #local vX2=vnormalize(Axis2); 
  #local vY=vnormalize(vcross(vX1,vX2)); 
  #local vZ1=vnormalize(vcross(vX1,vY)); 
  #local vZ2=vnormalize(vcross(vX2,vY)); 
   #if (vX2.x = 0 & vY.y = 0 & vZ2.z = 0) 
   #debug "zut, la normale est  <0,0,0> \n" 
   #else 
  matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0> 
  matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0> 
  #end 
#end 

#declare StockNorm = <0,0,0>;                  

#declare BarbieMP3 = union {

#declare Pt1 = trace (Boitier,<-1,4,4.5>,y*-1,StockNorm);
object {BoutonRond (1,.15,.1,.05,PlayPause) Reorient (y,StockNorm) translate Pt1}
#declare Pt1 = trace (Boitier,<1,4,4>,y*-1,StockNorm);
object {BoutonRond (.5,.1,.1,.05,Track1) Reorient (y,StockNorm) translate Pt1}
#declare Pt1 = trace (Boitier,<2.3,4,3.3>,y*-1,StockNorm);
object {BoutonRond (.5,.1,.1,.05,Track2) Reorient (y,StockNorm) translate Pt1}
#declare Pt1 = trace (Boitier,<-3,4,4.5>,y*-1,StockNorm);
object {BoutonRond (.5,.1,.1,.05,Stop) Reorient (y,StockNorm) translate Pt1}


difference {
object {Boitier}
cone {<0,-.1,0>,4,<0,1,0>,5 scale <1,1,.2> rotate y*10 translate <0,.9,2>
      pigment {Rose} finish {phong .9}
}
}
              

object {Boitier
     pigment {image_map {png "barbie-mp3-logo" transmit 14,1 once} 
              translate <-.5,-.5,0> rotate <90,180,0> 
              scale <10,0,8>*.7 rotate y*30 translate <-2.2,0,-2>}
     clipped_by {cylinder {<-2,.5,-2>,<-2,5,-2>,2.7}}      
     translate y*.01   
}

box {<4,0,-.8>,<-4,.01,.8> 
     pigment {image_map {png "b-mp3-disp" filter all 1} 
              translate <-.5,-.5,0> rotate <90,180,0> scale <12,0,2.89>*.75}
     rotate y*10 translate <0,.9,2>}
                                              
box {<4,0,-.8>,<-4,.01,.8> rotate y*10 translate <0,.9-.02,2> pigment {FondLCD}}
}