
// POV-Ray Object File - The Glassblower
// created 26-Nov-00
// last update 31-Dec-00
// 1999 Glenn McCarter
// This file does not render.  #include "Craftsmen.inc" in another .pov file
// Required #include files: "HandTools.inc" must be called before this file
//
// Objects:
// UprightGlassblower
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)

//#include "testpose.inc"
#include "apprentice.inc"
#include "uprightglassblower.inc"

//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare ApronTex =
	texture {
		pigment {
			color rgb <0.649,0.622,0.306>
		}
		normal { bumps 0.3 scale 6}
		finish { ambient 0.1 specular 0.1 roughness 0.18 }
	}



//===============================================
//             Objects
//===============================================


object { UprightGlassblower
	scale 5.0*Feet+10 // final overall height
	scale 1.40 // Poser adjustment factor?
	rotate x*90 // set Z=up
	// figure faces -Y
	rotate z*-90
	translate <24*Feet,28*Feet,8>
	}

#include "Apron.inc"
object { ApronShape
	scale 2.8
	rotate z*180
	rotate y*-7
	rotate x*5
	translate <5,2.5,21.6>
	texture { ApronTex }
	rotate z*-90
	translate <24*Feet,28*Feet,8>
}

object { HotBlowPipeSmall
	rotate z*-90 // point to -Y
	rotate x*-8 // raise tip
	rotate z*-5 // touch right hand
	translate <0,0,5*Feet+4> // raise to lips
	rotate z*-90 // match pose
	translate <24*Feet,28*Feet,8> // match pose
	}

object { Apprentice
	scale 5.0*Feet+10 // final overall height
	scale 1.40 // Poser adjustment factor?
	rotate x*90 // set Z=up
	// figure faces -Y
	rotate z*90
	translate <13*Feet+7+6,23*Feet+2,8>
	}

object { Jacks
	rotate <90,90,0>
	rotate <-15,0,0> // match wrist
	translate <-17,-1,39>
	rotate z*90 // match pose
	translate <13*Feet+7+6,23*Feet+2,4.5> // match pose
	}
object { HotBlowPipeLarge
	rotate z*-180 // point to -X
	translate <30,-4,25+0.38> // raise to benchtop
	rotate z*90 // match pose
	translate <13*Feet+7+6,23*Feet+2,8> // match pose
	}


/*
cylinder { // test guy
	<0,0,0>,<0,0,5.0*Feet+10>,6
	texture { pigment { color rgb<1,1,1> } }
	translate <12*Feet,21*Feet,8>
}
*/
