// Persistence of Vision Ray Tracer Scene Description File
// File: hunters.pov
// Vers: 3.1g
// Desc: Contrast entry
// Date: 12/29/00
// Auth: Alan Shaklee




#include "colors.inc"
#include "textures.inc"
#include "sub1.inc"
#include "whale.inc"
global_settings { assumed_gamma 2.5 }
//global_settings { hf_gray_16 on }
background { NavyBlue }
#declare DarkWater=
texture { 
    NBglass
    pigment { rgbf <0.1, 0.7, 0.8, 0.8> } 
    normal {
        ripples 0.75
        frequency 10
    }
}


camera {
	location <14, -2, 7>
	look_at <0,0,0>
}
light_source
{
  0*y // light's position (translated below)
  color rgb 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <-16, 0, 16> <16, 0, 16> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <0, 40, 0>   // <x y z> position of light
}                      


plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  3.0 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?
  texture { DarkWater scale 2 translate <50,0,100>}                                      
}  
     
plane
{
  y, // <X Y Z> unit surface normal, vector points "away from surface"
  -3.0 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?
  pigment{
    granite
    color_map{
      [0.0 White]
      [1.0 Yellow]
      }
    turbulence .4
    }
}  
     
//FIXME
// set global atmospheric fog effect in the scene.
// at the fog distance, there will be 63% visibility
fog {
  fog_type 1 // 1=constant, 2=ground_fog
  distance 15
  color NavyBlue
  turbulence .2
  turb_depth .3
// omega OMEGA
// lambda LAMBDA
  octaves .5
  fog_offset .3
  fog_alt .2
}
 
object { Sub translate <0,0,0> }

//object { Whale scale .5  scale <1,1,1> translate <0,0,6>}
object { Whale scale .5  scale <1,1,-1> rotate <0,20,0> translate <-1.5,3,3>}
object { Whale scale .5  scale <1,1,-1> rotate <0,20,0> translate <2,2.5,-6>}
object { Whale scale .5  scale <1,1,-1> rotate <0,30,0> translate <5,-1.5,-3>}
                                                                     