#version unofficial MegaPov 0.6;

#ifndef (DOOR_INC)
  #declare DOOR_INC = 0 ;
  
  #ifndef (HighQuality)
    #declare HighQuality = on ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"
  #include "isosurf.inc"

  #declare Door = union {
    box {
      <0.5, 1.5, -1.5>*cm, <74.5, 198.5, 1.5>*cm
      pigment {
        PDarkWood
        scale <0.3, 0.3, 0.7>/4
        scale 10*cm
        translate 7.5*cm*(x+y)
        warp { repeat 15*cm*y offset 1*m*z }
        warp { repeat 15*cm*x offset -5*m*z }
      }
      finish {
        brilliance 1.2
        specular 0.01
        roughness 0.2
      }
    }
    box { <0, 1, -2.5>*cm, <11.25, 199, 2.5>*cm texture { DarkWood() rotate 90*z translate 5.62*cm*x } }
    box { <63.75, 1, -2.5>*cm, <75, 199, 2.5>*cm texture { DarkWood() rotate 90*z translate 69.37*cm*x } }
    box { <11.26, 1, -2.5>*cm, <63.74, 12.25, 2.5>*cm texture { DarkWood() translate 6.62*cm*y } }
    box { <11.26, 187.75, -2.5>*cm, <63.74, 199, 2.5>*cm texture { DarkWood() translate 193.38*cm*y } }
    #local i = 22.25*cm ;
    #while (i < 187.75*cm)
      box {
        <11.26, 0, -2.5>*cm, <63.74, 8.39, 2.5>*cm
        texture { DarkWood() translate 8.39/2*cm*y }
        translate i*y
      }
      #local i = i + 18.39*cm ;
    #end
    #local i = 12.25*cm ;
    #while (i < 187.75*cm)
      box {
        <-5.62, 0.01, -2.5>*cm, <5.62, 9.99, 2.5>*cm
        texture { DarkWood() rotate 90*z }
        translate (i + 18.39*cm)*y+37.5*cm*x
      }
      box {
        <-5.62, 0.01, -2.5>*cm, <5.62, 9.99, 2.5>*cm
        texture { DarkWood() rotate 90*z }
        translate i*y-10.62*cm*x+37.5*cm*x
      }
      box {
        <-5.62, 0.01, -2.5>*cm, <5.62, 9.99, 2.5>*cm
        texture { DarkWood() rotate 90*z }
        translate i*y+10.62*cm*x+37.5*cm*x
      }
      #local i = i + 2*18.39*cm ;
    #end
    
    difference {                // latch
      box { <-18, -18, -9>*mm, <18, 18, 9>*mm }
      plane { -x, 0 rotate -30*y translate 22*mm*z }
      translate <74.5, 107, 0>*cm
      texture { DarkMetal }
    }
    union {
      cylinder { <0, 0, -7.5>*cm, <0, 0, 7.5>*cm, 1*cm }
      sphere { 0, 4*cm scale <0.625, 1, 0.5>*cm translate -7.5*cm*z texture { TGold } }
      sphere { 0, 4*cm scale <0.625, 1, 0.5>*cm translate 7.5*cm*z texture { TGold } }
      texture { DarkWood() rotate 90*y }
      translate <70.5, 104, 0>*cm
    }
    
    pigment { color rgb <0.50, 0.34, 0.15> }
  }
    
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 110*cm*y-2.3*m*z
      look_at  100*cm*y
      angle 40
      //angle 5
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 1.5
    }
    
    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1
      }
      rotate 30*y
    }
    
    object {
      Door
      translate -30*cm*x
      //rotate 90*x translate 1*m*y-100*cm*x
      rotate 30*y
    }
  #end
  
  #include "leave"
#end
