#version unofficial MegaPov 0.6;

#ifndef (EASEL_INC)
  #declare EASEL_INC = 0;

  #ifndef (HighQuality)
    #declare HighQuality = no ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"
  #include "isosurf.inc"
  #include "paintbrush.inc"

  #macro Easel (Painting)
    union {
      union {
        box {
          <-2, 0, -1.5>*cm, <2, 202, 1.5>*cm
          texture {
            OrangeWood()
            rotate 90*x
          }
          rotate -12*z
          translate -46*cm*x
        }
        box {
          <-2, 0, -1.5>*cm, <2, 202, 1.5>*cm
          texture {
            OrangeWood()
            rotate 90*x
          }
          rotate 12*z
          translate 46*cm*x
        }
        box {
          <-35, 79, -2>*cm, <35, 82, -10>*cm
          texture {
            OrangeWood()
            rotate 90*y
            translate 80*cm*y
          }
        }
        /*box {
          <-30, 82, -2>*cm, <30, 165, -4>*cm
          pigment { color rgb 1 }
        }*/
        object { Painting translate 82*cm*y-2*cm*z }
      }
      box {
        <-1.5, -200, -2>*cm, <1.5, 3, 2>*cm
        texture {
          OrangeWood()
          rotate 90*x
        }
        rotate -40*x
        translate 194*cm*y
      }
      cylinder {
        -5*cm*x, 5*cm*x, 1*cm
        texture {
          OrangeWood()
          rotate 90*y
        }
        translate 194*cm*y
      }
      rotate 20*x
      translate -2*m*sin(20*pi/180)*z
      pigment { color rgb <0.2, 0.15, 0.0> }
    }
  #end
	
  #declare MonaLisa = object {
    RoundedBox(58, 90, 2, 0.5)
    scale 1*cm
    texture { pigment { color rgb 1 } }
    texture {
      pigment {
        image_map {
          png "monalisa.png"
          once
          interpolate 2
        }
      }
      finish { diffuse 1.2 }
      translate -0.5*x-0.5*y
      scale <58, 90, 1>*cm
    }
    translate 45*cm*y-1*cm*z
  }

  #declare Picture = union {
    difference {
      object {
        RoundedBox(60, 97, 2, 0.75)
        scale 1*cm
      }
      box { <-56.01, -56.01*3/4, -1>*cm/2, <56.01, 56.01*3/4, 2>*cm/2 translate -1*cm*z }
      texture {
        pigment { color rgb 1 }
        normal { quilted 0.2 scale 1*cm turbulence 0.1 }
      }
      texture {
        pigment {
          image_map {
            png "display.png"
            once
            interpolate 2
          }
        }
        finish { diffuse 1.1 }
        translate -0.5*x-0.5*y
        scale <56, 56*3/4, 1>*cm
      }
      texture {
        pigment {
          image_map {
            png "sig.png"
            once
            interpolate 2
          }
        }
        translate -x
        scale <449/139*7, 7, 1>*cm
        translate <28, -97/2+2, 0>*cm
      }
    }
    box {
      -1, 1
      pigment { rgbf 1 }
      hollow
      no_reflection
      interior {
        media {
          emission <0.0, 0.0, 0.3>
          emission_type 2
          emission_extinction 0.3
          density { 
            boxed
            color_map {
              [ 0.0 rgb 0 ]
              [ 0.1 rgb 1 ]
              [ 1.0 rgb 0 ]
            }
          }
          method 3
          samples 5, 5
        }
      }
      scale <62, 62*3/4, 2>/2*cm
      translate -1*cm*z
    }
    object {
      PaintBrush
      rotate 15*y
      translate -1.3*cm*z+8*cm*x-97/2*cm*y
    }
    translate 48.5*y*cm-1*cm*z
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    camera {
	  up y
	  right (image_width/image_height)*x
      location 110*cm*y-2*m*z
      look_at  100*cm*y
      angle 60
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 2
    }

    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1
      }
      rotate 30*y
    }

    object {
      Easel(Picture)
      rotate 45*y
    }
  #end
  
  #include "leave"
#end