#version unofficial MegaPov 0.6;

#ifndef (GLASS_INC)
  #declare GLASS_INC = 0 ;
  
  #ifndef (HighQuality)
    #declare HighQuality = on ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"
  #include "paintbrush.inc"
  #include "paintbrush2.inc"

  #declare Glass = union {
    merge {
      difference {
        cylinder { 2*mm*y, 9*cm*y, 4*cm }
        cylinder { 7*mm*y, 10*cm*y, 3.6*cm }
      }
      torus { 3.8*cm, 2*mm translate 9*cm*y }
      torus { 3.8*cm, 2*mm translate 2*mm*y }
    
      #if (HighQuality)
        isoblob {
          threshold 0.5
          
          #local Torus = function { max ((1 - sqrt (sqr (sqrt (sqr(x)+sqr(y)+sqr(z)) - 3) + sqr (z))), 0) }
          function { if (x+0.5, Torus (x, y, z), 0) }
          
          #local Bump = function { 1 + 3*exp (-sqr (x-4)*20) }
          function { max (0.9-sqrt (sqr(x)+sqr(y)+sqr(z))+0.5, 0) * Bump (sqrt(sqr(x+4)+sqr(z)), 0, 0) }
      
          sphere { 0, 4.5, strength 1 function 1 }
          sphere { -3*y, 3, strength 1 function 2 }
          sphere { 3*y, 3, strength 1 function 2 }

          bounded_by { box { <-1, -6, -1>, <4, 6, 1> } }
          
          scale 1*cm
          translate 4.5*cm*y+4.1*cm*x
        }
      #else
        difference {
          torus { 3*cm, 5*mm rotate 90*x translate 4.5*cm*y+4.1*cm*x }
          plane { x, 3.91*cm }
        }
      #end
    
      material { MBlueGlass }
      photons { target refraction on ignore_photons }
    }
    object {
      PaintBrush
      translate -3*mm*y
      rotate 50.5*z
      translate 1*cm*y-3.3*cm*x
      rotate 30*y
    }
    object {
      PaintBrush2
      translate -3*mm*y
      rotate 5*x
      rotate 53*z
      translate 1*cm*y-3*cm*x
      translate -3.6*cm*x rotate -17*y translate 3.6*cm*x
      rotate -120*y
    }
    object {
      PaintBrush
      translate -3*mm*y
      rotate 54.5*z
      translate 1*cm*y-2.4*cm*x
      translate -3.6*cm*x rotate 4.7*y translate 3.6*cm*x
      rotate 135*y
    }
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
      max_trace_level 10
      #if (HighQuality)
        photons {
          spacing 1*mm
          autostop 0
        }
      #end
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 20*cm*y-50*cm*z
      look_at  10*cm*y
      angle 40
      //angle 20
    }
    light_source {
      110*cm*y-3*m*z
      color rgb 0.25
      shadowless
    }
    
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 1.5
    }
    
    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1
      }
      rotate 30*y
    }
    
    object {
      Glass
      rotate -30*y
      //rotate 90*x
      //translate 10*cm*y
    }
  #end
  
  #include "leave"
#end
