#version unofficial MegaPov 0.6;

#include "enter"
#include "metrics.inc"

#declare SkyView = no ;
#declare HighQuality = on ;
#declare Bright = no ;

#include "text.inc"

#include "computer.inc"
#include "cupboard.inc"
#include "door.inc"
#include "easel.inc"
#include "lantern.inc"
#include "stable.inc"
#include "table.inc"

global_settings {
  assumed_gamma 1.0
  #if (!SkyView)
    ini_option "+QR"
    radiosity {
      #if (HighQuality)
        pretrace_start 0.08
        pretrace_end 0.01
        count 100
        nearest_count 20
        error_bound 1
        always_sample no
        //normal on
      #end
      media on
      recursion_limit 3
      adc_bailout 0.01/5
    }
  #end
  #if (HighQuality)
    max_trace_level 6
    photons {
      spacing 1*mm
      autostop 0
    }
  #end
}

#if (!SkyView)
  camera {
    up 4/3*y
    right x
    location -1.2*m*x-2.9*m*z+120*cm*y
    look_at 100*cm*y
    angle 60
  }
#else
  camera {
    location 10*m*y-1*m*z//-1*m*x
    look_at -1*m*z//-1*m*x
    up 4/3*z
    right x
    angle 40
  }
  light_source {
    10*m*y-1*m*z//-1*m*x
    rgb 1
  }
  sphere {
    -1.2*m*x-2.9*m*z+120*cm*y, 10*cm
    pigment { color rgb <0, 1, 0> }
  }
#end

#if (Bright)
  light_source {
    -1.2*m*x-2.9*m*z+120*cm*y
    rgb 0.25
    shadowless
  }
#end

/*light_source {
  1*m*y-100*cm*x
  rgb 1
  }
light_source {
  -1*m*x-2*m*z+90*cm*y
  rgb 0.1
  shadowless
  }*/

difference {                     // Walls
  #if (SkyView)
    union { 
      plane { y, 0 }
      plane { -z, -2*m }
      plane { -x, -2*m }
      plane { x, -2*m }
      plane { z, -3*m }
    }
  #else
    box {
      <-2, -0.01, -3>*m, <2, 2.5, 2>*m
      inverse
    }
  #end
  box {
    <0.75, 0, 1.99>*m, <1.5, 2, 2.1>*m
    pigment { color rgb <1.0, 1.0, 0.5> }
    finish { diffuse 0 ambient 5 }
  }
  texture {
    pigment { color rgb 1 }
    normal { agate 0.1 scale 1*cm }
  }
  Dirty (2*cm, 5)
}
object {                        // Door
//  <0, 1, -2.5>*cm, <75, 199, 2.5>*cm
//  pigment { color rgb <0.50, 0.34, 0.15> }
  Door
  rotate 30*y
  translate <0.75, 0, 2>*m
}
#declare i = -2.975*m;         // floor
#while (i < 2.1*m)
  #declare j = -2*m -50*cm*mod ((i+2.975*m)/(5*cm), 2) ;
  #while (j < 2.1*m)
    object {
      #if (HighQuality * (i < -1.5*m) * (j < 0))
        #local Tr = <rand (Seed), rand (Seed), rand (Seed)>;
        #local Rot = <rand (Seed)-0.5, rand (Seed)-0.5, rand (Seed)*360>;
        DarkWoodBlock (4.9*2, 2*2, 99.8*2, 0.2*2, Tr, Rot)
        texture {
          pigment { PDarkWood rotate Rot translate Tr }
          finish { FDarkWood }
        }
        rotate 90*y
        scale 1/2*cm
      #else
        RoundedBox (0.998*m, 2*cm, 4.9*cm, 2*mm)
        texture { DarkWood() }
      #end
      translate j*x-1*cm*y+i*z
      //Dirty (2*cm, 2)
    }
    #declare j = j + 1*m ;
  #end
  #declare i = i + 5*cm ;
#end
#if (!SkyView)                // ceiling beams
  #declare Seed = seed(1234);
  #declare i = 0;
  #while (i < 26)
    box {
      <-3, 2.4, -0.05>*m, <3, 2.6, 0.05>*m
      //pigment { color rgb <0.25, 0.17, 0.08> }
      texture { DarkWood() }
      translate (-3+i*0.2)*m*z
    }
    #declare i = i + 1 ;
  #end
#end

object {                        // Small Table
  /*box {
  <-35, 0, -30>*cm, <35, 70, 30>*cm
  }*/
  SmallTable
  pigment { color rgb <0.50, 0.34, 0.15> }
  rotate -10*y
  translate -1.53*m*x-1*m*z
}
light_source {
  (<80, 120, -60>*cm+<15, 70, -5>*cm)/2
  rgb <1.0, 1.0, 0.8>
  spotlight
  point_at <15, 70, -5>*cm
  tightness 1
  radius 30
  falloff 60
  fade_distance 40*cm
  fade_power 4
  #if (HighQuality)
    area_light x*5*cm, y*5*cm, 5, 5
    adaptive 1
    circular
    orient
  #end
  rotate -10*y
  translate -1.60*m*x-1*m*z
}

object {                        // Computer
  Computer
  rotate -15*y
  translate -20*cm*x-1.6*m*z
}
light_source {
  <-15, 20, -30>*cm
  rgb <1.0, 0.8, 0.7>
  fade_distance 10*cm
  fade_power 2
  photons { reflection off refraction off }
  #if (HighQuality)
    area_light x*2*cm, y*2*cm, 5, 5
    adaptive 1
    circular
    orient
  #end
  rotate -15*y
  translate -20*cm*x-1.6*m*z
}

object {                     // Main Easel
  Easel(Picture)
  rotate 65*y
  translate 5*cm*x-1.7*m*z
}
light_source {
  <0, 1.0, -1.5>*m
  rgb <1.0, 1.0, 1.2>
  spotlight
  point_at 1.3*m*y
  tightness 0
  radius 8
  falloff 30
  fade_distance 120*cm
  fade_power 6
  photons { reflection off refraction off }
  #if (HighQuality)
    area_light x*15*cm, y*15*cm, 5, 5
    adaptive 1
    circular
    orient
  #end
  rotate 65*y
  translate 5*cm*x-1.7*m*z
}

object {                     // Back Easel
  Easel(MonaLisa)
  rotate -20*y
  translate 135*cm*z-150*cm*x
}

object {                        // Center table
  /*box {
    <-75, 0, -50>*cm, <75, 70, 50>*cm
  }*/
  Table
  pigment { color rgb <0.50, 0.34, 0.15> }
  rotate 30*y
  translate -15*cm*z+45*cm*x
}
light_source {
  <0.45, 0.8, -0.15>*m
  rgb <1.1, 1.05, 0.8>*2.6
  fade_distance 10*cm
  fade_power 2
  photons { reflection off refraction off }
  #if (HighQuality)
    area_light x*5*cm, y*5*cm, 5, 5
    adaptive 1
    circular
    orient
  #end
}
object {
  Lantern
  rotate 95*y
  translate 45*cm*x-15*cm*z+70*cm*y
}

object {
  Cupboard
  translate 2*m*z-20*cm*x
}

#include "leave"
