#version unofficial MegaPov 0.6;

#ifndef (TABLE_INC)
  #declare TABLE_INC = 0 ;
  
  #ifndef (HighQuality)
    #declare HighQuality = no ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"
  #include "isosurf.inc"
  #include "bottle.inc"
  #include "timbal.inc"

  #local Foot = union {
    box { <-7, 52, -7>*cm, <7, 67, 7>*cm }
    box { <-6, 2, -6>*cm, <6, 14, 6>*cm }
    cylinder { 0, 3*cm*y, 6.5*cm }
    mesh2 {
      vertex_vectors {
        24,
        <-7, 53, -7>, <-7, 53, 7>, <7, 53, 7>, <7, 53, -7>,
        <-8, 52, -8>, <-8, 52, 8>, <8, 52, 8>, <8, 52, -8>,
        <-7, 51, -7>, <-7, 51, 7>, <7, 51, 7>, <7, 51, -7>, // top notch
        <-6, 15, -6>, <-6, 15, 6>, <6, 15, 6>, <6, 15, -6>,
        <-7, 14, -7>, <-7, 14, 7>, <7, 14, 7>, <7, 14, -7>,
        <-6, 13, -6>, <-6, 13, 6>, <6, 13, 6>, <6, 13, -6>  // bottom notch
      }
      face_indices {
        40,
        <0, 1, 4>, <1, 4, 5>, <1, 2, 5>, <2, 5, 6>, <2, 3, 6>, <3, 6, 7>, <3, 0, 7>, <0, 7, 4>,
        <4, 5, 8>, <5, 8, 9>, <5, 6, 9>, <6, 9, 10>, <6, 7, 10>, <7, 10, 11>, <7, 4, 11>, <4, 11, 8>,
                                                            // top notch
        <8, 9, 12>, <9, 12, 13>, <9, 10, 13>, <10, 13, 14>, <10, 11, 14>, <11, 14, 15>, <11, 8, 15>, <8, 15, 12>,
                                                            // foot
        <12, 13, 16>, <13, 16, 17>, <13, 14, 17>, <14, 17, 18>, <14, 15, 18>, <15, 18, 19>, <15, 12, 19>, <12, 19, 16>,
        <16, 17, 20>, <17, 20, 21>, <17, 18, 21>, <18, 21, 22>, <18, 19, 22>, <19, 22, 23>, <19, 16, 23>, <16, 23, 20>
                                                            // bottom notch
      }
      scale 1*cm
    }
    mesh2 { // bottom notch
      vertex_vectors {
        12,
        <-6, 4, -6>, <-6, 4, 6>, <6, 4, 6>, <6, 4, -6>,
        <-7, 3, -7>, <-7, 3, 7>, <7, 3, 7>, <7, 3, -7>,
        <-6, 2, -6>, <-6, 2, 6>, <6, 2, 6>, <6, 2, -6>
      }
      face_indices {
        16,
        <0, 1, 4>, <1, 4, 5>, <1, 2, 5>, <2, 5, 6>, <2, 3, 6>, <3, 6, 7>, <3, 0, 7>, <0, 7, 4>,
        <4, 5, 8>, <5, 8, 9>, <5, 6, 9>, <6, 9, 10>, <6, 7, 10>, <7, 10, 11>, <7, 4, 11>, <4, 11, 8>
      }
      scale 1*cm
    }
    texture {
      DarkWood()
      rotate 90*z
    }
  }
  
  
  #declare Table = union {
    object { Foot translate <-58, 0, -33>*cm }
    object { Foot translate <58, 0, -33>*cm }
    object { Foot translate <-58, 0, 33>*cm }
    object { Foot translate <58, 0, 33>*cm }

    box {
      <-75, 66, -50>*cm, <75, 70, 50>*cm
      texture {
        DarkWood()
        warp { repeat 10*cm*z offset 1*m*x flip <0, 1, 1>}
      }
    }
    box {
      <-63, 54, -38>*cm, <63, 68, 38>*cm
      texture {
        DarkWood()
        translate 61*cm*y
        warp { repeat 10*cm*z offset 10*m*x }
      }
    }
    box {
      <-63, 4, -33>*cm, <-53, 12, 33>*cm
      texture {
        DarkWood()
        rotate 90*y
        translate 8*cm*y
      }
    }
    box {
      <63, 4, -33>*cm, <53, 12, 33>*cm
      texture {
        DarkWood()
        rotate 90*y
        translate 8*cm*y
      }
    }
    box {
      <-58, 4.01, -4>*cm, <58, 11.99, 4>*cm
      texture { DarkWood() translate 8*cm*y }
    }
    
    union {
      object { Bottle }
      object { Cork }
      translate <-32, 70, -10>*cm
    }
    object {
      Timbal
      rotate 90*y
      translate <-20, 70, -20>*cm
    }
    union {             // eating plate
      difference {
        union {
          difference {
            cylinder { 15*mm*y, 20*mm*y, 10*cm }
            cone { 17*mm*y, 7*cm, 20.1*mm*y, 10*cm }
          }
          cone { 0, 7*cm, 17*mm*y, 7.5*cm }
        }
        cone { 4*mm*y, 6.5*cm, 21*mm*y, 7.5*cm }
      }
      torus { 10*cm, 2.5*mm translate 17.5*mm*y }
      cylinder {
        3*mm*y, 6*mm*y, 7*cm
        texture {
          pigment { color rgbf <0.5, 0.55, 0.0, 0.8> }
          finish { specular 0.2 roughness 0.1 }
          normal { bumps 0.1 scale 1*cm }
        }
        interior {
          ior 2
          fade_distance 1*mm
          fade_power 100000
          fade_color rgb <0.5, 0.55, 0.0>
        }
      }
      union {
        cone { 0, 5*mm, 9*cm*x, 7*mm }
        sphere { 9*cm*x, 7*mm }
        scale <1, 0.5, 1>
        rotate 10*z
        translate 1.6*cm*y+4.5*cm*x
        rotate 20*y
        texture { DarkMetal }
      }
      texture {
        pigment { color rgb <1.0, 0.8, 0.6> }
        normal { bumps 0.2 scale 1*mm }
        finish { specular 0.1 roughness 1 }
      }
      translate <-25, 70, -35>*cm
    }
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
      #if (HighQuality)
        photons {
          spacing 1*mm
          autostop 0
        }
      #end
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 110*cm*y-2*m*z
      look_at  60*cm*y
      //angle 40
      angle 20
    }
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 1.5
    }
    
    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1
      }
      rotate 30*y
    }
    
    object {
      Table
      //Foot
      translate 50*cm*x
      rotate 30*y
    }
  #end
  
  #include "leave"
#end