#version unofficial MegaPov 0.6;

#ifndef (TEXT_INC)
  #declare TEXT_INC = 0;
  
  #include "enter"
  #include "metrics.inc"
  #include "teak.map"
  #include "orngwood.map"

  #default{
    finish { diffuse 0.9 ambient 0.0 }
  }

  #declare Dirt = texture {
    pigment {
      bozo
      color_map {
        [0 rgb <.6,.5,.4> transmit .75]
        [1 rgb <.6,.5,.4> transmit 1]
      }
      scale 2
    }
  }
  texture {
    pigment {
      bozo
      pigment_map {
        [0 bozo color_map {[0 rgb <.6,.5,.4> transmit .75][1 rgb <.6,.5,.4> transmit 1]}scale .125]
        [.5 rgb <.6,.5,.4> transmit 1]
      }
      scale 2
    }
    translate 5
  }
  
  #declare Seed = seed(1234);
  #macro Dirty (BaseScale, N)
    #local i = N - 1;
    #while (i>=0)
      texture {
        Dirt
        translate <BaseScale*rand(Seed), BaseScale*rand(Seed), BaseScale*rand(Seed)>
        scale BaseScale*pow (2, i)
      }
      #local i = i - 1;
    #end
  #end

  #declare PDarkWood = pigment {
    wood
    color_map { M_Teak }
    turbulence <0.07, 0.07, 0.2 >
  }
  #declare FDarkWood = finish {
    brilliance 1.2
    specular 0.01
    roughness 0.2
  }
  #macro DarkWood()
    pigment { PDarkWood }
    normal {
      wood 2
      turbulence <0.07, 0.07, 0.2 >
    }
    finish { FDarkWood }
    scale      <0.3, 0.3, 0.7>/4
    translate  <rand(Seed), rand(Seed), rand(Seed)*100>/10
    rotate <rand(Seed)-0.5, rand(Seed)-0.5, rand(Seed)*360>
    rotate 90*y
    scale 10*cm
  #end

  #macro OrangeWood()
    pigment {
      wood
      color_map { M_Orangewood }
      turbulence <0.05, 0.05, 0.4>
    }
    normal {
      wood 1
      turbulence <0.02, 0.02, 0.12>
    }
    scale      <0.03, 0.03, 0.07>
    translate  <rand(Seed), rand(Seed), rand(Seed)>/2
    rotate <rand(Seed)-0.5, rand(Seed)-0.5, rand(Seed)*360>
    scale 10*cm
  #end
  
  #declare PWhiteWood = pigment {
    wood
    octaves 4
    lambda 2.2
    turbulence <0.06, 0.06, 0.6>
    color_map {
      [0.0 color rgb < 0.953, 0.878, 0.761 > ]
      [0.2 color rgb < 0.980, 0.851, 0.647 > ]
      [0.4 color rgb < 0.871, 0.776, 0.627 > ]
      [0.6 color rgb < 0.792, 0.698, 0.533 > ]
      [0.8 color rgb < 0.757, 0.580, 0.373 > ]
      [1.0 color rgb < 0.667, 0.459, 0.263 > ]
    }
    scale      <0.2, 0.2, 4>*1.5
  }
  #declare FWhiteWood = finish {
    brilliance 1.2
    specular 0.2
    roughness 0.2
  }
  #macro WhiteWood()
    pigment {
      wood
      octaves 4
      lambda 2.2
      turbulence <0.06, 0.06, 0.6>
      color_map {
        [0.0 color rgb < 0.953, 0.878, 0.761 > ]
        [0.2 color rgb < 0.980, 0.851, 0.647 > ]
        [0.4 color rgb < 0.871, 0.776, 0.627 > ]
        [0.6 color rgb < 0.792, 0.698, 0.533 > ]
        [0.8 color rgb < 0.757, 0.580, 0.373 > ]
        [1.0 color rgb < 0.667, 0.459, 0.263 > ]
      }
    }
    normal {
      wood 0.5
      octaves 4
      lambda 2.2
      turbulence <0.06, 0.06, 0.6>
    }
    finish {
      FWhiteWood
    }
    scale      <0.02, 0.02, 0.4>*1.5
    translate  <rand(Seed), rand(Seed), rand(Seed)>/2
    rotate <rand(Seed)-0.5, rand(Seed)-0.5, rand(Seed)*360>
    scale 10*cm
  #end

  #declare TLightWood = texture {
    pigment {
      wood
      octaves 3
      lambda 2.2
      omega 0.4
      turbulence <0.03, 0.03, 0.6>
      scale <1, 1, 10>*mm
      color_map {
        [0.0 color rgb < 0.949, 0.792, 0.514 > ]
        [0.3 color rgb < 0.855, 0.651, 0.376 > ]
        [0.6 color rgb < 0.831, 0.596, 0.275 > ]
        [0.9 color rgb < 0.620, 0.447, 0.204 > ]
      }
    }
    normal {
      wood 0.1
      octaves 3
      lambda 2.2
      omega 0.4
      turbulence <0.03, 0.03, 0.6>
      scale <1, 1, 10>*mm
    }
    finish {
      brilliance 1.2
      specular 0.01
      roughness 0.2
    }    
  }
  
  #macro SplashPaint(Amount)
    /*texture {
      pigment {
        bozo
        turbulence 0.2
        color_map {
          [ Amount color rgbf <1, 1, 0, 0.25> ]
          [ Amount+0.1 color rgbf <0, 0, 0, 1> ]
        }
      }
      translate <10*rand (Seed), 10*rand (Seed), 10*rand (Seed)>
      scale 10*cm
    }
    texture {
      pigment {
        bozo
        turbulence 0.2
        color_map {
          [ Amount color rgbf <0, 1, 1, 0.25> ]
          [ Amount+0.1 color rgbf <0, 0, 0, 1> ]
        }
      }
      translate <10*rand (Seed), 10*rand (Seed), 10*rand (Seed)>
      scale 10*cm
    }
    texture {
      pigment {
        bozo
        turbulence 0.2
        color_map {
          [ Amount color rgbf <1, 0, 1, 0.25> ]
          [ Amount+0.1 color rgbf <0, 0, 0, 1> ]
        }
      }
      translate <10*rand (Seed), 10*rand (Seed), 10*rand (Seed)>
      scale 10*cm
    }
    texture {
      pigment {
        bozo
        turbulence 0.2
        color_map {
          [ Amount color rgbf <1, 1, 0, 0.25> ]
          [ Amount+0.1 color rgbf <0, 0, 0, 1> ]
        }
      }
      translate <10*rand (Seed), 10*rand (Seed), 10*rand (Seed)>
      scale 10*cm
    }
    texture {
      pigment {
        bozo
        turbulence 0.2
        color_map {
          [ Amount color rgbf <0, 1, 1, 0.25> ]
          [ Amount+0.1 color rgbf <0, 0, 0, 1> ]
        }
      }
      translate <10*rand (Seed), 10*rand (Seed), 10*rand (Seed)>
      scale 10*cm
    }
    texture {
      pigment {
        bozo
        turbulence 0.2
        color_map {
          [ Amount color rgbf <1, 0, 1, 0.25> ]
          [ Amount+0.1 color rgbf <0, 0, 0, 1> ]
        }
      }
      translate <10*rand (Seed), 10*rand (Seed), 10*rand (Seed)>
      scale 10*cm
    }*/
    #macro MakeSplash (col)
      bozo
      turbulence 0.2
      color_map {
        [ Amount color rgb col filter -0.5 ]
        [ Amount+0.1 color rgbf <0, 0, 0, 1> ]
      }
      translate <10*rand (Seed), 10*rand (Seed), 10*rand (Seed)>
    #end
    texture {
      pigment {
        average
        pigment_map {
          [ 1 MakeSplash (<1, 1, 0>)]
          [ 1 MakeSplash (<1, 0, 1>)]
        }
      }
      scale 10*cm
    } 
    texture {
      pigment {
        average
        pigment_map {
          [ 1 MakeSplash (<1, 0, 1>)]
          [ 1 MakeSplash (<0, 1, 1>)]
        }
      }
      scale 10*cm
    } 
    texture {
      pigment {
        average
        pigment_map {
          [ 1 MakeSplash (<0, 1, 1>)]
          [ 1 MakeSplash (<1, 1, 0>)]
        }
      }
      scale 10*cm
    } 
  #end

  #macro PaintSpot (col, fil)
    spherical
    color_map {
      [ 0.0 rgb 0 filter 1 ]
      [ 0.5 rgb col*(fil+1) filter 0.25*(fil+1)-fil ]
    }
    scale <1, 0.5, 1>
    #local Vec = <rand (Seed), rand (Seed), rand (Seed)>*100 ;
    translate Vec
    warp { turbulence 0.5 octaves 4 }
    translate -Vec
    scale 6*cm
  #end
  
  #declare DarkMetal = texture {
    pigment { color rgb 0.25 }
    finish { brilliance 3 metallic reflect_metallic reflection 0.1 specular 0.5 roughness 1/60 }
    normal { bumps 1 scale 1*mm }
  }
  
  #declare TGold = texture {
    pigment { color rgb <1.00, 0.675, 0.175> }
    finish {
      brilliance 2
      reflection 0.15
      diffuse 0.3
      reflect_metallic
      reflection_blur 0.05
      reflection_samples 1
      specular 0.3
      roughness 1/60
      metallic
    }
    normal {
      bumps 0.1
      scale 1*mm
    }
  }
  
  #declare MSilver = material {
    texture {
      pigment { color rgb <0.94, 0.93, 0.90> }
      finish {
        brilliance 2
        diffuse 0.3
        metallic
        reflect_metallic
        blinn 2.0 facets 0.28
        reflection 0.15
        reflection_blur 0.05
        reflection_samples 1
      }
    }
    interior { ior 20 }
  }
  
  #declare MGreenGlass = material {
    texture {
      pigment { color rgbf <0.75, 1, 0.9, 0.75> }
      finish {
        diffuse 0.1
        reflection 0.05
        reflection_blur 0.05
        #if (HighQuality)
          reflection_samples 5
        #else
          reflection_samples 1
        #end
        blinn 0.9 facets 0.15
      }
    }
    interior { ior 1.6 fade_distance 4*mm fade_power 10000 fade_color rgb <0.75, 1, 0.9>/2 }
  }
  
  #declare MRedGlass = material {
    texture {
      pigment { color rgbf <1, 0.85, 0.8, 1> }
      finish {
        diffuse 0.1
        reflection 0.05
        reflection_blur 0.05
        #if (HighQuality)
          reflection_samples 5
        #else
          reflection_samples 1
        #end
        blinn 0.9 facets 0.15
      }
    }
    interior { ior 1.6 fade_distance 4*mm fade_power 10000 fade_color rgb <1, 0.8, 0.75> }
  }
  
  #declare MBlueGlass = material {
    texture {
      pigment { color rgbf <0.9, 0.95, 1, 1> }
      finish {
        diffuse 0.1
        reflection 0.05
        reflection_blur 0.05
        #if (HighQuality)
          reflection_samples 5
        #else
          reflection_samples 1
        #end
        blinn 0.9 facets 0.15
      }
    }
    interior { ior 1.7 fade_distance 1*mm fade_power 10000 fade_color rgb <0.9, 0.95, 1> }
  }

  #declare PCork = pigment {
    crackle
    color_map {
      [ 0.0 color rgb <1.00, 1.0, 1.0> ]
      [ 0.2 color rgb <0.90, 0.8, 0.6> ]
      [ 0.3 color rgb <0.75, 0.6, 0.3> ]
    }
    turbulence 0.1
    scale <5, 2.5, 5>*mm
  }
  
  #include "leave"
#end