#version unofficial MegaPov 0.6;

#ifndef (PAINTBRUSH2_INC)
  #declare PAINTBRUSH2_INC = 0 ;
  
  #ifndef (HighQuality)
    #declare HighQuality = on ;
  #end
  
  #include "enter"
  #include "metrics.inc"
  #include "text.inc"

  #declare PaintBrush2 = union {
    #local Circle = function { sqrt (sqr(x) + sqr(z)) - 0.3 }
    #local Super  = function { sqr (sqr (x)) + sqr (sqr (z/0.3)) - 1 }
    superellipsoid {
      <0.25, 0.25>
      scale <9, 20, 2>*mm
      translate 17.8*cm*y
      pigment {
        bozo
        color_map {
          [ 0.45 rgb <1.0, 1.0, 0.5> ]
          [ 0.50 rgb <1.1, 1.1, 1.1> ]
          [ 0.55 rgb <1.0, 0.9, 0.5> ]
        }
        scale <1*mm, 1*cm, 1*mm>
      }
      normal {
        bozo 0.1
        scale <1*mm, 1*cm, 1*mm>
      }
    }
    difference {
      isosurface {
        function { Super (x*(1+(y-14)/40), y, z*(1+(y-14)/40)) }
        contained_by { box { <-1.05, 13.9, -0.35>, <1.05, 17, 0.35> } }
        method 2
        max_gradient 18
        //eval
        scale 1*cm
      }
      cylinder { <-1.1, 14.2,-0.3>*cm, <1.1, 14.2,-0.3>*cm, 1*mm }
      cylinder { <-1.1, 14.2, 0.3>*cm, <1.1, 14.2, 0.3>*cm, 1*mm }
      cylinder { <-1.05, 14.2, -0.3>*cm, <-1.05, 14.2, 0.3>*cm, 1*mm }
      cylinder { < 1.05, 14.2, -0.3>*cm, < 1.05, 14.2, 0.3>*cm, 1*mm }
      cylinder { <-1.1, 14.6,-0.3>*cm, <1.1, 14.6,-0.3>*cm, 1*mm }
      cylinder { <-1.1, 14.6, 0.3>*cm, <1.1, 14.6, 0.3>*cm, 1*mm }
      cylinder { <-1.05, 14.6, -0.3>*cm, <-1.05, 14.6, 0.3>*cm, 1*mm }
      cylinder { < 1.05, 14.6, -0.3>*cm, < 1.05, 14.6, 0.3>*cm, 1*mm }
      material { MSilver }
    }
    union {
      isosurface {
        function { (1-y)*Circle (x, y, z) + y*Super (x, y, z) }
        contained_by { box { <-1.01, 0, -0.31>, <1.01, 1, 0.31> } }
        method 2
        max_gradient 15
        //eval
        scale <1, 13.7, 1>*cm
        translate 3*mm*y
      }
      sphere { 3*mm*y, 3*mm }
      texture { TLightWood rotate 90*x }
    }
    translate -3*mm*y
    rotate 90*x
    translate 3*mm*y
    rotate 90*y
  }
  
  #if (!included)
    global_settings {
      assumed_gamma 1
    }
    camera {
      up y
      right (image_width/image_height)*x
      location 10*cm*y-50*cm*z
      look_at  0*cm*y
      angle 20
    }
    light_source {
      110*cm*y-3*m*z
      color rgb 0.25
      shadowless
    }
    
    light_source {
      <1000, 1000, -1000>*m
      color rgb 1
    }
    light_source {
      <-1000, 1000, -1000>*m
      color rgb 1/4
    }
    light_source {
      <0, 1000, 1000>*m
      color rgb 1.5
    }
    
    cylinder {
      -y, 0, 2*m
      pigment {
        checker
        color rgb 0.25
        color rgb 0.50
        scale 20*cm
      }
      finish {
        diffuse 0.5
        reflection 0.25
        reflection_blur 0.05
        reflection_samples 1
      }
      rotate 30*y
    }
    
    object {
      PaintBrush2
      translate -12*cm*x
      rotate 30*y
    }
  #end
  
  #include "leave"
#end
