// generic macro's

#macro swap(a,b) // swaps a & b
	#local temp=a;
	#local a=b;
	#local b=temp;
#end

#macro rbox(sp,ep,cs) // rounded box created by corners sp and ep, ep = size of cylinder/sphere making curve
	#local spx=sp.x;
	#local spy=sp.y;
	#local spz=sp.z;
	#local epx=ep.x;
	#local epy=ep.y;
	#local epz=ep.z;
	#if (spx>epx)
		swap(spx,epx)
	#end
	#if (spy>epy)
		swap(spy,epy)
	#end
	#if (spz>epz)
		swap(spz,epz)
	#end
	merge {
		cylinder { <spx,spy,spz> <spx,spy,epz> cs }
		cylinder { <epx,spy,spz> <epx,spy,epz> cs }
		cylinder { <spx,epy,spz> <spx,epy,epz> cs }
		cylinder { <epx,epy,spz> <epx,epy,epz> cs }

		cylinder { <spx,spy,spz> <spx,epy,spz> cs }
		cylinder { <epx,spy,spz> <epx,epy,spz> cs }
		cylinder { <spx,spy,epz> <spx,epy,epz> cs }
		cylinder { <epx,spy,epz> <epx,epy,epz> cs }

		cylinder { <spx,spy,spz> <epx,spy,spz> cs }
		cylinder { <spx,epy,spz> <epx,epy,spz> cs }
		cylinder { <spx,spy,epz> <epx,spy,epz> cs }
		cylinder { <spx,epy,epz> <epx,epy,epz> cs }
		
		sphere { <spx,spy,spz> cs }
		sphere { <epx,spy,spz> cs }
		sphere { <spx,epy,spz> cs }
		sphere { <epx,epy,spz> cs }
		sphere { <spx,spy,epz> cs }
		sphere { <epx,spy,epz> cs }
		sphere { <spx,epy,epz> cs }
		sphere { <epx,epy,epz> cs }
		
		box { <spx,spy,spz>-x*cs <epx,epy,epz>+x*cs }
		box { <spx,spy,spz>-y*cs <epx,epy,epz>+y*cs }
		box { <spx,spy,spz>-z*cs <epx,epy,epz>+z*cs }
	}
#end
