//*****************************************************************************************************************************
// scene environment
//*****************************************************************************************************************************
// Justin Whitton
//               IRTC 2000 Round 6 November-December "Contrast"
// irtc@rayjay.clara.co.uk
//*****************************************************************************************************************************
#version unofficial MegaPov 0.6;
#local quality = 1;
#local bwe = 0; // saturation multiplier for unsaturated parts of the image
#local filllight=0;
//#declare pov = <200,180,-190>;
//#declare poi = <-200,0,195>;
#declare pov=<-200,100,150>;
#declare poi=<-40,10,120>;

#include "hsi_rgb.inc" //hsi<->rgb conversion routines
#include "generic.inc" //generic macro's (started for this image)
#include "car.inc" //spatch generated car

camera {
	location pov
	sky y
	right 4/3*x
	look_at poi
}

#if (filllight=1)
	light_source { pov rgb 0.5 }
#end

global_settings {
	max_trace_level 30
	number_of_waves 20
	post_process {
		focal_blur{vlength(pov-poi),vlength(pov-poi)/6, 8, 1/3}
		soft_glow{1,8}
	}
	#if (quality >=1)
	  	ini_option "+QR"
	  	ini_option "Preview_Start_Size=16"
	  	ini_option "Preview_End_Size=8"
	  
	  	radiosity{
		    count 40             // CHANGE range from 20 to 150
		    nearest_count 3      // CHANGE range from 3 to 10
		    error_bound 3        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
		                         //   1 : preview_end_size = 4
		                         //   3 : preview_end_size = 8
		                         //   use preview_start_size = 16
		                         // you can go lower than 1, but then you probably will want to set
		                         // preview_end_size to 2, which is really slow
		    recursion_limit 3    // CHANGE
		    
		    low_error_factor .5  // leave this
		    gray_threshold 1-bwe
		    minimum_reuse 0.015  // leave this
		    brightness 2/3
		    
		    max_sample 1         // CHANGE - this should be the same as the brightest object
		    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		    normal on
		}
	#end
}


sky_sphere {
	pigment {
		planar
		scale 2
		translate y*-1
		rotate x*70
		rotate y*-30
		colour_map {
			[ 0 rgb desat(<2/3,5/6,1>,bwe) ]
			[ 0.5 rgb desat(<0.5,0.6,1>,bwe) ]
			[ 1 rgb desat(<0.1,0.1,0.2>,bwe) ]
		}
	}
}


light_source { vrotate(vrotate(y*10000,x*70),y*-30) rgb desat(<1,0.9,0.7>,bwe)*1.5 parallel point_at 0 groups "exterior" }

plane { y, -1 pigment { rgb desat(<0.2,0.5,0.1>,bwe) } finish { ambient 0 diffuse 0.9 } }

#declare walltext= texture {
	pigment {
		rgb 1
	}
	normal {
		granite 0.3
		scale 3
	}
	finish {
		ambient 0
		diffuse 0.9
	}
}
texture {
	pigment {
		granite
		scale 4/100
		pigment_map {
			[0 rgbt <0,0,0,1>]
			[1 planar
				colour_map {
					[0 rgbt <0,0,0,1>]
					[1 rgbt <0,0,0,0.6>]
				}
			]
		}
	}
	normal {
		granite 0.3/250
		scale 3
	}
	finish {
		ambient 0
		diffuse 0
	}
	scale 250
}

#declare upvc = texture {
	pigment {
		rgb 1
	}
	finish {
		ambient 0
		diffuse 1.6
		phong 0.2
		specular 0.2
	}
}
texture {
	pigment {
		slope y
		colour_map {
			[0 rgbt t*0.2]
			[0.49 rgbt t*0.9]
			[0.499 rgbt t*1]
		}
	}
	finish {
		ambient 0
		diffuse 0
	}
}

#declare rubber = texture {
	pigment {
		rgb 1
	}
	finish {
		ambient 0
		diffuse 0.1
		specular 0
		phong 0.9
		phong_size 10
	}
}

#declare room= union {
	mesh { // frosted window
		triangle { <-250,0,200> <-250,200,200> <250,200,200> }
		triangle { <-250,0,200> <250,0,200> <250,200,200> }
		double_illuminate
		texture {
			pigment { rgbf <0.9,0.9,0.9,0.1> }
			finish { ambient 0 diffuse 1 }
		}
		no_shadow
	}
	mesh { // window dirt
		triangle { <-250,0,200> <-250,200,200> <250,200,200> }
		triangle { <-250,0,200> <250,0,200> <250,200,200> }
		translate z*-0.01
		double_illuminate
		texture {
			pigment {
				granite
				scale 3
				colour_map {
					[0 rgbt <0,0,0,1>]
					[0.7 rgbt <0,0,0,0.5>]
				}
			}
			finish {
				ambient 0
				diffuse 1
			}
		}
		texture {
			pigment {
				gradient y
				scale 40
				colour_map {
					[0 rgbt <0,0,0,0.6>]
					[0.3 rgbt <0,0,0,1>]
				}
			}
			finish {
				ambient 0
				diffuse 1
			}
		}
		texture {
			pigment {
				gradient x
				scale 40
				colour_map {
					[0.0 rgbt <0,0,0,0.6>]
					[0.3 rgbt <0,0,0,1>]
					[0.7 rgbt <0,0,0,1>]
					[1 rgbt <0,0,0,0.6>]
				}
			}
			finish {
				ambient 0
				diffuse 1
			}
		}
	}
	difference { // walls
		box {
			<-255,-1,-205> <255,255,205>
		}
		box {
			<-245,0,-195> <245,245,195>
		}
		box {
			<-240,120,190> <240,200,210>
		}
		box {
			<-160,1,190> <-40,200,210>
		}
		texture {
			walltext
		}
	}
	#macro windowseg(spoint,epoint,thinsize,wid)
		#local spx = spoint.x;
		#local spy = spoint.y;
		#local spz = spoint.z;
		#local epx = epoint.x;
		#local epy = epoint.y;
		#local epz = epoint.z;
		#if (spx>epx)
			swap(spx,epx)
		#end
		#if (spy>epy)
			swap(spy,epy)
		#end
		#if (spz>epz)
			swap(spz,epz)
		#end
		#local thinsizevec=vnormalize(vcross(<epx,epy,epz>-<spx,spy,spz>,z))*thinsize;
		#local nspoint=<spx,spy,spz-wid>-thinsizevec;
		#local nepoint=<epx,epy,epz+wid>+thinsizevec;
		object { rbox(nspoint,nepoint,2) texture{ upvc } }
	#end
	union { // window & door
		windowseg(<-241,200,200>,<241,200,200>,1,5)
		windowseg(<-241,200,200>,<-241,120,200>,1,5)
		windowseg(<241,200,200>,<241,120,200>,1,5)
		windowseg(<-241,120,200>,<-160,120,200>,1,5)
		windowseg(<-40,120,200>,<241,120,200>,1,5)
		windowseg(<-160,200,200>,<-160,0,200>,1,5)
		windowseg(<-40,200,200>,<-40,0,200>,1,5)
		windowseg(<-160,0,200>,<-40,0,200>,1,5)
		windowseg(<-240,160,200>,<240,160,200>,0.01,0.01)
		#local cx=-200;
		#while (cx<240)
			windowseg(<cx,0,200>,<cx,200,200>,0.01,0.01)
			#local cx=cx+40;
		#end
		#local cy=40;
		#while (cy<160)
			windowseg(<-160,cy,200>,<-40,cy,200>,0.01,0.01)
			#local cy=cy+40;
		#end
		windowseg(<-155,5,200>,<-155,195,200>,0.01,3)
		windowseg(<-45,5,200>,<-45,195,200>,0.01,3)
		windowseg(<-155,5,200>,<-45,5,200>,0.01,3)
		windowseg(<-155,195,200>,<-45,195,200>,0.01,3)
		windowseg(<-80,100,200>,<-45,100,200>,20,0.01)
	}
}

object { room }

sphere {
	0,1
	texture {
		pigment {
			planar
			rotate <20,32,17>
			colour_map {
				//[0.1 rgb desat(y,bwe) ]
				[0.1 rgb y ]
				[0.2 rgb 0]
				[0.3 rgb 0]
				//[0.4 rgb desat(x,bwe) ]
				//[0.6 rgb desat(x,bwe) ]
				[0.4 rgb x ]
				[0.6 rgb x ]
				[0.7 rgb 1]
				[0.8 rgb 1]
				//[0.9 rgb desat(z,bwe) ]
				[0.9 rgb z ]
			}
		}
		finish {
			ambient 0
			diffuse 1
			specular 0.2
			phong 0.2
		}
	}
	scale 10
	translate <-36,10,184>
}

#local rs=seed(42^2);

#macro cbox(loc)
	object {
		rbox(<-24,1,-24>,<24,49,24>,1)
		texture {
			pigment {
				wrinkles
				scale 20
				colour_map {
					#local cboxhue=0.1+rand(rs)*0.1;
					[0 rgb desat(hsi2rgb(<cboxhue,0.3,0.5>),bwe) ]
					[1 rgb desat(hsi2rgb(<cboxhue,0.3,1>),bwe) ] 
				}
				translate <rand(rs)*1000,rand(rs)*1000,rand(rs)*1000>
			}
			normal {
				wrinkles 1/30
				scale 20
			}
			finish {
				diffuse 0.9
				ambient 0
			}
		}
		rotate y*(60*rand(rs)-30)
		translate loc
	}
#end

#local zc=-165;
#while (zc<=165)
	#local yc=0;
	#local bup=0;
	#while (bup<0.8)
		cbox(<220,yc,zc>)
		#local yc=yc+50.01;
		#local bup=rand(rs);
	#end
	#local zc=zc+55;
#end

#macro pcan(loc)
	union {
		cylinder {
			loc+0.5*y loc+9.5*y 4.7
			pigment {
				planar
				scale 10
				translate loc
				#local phue=rand(rs);
				colour_map {
					[0.1 rgb desat(hsi2rgb(<phue,1,2/3>),bwe) ]
					[0.2 rgb 1]
					[0.4 rgb 1]
					[0.6 rgb desat(hsi2rgb(<phue,1,2/3>),bwe) ]
				}
			}
			finish { ambient 0 diffuse 1 specular 0.2 phong 0.2 }
		}
		cylinder { loc loc+1*y 4.9 }
		difference {
			cylinder { loc+9*y loc+9.9*y 4.9 }
			cylinder { loc+8.9*y loc+9.91*y 4 }
		}
		texture {
			pigment {
				rgb 1
			}
			finish {
				ambient 0
				diffuse 0.8
				reflection 0.2
				specular 1
				phong 0.5
			}
		}
	}
#end

#local xoff1=sqrt(2)*5.1;
#local xoff2=0;
#local zc=95;
#while (zc<190)
	#local xc=0;
	#while ((xc+xoff1)<190)
		#local yc=0;
		#while (rand(rs)<(((zc-95)/(195-95))*(xc/190)))
			pcan(<xc+xoff1,yc,zc>)
			#local yc=yc+10.01;
		#end
		#local xc=xc+10.1;
	#end
	#local zc=zc+sqrt(2)*5.1;
	swap(xoff1,xoff2)
#end

object {
	car
	rotate y*190
	translate <40,0,0>
}
