// A macro to generate a hedge from tree objects.
// Copyright 2000 M. D. Mackey

#declare hedgersd=5133;
#declare hedgerd=seed(hedgersd);

#macro Hedge(HedgeTree,length,treesize,sizestd,treedist,diststd,transversestd)
#render "Adding hedge "
#declare numtrees=length/treedist;
#while (numtrees>0)
#render "."
  object {
    HedgeTree
    rotate y*360*rand(hedgerd)
    scale treesize+(0.5-rand(hedgerd))*sizestd*2*treesize
    translate x*numtrees*treedist
    translate x*(0.5-rand(hedgerd))*diststd*2*treedist
    translate z*(0.5-rand(hedgerd))*transversestd*2*treedist
  }
  #declare numtrees=numtrees-1;
#end
#render "\n"
#end
 
