// A collection of leaf objects. Copyright 2000 M. D. Mackey
// Most of these are similar or identical to the leaves
// distributed with the MakeTree macro by Gilles Tran.

#include "colors.inc"
#include "txttree.inc"
#include "maketree.pov" // tree & leaf macro

#declare lsize=0.3;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=5;          // leaf length
#declare wl=1;          // leaf width
#declare fl=0.5;        // depth of leaf fold
#declare lpow=2;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=7;      // number of lobes (individual leaves)
#declare alobes=280;    // angle made by all the lobes
#declare qlobes=0.6;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)
#declare ls=1;          // stalk length (0=no stalk)
#declare ws=0.1;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward

#declare Leaf1=
object {
  MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
           ndents,nlobes,alobes,qlobes,ls,ws,as,false,"delthis")
  texture{txtLeaf_4}
  rotate 35*x
}

//-----------------------------------------
#declare lsize=0.3;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=5;          // leaf length
#declare wl=1;          // leaf width
#declare fl=0.5;        // depth of leaf fold
#declare lpow=1;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=1;      // number of lobes (individual leaves)
#declare alobes=0;    // angle made by all the lobes
#declare qlobes=1;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)
#declare ls=0.5;          // stalk length (0=no stalk)
#declare ws=0.1;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward

#declare Leaf2=
object {
  MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
           ndents,nlobes,alobes,qlobes,ls,ws,as,false,"delthis")
  texture{txtLeaf_8}
  rotate 50*x
  rotate 50*z
}

//-----------------------------------------
#declare lsize=0.3;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=5;          // leaf length
#declare wl=1.2;          // leaf width
#declare fl=0.5;        // depth of leaf fold
#declare lpow=1;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=3;      // number of lobes (individual leaves)
#declare alobes=110;    // angle made by all the lobes
#declare qlobes=0.7;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)
#declare ls=0.3;          // stalk length (0=no stalk)
#declare ws=0.12;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward

#declare Leaf3=
object {
  MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
           ndents,nlobes,alobes,qlobes,ls,ws,as,false,"delthis")
  texture{txtLeaf_9}
  translate -y*0.8
  rotate 55*x
  rotate 180*z
}

//-----------------------------------------
#declare lsize=0.4;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=3;          // leaf length
#declare wl=0.6;          // leaf width
#declare fl=0.1;        // depth of leaf fold
#declare lpow=0.3;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=5;      // number of lobes (individual leaves)
#declare alobes=288;    // angle made by all the lobes
#declare qlobes=1;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)
#declare ls=0;          // stalk length (0=no stalk)
#declare ws=0.1;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward

#declare Leaf4=
object {
  MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
           ndents,nlobes,alobes,qlobes,ls,ws,as,false,"delthis")
  texture{txtLeaf_3}
  rotate -90*x
  translate 0.7*y

}

//-----------------------------------------
#declare txtLeaf=texture{txtLeaf_5} // Leaf texture
#declare lsize=0.3;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=7;          // leaf length
#declare wl=1.2;          // leaf width
#declare fl=0.5;        // depth of leaf fold
#declare lpow=1;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=3;      // number of lobes (individual leaves)
#declare alobes=110;    // angle made by all the lobes
#declare qlobes=0.7;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)
#declare ls=1;          // stalk length (0=no stalk)
#declare ws=0.12;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward

#declare Leaf5=
object {
  MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,
           ndents,nlobes,alobes,qlobes,ls,ws,as,false,"delthis")
  texture{txtLeaf_5}
}

#declare nLeaves=5;
#declare LeafArray=
array[nLeaves] {Leaf1,Leaf2,Leaf3,Leaf4,Leaf5}

#declare LeafProbs=
array[nLeaves] {0.25,0.2,0.2,0.1,0.25}

#declare nLeaves2=5;
#declare LeafArray2=
array[nLeaves] {Leaf1,Leaf2,Leaf3,Leaf4,Leaf5}

#declare LeafProbs2=
array[nLeaves] {0.05,0.3,0.25,0.1,0.3}
