// A starry sky generator. Copyright 2000 M. D. Mackey
/* How to generate objects uniformly distributed on a sphere:
        (a) Choose z uniformly distributed in [-1,1].
        (b) Choose t uniformly distributed on [0, 2*pi).
        (c) Let r = sqrt(1-z^2).
        (d) Let x = r * cos(t).
        (e) Let y = r * sin(t).
*/

// Direction should be the camera direction vector length
#macro starrysky(Direction, number_of_stars)
#render concat("\nGenerating ",str(number_of_stars,0,0)," stars\n")
#local S0=seed(0); 
#local Count=0;
#local Diameter=2000;
#local Distance=image_height*Direction*Diameter;
#while (Count < number_of_stars) 

  sphere { <0,0,0>,Diameter/1.5 
    no_shadow 
// the sequence of rand() scales biases the stars to lower brightness
    pigment { rgb <1+rand(S0)*0.5,1+rand(S0)*0.5,1+rand(S0)*0.5>*rand(S0)*rand(S0)*rand(S0) } 
    finish { ambient <1/ambient_red,1/ambient_green,1/ambient_blue>*1.5 diffuse 0 specular 0 phong 0 reflection 0 } 
    #local zc=rand(S0);
    #local rc=sqrt(1-zc^2);
    translate <rc,0,zc>*Distance
    rotate < 0,0,360*rand(S0) > 
  } 
#declare Count=Count+1;
#end
#end
