// Persistence of Vision Ray Tracer Scene Description File
// File: mg_last.pov
// Vers: 3.1
// Desc: Contrast topic (IRTC)
// Date: Dec 29 2000
// Auth: marjorie Graterol 


#include "colors.inc"	
#include "textures.inc"	
#include "mg_12tex.inc"  //textures - texturas



global_settings{assumed_gamma 2.00}
background { color Black }

camera
{
  location  <1.0 , 2.5 ,-8.0>
  look_at   <3.0 , 1.5 , 6.0>
  angle 60
}

//Lights -Luces
#include "mg_12luz.inc"

object{general}
object{specific}

//floor -piso
plane
{
  y, 
  -5.0 
  hollow on 
  interior {ior 1.500}
  texture{superficie}

}

//wine glass -copa de vino
#include "copa2.inc"

object {copa2 
        texture {Glass2}
        scale <1,1.25,1> 
        translate <0,1,0>}


difference
{

  sphere
  {
  <0, 0.65, 0> 0.88       
  texture {wine} 
  interior {ior 1.360
  caustics 0.8 }
  }


  box
  {
  <-1, -1, -1>  
  < 1,  1,  1>  
  texture{wine}
  translate <0,1.30,0> }
  interior {ior 1.360 caustics 0.8 }
  }




object {copa2 texture {Glass2}
 
        rotate 90*x
        rotate 49*y

        translate <-2,-1,0>}



//table -mesa
cylinder
{
  0*y,  0.25*y,  4
   //open 
   
  texture{Rosewood scale 0.70}
  translate <-1,-1.75,0>
} 



//walls -paredes
#declare tabique=
box
{
  <-1, -1, -1>  
  < 1,  1,  1>  
texture {paneltex}
scale <1.5,8,0.5>
}

object {tabique translate <0,0,6>}
object {tabique translate <3.02,0,6>} 
object {tabique translate <6.03,0,6>}  
object {tabique translate <9.04,0,6>}
object {tabique rotate 90*y translate <-4,0,6>}

#declare ventanal=
union{
difference{
object {tabique scale <1,1,0.5> translate <-2.50,0,5>}
object {tabique scale <0.25,0.25,2 > translate <-3,6,5>}
object {tabique scale <0.25,0.25,2 > translate <-3,1,5>}
object {tabique scale <0.25,0.25,2 > translate <-2.10,5,5>}
object {tabique scale <0.25,0.25,2 > translate <-2.10,0.5,5>}

}

//

object {tabique 
        texture{Prussian_mood} 
        scale <1,1,0.5> 
        translate <-2.50,0,5.2> 
        interior{ior 1.5
        fade_power 1
        fade_distance 20
        
        }}

}


object{ventanal}    
object{ventanal rotate 90*y translate <4.90,0,1.30>}


//shelf- repisa
box
{
  <-1, 0.75, -1>  
  < 9.5,  1,  1>  
  texture {Rosewood scale 0.80}
  
  finish {phong 0.6}
  translate <0,0.5,5>
}

 
//red rose -rosa roja
#include "rose.inc"
object{rose  scale <0.20,0.25,0.20> rotate -30*y translate <2.75,3.25,5> }                 



object{rose  scale <0.20,0.25,0.20> rotate -30*y translate <2.80,4.25,5> } 
object{rose  scale <0.20,0.25,0.20> rotate -45*y rotate -32*z translate  <3.5,3.95,5> }
object{rose  scale <0.20,0.25,0.20> rotate -60*y rotate 15*z  translate <2.5,3.65,4.75> }


//white rose -rosa blanca
#include "rose_2.inc"
object{rose_2  scale <0.23,0.25,0.23> 
rotate 220*x 

 rotate 90*z 
 translate <5,1.50,3.90> }  

//vase-florero
#include "vase.inc"
object{vase scale <0.70,0.50,0.70> translate<2.7,2.3,4.8>}

//chair-silla
#include "silla2.inc" 

object{silla2 
texture{Dusty_Plastic}
                
scale <6,6.5,6>
rotate -15*x
rotate 210*y 
translate <2.8,-2,1.5>} 


//Second shelf-segunda repisa
box
{
  <-1, -5.50, 0>  
  < 9.5,  0.75,  0.10>  
  
texture{Rosewood scale 0.10 }  

  translate <0,0.5,5.1>
}

//ceniceros -ashtrays
#include "ceniceros.inc"

object {ceniceros 
         texture{MessTexture}
        scale 2.25 
        translate<-0.25,1.41,4.95>
}


//purse- cartera
#include "cartera.inc"
object {cartera 
        rotate -38*y
        
        
        translate<4.3,2.1,4.50>} 
        
        
//columns - columnas
#declare columna=
cylinder
{
  -6*y,  12*y, 0.5
  // open
  texture{paneltex}
  
}


object{columna translate <7.35,0,2>}
object {columna translate <7.75,0,-2.5>}
object {columna translate <9,0,-8>}

//izquierda
object {columna translate <-4.7,0,4.80>}  

//steps - escalones

#local escalon=
box
{
  <-1, -1, -1>  
  < 1,  1.75,  1>  
  texture{BWood scale 0.50}
  scale <1,0.75,1.5>
  
}
union{
object {escalon translate <-2.0,-4.5,2.8>}  
object {escalon translate <-3.3,-3.50,2.8>}
object {escalon translate <-4.8,-2.50,2.8>}

}


//notepad - libreta
#include "libreta.inc"

object {libreta scale 0.72 rotate 30*y translate<6,1.55,4.50>}//1.5y

//pen - boligrafo
#include "pen.inc"

object{pen scale 0.80 rotate 90*z translate <7.5,1.56,4.50>}


//back door - puerta de atras
#declare detras=
union{
#include "entrada.inc"
object {puerta scale 5 translate <3,2,-3>}



box
{
  <-1.60, -2, -0.05>  
  < 2.60,  5.0,  -0.10>  
  texture{NBbeerbottle}
  translate <0,0,-3.35>
}
box
{
  <-1.60, -2, -0.05>  
  < 2.60,  5.0,  -0.10>  
  texture{NBbeerbottle}
  translate <5,0,-3.35>
}
}


object{detras translate <3,2,-9>} 

//ornaments -adornos del techo
#include "stars.inc"
object{stars rotate 12*y translate <4,11,-9>}

