#include "colors.inc"

camera { location <55,40,90> look_at  <0,0,0> }      

// camera light
light_source { <55,40,90> color White*0.5 }

// Lights on ceiling
light_source { <1,60,1> color White*0.1 }

// Lights on ceiling
light_source { <10,60,00> color White*0.1 }
light_source { <10,60,20> color White*0.1 }
light_source { <10,60,40> color White*0.1 }
light_source { <10,60,60> color White*0.1 }

// Lights on ceiling
#local X=20;
#while (X<80)
	#local Y=0;
	#while (Y<80)
		light_source { <X,60,Y> color White*0.1 }
		#local Y=Y+20;
	#end
	#local X=X+20;
#end

// Lights on big sphere
#declare R1 = seed(0);
#local Count=0;
#while (Count<10)
		  light_source { <0,0,0> 
			 color White*0.2 
			 fade_distance 13
			 fade_power 20 
			 translate <7.5,7.5,7.5> 
			 rotate <(rand(R1)-rand(R1))*100,(rand(R1)-rand(R1))*100,(rand(R1)-rand(R1))*100> 
			 translate <26,33,26> 
		  }
		  #local Count=Count+1;
#end

// Lights on small sphere
#declare R1 = seed(3);
#local Count=0;
#while (Count<10)
	   light_source { <0,0,0> 
		  color White*0.1 
		  fade_distance 5
		  fade_power 20 
		  translate <3,3,3> 
		  rotate <(rand(R1)-rand(R1))*80,(rand(R1)-rand(R1))*80,(rand(R1)-rand(R1))*80> 
		  translate <26,24,26> 
	   }
	   #local Count=Count+1;
#end

// Walls
box { <0,-1,-1>,<-1,100,100> texture { pigment { color White quick_color Blue}  normal { dents .65 scale .05 } } }
box { <-1,-1,0>,<100,100,-1> texture { pigment { color White quick_color Blue}  normal { dents .65 scale .05 } } }

// Display Base
box { <20,0,20>,<35,10,35>  texture { pigment { color White quick_color Pink } } }  
box { <35+0.3,0,35>,<20-0.3,1.5,35+0.3>   texture { pigment { color White quick_color Red } finish { roughness 0 } } } 
box { <35,0,35>,<35+0.3,1.5,20-0.3>   texture { pigment { color White quick_color Red } finish { roughness 0 } } } 

// Left Bench
box { <55,0,10>,<60,4,25> texture { pigment { color White } } translate <3,0,0> }
box { <54,4,9>,<61,5,26> texture { pigment { color White } normal { crackle 10 } } translate <3,0,0> }

// Center bench
box { <55,0,-12>,<60,4,12> texture { pigment { color White } } rotate <0,-45,0> translate <5,0,5> }
box { <54,4,-13>,<61,5,13> texture { pigment { color White } normal { crackle 10 } } rotate <0,-45,0> translate <5,0,5> }

// Right bench
box { <10,0,55>,<25,4,60> texture { pigment { color White } } translate <0,0,3> }
box { <9,4,54>,<26,5,61> texture { pigment { color White } normal { crackle 10 } } translate <0,0,3> }

#include "tree.pov"

// Right Wall striping
box { <0,0,0>,<100,1.5,0.3> texture { pigment { color White quick_color Red } } } 
box { <0,0,0.3>,<100,1.5,0.3> texture { pigment { color White quick_color Red } finish { ambient 0.2 } } } 

// Left Wall striping
box { <0,0,0>,<0.3,1.5,100>   texture { pigment { color White quick_color Red } } } 
box { <0.3,0,0>,<0.3,1.5,100> texture { pigment { color White quick_color Red } finish { ambient 0.2 } } } 

// Build the floor
#local X=0;
#while (X<100)
		  #local Y=0;
		  #while (Y<100)
			  box { <0.1,0,0.1>,<4.9,0.5,4.9> 
				  texture { pigment { color White quick_color Blue } } 
				  translate <X,0,Y>
			  }	
			  #local Y=Y+5;
		  #end
		  #local X=X+5;
#end


