//  Variablen

#declare Tiefe=1;
#declare Dicke=0.5;
#declare Abschnitte=18;
#declare Abstand=(641.1-2*Tiefe-Dicke)/Abschnitte;

#declare Hoehe=0.5;
#declare Ueberstand=0.2;
#declare Einfassung=3; 

#declare Cassetteneinrueckung=Tiefe+0.1
#declare Cassettendicke=8
#declare Cassettenabstand=(641.1-2*Cassetteneinrueckung-Cassettendicke)/Abschnitte; 


// Texturen

#include "pinkmarb.map"

#declare Dmaterial3a = texture {
   pigment {
    granite
    color_map { M_PinkMarb }
    scale <0.0125,0.0125,16>
  }  rotate z*45
  finish {
    specular 0.05
    roughness 0.2
    ambient 0
    diffuse 0.1
  }
}

#declare Dmaterial3b = texture {
   pigment {
    granite
    color_map { M_PinkMarb }
    scale <0.0125,16,0.444>
  }
  finish {
    specular 0.05
    roughness 0.2
    ambient 0
    diffuse 0.1
  }
}

#declare Dmaterial3b2 = texture {
   pigment {
    granite
    color_map { M_PinkMarb }
    scale <16,0.0125,0.444>
  } rotate z*90
  finish {
    specular 0.05
    roughness 0.2
    ambient 0
    diffuse 0.1
  }
}

#declare Dmaterial3c = texture {
   pigment {
    granite
    color_map { M_PinkMarb }
    scale <0.0125,2.667,16>
  }
  finish {
    specular 0.05
    roughness 0.2
    ambient 0
    diffuse 0.1
  }
}

#declare Dmaterial3c2 = texture {
   pigment {
    granite
    color_map { M_PinkMarb }
    scale <2.667,0.0125,16>
  } rotate z*90
  finish {
    specular 0.05
    roughness 0.2
    ambient 0
    diffuse 0.1
  }
}

#declare Dmaterial3d = texture {
    normal { granite scale 40 bump_size 0.3 } rotate z*45
    pigment { rgbft <0.99,0.99,0.99,0,0> }    
    finish { ambient 0.06 diffuse 0.15 }
}


  
// senkrechte Dachplatten
#macro Dachplattex (nf)
    box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <Dicke/2, 320.55, 8.9>
    translate  <-354.7+Tiefe+Dicke/2+Abstand*nf, 234.15, 93> // von links nach rechts
    texture { Dmaterial3b2 }                                                                         
    }
#end  

#macro Dachplattey (nf)
    box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <320.55, Dicke/2, 8.9>
    translate  <-34.15, -86.4+Tiefe+Dicke/2+Abstand*nf, 93> // von vorne nach hinten
    texture { Dmaterial3b }                                                                         
    }
#end 


#declare nf=0; 
#while (nf<Abschnitte+1)
    Dachplattex (nf)
    Dachplattey (nf)
#declare nf=nf+1; #end


// obere Dachplatten

box { 
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Dmaterial3a
  }
  scale <320.55, 320.55, Hoehe/2>
  translate  <-34.15, 234.15, 102-Hoehe/2*3>
}  

box { 
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Dmaterial3a
  }
  scale <320.55+Ueberstand, 320.55+Ueberstand, Hoehe/2>
  translate  <-34.15, 234.15, 102-Hoehe/2>
}   


// untere Einfassung

box {           // vorne
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Dmaterial3c
  }
  scale <320.55, Einfassung/2, Hoehe/2>
  translate  <-34.15, -86.401+Einfassung/2, 84-Hoehe/2>
} 

box {           // hinten
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Dmaterial3c
  }
  scale <320.55, Einfassung/2, Hoehe/2>
  translate  <-34.15, 554.701-Einfassung/2, 84-Hoehe/2>
}                                                       

box {           // links
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Dmaterial3c2
  }
  scale <Einfassung/2, 320.55, Hoehe/2>
  translate  <-354.701+Einfassung/2, 234.15, 84-Hoehe/2>
}

box {           // rechts
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Dmaterial3c2
  }
  scale <Einfassung/2, 320.55, Hoehe/2>
  translate  <286.401-Einfassung/2, 234.15, 84-Hoehe/2>
}

// Cassetten
#macro Cassettenx (nf)
    box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <Cassettendicke/2, 320.55-Cassetteneinrueckung, 8.901>
    translate  <-354.7+Cassetteneinrueckung+Cassettendicke/2+Cassettenabstand*nf, 234.15, 93> // von links nach rechts
    texture { Dmaterial3d }                                                                         
    }
#end  

#macro Cassetteny (nf)
    box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <320.55-Cassetteneinrueckung, Cassettendicke/2, 8.901>
    translate  <-34.15, -86.4+Cassetteneinrueckung+Cassettendicke/2+Cassettenabstand*nf, 93> // von vorne nach hinten
    texture { Dmaterial3d }                                                                         
    }
#end  


#declare nf=0; 
#while (nf<Abschnitte+1)
    Cassettenx (nf)
    Cassetteny (nf)
#declare nf=nf+1; #end    


// Decke des Galerieinneren

box { 
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Dmaterial3d
  }
  scale <247.5, 247.5, 0.01>
  translate  <-32, 234.5, 84.098>
}  
     