//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 18 materials and 1750 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 12/30/2000    (30.12.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

Copyright 2000 by Johannes Ewers 

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.478> }

camera {  //  Camera FrontMCam
  location  <    -99.793,      36.084,       4.278>
  sky       <   -0.17007,    -0.19405,     0.96614> // Use right handed-system (rotated by 15.00 degrees)!
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.37871,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         52.74261    // Vertical      39.557
  look_at   <    -13.256,     -38.189,      -4.722>
}

//    Other cameras are commented out.
/*
camera {  //  Camera StdCam
  location  <   -280.900,     -46.580,     103.047>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <     -3.141,     -70.010,       0.643>
}

*/

/*
camera {  //  Camera SpotCam001
  location  <    -33.797,    -122.725,     284.921> // Attached to sunlight
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.41082,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         66.79927    // Vertical      50.099
  look_at   <    -11.937,     -96.487,     101.783> // Following sunlight
}

*/

//
// *******  L I G H T S *******
//

light_source {   // supportsun
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.8000
  media_interaction off
  translate  <-29.423147, -122.956201, 285.48377>
}

light_source {   // Spotlight sunlight
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.5000
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    26.314  // outer radius (in deg)
    radius     22.894  // inner radius
    tightness  0.000
  fade_distance  200.0
  fade_power 1.0
  media_attenuation on
  scale 186.294876
  rotate <10.224253, -2.668111, -25.328064>
  translate  <-33.797182, -122.725184, 284.921173>
}

light_source {   // supportlight1
  <0.0, 0.0, 0.0>
  color rgb <0.671, 0.629, 0.886>*0.3000
  media_interaction off
  translate  <-17.534546, -74.576349, -193.851695>
}


//
// ********  MATERIALS  *******
//

#include "nautilus.inc"


//
// ********  REFERENCED OBJECTS  *******
//

// The following include file contains the definition for Zahn01
#include "nautilus.in1"
#declare Zahn01 = object {
  Zahn01_Raw
  rotate <-0.0, -0.0, -0.0>
  translate  <-0.013748, 0.025933, -0.011171>
  material {
    hullMskinMzahn
  }
  scale <1.0, 1.0, 7.0>
  rotate <-284.059845, -224.629471, -189.97818>
  translate  <0.028133, -45.857273, 19.253489>
}
#declare Zahn02 = object {
  object { // Zahn02->Zahn01
    Zahn01
    rotate <-12.231002, -0.0, -0.0>
    translate  <0.0, -0.172626, -9.699013>
  }
}
#declare Zahn03 = object {
  object { // Zahn03->Zahn02
    Zahn02
    rotate <-8.851248, 0.0, -0.0>
    translate  <0.0, 1.690411, -7.895375>
  }
}
#declare Zahn08 = object {
  object { // Zahn08->Zahn01
    Zahn01
    scale <1.0, 1.299493, 1.0>
    rotate <-13.448291, -0.0, -0.0>
    translate  <0.0, 37.128245, -26.093638>
  }
}
// The following include file contains the definition for Zahn24
#include "nautilus.in2"
#declare Zahn24 = object {
  Zahn24_Raw
  rotate <-0.0, -0.0, -0.0>
  translate  <-0.013748, 0.025933, -0.011171>
  material {
    hullMskinMzahn
  }
  scale <1.0, 1.0, 7.0>
  rotate <-277.398224, -225.261261, -185.269531>
  translate  <0.028133, -47.156628, 13.585672>
}
// The following include file contains the definition for Zahn35
#include "nautilus.in3"
#declare Zahn35 = object {
  Zahn35_Raw
  rotate <-0.0, -0.0, -0.0>
  translate  <-0.013748, 0.025933, -0.011171>
  material {
    hullMskinMzahn
  }
  scale <0.8, 0.8, 5.0>
  rotate <-105.764191, 44.402512, -11.173172>
  translate  <0.028133, -94.253883, 19.233651>
}
#declare Sphere002 = object {
  sphere { // Sphere002
    <0,0,0>,1
    material {
      hullMskinMzahn
    }
    scale <1.36349, 0.096505, 3.269991>
    rotate 33.645016*z
    translate  <-0.024604, -0.184534, 3.597621>
  }
}
// The following include file contains the definition for Zahn39
#include "nautilus.in4"
#declare Zahn39 = object {
  Zahn39_Raw
  rotate <-0.0, -0.0, -0.0>
  translate  <-0.013748, 0.025933, -0.011171>
  material {
    hullMskinMzahn
  }
  scale <1.950265, 4.027669, 0.612495>
  rotate <-172.9888, 0.0, -0.0>
  translate  <0.028133, -61.739169, 15.841439>
}
#declare Zahn40 = object {
  object { // Zahn40->Zahn39
    Zahn39
    rotate <-0.0, -0.0, -0.0>
    translate  <-0.0, -2.7489, -0.374335>
  }
}
#declare Zahn41 = object {
  object { // Zahn41->Zahn40
    Zahn40
    rotate 0.0*x
    translate  <0.0, -2.870669, -0.287067>
  }
}
#declare Zahn42 = object {
  object { // Zahn42->Zahn41
    Zahn41
    rotate -0.0*x
    translate  <0.0, -2.760258, -0.397477>
  }
}
#declare Zahn43 = object {
  object { // Zahn43->Zahn42
    Zahn42
    scale <0.9, 1.0, 1.0>
    rotate -0.0*x
    translate  <0.0, -3.096631, -0.309149>
  }
}
#declare Zahn44 = object {
  object { // Zahn44->Zahn43
    Zahn43
    scale <0.9, 1.0, 1.0>
    rotate -0.0*x
    translate  <0.0, -3.230097, -0.4365>
  }
}
// Include contains 'TransSweep001'
#include "nautilus.in5"

#declare TransSweep001 = object {
  TransSweep001_Raw
  material {
    hullMskinMparts
  }
  rotate <90.0, 0.0, -90.0>
  translate  <-0.110494, -0.0, 0.0>
}
#declare Fensterbasis = union {
  cone { // Cone009
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.2, 0.2, 1.0>
    rotate -90.0*y
    translate  <0.0, -0.555937, -0.731233>
  }
  cone { // Cone008
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.2, 0.2, 1.0>
    rotate -90.0*y
    translate  <0.0, 0.560946, -0.731233>
  }
  cone { // Cone007
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.2, 0.2, 1.0>
    rotate -90.0*y
    translate  <0.0, -0.200338, -0.886495>
  }
  cone { // Cone006
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.2, 0.2, 1.0>
    rotate -90.0*y
    translate  <0.0, 0.210355, -0.886495>
  }
  cone { // Cone005
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.2, 0.2, 1.0>
    rotate -90.0*y
    translate  <0.0, 0.465785, 0.816377>
  }
  cone { // Cone004
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.2, 0.2, 1.0>
    rotate -90.0*y
    translate  <0.0, -0.475802, 0.816377>
  }
  cone { // Cone003
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.0>
    rotate -90.0*y
    translate  -1.106866*y
  }
  cone { // Cone002
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <0.4, 0.4, 1.0>
    rotate -90.0*y
    translate  1.106866*y
  }
  cone { // Cone001
    <0,0,0>, 0.8, <0,0,1>, 1.0
    rotate -90.0*y
  }
  object { TransSweep001 }
  material {
    hullMskinMstandard
  }
  scale <8.074427, 5.0, 5.0>
  rotate 180.0*z
  translate  <-13.251982, -75.309326, 0.0>
}
#declare CSG012 = intersection {
  torus { // Torus003
    1.05, 0.05  rotate -x*90
    material {
      hullMskinMzahn
    }
    rotate -90.0*x
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    material {
      hullMskinMzahn
    }
    scale <0.666827, 1.009613, 1.163172>
    translate  0.676507*x
  }
}
#declare CSG015 = union {
  torus { // Torus004
    1.075, 0.075  rotate -x*90
    material {
      hullMskinMzahn
    }
    scale <0.5, 0.499998, 1.0>
    translate  <0.0, 0.0, 0.926976>
  }
  object { // CSG014->CSG012
    CSG012
    rotate 120.0*z
  }
  object { // CSG013->CSG012
    CSG012
    rotate -120.0*z
  }
  object { CSG012 }
}
#declare CSG016 = difference {
  object { CSG015 }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <0.5, 0.5, 1.5>
    translate  -0.279883*z
  }
}
#declare hauptfenster = union {
  object { CSG016 }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    material {
      fensterlicht
    }
    scale <1.0, 1.0, 0.1>
    translate  -0.05*z
  }
  sphere { // Sphere016
    <0,0,0>,1
    material {
      fensterglas
    }
    scale 1.05
  }
  scale <3.470879, 3.470879, 1.7>
  rotate -90.0*y
  translate  <-13.290489, -75.211637, 0.0>
}
#declare fenstergruppeMlinks = union {
  object { Fensterbasis }
  sphere { // lampeMunten4
    <0,0,0>,1
    material {
      scheinwerferlicht
    }
    scale <0.18, 0.6, 0.6>
    translate  <-13.248593, -78.114225, -3.651566>
  }
  sphere { // lampeMunten3
    <0,0,0>,1
    material {
      scheinwerferlicht
    }
    scale <0.18, 0.6, 0.6>
    translate  <-13.248593, -76.364352, -4.431212>
  }
  sphere { // lampeMunten2
    <0,0,0>,1
    material {
      scheinwerferlicht
    }
    scale <0.18, 0.6, 0.6>
    translate  <-13.248593, -74.314171, -4.431212>
  }
  sphere { // lampeMunten1
    <0,0,0>,1
    material {
      scheinwerferlicht
    }
    scale <0.18, 0.6, 0.6>
    translate  <-13.248593, -72.529648, -3.640015>
  }
  sphere { // lampeMrechtsMoben
    <0,0,0>,1
    material {
      scheinwerferlicht
    }
    scale <0.18, 0.6, 0.6>
    translate  <-13.248593, -77.660038, 4.095392>
  }
  sphere { // lampeMlinksMoben
    <0,0,0>,1
    material {
      scheinwerferlicht
    }
    scale <0.18, 0.6, 0.6>
    translate  <-13.248593, -72.931815, 4.095392>
  }
  sphere { // lampeMrechts
    <0,0,0>,1
    material {
      scheinwerferlicht
    }
    scale <0.4, 1.333333, 1.333333>
    translate  <-13.243154, -80.841236, 0.0>
  }
  sphere { // lampeMlinks
    <0,0,0>,1
    material {
      scheinwerferlicht
    }
    scale <0.4, 1.333333, 1.333333>
    translate  <-13.243154, -69.77261, 0.0>
  }
  object { hauptfenster }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <1.290005, 2.651998, 0.165079>
    translate  <-13.075036, -75.132437, -2.412025>
  }
}




//
// ********  OBJECTS  *******
//





disc { // Wasseroberflaehe
  <0,0,0>, <0,0,1>, 1.0
  material {
    wasseroberflaehe
  }
  hollow
  scale <300.0, 300.0, 1.0>
  translate  233.427438*z
}


cylinder { // Wassermedium
  <0,0,1>, <0,0,0>, 1 
  material {
    WasserMmedium
  }
  hollow
  scale <550.0, 513.307495, 633.074829>
  translate  -435.655746*z
}


#declare oktobody = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.247849, 0.000000, 0.000000>, <-1.247849, -0.629457, 0.000000>, <-0.686317, -1.144467, 0.000000>, <0.000000, -1.144467, 0.000000>, 
      <-1.181854, 0.000000, 0.713965>, <-1.181854, -0.531471, 0.713965>, <-0.650020, -0.966311, 0.713965>, <0.000000, -0.966311, 0.713965>, 
      <-1.987334, 0.000000, 1.358717>, <-1.987334, -0.212385, 1.358717>, <-0.832040, -1.729735, 1.392843>, <0.000000, -1.729735, 1.392843>, 
      <-2.117816, 0.000000, 2.038075>, <-2.117816, -0.207195, 2.038075>, <-0.929909, -1.729735, 2.089265>, <0.000000, -1.729735, 2.119670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.144467, 0.000000>, <0.686317, -1.144467, 0.000000>, <1.247849, -0.629457, 0.000000>, <1.247849, 0.000000, 0.000000>, 
      <0.000000, -0.966311, 0.713965>, <0.650020, -0.966311, 0.713965>, <1.181854, -0.531471, 0.713965>, <1.181854, 0.000000, 0.713965>, 
      <0.000000, -1.729735, 1.392843>, <0.832040, -1.729735, 1.392843>, <1.987334, -0.212385, 1.358717>, <1.987334, 0.000000, 1.358717>, 
      <0.000000, -1.729735, 2.119670>, <0.929909, -1.770276, 2.150076>, <2.117816, -0.207195, 2.038075>, <2.117816, 0.000000, 2.038075>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.247849, 0.000000, 0.000000>, <1.247849, 0.629457, 0.000000>, <0.686317, 1.144467, 0.000000>, <0.000000, 1.144467, 0.000000>, 
      <1.181854, 0.000000, 0.713965>, <1.181854, 0.531471, 0.713965>, <0.650020, 0.966311, 0.713965>, <0.000000, 0.966311, 0.713965>, 
      <1.987334, 0.000000, 1.358717>, <1.987334, 0.212385, 1.358717>, <0.832040, 1.729735, 1.392843>, <0.000000, 1.729735, 1.392843>, 
      <2.117816, 0.000000, 2.038075>, <2.117816, 0.207195, 2.038075>, <0.929909, 1.729735, 2.089265>, <0.000000, 1.729735, 2.089265>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.144467, 0.000000>, <-0.686317, 1.144467, 0.000000>, <-1.247849, 0.629457, 0.000000>, <-1.247849, 0.000000, 0.000000>, 
      <0.000000, 0.966311, 0.713965>, <-0.650020, 0.966311, 0.713965>, <-1.181854, 0.531471, 0.713965>, <-1.181854, 0.000000, 0.713965>, 
      <0.000000, 1.729735, 1.392843>, <-0.832040, 1.729735, 1.392843>, <-1.987334, 0.212385, 1.358717>, <-1.987334, 0.000000, 1.358717>, 
      <0.000000, 1.729735, 2.089265>, <-0.929909, 1.729735, 2.089265>, <-2.117816, 0.207195, 2.038075>, <-2.117816, 0.000000, 2.038075>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.117816, 0.000000, 2.038075>, <-2.117816, -0.207195, 2.038075>, <-0.929909, -1.729735, 2.089265>, <0.000000, -1.729735, 2.119670>, 
      <-2.248299, 0.000000, 2.717434>, <-2.248299, -0.202004, 2.717434>, <-1.027778, -1.729735, 2.785686>, <0.000000, -1.770276, 2.846498>, 
      <-2.248299, 0.214939, 3.444087>, <-2.248299, 0.014809, 3.450625>, <-1.027778, -1.493346, 3.586577>, <0.000000, -1.533887, 3.586577>, 
      <-1.820304, 0.383013, 4.021565>, <-1.820304, 0.204065, 4.029782>, <-1.091117, -0.931515, 4.132155>, <0.000000, -0.982191, 4.152425>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.729735, 2.119670>, <0.929909, -1.770276, 2.150076>, <2.117816, -0.207195, 2.038075>, <2.117816, 0.000000, 2.038075>, 
      <0.000000, -1.770276, 2.846498>, <1.027778, -1.810817, 2.907309>, <2.248299, -0.202004, 2.717434>, <2.248299, 0.000000, 2.717434>, 
      <0.000000, -1.533887, 3.586577>, <1.027778, -1.574428, 3.586577>, <2.248299, 0.014809, 3.450625>, <2.248299, 0.214939, 3.444087>, 
      <0.000000, -0.982191, 4.152425>, <1.091117, -1.032868, 4.172696>, <1.856021, 0.203137, 4.022041>, <1.856021, 0.382086, 4.013824>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.117816, 0.000000, 2.038075>, <2.117816, 0.207195, 2.038075>, <0.929909, 1.729735, 2.089265>, <0.000000, 1.729735, 2.089265>, 
      <2.248299, 0.000000, 2.717434>, <2.248299, 0.202004, 2.717434>, <1.027778, 1.729735, 2.785686>, <0.000000, 1.729735, 2.785686>, 
      <2.248299, 0.214939, 3.444087>, <2.248299, 0.415068, 3.437549>, <1.027778, 1.934021, 3.474604>, <0.000000, 1.934021, 3.474604>, 
      <1.856021, 0.382086, 4.013824>, <1.856021, 0.561034, 4.005606>, <1.091117, 1.705430, 4.018254>, <0.000000, 1.705430, 4.018254>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.729735, 2.089265>, <-0.929909, 1.729735, 2.089265>, <-2.117816, 0.207195, 2.038075>, <-2.117816, 0.000000, 2.038075>, 
      <0.000000, 1.729735, 2.785686>, <-1.027778, 1.729735, 2.785686>, <-2.248299, 0.202004, 2.717434>, <-2.248299, 0.000000, 2.717434>, 
      <0.000000, 1.934021, 3.474604>, <-1.027778, 1.934021, 3.474604>, <-2.248299, 0.415068, 3.437549>, <-2.248299, 0.214939, 3.444087>, 
      <0.000000, 1.705430, 4.018254>, <-1.091117, 1.705430, 4.018254>, <-1.820304, 0.561962, 4.013348>, <-1.820304, 0.383013, 4.021565>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.820304, 0.383013, 4.021565>, <-1.820304, 0.204065, 4.029782>, <-1.091117, -0.931515, 4.132155>, <0.000000, -0.982191, 4.152425>, 
      <-1.392309, 0.551088, 4.599043>, <-1.392309, 0.393320, 4.608939>, <-1.154456, -0.369684, 4.677733>, <0.000000, -0.430496, 4.718274>, 
      <-1.231589, 1.003715, 5.165399>, <-1.231589, 0.611297, 5.205317>, <-0.677374, 0.290228, 5.237977>, <0.000000, 0.290228, 5.237977>, 
      <-0.029381, 1.655384, 6.145809>, <-0.029381, 1.644473, 6.147347>, <-0.016160, 1.635547, 6.148606>, <0.000000, 1.635547, 6.148606>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.982191, 4.152425>, <1.091117, -1.032868, 4.172696>, <1.856021, 0.203137, 4.022041>, <1.856021, 0.382086, 4.013824>, 
      <0.000000, -0.430496, 4.718274>, <1.154456, -0.491307, 4.758815>, <1.463742, 0.391465, 4.593457>, <1.463742, 0.549232, 4.583560>, 
      <0.000000, 0.290228, 5.237977>, <0.677374, 0.290228, 5.237977>, <1.231589, 0.611297, 5.205317>, <1.231589, 1.003715, 5.165399>, 
      <0.000000, 1.635547, 6.148606>, <0.016160, 1.635547, 6.148606>, <0.029381, 1.644473, 6.147347>, <0.029381, 1.655384, 6.145809>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.856021, 0.382086, 4.013824>, <1.856021, 0.561034, 4.005606>, <1.091117, 1.705430, 4.018254>, <0.000000, 1.705430, 4.018254>, 
      <1.463742, 0.549232, 4.583560>, <1.463742, 0.707000, 4.573664>, <1.154456, 1.476838, 4.561903>, <0.000000, 1.476838, 4.561903>, 
      <1.231589, 1.003715, 5.165399>, <1.231589, 1.396133, 5.125481>, <0.677374, 1.717202, 5.092821>, <0.000000, 1.717202, 5.092821>, 
      <0.029381, 1.655384, 6.145809>, <0.029381, 1.666294, 6.144271>, <0.016160, 1.675221, 6.143012>, <0.000000, 1.675221, 6.143012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.705430, 4.018254>, <-1.091117, 1.705430, 4.018254>, <-1.820304, 0.561962, 4.013348>, <-1.820304, 0.383013, 4.021565>, 
      <0.000000, 1.476838, 4.561903>, <-1.154456, 1.476838, 4.561903>, <-1.392309, 0.708855, 4.589146>, <-1.392309, 0.551088, 4.599043>, 
      <0.000000, 1.717202, 5.092821>, <-0.677374, 1.717202, 5.092821>, <-1.231589, 1.396133, 5.125481>, <-1.231589, 1.003715, 5.165399>, 
      <0.000000, 1.675221, 6.143012>, <-0.016160, 1.675221, 6.143012>, <-0.029381, 1.666294, 6.144271>, <-0.029381, 1.655384, 6.145809>
    }
  }
  scale <2.606896, 2.8, 2.606896>
  rotate -180.0*z
  translate  4.486321*z
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare CSG021 = union {
  cylinder { // oktomitte
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 6.0>
    translate  -1.244747*z
    material {
      oktoMskinMaussen
      // Transform to world space
      translate  -1.244747*z
      translate  <12.127279, 18.190885, 4.082331>
      rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
      scale 1.0/2.5
    }
  }
  torus { // Torus079
    1.5, 0.5  rotate -x*90
    scale 0.6
    rotate <-90.0, 0.0, -44.486275>
    translate  <1.65824, 2.276242, 1.782304>
  }
  torus { // Torus078
    1.35, 0.35  rotate -x*90
    scale 0.6
    rotate <-90.0, -0.0, 129.545105>
    translate  <1.864712, 2.441192, 1.782304>
  }
  torus { // Torus077
    1.25, 0.25  rotate -x*90
    scale 0.6
    rotate <-90.0, -0.0, 119.005203>
    translate  <2.013856, 2.439868, 1.782304>
  }
  torus { // Torus080
    1.5, 0.5  rotate -x*90
    scale 0.6
    rotate <90.0, -0.0, -133.400818>
    translate  <-1.760175, 2.183472, 1.782304>
  }
  torus { // Torus081
    1.35, 0.35  rotate -x*90
    scale 0.6
    rotate <90.0, 0.0, 52.567795>
    translate  <-1.972588, 2.340698, 1.782304>
  }
  torus { // Torus082
    1.25, 0.25  rotate -x*90
    scale 0.6
    rotate <90.0, 0.0, 63.107697>
    translate  <-2.121582, 2.333876, 1.782304>
  }
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  -1.244747*z
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare CSG018 = difference {
  sphere { // Sphere042
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    material {
      eyeMblack
    }
    scale 1.278884
    translate  -1.282059*z
  }
  rotate <180.0, -1.0, 180.0>
  translate  -0.3*z
}
#declare CSG017 = difference {
  sphere { // Sphere041
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    material {
      eyeMblack
    }
    scale 1.278884
    translate  -1.282059*z
  }
  rotate -10.0*y
  translate  -0.1*z
}
#declare oktoMeyeMlinks = union {
  sphere { // Sphere043
    <0,0,0>,1
    material {
      eyeMblack
    }
    scale 0.9
    translate  -0.174826*z
  }
  object { CSG018 }
  object { CSG017 }
  scale <0.6, 0.88283, 0.564646>
  rotate <-90.0, 0.0, 25.37936>
  translate  <1.734331, 2.436669, 1.780516>
}
#declare CSG019 = difference {
  sphere { // Sphere045
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    material {
      eyelidMskin
    }
    scale 1.278884
    translate  -1.282059*z
  }
  rotate <180.0, -1.541672, 180.0>
  translate  -0.320515*z
}
#declare CSG020 = difference {
  sphere { // Sphere046
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    material {
      eyelidMskin
    }
    scale 1.278884
    translate  -1.282059*z
  }
  rotate -3.352657*y
}
#declare oktoMeyeMrechts = union {
  sphere { // Sphere044
    <0,0,0>,1
    material {
      eyeMblack
    }
    scale 0.9
    translate  -0.174826*z
  }
  object { CSG019 }
  object { CSG020 }
  scale <0.6, 0.88283, 0.564646>
  rotate <90.0, 0.0, 165.733536>
  translate  <-1.980623, 2.358517, 1.782304>
}
#declare oktobasis = union {
  object { CSG021 }
  object { oktoMeyeMlinks }
  object { oktoMeyeMrechts }
  translate  1.244747*z
}
#declare saugnapf60 = union {
  torus { // Torus065
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf61 = union {
  torus { // Torus066
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf62 = union {
  torus { // Torus067
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf63 = union {
  torus { // Torus068
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf64 = union {
  torus { // Torus069
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf65 = union {
  torus { // Torus070
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe10 = union {
  object { saugnapf60 }
  object { saugnapf61 }
  object { saugnapf62 }
  object { saugnapf63 }
  object { saugnapf64 }
  object { saugnapf65 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf66 = union {
  torus { // Torus071
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf67 = union {
  torus { // Torus072
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf68 = union {
  torus { // Torus073
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf69 = union {
  torus { // Torus074
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf70 = union {
  torus { // Torus075
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf71 = union {
  torus { // Torus076
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe11 = union {
  object { saugnapf66 }
  object { saugnapf67 }
  object { saugnapf68 }
  object { saugnapf69 }
  object { saugnapf70 }
  object { saugnapf71 }
}
#declare armteilaussen5 = union {
  sphere { // Sphere037
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere038
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone020
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.061007, 0.0, 11.846591>
    rotate -240.498795*z rotate 211.762161*y rotate 223.550461*x
    scale 1.0/0.32768
    translate  <-0.177544, 0.0, 5.043157>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate -19.796301*z rotate 43.407394*y rotate -23.575901*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate -21.547167*y
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -3.84893*z rotate -1.32569*y rotate -8.794429*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -13.370002*y
    translate  <-0.230349, 0.0, 0.024247>
    translate  2.5*x
    rotate -12.05905*y
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen5 = union {
  sphere { // Sphere039
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere040
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
    scale 0.8
  }
  cone { // Cone021
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil5 = union {
  object { saugreihe10 }
  object { saugreihe11 }
  object { armteilaussen5 }
  object { armteilinnen5 }
  rotate -0.0*y
  translate  <0.177544, 0.0, -5.043157>
  scale 0.32768
  rotate <-223.550461, -211.762161, 240.498795>
  translate  <-0.061007, 0.0, -11.846591>
}
#declare saugnapf48 = union {
  torus { // Torus053
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf49 = union {
  torus { // Torus054
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf50 = union {
  torus { // Torus055
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf51 = union {
  torus { // Torus056
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf52 = union {
  torus { // Torus057
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf53 = union {
  torus { // Torus058
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe8 = union {
  object { saugnapf48 }
  object { saugnapf49 }
  object { saugnapf50 }
  object { saugnapf51 }
  object { saugnapf52 }
  object { saugnapf53 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf54 = union {
  torus { // Torus059
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf55 = union {
  torus { // Torus060
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf56 = union {
  torus { // Torus061
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf57 = union {
  torus { // Torus062
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf58 = union {
  torus { // Torus063
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf59 = union {
  torus { // Torus064
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe9 = union {
  object { saugnapf54 }
  object { saugnapf55 }
  object { saugnapf56 }
  object { saugnapf57 }
  object { saugnapf58 }
  object { saugnapf59 }
}
#declare armteilaussen4 = union {
  sphere { // Sphere033
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere034
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone018
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.063949, 0.0, 9.800106>
    scale 1.0/0.4096
    translate  <-0.156126, 0.0, 5.027255>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate -19.796301*z rotate 43.407394*y rotate -23.575901*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate -21.547167*y
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -3.84893*z rotate -1.32569*y rotate -8.794429*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -13.370002*y
    translate  <-0.230349, 0.0, 0.024247>
    translate  2.5*x
    rotate -12.05905*y
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen4 = union {
  sphere { // Sphere035
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere036
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone019
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil4 = union {
  object { saugreihe8 }
  object { saugreihe9 }
  object { armteilaussen4 }
  object { armteilinnen4 }
  rotate -0.0*y
  translate  <0.156126, 0.0, -5.027255>
  scale 0.4096
  translate  <-0.063949, 0.0, -9.800106>
}
#declare tentaka = union {
  object { armteil5 }
  object { armteil4 }
  rotate -0.0*y
  translate  <0.083933, 0.0, 9.820163>
  rotate <23.575901, -43.407394, 19.796301>
  translate  <-0.083933, 0.0, -9.820163>
}
#declare saugnapf36 = union {
  torus { // Torus041
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf37 = union {
  torus { // Torus042
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf38 = union {
  torus { // Torus043
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf39 = union {
  torus { // Torus044
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf40 = union {
  torus { // Torus045
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf41 = union {
  torus { // Torus046
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe6 = union {
  object { saugnapf36 }
  object { saugnapf37 }
  object { saugnapf38 }
  object { saugnapf39 }
  object { saugnapf40 }
  object { saugnapf41 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf42 = union {
  torus { // Torus047
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf43 = union {
  torus { // Torus048
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf44 = union {
  torus { // Torus049
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf45 = union {
  torus { // Torus050
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf46 = union {
  torus { // Torus051
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf47 = union {
  torus { // Torus052
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe7 = union {
  object { saugnapf42 }
  object { saugnapf43 }
  object { saugnapf44 }
  object { saugnapf45 }
  object { saugnapf46 }
  object { saugnapf47 }
}
#declare armteilaussen3 = union {
  sphere { // Sphere029
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere030
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone016
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.095217, 0.0, 7.227235>
    scale 1.0/0.512
    translate  <-0.162371, 0.0, 5.033499>
    translate  <0.083933, 0.0, 7.232228>
    rotate -21.547167*y
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -3.84893*z rotate -1.32569*y rotate -8.794429*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -13.370002*y
    translate  <-0.230349, 0.0, 0.024247>
    translate  2.5*x
    rotate -12.05905*y
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen3 = union {
  sphere { // Sphere031
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere032
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone017
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil3 = union {
  object { saugreihe6 }
  object { saugreihe7 }
  object { armteilaussen3 }
  object { armteilinnen3 }
  translate  <0.162371, 0.0, -5.033499>
  scale 0.512
  translate  <-0.095217, 0.0, -7.227235>
}
#declare tentakb = union {
  object { tentaka }
  object { armteil3 }
  rotate 0.0*y
  translate  <0.083933, 0.0, 7.232228>
  rotate 21.547167*y
  translate  <-0.083933, 0.0, -7.232228>
}
#declare saugnapf24 = union {
  torus { // Torus029
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf25 = union {
  torus { // Torus030
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf26 = union {
  torus { // Torus031
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf27 = union {
  torus { // Torus032
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf28 = union {
  torus { // Torus033
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf29 = union {
  torus { // Torus034
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe4 = union {
  object { saugnapf24 }
  object { saugnapf25 }
  object { saugnapf26 }
  object { saugnapf27 }
  object { saugnapf28 }
  object { saugnapf29 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf30 = union {
  torus { // Torus035
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf31 = union {
  torus { // Torus036
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf32 = union {
  torus { // Torus037
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf33 = union {
  torus { // Torus038
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf34 = union {
  torus { // Torus039
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf35 = union {
  torus { // Torus040
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe5 = union {
  object { saugnapf30 }
  object { saugnapf31 }
  object { saugnapf32 }
  object { saugnapf33 }
  object { saugnapf34 }
  object { saugnapf35 }
}
#declare armteilaussen2 = union {
  sphere { // Sphere025
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere026
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone014
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.193325, 0.0, 4.006921>
    scale 1.0/0.64
    translate  <-0.283191, 0.0, 5.040802>
    rotate 0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -3.84893*z rotate -1.32569*y rotate -8.794429*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -13.370002*y
    translate  <-0.230349, 0.0, 0.024247>
    translate  2.5*x
    rotate -12.05905*y
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen2 = union {
  sphere { // Sphere027
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere028
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone015
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil2 = union {
  object { saugreihe4 }
  object { saugreihe5 }
  object { armteilaussen2 }
  object { armteilinnen2 }
  rotate -0.0*y
  translate  <0.283191, 0.0, -5.040802>
  scale 0.64
  translate  <-0.193325, 0.0, -4.006921>
}
#declare tentakc = union {
  object { tentakb }
  object { armteil2 }
  translate  <0.223821, 0.0, 4.014796>
  rotate <8.794429, 1.32569, 3.84893>
  translate  <-0.223821, 0.0, -4.014796>
}
#declare saugnapf12 = union {
  torus { // Torus017
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf13 = union {
  torus { // Torus018
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf14 = union {
  torus { // Torus019
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf15 = union {
  torus { // Torus020
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf16 = union {
  torus { // Torus021
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf17 = union {
  torus { // Torus022
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe2 = union {
  object { saugnapf12 }
  object { saugnapf13 }
  object { saugnapf14 }
  object { saugnapf15 }
  object { saugnapf16 }
  object { saugnapf17 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf18 = union {
  torus { // Torus023
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf19 = union {
  torus { // Torus024
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf20 = union {
  torus { // Torus025
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf21 = union {
  torus { // Torus026
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf22 = union {
  torus { // Torus027
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf23 = union {
  torus { // Torus028
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe3 = union {
  object { saugnapf18 }
  object { saugnapf19 }
  object { saugnapf20 }
  object { saugnapf21 }
  object { saugnapf22 }
  object { saugnapf23 }
}
#declare armteilaussen1 = union {
  sphere { // Sphere021
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere022
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone012
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.205408, 0.0, 0.007886>
    scale 1.0/0.8
    translate  <-0.25676, 0.0, 5.014371>
    translate  <0.230349, 0.0, -0.024247>
    rotate -13.370002*y
    translate  <-0.230349, 0.0, 0.024247>
    translate  2.5*x
    rotate -12.05905*y
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen1 = union {
  sphere { // Sphere023
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere024
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone013
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil1 = union {
  object { saugreihe2 }
  object { saugreihe3 }
  object { armteilaussen1 }
  object { armteilinnen1 }
  translate  <0.25676, 0.0, -5.014371>
  scale 0.8
  translate  <-0.205408, 0.0, -0.007886>
}
#declare tentakd = union {
  object { tentakc }
  object { armteil1 }
  translate  <0.230349, 0.0, -0.024247>
  rotate 13.370002*y
  translate  <-0.230349, 0.0, 0.024247>
}
#declare saugnapf6 = union {
  torus { // Torus011
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf7 = union {
  torus { // Torus012
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf8 = union {
  torus { // Torus013
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf9 = union {
  torus { // Torus014
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf10 = union {
  torus { // Torus015
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf11 = union {
  torus { // Torus016
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe1 = union {
  object { saugnapf6 }
  object { saugnapf7 }
  object { saugnapf8 }
  object { saugnapf9 }
  object { saugnapf10 }
  object { saugnapf11 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf5 = union {
  torus { // Torus010
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf4 = union {
  torus { // Torus009
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf3 = union {
  torus { // Torus008
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf2 = union {
  torus { // Torus007
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf1 = union {
  torus { // Torus006
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf = union {
  torus { // Torus005
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe = union {
  object { saugnapf5 }
  object { saugnapf4 }
  object { saugnapf3 }
  object { saugnapf2 }
  object { saugnapf1 }
  object { saugnapf }
}
#declare armteilaussen = union {
  sphere { // Sphere019
    <0,0,0>,1
    scale <1.003325, 1.482848, 1.228788>
    translate  5.0*z
    material {
      oktoMskinMaussen
      // Transform to world space
      translate  0.25*x
      rotate 0.647847*y
      scale <1.0/0.777959, 1.0/1.184654, 1.0/1.0>
      translate  <0.281548, 0.0, -4.951811>
      translate  <-0.281548, 0.0, 4.951811>
      translate  2.5*x
      rotate -12.05905*y
      translate  <-0.262187, 0.0, 4.977383>
      rotate 0.0*y
      translate  <12.127279, 18.190885, 4.082331>
      rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
      scale 1.0/2.5
    }
  }
  sphere { // Sphere020
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone011
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.281548, 0.0, -4.951811>
    translate  <-0.281548, 0.0, 4.951811>
    translate  2.5*x
    rotate -12.05905*y
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen = union {
  sphere { // Sphere018
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere017
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone010
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil = union {
  object { saugreihe1 }
  object { saugreihe }
  object { armteilaussen }
  object { armteilinnen }
  translate  <0.281548, 0.0, -4.951811>
  translate  <-0.281548, 0.0, 4.951811>
}
#declare tentakel = union {
  object { tentakd }
  object { armteil }
  rotate -0.0*y
  translate  <0.262187, 0.0, -4.977383>
  rotate 12.05905*y
  translate  -2.5*x
}
#declare saugnapf72 = union {
  torus { // Torus083
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf73 = union {
  torus { // Torus084
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf74 = union {
  torus { // Torus085
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf75 = union {
  torus { // Torus086
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf76 = union {
  torus { // Torus087
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf77 = union {
  torus { // Torus088
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe12 = union {
  object { saugnapf72 }
  object { saugnapf73 }
  object { saugnapf74 }
  object { saugnapf75 }
  object { saugnapf76 }
  object { saugnapf77 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf78 = union {
  torus { // Torus089
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf79 = union {
  torus { // Torus090
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf80 = union {
  torus { // Torus091
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf81 = union {
  torus { // Torus092
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf82 = union {
  torus { // Torus093
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf83 = union {
  torus { // Torus094
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe13 = union {
  object { saugnapf78 }
  object { saugnapf79 }
  object { saugnapf80 }
  object { saugnapf81 }
  object { saugnapf82 }
  object { saugnapf83 }
}
#declare armteilaussen6 = union {
  sphere { // Sphere047
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere048
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone022
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.061007, 0.0, 11.846591>
    rotate 150.102402*z rotate 221.232269*y rotate 146.286209*x
    scale 1.0/0.32768
    translate  <-0.177544, 0.0, 5.043157>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate 3.469915*z rotate 17.306194*y rotate -18.275087*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate -129.522598*z rotate 146.015564*y rotate 176.503632*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 140.601028*z rotate 148.051086*y rotate -205.36409*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 340.930603*z rotate 149.874374*y rotate -223.204849*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <1.767767, -1.767767, 0.0>
    rotate 201.228989*z rotate 208.084503*y rotate 155.019394*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen6 = union {
  sphere { // Sphere049
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere050
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
    scale 0.8
  }
  cone { // Cone023
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil6 = union {
  object { saugreihe12 }
  object { saugreihe13 }
  object { armteilaussen6 }
  object { armteilinnen6 }
  rotate -0.0*y
  translate  <0.177544, 0.0, -5.043157>
  scale 0.32768
  rotate <-146.286209, -221.232269, -150.102402>
  translate  <-0.061007, 0.0, -11.846591>
}
#declare saugnapf84 = union {
  torus { // Torus095
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf85 = union {
  torus { // Torus096
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf86 = union {
  torus { // Torus097
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf87 = union {
  torus { // Torus098
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf88 = union {
  torus { // Torus099
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf89 = union {
  torus { // Torus100
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe14 = union {
  object { saugnapf84 }
  object { saugnapf85 }
  object { saugnapf86 }
  object { saugnapf87 }
  object { saugnapf88 }
  object { saugnapf89 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf90 = union {
  torus { // Torus101
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf91 = union {
  torus { // Torus102
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf92 = union {
  torus { // Torus103
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf93 = union {
  torus { // Torus104
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf94 = union {
  torus { // Torus105
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf95 = union {
  torus { // Torus106
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe15 = union {
  object { saugnapf90 }
  object { saugnapf91 }
  object { saugnapf92 }
  object { saugnapf93 }
  object { saugnapf94 }
  object { saugnapf95 }
}
#declare armteilaussen7 = union {
  sphere { // Sphere051
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere052
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone024
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.063949, 0.0, 9.800106>
    scale 1.0/0.4096
    translate  <-0.156126, 0.0, 5.027255>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate 3.469915*z rotate 17.306194*y rotate -18.275087*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate -129.522598*z rotate 146.015564*y rotate 176.503632*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 140.601028*z rotate 148.051086*y rotate -205.36409*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 340.930603*z rotate 149.874374*y rotate -223.204849*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <1.767767, -1.767767, 0.0>
    rotate 201.228989*z rotate 208.084503*y rotate 155.019394*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen7 = union {
  sphere { // Sphere053
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere054
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone025
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil7 = union {
  object { saugreihe14 }
  object { saugreihe15 }
  object { armteilaussen7 }
  object { armteilinnen7 }
  rotate -0.0*y
  translate  <0.156126, 0.0, -5.027255>
  scale 0.4096
  translate  <-0.063949, 0.0, -9.800106>
}
#declare tentaka1 = union {
  object { armteil6 }
  object { armteil7 }
  rotate -0.0*y
  translate  <0.083933, 0.0, 9.820163>
  rotate <18.275087, -17.306194, -3.469915>
  translate  <-0.083933, 0.0, -9.820163>
}
#declare saugnapf96 = union {
  torus { // Torus107
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf97 = union {
  torus { // Torus108
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf98 = union {
  torus { // Torus109
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf99 = union {
  torus { // Torus110
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf100 = union {
  torus { // Torus111
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf101 = union {
  torus { // Torus112
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe16 = union {
  object { saugnapf96 }
  object { saugnapf97 }
  object { saugnapf98 }
  object { saugnapf99 }
  object { saugnapf100 }
  object { saugnapf101 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf102 = union {
  torus { // Torus113
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf103 = union {
  torus { // Torus114
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf104 = union {
  torus { // Torus115
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf105 = union {
  torus { // Torus116
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf106 = union {
  torus { // Torus117
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf107 = union {
  torus { // Torus118
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe17 = union {
  object { saugnapf102 }
  object { saugnapf103 }
  object { saugnapf104 }
  object { saugnapf105 }
  object { saugnapf106 }
  object { saugnapf107 }
}
#declare armteilaussen8 = union {
  sphere { // Sphere055
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere056
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone026
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.095217, 0.0, 7.227235>
    scale 1.0/0.512
    translate  <-0.162371, 0.0, 5.033499>
    translate  <0.083933, 0.0, 7.232228>
    rotate -129.522598*z rotate 146.015564*y rotate 176.503632*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 140.601028*z rotate 148.051086*y rotate -205.36409*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 340.930603*z rotate 149.874374*y rotate -223.204849*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <1.767767, -1.767767, 0.0>
    rotate 201.228989*z rotate 208.084503*y rotate 155.019394*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen8 = union {
  sphere { // Sphere057
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere058
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone027
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil8 = union {
  object { saugreihe16 }
  object { saugreihe17 }
  object { armteilaussen8 }
  object { armteilinnen8 }
  translate  <0.162371, 0.0, -5.033499>
  scale 0.512
  translate  <-0.095217, 0.0, -7.227235>
}
#declare tentakb1 = union {
  object { tentaka1 }
  object { armteil8 }
  rotate 0.0*y
  translate  <0.083933, 0.0, 7.232228>
  rotate <-176.503632, -146.015564, 129.522598>
  translate  <-0.083933, 0.0, -7.232228>
}
#declare saugnapf108 = union {
  torus { // Torus119
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf109 = union {
  torus { // Torus120
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf110 = union {
  torus { // Torus121
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf111 = union {
  torus { // Torus122
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf112 = union {
  torus { // Torus123
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf113 = union {
  torus { // Torus124
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe18 = union {
  object { saugnapf108 }
  object { saugnapf109 }
  object { saugnapf110 }
  object { saugnapf111 }
  object { saugnapf112 }
  object { saugnapf113 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf114 = union {
  torus { // Torus125
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf115 = union {
  torus { // Torus126
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf116 = union {
  torus { // Torus127
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf117 = union {
  torus { // Torus128
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf118 = union {
  torus { // Torus129
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf119 = union {
  torus { // Torus130
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe19 = union {
  object { saugnapf114 }
  object { saugnapf115 }
  object { saugnapf116 }
  object { saugnapf117 }
  object { saugnapf118 }
  object { saugnapf119 }
}
#declare armteilaussen9 = union {
  sphere { // Sphere059
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere060
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone028
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.193325, 0.0, 4.006921>
    scale 1.0/0.64
    translate  <-0.283191, 0.0, 5.040802>
    rotate 0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 140.601028*z rotate 148.051086*y rotate -205.36409*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 340.930603*z rotate 149.874374*y rotate -223.204849*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <1.767767, -1.767767, 0.0>
    rotate 201.228989*z rotate 208.084503*y rotate 155.019394*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen9 = union {
  sphere { // Sphere061
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere062
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone029
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil9 = union {
  object { saugreihe18 }
  object { saugreihe19 }
  object { armteilaussen9 }
  object { armteilinnen9 }
  rotate -0.0*y
  translate  <0.283191, 0.0, -5.040802>
  scale 0.64
  translate  <-0.193325, 0.0, -4.006921>
}
#declare tentakc1 = union {
  object { tentakb1 }
  object { armteil9 }
  translate  <0.223821, 0.0, 4.014796>
  rotate <205.36409, -148.051086, -140.601028>
  translate  <-0.223821, 0.0, -4.014796>
}
#declare saugnapf120 = union {
  torus { // Torus131
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf121 = union {
  torus { // Torus132
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf122 = union {
  torus { // Torus133
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf123 = union {
  torus { // Torus134
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf124 = union {
  torus { // Torus135
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf125 = union {
  torus { // Torus136
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe20 = union {
  object { saugnapf120 }
  object { saugnapf121 }
  object { saugnapf122 }
  object { saugnapf123 }
  object { saugnapf124 }
  object { saugnapf125 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf126 = union {
  torus { // Torus137
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf127 = union {
  torus { // Torus138
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf128 = union {
  torus { // Torus139
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf129 = union {
  torus { // Torus140
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf130 = union {
  torus { // Torus141
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf131 = union {
  torus { // Torus142
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe21 = union {
  object { saugnapf126 }
  object { saugnapf127 }
  object { saugnapf128 }
  object { saugnapf129 }
  object { saugnapf130 }
  object { saugnapf131 }
}
#declare armteilaussen10 = union {
  sphere { // Sphere063
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere064
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone030
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.205408, 0.0, 0.007886>
    scale 1.0/0.8
    translate  <-0.25676, 0.0, 5.014371>
    translate  <0.230349, 0.0, -0.024247>
    rotate 340.930603*z rotate 149.874374*y rotate -223.204849*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <1.767767, -1.767767, 0.0>
    rotate 201.228989*z rotate 208.084503*y rotate 155.019394*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen10 = union {
  sphere { // Sphere065
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere066
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone031
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil10 = union {
  object { saugreihe20 }
  object { saugreihe21 }
  object { armteilaussen10 }
  object { armteilinnen10 }
  translate  <0.25676, 0.0, -5.014371>
  scale 0.8
  translate  <-0.205408, 0.0, -0.007886>
}
#declare tentakd1 = union {
  object { tentakc1 }
  object { armteil10 }
  translate  <0.230349, 0.0, -0.024247>
  rotate <223.204849, -149.874374, -340.930603>
  translate  <-0.230349, 0.0, 0.024247>
}
#declare saugnapf132 = union {
  torus { // Torus143
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf133 = union {
  torus { // Torus144
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf134 = union {
  torus { // Torus145
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf135 = union {
  torus { // Torus146
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf136 = union {
  torus { // Torus147
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf137 = union {
  torus { // Torus148
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe22 = union {
  object { saugnapf132 }
  object { saugnapf133 }
  object { saugnapf134 }
  object { saugnapf135 }
  object { saugnapf136 }
  object { saugnapf137 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf138 = union {
  torus { // Torus149
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf139 = union {
  torus { // Torus150
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf140 = union {
  torus { // Torus151
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf141 = union {
  torus { // Torus152
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf142 = union {
  torus { // Torus153
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf143 = union {
  torus { // Torus154
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe23 = union {
  object { saugnapf138 }
  object { saugnapf139 }
  object { saugnapf140 }
  object { saugnapf141 }
  object { saugnapf142 }
  object { saugnapf143 }
}
#declare armteilaussen11 = union {
  sphere { // Sphere067
    <0,0,0>,1
    scale <1.003325, 1.482848, 1.228788>
    translate  5.0*z
    material {
      oktoMskinMaussen
      // Transform to world space
      translate  0.25*x
      rotate 0.647847*y
      scale <1.0/0.777959, 1.0/1.184654, 1.0/1.0>
      translate  <0.281548, 0.0, -4.951811>
      rotate 80.0*z
      translate  <-0.281548, 0.0, 4.951811>
      translate  <1.767767, -1.767767, 0.0>
      rotate 201.228989*z rotate 208.084503*y rotate 155.019394*x
      translate  <-0.262187, 0.0, 4.977383>
      rotate 0.0*y
      translate  <12.127279, 18.190885, 4.082331>
      rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
      scale 1.0/2.5
    }
  }
  sphere { // Sphere068
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone032
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.281548, 0.0, -4.951811>
    rotate 80.0*z
    translate  <-0.281548, 0.0, 4.951811>
    translate  <1.767767, -1.767767, 0.0>
    rotate 201.228989*z rotate 208.084503*y rotate 155.019394*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen11 = union {
  sphere { // Sphere069
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere070
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone033
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil11 = union {
  object { saugreihe22 }
  object { saugreihe23 }
  object { armteilaussen11 }
  object { armteilinnen11 }
  translate  <0.281548, 0.0, -4.951811>
  rotate -80.0*z
  translate  <-0.281548, 0.0, 4.951811>
}
#declare tentakel1 = union {
  object { tentakd1 }
  object { armteil11 }
  rotate -0.0*y
  translate  <0.262187, 0.0, -4.977383>
  rotate <-155.019394, -208.084503, -201.228989>
  translate  <-1.767767, 1.767767, 0.0>
}
#declare saugnapf144 = union {
  torus { // Torus155
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf145 = union {
  torus { // Torus156
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf146 = union {
  torus { // Torus157
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf147 = union {
  torus { // Torus158
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf148 = union {
  torus { // Torus159
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf149 = union {
  torus { // Torus160
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe24 = union {
  object { saugnapf144 }
  object { saugnapf145 }
  object { saugnapf146 }
  object { saugnapf147 }
  object { saugnapf148 }
  object { saugnapf149 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf150 = union {
  torus { // Torus161
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf151 = union {
  torus { // Torus162
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf152 = union {
  torus { // Torus163
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf153 = union {
  torus { // Torus164
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf154 = union {
  torus { // Torus165
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf155 = union {
  torus { // Torus166
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe25 = union {
  object { saugnapf150 }
  object { saugnapf151 }
  object { saugnapf152 }
  object { saugnapf153 }
  object { saugnapf154 }
  object { saugnapf155 }
}
#declare armteilaussen12 = union {
  sphere { // Sphere071
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere072
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone034
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.061007, 0.0, 11.846591>
    rotate 192.687408*z rotate 125.93399*y rotate -149.788986*x
    scale 1.0/0.32768
    translate  <-0.177544, 0.0, 5.043157>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate 32.27549*z rotate 32.336494*y rotate 47.35482*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate 140.351242*z rotate 205.160843*y rotate 146.829941*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 176.224625*z rotate 145.432175*y rotate -180.673981*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 129.480591*z rotate 210.751144*y rotate 149.431946*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-0.0, -2.5, 0.0>
    rotate 104.446922*z rotate 13.769349*y rotate 4.67748*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen12 = union {
  sphere { // Sphere073
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere074
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
    scale 0.8
  }
  cone { // Cone035
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil12 = union {
  object { saugreihe24 }
  object { saugreihe25 }
  object { armteilaussen12 }
  object { armteilinnen12 }
  rotate -0.0*y
  translate  <0.177544, 0.0, -5.043157>
  scale 0.32768
  rotate <149.788986, -125.93399, -192.687408>
  translate  <-0.061007, 0.0, -11.846591>
}
#declare saugnapf156 = union {
  torus { // Torus167
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf157 = union {
  torus { // Torus168
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf158 = union {
  torus { // Torus169
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf159 = union {
  torus { // Torus170
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf160 = union {
  torus { // Torus171
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf161 = union {
  torus { // Torus172
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe26 = union {
  object { saugnapf156 }
  object { saugnapf157 }
  object { saugnapf158 }
  object { saugnapf159 }
  object { saugnapf160 }
  object { saugnapf161 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf162 = union {
  torus { // Torus173
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf163 = union {
  torus { // Torus174
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf164 = union {
  torus { // Torus175
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf165 = union {
  torus { // Torus176
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf166 = union {
  torus { // Torus177
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf167 = union {
  torus { // Torus178
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe27 = union {
  object { saugnapf162 }
  object { saugnapf163 }
  object { saugnapf164 }
  object { saugnapf165 }
  object { saugnapf166 }
  object { saugnapf167 }
}
#declare armteilaussen13 = union {
  sphere { // Sphere075
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere076
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone036
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.063949, 0.0, 9.800106>
    scale 1.0/0.4096
    translate  <-0.156126, 0.0, 5.027255>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate 32.27549*z rotate 32.336494*y rotate 47.35482*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate 140.351242*z rotate 205.160843*y rotate 146.829941*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 176.224625*z rotate 145.432175*y rotate -180.673981*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 129.480591*z rotate 210.751144*y rotate 149.431946*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-0.0, -2.5, 0.0>
    rotate 104.446922*z rotate 13.769349*y rotate 4.67748*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen13 = union {
  sphere { // Sphere077
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere078
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone037
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil13 = union {
  object { saugreihe26 }
  object { saugreihe27 }
  object { armteilaussen13 }
  object { armteilinnen13 }
  rotate -0.0*y
  translate  <0.156126, 0.0, -5.027255>
  scale 0.4096
  translate  <-0.063949, 0.0, -9.800106>
}
#declare tentaka2 = union {
  object { armteil12 }
  object { armteil13 }
  rotate -0.0*y
  translate  <0.083933, 0.0, 9.820163>
  rotate <-47.35482, -32.336494, -32.27549>
  translate  <-0.083933, 0.0, -9.820163>
}
#declare saugnapf168 = union {
  torus { // Torus179
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf169 = union {
  torus { // Torus180
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf170 = union {
  torus { // Torus181
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf171 = union {
  torus { // Torus182
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf172 = union {
  torus { // Torus183
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf173 = union {
  torus { // Torus184
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe28 = union {
  object { saugnapf168 }
  object { saugnapf169 }
  object { saugnapf170 }
  object { saugnapf171 }
  object { saugnapf172 }
  object { saugnapf173 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf174 = union {
  torus { // Torus185
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf175 = union {
  torus { // Torus186
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf176 = union {
  torus { // Torus187
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf177 = union {
  torus { // Torus188
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf178 = union {
  torus { // Torus189
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf179 = union {
  torus { // Torus190
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe29 = union {
  object { saugnapf174 }
  object { saugnapf175 }
  object { saugnapf176 }
  object { saugnapf177 }
  object { saugnapf178 }
  object { saugnapf179 }
}
#declare armteilaussen14 = union {
  sphere { // Sphere079
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere080
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone038
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.095217, 0.0, 7.227235>
    scale 1.0/0.512
    translate  <-0.162371, 0.0, 5.033499>
    translate  <0.083933, 0.0, 7.232228>
    rotate 140.351242*z rotate 205.160843*y rotate 146.829941*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 176.224625*z rotate 145.432175*y rotate -180.673981*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 129.480591*z rotate 210.751144*y rotate 149.431946*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-0.0, -2.5, 0.0>
    rotate 104.446922*z rotate 13.769349*y rotate 4.67748*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen14 = union {
  sphere { // Sphere081
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere082
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone039
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil14 = union {
  object { saugreihe28 }
  object { saugreihe29 }
  object { armteilaussen14 }
  object { armteilinnen14 }
  translate  <0.162371, 0.0, -5.033499>
  scale 0.512
  translate  <-0.095217, 0.0, -7.227235>
}
#declare tentakb2 = union {
  object { tentaka2 }
  object { armteil14 }
  rotate 0.0*y
  translate  <0.083933, 0.0, 7.232228>
  rotate <-146.829941, -205.160843, -140.351242>
  translate  <-0.083933, 0.0, -7.232228>
}
#declare saugnapf180 = union {
  torus { // Torus191
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf181 = union {
  torus { // Torus192
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf182 = union {
  torus { // Torus193
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf183 = union {
  torus { // Torus194
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf184 = union {
  torus { // Torus195
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf185 = union {
  torus { // Torus196
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe30 = union {
  object { saugnapf180 }
  object { saugnapf181 }
  object { saugnapf182 }
  object { saugnapf183 }
  object { saugnapf184 }
  object { saugnapf185 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf186 = union {
  torus { // Torus197
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf187 = union {
  torus { // Torus198
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf188 = union {
  torus { // Torus199
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf189 = union {
  torus { // Torus200
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf190 = union {
  torus { // Torus201
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf191 = union {
  torus { // Torus202
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe31 = union {
  object { saugnapf186 }
  object { saugnapf187 }
  object { saugnapf188 }
  object { saugnapf189 }
  object { saugnapf190 }
  object { saugnapf191 }
}
#declare armteilaussen15 = union {
  sphere { // Sphere083
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere084
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone040
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.193325, 0.0, 4.006921>
    scale 1.0/0.64
    translate  <-0.283191, 0.0, 5.040802>
    rotate 0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 176.224625*z rotate 145.432175*y rotate -180.673981*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 129.480591*z rotate 210.751144*y rotate 149.431946*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-0.0, -2.5, 0.0>
    rotate 104.446922*z rotate 13.769349*y rotate 4.67748*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen15 = union {
  sphere { // Sphere085
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere086
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone041
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil15 = union {
  object { saugreihe30 }
  object { saugreihe31 }
  object { armteilaussen15 }
  object { armteilinnen15 }
  rotate -0.0*y
  translate  <0.283191, 0.0, -5.040802>
  scale 0.64
  translate  <-0.193325, 0.0, -4.006921>
}
#declare tentakc2 = union {
  object { tentakb2 }
  object { armteil15 }
  translate  <0.223821, 0.0, 4.014796>
  rotate <180.673981, -145.432175, -176.224625>
  translate  <-0.223821, 0.0, -4.014796>
}
#declare saugnapf192 = union {
  torus { // Torus203
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf193 = union {
  torus { // Torus204
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf194 = union {
  torus { // Torus205
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf195 = union {
  torus { // Torus206
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf196 = union {
  torus { // Torus207
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf197 = union {
  torus { // Torus208
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe32 = union {
  object { saugnapf192 }
  object { saugnapf193 }
  object { saugnapf194 }
  object { saugnapf195 }
  object { saugnapf196 }
  object { saugnapf197 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf198 = union {
  torus { // Torus209
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf199 = union {
  torus { // Torus210
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf200 = union {
  torus { // Torus211
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf201 = union {
  torus { // Torus212
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf202 = union {
  torus { // Torus213
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf203 = union {
  torus { // Torus214
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe33 = union {
  object { saugnapf198 }
  object { saugnapf199 }
  object { saugnapf200 }
  object { saugnapf201 }
  object { saugnapf202 }
  object { saugnapf203 }
}
#declare armteilaussen16 = union {
  sphere { // Sphere087
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere088
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone042
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.205408, 0.0, 0.007886>
    scale 1.0/0.8
    translate  <-0.25676, 0.0, 5.014371>
    translate  <0.230349, 0.0, -0.024247>
    rotate 129.480591*z rotate 210.751144*y rotate 149.431946*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-0.0, -2.5, 0.0>
    rotate 104.446922*z rotate 13.769349*y rotate 4.67748*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen16 = union {
  sphere { // Sphere089
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere090
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone043
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil16 = union {
  object { saugreihe32 }
  object { saugreihe33 }
  object { armteilaussen16 }
  object { armteilinnen16 }
  translate  <0.25676, 0.0, -5.014371>
  scale 0.8
  translate  <-0.205408, 0.0, -0.007886>
}
#declare tentakd2 = union {
  object { tentakc2 }
  object { armteil16 }
  translate  <0.230349, 0.0, -0.024247>
  rotate <-149.431946, -210.751144, -129.480591>
  translate  <-0.230349, 0.0, 0.024247>
}
#declare saugnapf204 = union {
  torus { // Torus215
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf205 = union {
  torus { // Torus216
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf206 = union {
  torus { // Torus217
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf207 = union {
  torus { // Torus218
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf208 = union {
  torus { // Torus219
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf209 = union {
  torus { // Torus220
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe34 = union {
  object { saugnapf204 }
  object { saugnapf205 }
  object { saugnapf206 }
  object { saugnapf207 }
  object { saugnapf208 }
  object { saugnapf209 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf210 = union {
  torus { // Torus221
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf211 = union {
  torus { // Torus222
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf212 = union {
  torus { // Torus223
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf213 = union {
  torus { // Torus224
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf214 = union {
  torus { // Torus225
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf215 = union {
  torus { // Torus226
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe35 = union {
  object { saugnapf210 }
  object { saugnapf211 }
  object { saugnapf212 }
  object { saugnapf213 }
  object { saugnapf214 }
  object { saugnapf215 }
}
#declare armteilaussen17 = union {
  sphere { // Sphere091
    <0,0,0>,1
    scale <1.003325, 1.482848, 1.228788>
    translate  5.0*z
    material {
      oktoMskinMaussen
      // Transform to world space
      translate  0.25*x
      rotate 0.647847*y
      scale <1.0/0.777959, 1.0/1.184654, 1.0/1.0>
      translate  <0.281548, 0.0, -4.951811>
      translate  <-0.281548, 0.0, 4.951811>
      translate  <-0.0, -2.5, 0.0>
      rotate 104.446922*z rotate 13.769349*y rotate 4.67748*x
      translate  <-0.262187, 0.0, 4.977383>
      rotate 0.0*y
      translate  <12.127279, 18.190885, 4.082331>
      rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
      scale 1.0/2.5
    }
  }
  sphere { // Sphere092
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone044
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.281548, 0.0, -4.951811>
    translate  <-0.281548, 0.0, 4.951811>
    translate  <-0.0, -2.5, 0.0>
    rotate 104.446922*z rotate 13.769349*y rotate 4.67748*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen17 = union {
  sphere { // Sphere093
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere094
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone045
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil17 = union {
  object { saugreihe34 }
  object { saugreihe35 }
  object { armteilaussen17 }
  object { armteilinnen17 }
  translate  <0.281548, 0.0, -4.951811>
  translate  <-0.281548, 0.0, 4.951811>
}
#declare tentakel2 = union {
  object { tentakd2 }
  object { armteil17 }
  rotate -0.0*y
  translate  <0.262187, 0.0, -4.977383>
  rotate <-4.67748, -13.769349, -104.446922>
  translate  <0.0, 2.5, 0.0>
}
#declare saugnapf216 = union {
  torus { // Torus227
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf217 = union {
  torus { // Torus228
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf218 = union {
  torus { // Torus229
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf219 = union {
  torus { // Torus230
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf220 = union {
  torus { // Torus231
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf221 = union {
  torus { // Torus232
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe36 = union {
  object { saugnapf216 }
  object { saugnapf217 }
  object { saugnapf218 }
  object { saugnapf219 }
  object { saugnapf220 }
  object { saugnapf221 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf222 = union {
  torus { // Torus233
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf223 = union {
  torus { // Torus234
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf224 = union {
  torus { // Torus235
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf225 = union {
  torus { // Torus236
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf226 = union {
  torus { // Torus237
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf227 = union {
  torus { // Torus238
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe37 = union {
  object { saugnapf222 }
  object { saugnapf223 }
  object { saugnapf224 }
  object { saugnapf225 }
  object { saugnapf226 }
  object { saugnapf227 }
}
#declare armteilaussen18 = union {
  sphere { // Sphere095
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere096
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone046
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.061007, 0.0, 11.846591>
    rotate 24.7817*z rotate 9.687024*y rotate -61.433235*x
    scale 1.0/0.32768
    translate  <-0.177544, 0.0, 5.043157>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate -1.219207*z rotate -35.53046*y rotate 57.568161*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate 10.46872*z rotate 7.505443*y rotate -41.058197*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -24.736841*z rotate -11.288918*y rotate 7.788145*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 12.103623*z rotate 13.546424*y rotate 8.855826*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-1.767767, -1.767767, 0.0>
    rotate 131.165115*z rotate -5.692552*y rotate -17.281521*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen18 = union {
  sphere { // Sphere097
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere098
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
    scale 0.8
  }
  cone { // Cone047
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil18 = union {
  object { saugreihe36 }
  object { saugreihe37 }
  object { armteilaussen18 }
  object { armteilinnen18 }
  rotate -0.0*y
  translate  <0.177544, 0.0, -5.043157>
  scale 0.32768
  rotate <61.433235, -9.687024, -24.7817>
  translate  <-0.061007, 0.0, -11.846591>
}
#declare saugnapf228 = union {
  torus { // Torus239
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf229 = union {
  torus { // Torus240
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf230 = union {
  torus { // Torus241
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf231 = union {
  torus { // Torus242
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf232 = union {
  torus { // Torus243
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf233 = union {
  torus { // Torus244
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe38 = union {
  object { saugnapf228 }
  object { saugnapf229 }
  object { saugnapf230 }
  object { saugnapf231 }
  object { saugnapf232 }
  object { saugnapf233 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf234 = union {
  torus { // Torus245
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf235 = union {
  torus { // Torus246
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf236 = union {
  torus { // Torus247
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf237 = union {
  torus { // Torus248
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf238 = union {
  torus { // Torus249
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf239 = union {
  torus { // Torus250
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe39 = union {
  object { saugnapf234 }
  object { saugnapf235 }
  object { saugnapf236 }
  object { saugnapf237 }
  object { saugnapf238 }
  object { saugnapf239 }
}
#declare armteilaussen19 = union {
  sphere { // Sphere099
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere100
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone048
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.063949, 0.0, 9.800106>
    scale 1.0/0.4096
    translate  <-0.156126, 0.0, 5.027255>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate -1.219207*z rotate -35.53046*y rotate 57.568161*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate 10.46872*z rotate 7.505443*y rotate -41.058197*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -24.736841*z rotate -11.288918*y rotate 7.788145*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 12.103623*z rotate 13.546424*y rotate 8.855826*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-1.767767, -1.767767, 0.0>
    rotate 131.165115*z rotate -5.692552*y rotate -17.281521*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen19 = union {
  sphere { // Sphere101
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere102
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone049
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil19 = union {
  object { saugreihe38 }
  object { saugreihe39 }
  object { armteilaussen19 }
  object { armteilinnen19 }
  rotate -0.0*y
  translate  <0.156126, 0.0, -5.027255>
  scale 0.4096
  translate  <-0.063949, 0.0, -9.800106>
}
#declare tentaka3 = union {
  object { armteil18 }
  object { armteil19 }
  rotate -0.0*y
  translate  <0.083933, 0.0, 9.820163>
  rotate <-57.568161, 35.53046, 1.219207>
  translate  <-0.083933, 0.0, -9.820163>
}
#declare saugnapf240 = union {
  torus { // Torus251
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf241 = union {
  torus { // Torus252
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf242 = union {
  torus { // Torus253
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf243 = union {
  torus { // Torus254
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf244 = union {
  torus { // Torus255
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf245 = union {
  torus { // Torus256
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe40 = union {
  object { saugnapf240 }
  object { saugnapf241 }
  object { saugnapf242 }
  object { saugnapf243 }
  object { saugnapf244 }
  object { saugnapf245 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf246 = union {
  torus { // Torus257
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf247 = union {
  torus { // Torus258
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf248 = union {
  torus { // Torus259
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf249 = union {
  torus { // Torus260
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf250 = union {
  torus { // Torus261
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf251 = union {
  torus { // Torus262
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe41 = union {
  object { saugnapf246 }
  object { saugnapf247 }
  object { saugnapf248 }
  object { saugnapf249 }
  object { saugnapf250 }
  object { saugnapf251 }
}
#declare armteilaussen20 = union {
  sphere { // Sphere103
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere104
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone050
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.095217, 0.0, 7.227235>
    scale 1.0/0.512
    translate  <-0.162371, 0.0, 5.033499>
    translate  <0.083933, 0.0, 7.232228>
    rotate 10.46872*z rotate 7.505443*y rotate -41.058197*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -24.736841*z rotate -11.288918*y rotate 7.788145*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 12.103623*z rotate 13.546424*y rotate 8.855826*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-1.767767, -1.767767, 0.0>
    rotate 131.165115*z rotate -5.692552*y rotate -17.281521*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen20 = union {
  sphere { // Sphere105
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere106
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone051
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil20 = union {
  object { saugreihe40 }
  object { saugreihe41 }
  object { armteilaussen20 }
  object { armteilinnen20 }
  translate  <0.162371, 0.0, -5.033499>
  scale 0.512
  translate  <-0.095217, 0.0, -7.227235>
}
#declare tentakb3 = union {
  object { tentaka3 }
  object { armteil20 }
  rotate 0.0*y
  translate  <0.083933, 0.0, 7.232228>
  rotate <41.058197, -7.505443, -10.46872>
  translate  <-0.083933, 0.0, -7.232228>
}
#declare saugnapf252 = union {
  torus { // Torus263
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf253 = union {
  torus { // Torus264
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf254 = union {
  torus { // Torus265
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf255 = union {
  torus { // Torus266
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf256 = union {
  torus { // Torus267
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf257 = union {
  torus { // Torus268
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe42 = union {
  object { saugnapf252 }
  object { saugnapf253 }
  object { saugnapf254 }
  object { saugnapf255 }
  object { saugnapf256 }
  object { saugnapf257 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf258 = union {
  torus { // Torus269
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf259 = union {
  torus { // Torus270
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr296
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf260 = union {
  torus { // Torus271
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr297
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf261 = union {
  torus { // Torus272
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr298
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf262 = union {
  torus { // Torus273
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr299
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf263 = union {
  torus { // Torus274
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr300
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe43 = union {
  object { saugnapf258 }
  object { saugnapf259 }
  object { saugnapf260 }
  object { saugnapf261 }
  object { saugnapf262 }
  object { saugnapf263 }
}
#declare armteilaussen21 = union {
  sphere { // Sphere107
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere108
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone052
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.193325, 0.0, 4.006921>
    scale 1.0/0.64
    translate  <-0.283191, 0.0, 5.040802>
    rotate 0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -24.736841*z rotate -11.288918*y rotate 7.788145*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 12.103623*z rotate 13.546424*y rotate 8.855826*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-1.767767, -1.767767, 0.0>
    rotate 131.165115*z rotate -5.692552*y rotate -17.281521*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen21 = union {
  sphere { // Sphere109
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere110
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone053
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil21 = union {
  object { saugreihe42 }
  object { saugreihe43 }
  object { armteilaussen21 }
  object { armteilinnen21 }
  rotate -0.0*y
  translate  <0.283191, 0.0, -5.040802>
  scale 0.64
  translate  <-0.193325, 0.0, -4.006921>
}
#declare tentakc3 = union {
  object { tentakb3 }
  object { armteil21 }
  translate  <0.223821, 0.0, 4.014796>
  rotate <-7.788145, 11.288918, 24.736841>
  translate  <-0.223821, 0.0, -4.014796>
}
#declare saugnapf264 = union {
  torus { // Torus275
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr301
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf265 = union {
  torus { // Torus276
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr302
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf266 = union {
  torus { // Torus277
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr303
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf267 = union {
  torus { // Torus278
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr304
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf268 = union {
  torus { // Torus279
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr305
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf269 = union {
  torus { // Torus280
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr306
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe44 = union {
  object { saugnapf264 }
  object { saugnapf265 }
  object { saugnapf266 }
  object { saugnapf267 }
  object { saugnapf268 }
  object { saugnapf269 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf270 = union {
  torus { // Torus281
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr307
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf271 = union {
  torus { // Torus282
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr308
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf272 = union {
  torus { // Torus283
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr309
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf273 = union {
  torus { // Torus284
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr310
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf274 = union {
  torus { // Torus285
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr311
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf275 = union {
  torus { // Torus286
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr312
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe45 = union {
  object { saugnapf270 }
  object { saugnapf271 }
  object { saugnapf272 }
  object { saugnapf273 }
  object { saugnapf274 }
  object { saugnapf275 }
}
#declare armteilaussen22 = union {
  sphere { // Sphere111
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere112
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone054
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.205408, 0.0, 0.007886>
    scale 1.0/0.8
    translate  <-0.25676, 0.0, 5.014371>
    translate  <0.230349, 0.0, -0.024247>
    rotate 12.103623*z rotate 13.546424*y rotate 8.855826*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-1.767767, -1.767767, 0.0>
    rotate 131.165115*z rotate -5.692552*y rotate -17.281521*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen22 = union {
  sphere { // Sphere113
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere114
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone055
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil22 = union {
  object { saugreihe44 }
  object { saugreihe45 }
  object { armteilaussen22 }
  object { armteilinnen22 }
  translate  <0.25676, 0.0, -5.014371>
  scale 0.8
  translate  <-0.205408, 0.0, -0.007886>
}
#declare tentakd3 = union {
  object { tentakc3 }
  object { armteil22 }
  translate  <0.230349, 0.0, -0.024247>
  rotate <-8.855826, -13.546424, -12.103623>
  translate  <-0.230349, 0.0, 0.024247>
}
#declare saugnapf276 = union {
  torus { // Torus287
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr313
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf277 = union {
  torus { // Torus288
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr314
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf278 = union {
  torus { // Torus289
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr315
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf279 = union {
  torus { // Torus290
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr316
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf280 = union {
  torus { // Torus291
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr317
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf281 = union {
  torus { // Torus292
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr318
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe46 = union {
  object { saugnapf276 }
  object { saugnapf277 }
  object { saugnapf278 }
  object { saugnapf279 }
  object { saugnapf280 }
  object { saugnapf281 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf282 = union {
  torus { // Torus293
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr319
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf283 = union {
  torus { // Torus294
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr320
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf284 = union {
  torus { // Torus295
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr321
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf285 = union {
  torus { // Torus296
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr322
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf286 = union {
  torus { // Torus297
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr323
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf287 = union {
  torus { // Torus298
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr324
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe47 = union {
  object { saugnapf282 }
  object { saugnapf283 }
  object { saugnapf284 }
  object { saugnapf285 }
  object { saugnapf286 }
  object { saugnapf287 }
}
#declare armteilaussen23 = union {
  sphere { // Sphere115
    <0,0,0>,1
    scale <1.003325, 1.482848, 1.228788>
    translate  5.0*z
    material {
      oktoMskinMaussen
      // Transform to world space
      translate  0.25*x
      rotate 0.647847*y
      scale <1.0/0.777959, 1.0/1.184654, 1.0/1.0>
      translate  <0.281548, 0.0, -4.951811>
      translate  <-0.281548, 0.0, 4.951811>
      translate  <-1.767767, -1.767767, 0.0>
      rotate 131.165115*z rotate -5.692552*y rotate -17.281521*x
      translate  <-0.262187, 0.0, 4.977383>
      rotate 0.0*y
      translate  <12.127279, 18.190885, 4.082331>
      rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
      scale 1.0/2.5
    }
  }
  sphere { // Sphere116
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone056
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.281548, 0.0, -4.951811>
    translate  <-0.281548, 0.0, 4.951811>
    translate  <-1.767767, -1.767767, 0.0>
    rotate 131.165115*z rotate -5.692552*y rotate -17.281521*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen23 = union {
  sphere { // Sphere117
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere118
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone057
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil23 = union {
  object { saugreihe46 }
  object { saugreihe47 }
  object { armteilaussen23 }
  object { armteilinnen23 }
  translate  <0.281548, 0.0, -4.951811>
  translate  <-0.281548, 0.0, 4.951811>
}
#declare tentakel3 = union {
  object { tentakd3 }
  object { armteil23 }
  rotate -0.0*y
  translate  <0.262187, 0.0, -4.977383>
  rotate <17.281521, 5.692552, -131.165115>
  translate  <1.767767, 1.767767, 0.0>
}
#declare saugnapf288 = union {
  torus { // Torus299
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr325
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf289 = union {
  torus { // Torus300
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr326
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf290 = union {
  torus { // Torus301
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr327
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf291 = union {
  torus { // Torus302
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr328
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf292 = union {
  torus { // Torus303
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr329
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf293 = union {
  torus { // Torus304
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr330
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe48 = union {
  object { saugnapf288 }
  object { saugnapf289 }
  object { saugnapf290 }
  object { saugnapf291 }
  object { saugnapf292 }
  object { saugnapf293 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf294 = union {
  torus { // Torus305
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr331
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf295 = union {
  torus { // Torus306
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr332
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf296 = union {
  torus { // Torus307
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr333
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf297 = union {
  torus { // Torus308
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr334
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf298 = union {
  torus { // Torus309
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr335
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf299 = union {
  torus { // Torus310
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr336
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe49 = union {
  object { saugnapf294 }
  object { saugnapf295 }
  object { saugnapf296 }
  object { saugnapf297 }
  object { saugnapf298 }
  object { saugnapf299 }
}
#declare armteilaussen24 = union {
  sphere { // Sphere119
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere120
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone058
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.061007, 0.0, 11.846591>
    rotate -3.181294*z rotate -27.906471*y rotate 1.348853*x
    scale 1.0/0.32768
    translate  <-0.177544, 0.0, 5.043157>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate -28.172129*z rotate -49.548923*y rotate 9.846249*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate 22.444244*z rotate 20.475788*y rotate -18.847511*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -140.259048*z rotate 126.180916*y rotate 143.956131*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -173.059006*z rotate 208.129776*y rotate -159.565353*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-2.5, 0.0, 0.0>
    rotate 177.475372*z rotate -27.215973*y rotate -16.095221*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen24 = union {
  sphere { // Sphere193
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere194
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
    scale 0.8
  }
  cone { // Cone059
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil24 = union {
  object { saugreihe48 }
  object { saugreihe49 }
  object { armteilaussen24 }
  object { armteilinnen24 }
  rotate -0.0*y
  translate  <0.177544, 0.0, -5.043157>
  scale 0.32768
  rotate <-1.348853, 27.906471, 3.181294>
  translate  <-0.061007, 0.0, -11.846591>
}
#declare saugnapf300 = union {
  torus { // Torus311
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr337
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf301 = union {
  torus { // Torus312
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr338
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf302 = union {
  torus { // Torus313
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr339
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf303 = union {
  torus { // Torus314
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr340
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf304 = union {
  torus { // Torus315
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr341
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf305 = union {
  torus { // Torus316
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr342
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe50 = union {
  object { saugnapf300 }
  object { saugnapf301 }
  object { saugnapf302 }
  object { saugnapf303 }
  object { saugnapf304 }
  object { saugnapf305 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf306 = union {
  torus { // Torus317
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr343
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf307 = union {
  torus { // Torus318
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr344
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf308 = union {
  torus { // Torus319
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr345
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf309 = union {
  torus { // Torus320
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr346
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf310 = union {
  torus { // Torus321
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr347
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf311 = union {
  torus { // Torus322
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr348
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe51 = union {
  object { saugnapf306 }
  object { saugnapf307 }
  object { saugnapf308 }
  object { saugnapf309 }
  object { saugnapf310 }
  object { saugnapf311 }
}
#declare armteilaussen25 = union {
  sphere { // Sphere195
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere196
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone060
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.063949, 0.0, 9.800106>
    scale 1.0/0.4096
    translate  <-0.156126, 0.0, 5.027255>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate -28.172129*z rotate -49.548923*y rotate 9.846249*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate 22.444244*z rotate 20.475788*y rotate -18.847511*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -140.259048*z rotate 126.180916*y rotate 143.956131*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -173.059006*z rotate 208.129776*y rotate -159.565353*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-2.5, 0.0, 0.0>
    rotate 177.475372*z rotate -27.215973*y rotate -16.095221*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen25 = union {
  sphere { // Sphere197
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere198
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone061
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil25 = union {
  object { saugreihe50 }
  object { saugreihe51 }
  object { armteilaussen25 }
  object { armteilinnen25 }
  rotate -0.0*y
  translate  <0.156126, 0.0, -5.027255>
  scale 0.4096
  translate  <-0.063949, 0.0, -9.800106>
}
#declare tentaka4 = union {
  object { armteil24 }
  object { armteil25 }
  rotate -0.0*y
  translate  <0.083933, 0.0, 9.820163>
  rotate <-9.846249, 49.548923, 28.172129>
  translate  <-0.083933, 0.0, -9.820163>
}
#declare saugnapf312 = union {
  torus { // Torus323
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr349
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf313 = union {
  torus { // Torus324
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr350
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf314 = union {
  torus { // Torus325
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr351
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf315 = union {
  torus { // Torus326
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr352
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf316 = union {
  torus { // Torus327
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr353
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf317 = union {
  torus { // Torus328
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr354
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe52 = union {
  object { saugnapf312 }
  object { saugnapf313 }
  object { saugnapf314 }
  object { saugnapf315 }
  object { saugnapf316 }
  object { saugnapf317 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf318 = union {
  torus { // Torus329
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr355
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf319 = union {
  torus { // Torus330
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr356
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf320 = union {
  torus { // Torus331
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr357
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf321 = union {
  torus { // Torus332
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr358
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf322 = union {
  torus { // Torus333
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr359
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf323 = union {
  torus { // Torus334
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr360
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe53 = union {
  object { saugnapf318 }
  object { saugnapf319 }
  object { saugnapf320 }
  object { saugnapf321 }
  object { saugnapf322 }
  object { saugnapf323 }
}
#declare armteilaussen26 = union {
  sphere { // Sphere199
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere200
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone062
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.095217, 0.0, 7.227235>
    scale 1.0/0.512
    translate  <-0.162371, 0.0, 5.033499>
    translate  <0.083933, 0.0, 7.232228>
    rotate 22.444244*z rotate 20.475788*y rotate -18.847511*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -140.259048*z rotate 126.180916*y rotate 143.956131*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -173.059006*z rotate 208.129776*y rotate -159.565353*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-2.5, 0.0, 0.0>
    rotate 177.475372*z rotate -27.215973*y rotate -16.095221*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen26 = union {
  sphere { // Sphere201
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere202
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone063
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil26 = union {
  object { saugreihe52 }
  object { saugreihe53 }
  object { armteilaussen26 }
  object { armteilinnen26 }
  translate  <0.162371, 0.0, -5.033499>
  scale 0.512
  translate  <-0.095217, 0.0, -7.227235>
}
#declare tentakb4 = union {
  object { tentaka4 }
  object { armteil26 }
  rotate 0.0*y
  translate  <0.083933, 0.0, 7.232228>
  rotate <18.847511, -20.475788, -22.444244>
  translate  <-0.083933, 0.0, -7.232228>
}
#declare saugnapf324 = union {
  torus { // Torus335
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr361
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf325 = union {
  torus { // Torus336
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr362
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf326 = union {
  torus { // Torus337
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr363
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf327 = union {
  torus { // Torus338
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr364
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf328 = union {
  torus { // Torus339
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr365
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf329 = union {
  torus { // Torus340
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr366
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe54 = union {
  object { saugnapf324 }
  object { saugnapf325 }
  object { saugnapf326 }
  object { saugnapf327 }
  object { saugnapf328 }
  object { saugnapf329 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf330 = union {
  torus { // Torus341
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr367
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf331 = union {
  torus { // Torus342
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr368
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf332 = union {
  torus { // Torus343
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr369
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf333 = union {
  torus { // Torus344
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr370
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf334 = union {
  torus { // Torus345
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr371
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf335 = union {
  torus { // Torus346
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr372
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe55 = union {
  object { saugnapf330 }
  object { saugnapf331 }
  object { saugnapf332 }
  object { saugnapf333 }
  object { saugnapf334 }
  object { saugnapf335 }
}
#declare armteilaussen27 = union {
  sphere { // Sphere203
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere204
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone064
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.193325, 0.0, 4.006921>
    scale 1.0/0.64
    translate  <-0.283191, 0.0, 5.040802>
    rotate 0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -140.259048*z rotate 126.180916*y rotate 143.956131*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -173.059006*z rotate 208.129776*y rotate -159.565353*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-2.5, 0.0, 0.0>
    rotate 177.475372*z rotate -27.215973*y rotate -16.095221*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen27 = union {
  sphere { // Sphere205
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere206
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone065
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil27 = union {
  object { saugreihe54 }
  object { saugreihe55 }
  object { armteilaussen27 }
  object { armteilinnen27 }
  rotate -0.0*y
  translate  <0.283191, 0.0, -5.040802>
  scale 0.64
  translate  <-0.193325, 0.0, -4.006921>
}
#declare tentakc4 = union {
  object { tentakb4 }
  object { armteil27 }
  translate  <0.223821, 0.0, 4.014796>
  rotate <-143.956131, -126.180916, 140.259048>
  translate  <-0.223821, 0.0, -4.014796>
}
#declare saugnapf336 = union {
  torus { // Torus347
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr373
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf337 = union {
  torus { // Torus348
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr374
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf338 = union {
  torus { // Torus349
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr375
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf339 = union {
  torus { // Torus350
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr376
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf340 = union {
  torus { // Torus351
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr377
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf341 = union {
  torus { // Torus352
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr378
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe56 = union {
  object { saugnapf336 }
  object { saugnapf337 }
  object { saugnapf338 }
  object { saugnapf339 }
  object { saugnapf340 }
  object { saugnapf341 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf342 = union {
  torus { // Torus353
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr379
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf343 = union {
  torus { // Torus354
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr380
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf344 = union {
  torus { // Torus355
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr381
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf345 = union {
  torus { // Torus356
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr382
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf346 = union {
  torus { // Torus357
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr383
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf347 = union {
  torus { // Torus358
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr384
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe57 = union {
  object { saugnapf342 }
  object { saugnapf343 }
  object { saugnapf344 }
  object { saugnapf345 }
  object { saugnapf346 }
  object { saugnapf347 }
}
#declare armteilaussen28 = union {
  sphere { // Sphere207
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere208
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone066
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.205408, 0.0, 0.007886>
    scale 1.0/0.8
    translate  <-0.25676, 0.0, 5.014371>
    translate  <0.230349, 0.0, -0.024247>
    rotate -173.059006*z rotate 208.129776*y rotate -159.565353*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-2.5, 0.0, 0.0>
    rotate 177.475372*z rotate -27.215973*y rotate -16.095221*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen28 = union {
  sphere { // Sphere209
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere210
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone067
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil28 = union {
  object { saugreihe56 }
  object { saugreihe57 }
  object { armteilaussen28 }
  object { armteilinnen28 }
  translate  <0.25676, 0.0, -5.014371>
  scale 0.8
  translate  <-0.205408, 0.0, -0.007886>
}
#declare tentakd4 = union {
  object { tentakc4 }
  object { armteil28 }
  translate  <0.230349, 0.0, -0.024247>
  rotate <159.565353, -208.129776, 173.059006>
  translate  <-0.230349, 0.0, 0.024247>
}
#declare saugnapf348 = union {
  torus { // Torus359
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr385
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf349 = union {
  torus { // Torus360
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr386
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf350 = union {
  torus { // Torus361
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr387
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf351 = union {
  torus { // Torus362
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr388
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf352 = union {
  torus { // Torus363
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr389
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf353 = union {
  torus { // Torus364
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr390
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe58 = union {
  object { saugnapf348 }
  object { saugnapf349 }
  object { saugnapf350 }
  object { saugnapf351 }
  object { saugnapf352 }
  object { saugnapf353 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf354 = union {
  torus { // Torus365
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr391
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf355 = union {
  torus { // Torus366
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr392
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf356 = union {
  torus { // Torus367
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr393
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf357 = union {
  torus { // Torus368
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr394
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf358 = union {
  torus { // Torus369
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr395
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf359 = union {
  torus { // Torus370
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr396
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe59 = union {
  object { saugnapf354 }
  object { saugnapf355 }
  object { saugnapf356 }
  object { saugnapf357 }
  object { saugnapf358 }
  object { saugnapf359 }
}
#declare armteilaussen29 = union {
  sphere { // Sphere211
    <0,0,0>,1
    scale <1.003325, 1.482848, 1.228788>
    translate  5.0*z
    material {
      oktoMskinMaussen
      // Transform to world space
      translate  0.25*x
      rotate 0.647847*y
      scale <1.0/0.777959, 1.0/1.184654, 1.0/1.0>
      translate  <0.281548, 0.0, -4.951811>
      translate  <-0.281548, 0.0, 4.951811>
      translate  <-2.5, 0.0, 0.0>
      rotate 177.475372*z rotate -27.215973*y rotate -16.095221*x
      translate  <-0.262187, 0.0, 4.977383>
      rotate 0.0*y
      translate  <12.127279, 18.190885, 4.082331>
      rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
      scale 1.0/2.5
    }
  }
  sphere { // Sphere212
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone068
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.281548, 0.0, -4.951811>
    translate  <-0.281548, 0.0, 4.951811>
    translate  <-2.5, 0.0, 0.0>
    rotate 177.475372*z rotate -27.215973*y rotate -16.095221*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen29 = union {
  sphere { // Sphere213
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere214
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone069
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil29 = union {
  object { saugreihe58 }
  object { saugreihe59 }
  object { armteilaussen29 }
  object { armteilinnen29 }
  translate  <0.281548, 0.0, -4.951811>
  translate  <-0.281548, 0.0, 4.951811>
}
#declare tentakel4 = union {
  object { tentakd4 }
  object { armteil29 }
  rotate -0.0*y
  translate  <0.262187, 0.0, -4.977383>
  rotate <16.095221, 27.215973, -177.475372>
  translate  <2.5, -0.0, 0.0>
}
#declare saugnapf360 = union {
  torus { // Torus371
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr397
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf361 = union {
  torus { // Torus372
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr398
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf362 = union {
  torus { // Torus373
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr399
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf363 = union {
  torus { // Torus374
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr400
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf364 = union {
  torus { // Torus375
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr401
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf365 = union {
  torus { // Torus376
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr402
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe60 = union {
  object { saugnapf360 }
  object { saugnapf361 }
  object { saugnapf362 }
  object { saugnapf363 }
  object { saugnapf364 }
  object { saugnapf365 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf366 = union {
  torus { // Torus377
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr403
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf367 = union {
  torus { // Torus378
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr404
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf368 = union {
  torus { // Torus379
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr405
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf369 = union {
  torus { // Torus380
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr406
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf370 = union {
  torus { // Torus381
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr407
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf371 = union {
  torus { // Torus382
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr408
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe61 = union {
  object { saugnapf366 }
  object { saugnapf367 }
  object { saugnapf368 }
  object { saugnapf369 }
  object { saugnapf370 }
  object { saugnapf371 }
}
#declare armteilaussen30 = union {
  sphere { // Sphere215
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere216
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone070
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.061007, 0.0, 11.846591>
    rotate 135.654144*z rotate 218.96611*y rotate 162.96402*x
    scale 1.0/0.32768
    translate  <-0.177544, 0.0, 5.043157>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate 15.690114*z rotate 5.243773*y rotate -28.284327*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate -10.374993*z rotate 34.154243*y rotate 7.988245*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -2.413357*z rotate -7.630525*y rotate 25.466709*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -19.53281*z rotate 22.465298*y rotate 33.553711*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-1.767767, 1.767767, 0.0>
    rotate -296.99469*z rotate 231.821533*y rotate -188.917511*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen30 = union {
  sphere { // Sphere217
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere218
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
    scale 0.8
  }
  cone { // Cone071
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil30 = union {
  object { saugreihe60 }
  object { saugreihe61 }
  object { armteilaussen30 }
  object { armteilinnen30 }
  rotate -0.0*y
  translate  <0.177544, 0.0, -5.043157>
  scale 0.32768
  rotate <-162.96402, -218.96611, -135.654144>
  translate  <-0.061007, 0.0, -11.846591>
}
#declare saugnapf372 = union {
  torus { // Torus383
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr409
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf373 = union {
  torus { // Torus384
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr410
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf374 = union {
  torus { // Torus385
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr411
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf375 = union {
  torus { // Torus386
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr412
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf376 = union {
  torus { // Torus387
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr413
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf377 = union {
  torus { // Torus388
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr414
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe62 = union {
  object { saugnapf372 }
  object { saugnapf373 }
  object { saugnapf374 }
  object { saugnapf375 }
  object { saugnapf376 }
  object { saugnapf377 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf378 = union {
  torus { // Torus389
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr415
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf379 = union {
  torus { // Torus390
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr416
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf380 = union {
  torus { // Torus391
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr417
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf381 = union {
  torus { // Torus392
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr418
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf382 = union {
  torus { // Torus393
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr419
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf383 = union {
  torus { // Torus394
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr420
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe63 = union {
  object { saugnapf378 }
  object { saugnapf379 }
  object { saugnapf380 }
  object { saugnapf381 }
  object { saugnapf382 }
  object { saugnapf383 }
}
#declare armteilaussen31 = union {
  sphere { // Sphere219
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere220
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone072
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.063949, 0.0, 9.800106>
    scale 1.0/0.4096
    translate  <-0.156126, 0.0, 5.027255>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate 15.690114*z rotate 5.243773*y rotate -28.284327*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate -10.374993*z rotate 34.154243*y rotate 7.988245*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -2.413357*z rotate -7.630525*y rotate 25.466709*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -19.53281*z rotate 22.465298*y rotate 33.553711*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-1.767767, 1.767767, 0.0>
    rotate -296.99469*z rotate 231.821533*y rotate -188.917511*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen31 = union {
  sphere { // Sphere221
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere222
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone073
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil31 = union {
  object { saugreihe62 }
  object { saugreihe63 }
  object { armteilaussen31 }
  object { armteilinnen31 }
  rotate -0.0*y
  translate  <0.156126, 0.0, -5.027255>
  scale 0.4096
  translate  <-0.063949, 0.0, -9.800106>
}
#declare tentaka5 = union {
  object { armteil30 }
  object { armteil31 }
  rotate -0.0*y
  translate  <0.083933, 0.0, 9.820163>
  rotate <28.284327, -5.243773, -15.690114>
  translate  <-0.083933, 0.0, -9.820163>
}
#declare saugnapf384 = union {
  torus { // Torus395
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr421
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf385 = union {
  torus { // Torus396
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr422
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf386 = union {
  torus { // Torus397
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr423
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf387 = union {
  torus { // Torus398
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr424
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf388 = union {
  torus { // Torus399
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr425
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf389 = union {
  torus { // Torus400
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr426
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe64 = union {
  object { saugnapf384 }
  object { saugnapf385 }
  object { saugnapf386 }
  object { saugnapf387 }
  object { saugnapf388 }
  object { saugnapf389 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf390 = union {
  torus { // Torus401
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr427
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf391 = union {
  torus { // Torus402
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr428
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf392 = union {
  torus { // Torus403
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr429
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf393 = union {
  torus { // Torus404
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr430
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf394 = union {
  torus { // Torus405
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr431
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf395 = union {
  torus { // Torus406
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr432
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe65 = union {
  object { saugnapf390 }
  object { saugnapf391 }
  object { saugnapf392 }
  object { saugnapf393 }
  object { saugnapf394 }
  object { saugnapf395 }
}
#declare armteilaussen32 = union {
  sphere { // Sphere223
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere224
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone074
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.095217, 0.0, 7.227235>
    scale 1.0/0.512
    translate  <-0.162371, 0.0, 5.033499>
    translate  <0.083933, 0.0, 7.232228>
    rotate -10.374993*z rotate 34.154243*y rotate 7.988245*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -2.413357*z rotate -7.630525*y rotate 25.466709*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -19.53281*z rotate 22.465298*y rotate 33.553711*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-1.767767, 1.767767, 0.0>
    rotate -296.99469*z rotate 231.821533*y rotate -188.917511*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen32 = union {
  sphere { // Sphere225
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere226
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone075
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil32 = union {
  object { saugreihe64 }
  object { saugreihe65 }
  object { armteilaussen32 }
  object { armteilinnen32 }
  translate  <0.162371, 0.0, -5.033499>
  scale 0.512
  translate  <-0.095217, 0.0, -7.227235>
}
#declare tentakb5 = union {
  object { tentaka5 }
  object { armteil32 }
  rotate 0.0*y
  translate  <0.083933, 0.0, 7.232228>
  rotate <-7.988245, -34.154243, 10.374993>
  translate  <-0.083933, 0.0, -7.232228>
}
#declare saugnapf396 = union {
  torus { // Torus407
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr433
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf397 = union {
  torus { // Torus408
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr434
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf398 = union {
  torus { // Torus409
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr435
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf399 = union {
  torus { // Torus410
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr436
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf400 = union {
  torus { // Torus411
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr437
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf401 = union {
  torus { // Torus412
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr438
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe66 = union {
  object { saugnapf396 }
  object { saugnapf397 }
  object { saugnapf398 }
  object { saugnapf399 }
  object { saugnapf400 }
  object { saugnapf401 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf402 = union {
  torus { // Torus413
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr439
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf403 = union {
  torus { // Torus414
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr440
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf404 = union {
  torus { // Torus415
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr441
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf405 = union {
  torus { // Torus416
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr442
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf406 = union {
  torus { // Torus417
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr443
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf407 = union {
  torus { // Torus418
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr444
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe67 = union {
  object { saugnapf402 }
  object { saugnapf403 }
  object { saugnapf404 }
  object { saugnapf405 }
  object { saugnapf406 }
  object { saugnapf407 }
}
#declare armteilaussen33 = union {
  sphere { // Sphere227
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere228
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone076
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.193325, 0.0, 4.006921>
    scale 1.0/0.64
    translate  <-0.283191, 0.0, 5.040802>
    rotate 0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -2.413357*z rotate -7.630525*y rotate 25.466709*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -19.53281*z rotate 22.465298*y rotate 33.553711*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-1.767767, 1.767767, 0.0>
    rotate -296.99469*z rotate 231.821533*y rotate -188.917511*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen33 = union {
  sphere { // Sphere229
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere230
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone077
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil33 = union {
  object { saugreihe66 }
  object { saugreihe67 }
  object { armteilaussen33 }
  object { armteilinnen33 }
  rotate -0.0*y
  translate  <0.283191, 0.0, -5.040802>
  scale 0.64
  translate  <-0.193325, 0.0, -4.006921>
}
#declare tentakc5 = union {
  object { tentakb5 }
  object { armteil33 }
  translate  <0.223821, 0.0, 4.014796>
  rotate <-25.466709, 7.630525, 2.413357>
  translate  <-0.223821, 0.0, -4.014796>
}
#declare saugnapf408 = union {
  torus { // Torus419
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr445
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf409 = union {
  torus { // Torus420
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr446
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf410 = union {
  torus { // Torus421
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr447
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf411 = union {
  torus { // Torus422
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr448
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf412 = union {
  torus { // Torus423
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr449
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf413 = union {
  torus { // Torus424
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr450
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe68 = union {
  object { saugnapf408 }
  object { saugnapf409 }
  object { saugnapf410 }
  object { saugnapf411 }
  object { saugnapf412 }
  object { saugnapf413 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf414 = union {
  torus { // Torus425
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr451
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf415 = union {
  torus { // Torus426
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr452
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf416 = union {
  torus { // Torus427
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr453
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf417 = union {
  torus { // Torus428
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr454
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf418 = union {
  torus { // Torus429
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr455
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf419 = union {
  torus { // Torus430
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr456
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe69 = union {
  object { saugnapf414 }
  object { saugnapf415 }
  object { saugnapf416 }
  object { saugnapf417 }
  object { saugnapf418 }
  object { saugnapf419 }
}
#declare armteilaussen34 = union {
  sphere { // Sphere231
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere232
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone078
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.205408, 0.0, 0.007886>
    scale 1.0/0.8
    translate  <-0.25676, 0.0, 5.014371>
    translate  <0.230349, 0.0, -0.024247>
    rotate -19.53281*z rotate 22.465298*y rotate 33.553711*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <-1.767767, 1.767767, 0.0>
    rotate -296.99469*z rotate 231.821533*y rotate -188.917511*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen34 = union {
  sphere { // Sphere233
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere234
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone079
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil34 = union {
  object { saugreihe68 }
  object { saugreihe69 }
  object { armteilaussen34 }
  object { armteilinnen34 }
  translate  <0.25676, 0.0, -5.014371>
  scale 0.8
  translate  <-0.205408, 0.0, -0.007886>
}
#declare tentakd5 = union {
  object { tentakc5 }
  object { armteil34 }
  translate  <0.230349, 0.0, -0.024247>
  rotate <-33.553711, -22.465298, 19.53281>
  translate  <-0.230349, 0.0, 0.024247>
}
#declare saugnapf420 = union {
  torus { // Torus431
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr457
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf421 = union {
  torus { // Torus432
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr458
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf422 = union {
  torus { // Torus433
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr459
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf423 = union {
  torus { // Torus434
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr460
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf424 = union {
  torus { // Torus435
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr461
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf425 = union {
  torus { // Torus436
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr462
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe70 = union {
  object { saugnapf420 }
  object { saugnapf421 }
  object { saugnapf422 }
  object { saugnapf423 }
  object { saugnapf424 }
  object { saugnapf425 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf426 = union {
  torus { // Torus437
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr463
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf427 = union {
  torus { // Torus438
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr464
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf428 = union {
  torus { // Torus439
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr465
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf429 = union {
  torus { // Torus440
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr466
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf430 = union {
  torus { // Torus441
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr467
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf431 = union {
  torus { // Torus442
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr468
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe71 = union {
  object { saugnapf426 }
  object { saugnapf427 }
  object { saugnapf428 }
  object { saugnapf429 }
  object { saugnapf430 }
  object { saugnapf431 }
}
#declare armteilaussen35 = union {
  sphere { // Sphere235
    <0,0,0>,1
    scale <1.003325, 1.482848, 1.228788>
    translate  5.0*z
    material {
      oktoMskinMaussen
      // Transform to world space
      translate  0.25*x
      rotate 0.647847*y
      scale <1.0/0.777959, 1.0/1.184654, 1.0/1.0>
      translate  <0.281548, 0.0, -4.951811>
      translate  <-0.281548, 0.0, 4.951811>
      translate  <-1.767767, 1.767767, 0.0>
      rotate -296.99469*z rotate 231.821533*y rotate -188.917511*x
      translate  <-0.262187, 0.0, 4.977383>
      rotate 0.0*y
      translate  <12.127279, 18.190885, 4.082331>
      rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
      scale 1.0/2.5
    }
  }
  sphere { // Sphere236
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone080
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.281548, 0.0, -4.951811>
    translate  <-0.281548, 0.0, 4.951811>
    translate  <-1.767767, 1.767767, 0.0>
    rotate -296.99469*z rotate 231.821533*y rotate -188.917511*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen35 = union {
  sphere { // Sphere237
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere238
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone081
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil35 = union {
  object { saugreihe70 }
  object { saugreihe71 }
  object { armteilaussen35 }
  object { armteilinnen35 }
  translate  <0.281548, 0.0, -4.951811>
  translate  <-0.281548, 0.0, 4.951811>
}
#declare tentakel5 = union {
  object { tentakd5 }
  object { armteil35 }
  rotate -0.0*y
  translate  <0.262187, 0.0, -4.977383>
  rotate <188.917511, -231.821533, 296.99469>
  translate  <1.767767, -1.767767, 0.0>
}
#declare saugnapf504 = union {
  torus { // Torus515
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr597
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf505 = union {
  torus { // Torus516
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr598
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf506 = union {
  torus { // Torus517
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr599
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf507 = union {
  torus { // Torus518
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr600
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf508 = union {
  torus { // Torus519
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr601
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf509 = union {
  torus { // Torus520
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr602
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe84 = union {
  object { saugnapf504 }
  object { saugnapf505 }
  object { saugnapf506 }
  object { saugnapf507 }
  object { saugnapf508 }
  object { saugnapf509 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf510 = union {
  torus { // Torus521
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr603
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf511 = union {
  torus { // Torus522
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr604
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf512 = union {
  torus { // Torus523
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr605
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf513 = union {
  torus { // Torus524
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr606
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf514 = union {
  torus { // Torus525
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr607
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf515 = union {
  torus { // Torus526
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr608
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe85 = union {
  object { saugnapf510 }
  object { saugnapf511 }
  object { saugnapf512 }
  object { saugnapf513 }
  object { saugnapf514 }
  object { saugnapf515 }
}
#declare armteilaussen42 = union {
  sphere { // Sphere263
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere264
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone094
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.061007, 0.0, 11.846591>
    rotate -146.516785*z rotate 235.978195*y rotate -128.899368*x
    scale 1.0/0.32768
    translate  <-0.177544, 0.0, 5.043157>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate 156.571777*z rotate 117.357857*y rotate -176.426468*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate 11.66979*z rotate -31.253572*y rotate 15.028618*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 161.85321*z rotate 140.788544*y rotate -172.367966*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -21.227793*z rotate 9.385366*y rotate -9.639211*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <1.767767, 1.767767, 0.0>
    rotate -181.718185*z rotate 211.367599*y rotate -135.457275*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen42 = union {
  sphere { // Sphere265
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere266
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
    scale 0.8
  }
  cone { // Cone095
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil42 = union {
  object { saugreihe84 }
  object { saugreihe85 }
  object { armteilaussen42 }
  object { armteilinnen42 }
  rotate -0.0*y
  translate  <0.177544, 0.0, -5.043157>
  scale 0.32768
  rotate <128.899368, -235.978195, 146.516785>
  translate  <-0.061007, 0.0, -11.846591>
}
#declare saugnapf516 = union {
  torus { // Torus527
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr609
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf517 = union {
  torus { // Torus528
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr610
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf518 = union {
  torus { // Torus529
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr611
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf519 = union {
  torus { // Torus530
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr612
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf520 = union {
  torus { // Torus531
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr613
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf521 = union {
  torus { // Torus532
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr614
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe86 = union {
  object { saugnapf516 }
  object { saugnapf517 }
  object { saugnapf518 }
  object { saugnapf519 }
  object { saugnapf520 }
  object { saugnapf521 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf522 = union {
  torus { // Torus533
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr615
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf523 = union {
  torus { // Torus534
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr616
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf524 = union {
  torus { // Torus535
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr617
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf525 = union {
  torus { // Torus536
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr618
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf526 = union {
  torus { // Torus537
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr619
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf527 = union {
  torus { // Torus538
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr620
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe87 = union {
  object { saugnapf522 }
  object { saugnapf523 }
  object { saugnapf524 }
  object { saugnapf525 }
  object { saugnapf526 }
  object { saugnapf527 }
}
#declare armteilaussen43 = union {
  sphere { // Sphere267
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere268
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone096
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.063949, 0.0, 9.800106>
    scale 1.0/0.4096
    translate  <-0.156126, 0.0, 5.027255>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate 156.571777*z rotate 117.357857*y rotate -176.426468*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate 11.66979*z rotate -31.253572*y rotate 15.028618*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 161.85321*z rotate 140.788544*y rotate -172.367966*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -21.227793*z rotate 9.385366*y rotate -9.639211*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <1.767767, 1.767767, 0.0>
    rotate -181.718185*z rotate 211.367599*y rotate -135.457275*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen43 = union {
  sphere { // Sphere269
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere270
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone097
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil43 = union {
  object { saugreihe86 }
  object { saugreihe87 }
  object { armteilaussen43 }
  object { armteilinnen43 }
  rotate -0.0*y
  translate  <0.156126, 0.0, -5.027255>
  scale 0.4096
  translate  <-0.063949, 0.0, -9.800106>
}
#declare tentaka7 = union {
  object { armteil42 }
  object { armteil43 }
  rotate -0.0*y
  translate  <0.083933, 0.0, 9.820163>
  rotate <176.426468, -117.357857, -156.571777>
  translate  <-0.083933, 0.0, -9.820163>
}
#declare saugnapf528 = union {
  torus { // Torus539
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr621
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf529 = union {
  torus { // Torus540
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr622
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf530 = union {
  torus { // Torus541
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr623
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf531 = union {
  torus { // Torus542
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr624
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf532 = union {
  torus { // Torus543
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr625
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf533 = union {
  torus { // Torus544
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr626
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe88 = union {
  object { saugnapf528 }
  object { saugnapf529 }
  object { saugnapf530 }
  object { saugnapf531 }
  object { saugnapf532 }
  object { saugnapf533 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf534 = union {
  torus { // Torus545
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr627
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf535 = union {
  torus { // Torus546
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr628
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf536 = union {
  torus { // Torus547
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr629
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf537 = union {
  torus { // Torus548
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr630
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf538 = union {
  torus { // Torus549
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr631
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf539 = union {
  torus { // Torus550
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr632
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe89 = union {
  object { saugnapf534 }
  object { saugnapf535 }
  object { saugnapf536 }
  object { saugnapf537 }
  object { saugnapf538 }
  object { saugnapf539 }
}
#declare armteilaussen44 = union {
  sphere { // Sphere271
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere272
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone098
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.095217, 0.0, 7.227235>
    scale 1.0/0.512
    translate  <-0.162371, 0.0, 5.033499>
    translate  <0.083933, 0.0, 7.232228>
    rotate 11.66979*z rotate -31.253572*y rotate 15.028618*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 161.85321*z rotate 140.788544*y rotate -172.367966*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -21.227793*z rotate 9.385366*y rotate -9.639211*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <1.767767, 1.767767, 0.0>
    rotate -181.718185*z rotate 211.367599*y rotate -135.457275*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen44 = union {
  sphere { // Sphere273
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere274
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone099
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil44 = union {
  object { saugreihe88 }
  object { saugreihe89 }
  object { armteilaussen44 }
  object { armteilinnen44 }
  translate  <0.162371, 0.0, -5.033499>
  scale 0.512
  translate  <-0.095217, 0.0, -7.227235>
}
#declare tentakb7 = union {
  object { tentaka7 }
  object { armteil44 }
  rotate 0.0*y
  translate  <0.083933, 0.0, 7.232228>
  rotate <-15.028618, 31.253572, -11.66979>
  translate  <-0.083933, 0.0, -7.232228>
}
#declare saugnapf540 = union {
  torus { // Torus551
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr633
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf541 = union {
  torus { // Torus552
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr634
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf542 = union {
  torus { // Torus553
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr635
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf543 = union {
  torus { // Torus554
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr636
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf544 = union {
  torus { // Torus555
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr637
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf545 = union {
  torus { // Torus556
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr638
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe90 = union {
  object { saugnapf540 }
  object { saugnapf541 }
  object { saugnapf542 }
  object { saugnapf543 }
  object { saugnapf544 }
  object { saugnapf545 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf546 = union {
  torus { // Torus557
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr639
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf547 = union {
  torus { // Torus558
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr640
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf548 = union {
  torus { // Torus559
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr641
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf549 = union {
  torus { // Torus560
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr642
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf550 = union {
  torus { // Torus561
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr643
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf551 = union {
  torus { // Torus562
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr644
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe91 = union {
  object { saugnapf546 }
  object { saugnapf547 }
  object { saugnapf548 }
  object { saugnapf549 }
  object { saugnapf550 }
  object { saugnapf551 }
}
#declare armteilaussen45 = union {
  sphere { // Sphere275
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere276
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone100
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.193325, 0.0, 4.006921>
    scale 1.0/0.64
    translate  <-0.283191, 0.0, 5.040802>
    rotate 0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate 161.85321*z rotate 140.788544*y rotate -172.367966*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate -21.227793*z rotate 9.385366*y rotate -9.639211*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <1.767767, 1.767767, 0.0>
    rotate -181.718185*z rotate 211.367599*y rotate -135.457275*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen45 = union {
  sphere { // Sphere277
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere278
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone101
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil45 = union {
  object { saugreihe90 }
  object { saugreihe91 }
  object { armteilaussen45 }
  object { armteilinnen45 }
  rotate -0.0*y
  translate  <0.283191, 0.0, -5.040802>
  scale 0.64
  translate  <-0.193325, 0.0, -4.006921>
}
#declare tentakc7 = union {
  object { tentakb7 }
  object { armteil45 }
  translate  <0.223821, 0.0, 4.014796>
  rotate <172.367966, -140.788544, -161.85321>
  translate  <-0.223821, 0.0, -4.014796>
}
#declare saugnapf552 = union {
  torus { // Torus563
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr645
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf553 = union {
  torus { // Torus564
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr646
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf554 = union {
  torus { // Torus565
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr647
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf555 = union {
  torus { // Torus566
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr648
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf556 = union {
  torus { // Torus567
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr649
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf557 = union {
  torus { // Torus568
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr650
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe92 = union {
  object { saugnapf552 }
  object { saugnapf553 }
  object { saugnapf554 }
  object { saugnapf555 }
  object { saugnapf556 }
  object { saugnapf557 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf558 = union {
  torus { // Torus569
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr651
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf559 = union {
  torus { // Torus570
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr652
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf560 = union {
  torus { // Torus571
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr653
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf561 = union {
  torus { // Torus572
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr654
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf562 = union {
  torus { // Torus573
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr655
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf563 = union {
  torus { // Torus574
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr656
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe93 = union {
  object { saugnapf558 }
  object { saugnapf559 }
  object { saugnapf560 }
  object { saugnapf561 }
  object { saugnapf562 }
  object { saugnapf563 }
}
#declare armteilaussen46 = union {
  sphere { // Sphere279
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere280
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone102
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.205408, 0.0, 0.007886>
    scale 1.0/0.8
    translate  <-0.25676, 0.0, 5.014371>
    translate  <0.230349, 0.0, -0.024247>
    rotate -21.227793*z rotate 9.385366*y rotate -9.639211*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <1.767767, 1.767767, 0.0>
    rotate -181.718185*z rotate 211.367599*y rotate -135.457275*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen46 = union {
  sphere { // Sphere281
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere282
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone103
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil46 = union {
  object { saugreihe92 }
  object { saugreihe93 }
  object { armteilaussen46 }
  object { armteilinnen46 }
  translate  <0.25676, 0.0, -5.014371>
  scale 0.8
  translate  <-0.205408, 0.0, -0.007886>
}
#declare tentakd7 = union {
  object { tentakc7 }
  object { armteil46 }
  translate  <0.230349, 0.0, -0.024247>
  rotate <9.639211, -9.385366, 21.227793>
  translate  <-0.230349, 0.0, 0.024247>
}
#declare saugnapf564 = union {
  torus { // Torus575
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr657
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf565 = union {
  torus { // Torus576
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr658
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf566 = union {
  torus { // Torus577
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr659
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf567 = union {
  torus { // Torus578
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr660
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf568 = union {
  torus { // Torus579
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr661
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf569 = union {
  torus { // Torus580
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr662
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe94 = union {
  object { saugnapf564 }
  object { saugnapf565 }
  object { saugnapf566 }
  object { saugnapf567 }
  object { saugnapf568 }
  object { saugnapf569 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf570 = union {
  torus { // Torus581
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr663
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf571 = union {
  torus { // Torus582
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr664
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf572 = union {
  torus { // Torus583
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr665
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf573 = union {
  torus { // Torus584
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr666
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf574 = union {
  torus { // Torus585
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr667
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf575 = union {
  torus { // Torus586
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr668
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe95 = union {
  object { saugnapf570 }
  object { saugnapf571 }
  object { saugnapf572 }
  object { saugnapf573 }
  object { saugnapf574 }
  object { saugnapf575 }
}
#declare armteilaussen47 = union {
  sphere { // Sphere283
    <0,0,0>,1
    scale <1.003325, 1.482848, 1.228788>
    translate  5.0*z
    material {
      oktoMskinMaussen
      // Transform to world space
      translate  0.25*x
      rotate 0.647847*y
      scale <1.0/0.777959, 1.0/1.184654, 1.0/1.0>
      translate  <0.281548, 0.0, -4.951811>
      translate  <-0.281548, 0.0, 4.951811>
      translate  <1.767767, 1.767767, 0.0>
      rotate -181.718185*z rotate 211.367599*y rotate -135.457275*x
      translate  <-0.262187, 0.0, 4.977383>
      rotate 0.0*y
      translate  <12.127279, 18.190885, 4.082331>
      rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
      scale 1.0/2.5
    }
  }
  sphere { // Sphere284
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone104
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.281548, 0.0, -4.951811>
    translate  <-0.281548, 0.0, 4.951811>
    translate  <1.767767, 1.767767, 0.0>
    rotate -181.718185*z rotate 211.367599*y rotate -135.457275*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen47 = union {
  sphere { // Sphere285
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere286
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone105
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil47 = union {
  object { saugreihe94 }
  object { saugreihe95 }
  object { armteilaussen47 }
  object { armteilinnen47 }
  translate  <0.281548, 0.0, -4.951811>
  translate  <-0.281548, 0.0, 4.951811>
}
#declare tentakel7 = union {
  object { tentakd7 }
  object { armteil47 }
  rotate -0.0*y
  translate  <0.262187, 0.0, -4.977383>
  rotate <135.457275, -211.367599, 181.718185>
  translate  <-1.767767, -1.767767, 0.0>
}
#declare saugnapf432 = union {
  torus { // Torus443
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr469
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf433 = union {
  torus { // Torus444
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr470
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf434 = union {
  torus { // Torus445
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr471
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf435 = union {
  torus { // Torus446
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr472
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf436 = union {
  torus { // Torus447
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr473
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf437 = union {
  torus { // Torus448
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr474
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe72 = union {
  object { saugnapf432 }
  object { saugnapf433 }
  object { saugnapf434 }
  object { saugnapf435 }
  object { saugnapf436 }
  object { saugnapf437 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf438 = union {
  torus { // Torus449
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr475
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf439 = union {
  torus { // Torus450
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr476
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf440 = union {
  torus { // Torus451
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr477
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf441 = union {
  torus { // Torus452
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr478
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf442 = union {
  torus { // Torus453
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr479
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf443 = union {
  torus { // Torus454
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr480
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe73 = union {
  object { saugnapf438 }
  object { saugnapf439 }
  object { saugnapf440 }
  object { saugnapf441 }
  object { saugnapf442 }
  object { saugnapf443 }
}
#declare armteilaussen36 = union {
  sphere { // Sphere239
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere240
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone082
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.061007, 0.0, 11.846591>
    rotate 1.951938*z rotate -43.193317*y rotate 5.356513*x
    scale 1.0/0.32768
    translate  <-0.177544, 0.0, 5.043157>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate -51.047016*z rotate 32.556255*y rotate -9.986956*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate 9.227514*z rotate 21.519602*y rotate -9.966493*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -173.466537*z rotate 194.483688*y rotate -166.367935*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 155.73085*z rotate 147.133804*y rotate -180.481308*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <0.0, 2.5, 0.0>
    rotate -215.480515*z rotate 228.703552*y rotate -131.38652*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen36 = union {
  sphere { // Sphere241
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere242
    <0,0,0>,1
    material {
      oktoMskinMaussen
    }
    scale 0.8
  }
  cone { // Cone083
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil36 = union {
  object { saugreihe72 }
  object { saugreihe73 }
  object { armteilaussen36 }
  object { armteilinnen36 }
  rotate -0.0*y
  translate  <0.177544, 0.0, -5.043157>
  scale 0.32768
  rotate <-5.356513, 43.193317, -1.951938>
  translate  <-0.061007, 0.0, -11.846591>
}
#declare saugnapf444 = union {
  torus { // Torus455
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr481
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf445 = union {
  torus { // Torus456
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr482
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf446 = union {
  torus { // Torus457
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr483
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf447 = union {
  torus { // Torus458
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr484
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf448 = union {
  torus { // Torus459
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr485
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf449 = union {
  torus { // Torus460
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr486
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe74 = union {
  object { saugnapf444 }
  object { saugnapf445 }
  object { saugnapf446 }
  object { saugnapf447 }
  object { saugnapf448 }
  object { saugnapf449 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf450 = union {
  torus { // Torus461
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr487
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf451 = union {
  torus { // Torus462
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr488
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf452 = union {
  torus { // Torus463
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr545
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf453 = union {
  torus { // Torus464
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr546
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf454 = union {
  torus { // Torus465
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr547
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf455 = union {
  torus { // Torus466
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr548
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe75 = union {
  object { saugnapf450 }
  object { saugnapf451 }
  object { saugnapf452 }
  object { saugnapf453 }
  object { saugnapf454 }
  object { saugnapf455 }
}
#declare armteilaussen37 = union {
  sphere { // Sphere243
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere244
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone084
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.063949, 0.0, 9.800106>
    scale 1.0/0.4096
    translate  <-0.156126, 0.0, 5.027255>
    rotate 0.0*y
    translate  <0.083933, 0.0, 9.820163>
    rotate -51.047016*z rotate 32.556255*y rotate -9.986956*x
    translate  <-0.083933, 0.0, -9.820163>
    rotate 0.0*y
    translate  <0.083933, 0.0, 7.232228>
    rotate 9.227514*z rotate 21.519602*y rotate -9.966493*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -173.466537*z rotate 194.483688*y rotate -166.367935*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 155.73085*z rotate 147.133804*y rotate -180.481308*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <0.0, 2.5, 0.0>
    rotate -215.480515*z rotate 228.703552*y rotate -131.38652*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen37 = union {
  sphere { // Sphere245
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere246
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone085
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil37 = union {
  object { saugreihe74 }
  object { saugreihe75 }
  object { armteilaussen37 }
  object { armteilinnen37 }
  rotate -0.0*y
  translate  <0.156126, 0.0, -5.027255>
  scale 0.4096
  translate  <-0.063949, 0.0, -9.800106>
}
#declare tentaka6 = union {
  object { armteil36 }
  object { armteil37 }
  rotate -0.0*y
  translate  <0.083933, 0.0, 9.820163>
  rotate <9.986956, -32.556255, 51.047016>
  translate  <-0.083933, 0.0, -9.820163>
}
#declare saugnapf456 = union {
  torus { // Torus467
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr549
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf457 = union {
  torus { // Torus468
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr550
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf458 = union {
  torus { // Torus469
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr551
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf459 = union {
  torus { // Torus470
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr552
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf460 = union {
  torus { // Torus471
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr553
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf461 = union {
  torus { // Torus472
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr554
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe76 = union {
  object { saugnapf456 }
  object { saugnapf457 }
  object { saugnapf458 }
  object { saugnapf459 }
  object { saugnapf460 }
  object { saugnapf461 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf462 = union {
  torus { // Torus473
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr555
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf463 = union {
  torus { // Torus474
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr556
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf464 = union {
  torus { // Torus475
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr557
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf465 = union {
  torus { // Torus476
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr558
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf466 = union {
  torus { // Torus477
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr559
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf467 = union {
  torus { // Torus478
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr560
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe77 = union {
  object { saugnapf462 }
  object { saugnapf463 }
  object { saugnapf464 }
  object { saugnapf465 }
  object { saugnapf466 }
  object { saugnapf467 }
}
#declare armteilaussen38 = union {
  sphere { // Sphere247
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere248
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone086
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.095217, 0.0, 7.227235>
    scale 1.0/0.512
    translate  <-0.162371, 0.0, 5.033499>
    translate  <0.083933, 0.0, 7.232228>
    rotate 9.227514*z rotate 21.519602*y rotate -9.966493*x
    translate  <-0.083933, 0.0, -7.232228>
    rotate -0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -173.466537*z rotate 194.483688*y rotate -166.367935*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 155.73085*z rotate 147.133804*y rotate -180.481308*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <0.0, 2.5, 0.0>
    rotate -215.480515*z rotate 228.703552*y rotate -131.38652*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen38 = union {
  sphere { // Sphere249
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere250
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone087
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil38 = union {
  object { saugreihe76 }
  object { saugreihe77 }
  object { armteilaussen38 }
  object { armteilinnen38 }
  translate  <0.162371, 0.0, -5.033499>
  scale 0.512
  translate  <-0.095217, 0.0, -7.227235>
}
#declare tentakb6 = union {
  object { tentaka6 }
  object { armteil38 }
  rotate 0.0*y
  translate  <0.083933, 0.0, 7.232228>
  rotate <9.966493, -21.519602, -9.227514>
  translate  <-0.083933, 0.0, -7.232228>
}
#declare saugnapf468 = union {
  torus { // Torus479
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr561
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf469 = union {
  torus { // Torus480
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr562
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf470 = union {
  torus { // Torus481
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr563
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf471 = union {
  torus { // Torus482
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr564
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf472 = union {
  torus { // Torus483
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr565
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf473 = union {
  torus { // Torus484
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr566
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe78 = union {
  object { saugnapf468 }
  object { saugnapf469 }
  object { saugnapf470 }
  object { saugnapf471 }
  object { saugnapf472 }
  object { saugnapf473 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf474 = union {
  torus { // Torus485
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr567
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf475 = union {
  torus { // Torus486
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr568
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf476 = union {
  torus { // Torus487
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr569
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf477 = union {
  torus { // Torus488
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr570
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf478 = union {
  torus { // Torus489
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr571
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf479 = union {
  torus { // Torus490
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr572
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe79 = union {
  object { saugnapf474 }
  object { saugnapf475 }
  object { saugnapf476 }
  object { saugnapf477 }
  object { saugnapf478 }
  object { saugnapf479 }
}
#declare armteilaussen39 = union {
  sphere { // Sphere251
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere252
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone088
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.193325, 0.0, 4.006921>
    scale 1.0/0.64
    translate  <-0.283191, 0.0, 5.040802>
    rotate 0.0*y
    translate  <0.223821, 0.0, 4.014796>
    rotate -173.466537*z rotate 194.483688*y rotate -166.367935*x
    translate  <-0.223821, 0.0, -4.014796>
    translate  <0.230349, 0.0, -0.024247>
    rotate 155.73085*z rotate 147.133804*y rotate -180.481308*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <0.0, 2.5, 0.0>
    rotate -215.480515*z rotate 228.703552*y rotate -131.38652*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen39 = union {
  sphere { // Sphere253
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere254
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone089
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil39 = union {
  object { saugreihe78 }
  object { saugreihe79 }
  object { armteilaussen39 }
  object { armteilinnen39 }
  rotate -0.0*y
  translate  <0.283191, 0.0, -5.040802>
  scale 0.64
  translate  <-0.193325, 0.0, -4.006921>
}
#declare tentakc6 = union {
  object { tentakb6 }
  object { armteil39 }
  translate  <0.223821, 0.0, 4.014796>
  rotate <166.367935, -194.483688, 173.466537>
  translate  <-0.223821, 0.0, -4.014796>
}
#declare saugnapf480 = union {
  torus { // Torus491
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr573
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf481 = union {
  torus { // Torus492
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr574
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf482 = union {
  torus { // Torus493
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr575
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf483 = union {
  torus { // Torus494
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr576
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf484 = union {
  torus { // Torus495
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr577
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf485 = union {
  torus { // Torus496
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr578
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe80 = union {
  object { saugnapf480 }
  object { saugnapf481 }
  object { saugnapf482 }
  object { saugnapf483 }
  object { saugnapf484 }
  object { saugnapf485 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf486 = union {
  torus { // Torus497
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr579
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf487 = union {
  torus { // Torus498
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr580
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf488 = union {
  torus { // Torus499
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr581
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf489 = union {
  torus { // Torus500
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr582
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf490 = union {
  torus { // Torus501
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr583
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf491 = union {
  torus { // Torus502
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr584
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe81 = union {
  object { saugnapf486 }
  object { saugnapf487 }
  object { saugnapf488 }
  object { saugnapf489 }
  object { saugnapf490 }
  object { saugnapf491 }
}
#declare armteilaussen40 = union {
  sphere { // Sphere255
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere256
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone090
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.205408, 0.0, 0.007886>
    scale 1.0/0.8
    translate  <-0.25676, 0.0, 5.014371>
    translate  <0.230349, 0.0, -0.024247>
    rotate 155.73085*z rotate 147.133804*y rotate -180.481308*x
    translate  <-0.230349, 0.0, 0.024247>
    translate  <0.0, 2.5, 0.0>
    rotate -215.480515*z rotate 228.703552*y rotate -131.38652*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen40 = union {
  sphere { // Sphere257
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere258
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone091
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil40 = union {
  object { saugreihe80 }
  object { saugreihe81 }
  object { armteilaussen40 }
  object { armteilinnen40 }
  translate  <0.25676, 0.0, -5.014371>
  scale 0.8
  translate  <-0.205408, 0.0, -0.007886>
}
#declare tentakd6 = union {
  object { tentakc6 }
  object { armteil40 }
  translate  <0.230349, 0.0, -0.024247>
  rotate <180.481308, -147.133804, -155.73085>
  translate  <-0.230349, 0.0, 0.024247>
}
#declare saugnapf492 = union {
  torus { // Torus503
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr585
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf493 = union {
  torus { // Torus504
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr586
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.448206, 0.301582, 1.174916>
}
#declare saugnapf494 = union {
  torus { // Torus505
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr587
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf495 = union {
  torus { // Torus506
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr588
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.475896, 0.343117, 2.799521>
}
#declare saugnapf496 = union {
  torus { // Torus507
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr589
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf497 = union {
  torus { // Torus508
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr590
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.522959, 0.369554, 4.521041>
}
#declare saugreihe82 = union {
  object { saugnapf492 }
  object { saugnapf493 }
  object { saugnapf494 }
  object { saugnapf495 }
  object { saugnapf496 }
  object { saugnapf497 }
  rotate -33.189659*z
  translate  <-0.174668, -0.547292, 0.0>
}
#declare saugnapf498 = union {
  torus { // Torus509
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr591
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.171747
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.465416, 0.342122, 0.411071>
}
#declare saugnapf499 = union {
  torus { // Torus510
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr592
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.177059
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.422925, 0.450499, 1.174916>
}
#declare saugnapf500 = union {
  torus { // Torus511
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr593
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.182535
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.451572, 0.397502, 1.994141>
}
#declare saugnapf501 = union {
  torus { // Torus512
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr594
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.18818
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.469713, 0.463387, 2.799521>
}
#declare saugnapf502 = union {
  torus { // Torus513
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr595
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.194
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.520796, 0.425192, 3.632591>
}
#declare saugnapf503 = union {
  torus { // Torus514
    1.5, 0.5  rotate -x*90
    material {
      oktoMskinMinnen
    }
  }
  cylinder { // Cylndr596
    <0,0,1>, <0,0,0>, 1 
    material {
      oktoMskinMsaugnapf
    }
    scale <1.1, 1.1, 0.5>
    translate  -0.602428*z
  }
  scale 0.2
  rotate <-15.501369, 90.0, 0.0>
  translate  <0.501698, 0.492034, 4.521041>
}
#declare saugreihe83 = union {
  object { saugnapf498 }
  object { saugnapf499 }
  object { saugnapf500 }
  object { saugnapf501 }
  object { saugnapf502 }
  object { saugnapf503 }
}
#declare armteilaussen41 = union {
  sphere { // Sphere259
    <0,0,0>,1
    scale <1.003325, 1.482848, 1.228788>
    translate  5.0*z
    material {
      oktoMskinMaussen
      // Transform to world space
      translate  0.25*x
      rotate 0.647847*y
      scale <1.0/0.777959, 1.0/1.184654, 1.0/1.0>
      translate  <0.281548, 0.0, -4.951811>
      translate  <-0.281548, 0.0, 4.951811>
      translate  <0.0, 2.5, 0.0>
      rotate -215.480515*z rotate 228.703552*y rotate -131.38652*x
      translate  <-0.262187, 0.0, 4.977383>
      rotate 0.0*y
      translate  <12.127279, 18.190885, 4.082331>
      rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
      scale 1.0/2.5
    }
  }
  sphere { // Sphere260
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone092
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  scale <0.777959, 1.184654, 1.0>
  rotate -0.647847*y
  translate  -0.25*x
  material {
    oktoMskinMaussen
    // Transform to world space
    translate  <0.281548, 0.0, -4.951811>
    translate  <-0.281548, 0.0, 4.951811>
    translate  <0.0, 2.5, 0.0>
    rotate -215.480515*z rotate 228.703552*y rotate -131.38652*x
    translate  <-0.262187, 0.0, 4.977383>
    rotate 0.0*y
    translate  <12.127279, 18.190885, 4.082331>
    rotate 153.244034*z rotate -0.0*y rotate -117.226776*x
    scale 1.0/2.5
  }
}
#declare armteilinnen41 = union {
  sphere { // Sphere261
    <0,0,0>,1
    translate  5.0*z
  }
  sphere { // Sphere262
    <0,0,0>,1
    scale 0.8
  }
  cone { // Cone093
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
  }
  material {
    oktoMskinMinnen
  }
  scale <0.534145, 1.0, 1.0>
}
#declare armteil41 = union {
  object { saugreihe82 }
  object { saugreihe83 }
  object { armteilaussen41 }
  object { armteilinnen41 }
  translate  <0.281548, 0.0, -4.951811>
  translate  <-0.281548, 0.0, 4.951811>
}
#declare tentakel6 = union {
  object { tentakd6 }
  object { armteil41 }
  rotate -0.0*y
  translate  <0.262187, 0.0, -4.977383>
  rotate <131.38652, -228.703552, 215.480515>
  translate  <-0.0, -2.5, 0.0>
}
union { // oktopus
  object { oktobody }
  object { oktobasis }
  object { tentakel }
  object { tentakel1 }
  object { tentakel2 }
  object { tentakel3 }
  object { tentakel4 }
  object { tentakel5 }
  object { tentakel7 }
  object { tentakel6 }
  // All transformations fixed
  scale 2.5
  rotate <117.226776, 0.0, -153.244034>
  translate  <-12.127279, -18.190885, -4.082331>
}


// The following include file contains the definition for Zahn16
#include "nautilus.in6"
#declare Zahn16 = object {
  Zahn16_Raw
  rotate <-0.0, -0.0, -0.0>
  translate  <-0.013748, 0.025933, -0.011171>
  material {
    hullMskinMzahn
  }
  scale <1.0, 1.0, 7.0>
  rotate <-105.764191, 44.402512, -11.173172>
  translate  <0.028133, -47.029266, 15.396716>
}
#declare zahnreihe02 = union {
  object { // Zahn09->Zahn01
    Zahn01
    scale <1.0, 1.299493, 1.0>
    rotate <-17.161116, 0.0, -0.0>
    translate  <-0.0, 39.205643, -30.44472>
  }
  object { // Zahn10->Zahn01
    Zahn01
    rotate <-9.414077, -0.0, -0.0>
    translate  <0.0, 25.772307, -19.473517>
  }
  object { // Zahn11->Zahn01
    Zahn01
    rotate <-7.525631, -0.0, -0.0>
    translate  <0.0, 21.493023, -16.314165>
  }
  object { // Zahn12->Zahn01
    Zahn01
    rotate <-6.33498, -0.0, -0.0>
    translate  <0.0, 16.82143, -13.676066>
  }
  object { // Zahn13->Zahn03
    Zahn03
    rotate <17.691128, -0.0, -0.0>
    translate  <0.0, 6.940937, 6.577215>
  }
  object { // Zahn14->Zahn02
    Zahn02
    rotate <8.57032, -0.0, -0.0>
    translate  <0.0, 5.626866, 0.868793>
  }
  object { // Zahn15->Zahn01
    Zahn01
    rotate <0.325482, -0.0, -0.0>
    translate  <0.0, 3.901085, -4.772874>
  }
  object { Zahn16 }
  rotate <180.0, 0.0, 180.0>
}
#declare zahnreihe01 = union {
  object { Zahn08 }
  object { // Zahn07->Zahn01
    Zahn01
    rotate <-9.414077, -0.0, -0.0>
    translate  <0.0, 22.602027, -18.955726>
  }
  object { // Zahn06->Zahn01
    Zahn01
    rotate <-7.525631, -0.0, -0.0>
    translate  <0.0, 19.233726, -15.811409>
  }
  object { // Zahn05->Zahn01
    Zahn01
    rotate <-16.99785, -0.0, -0.0>
    translate  <0.0, 10.544074, -19.965535>
  }
  object { // Zahn04->Zahn03
    Zahn03
    rotate 0.0*x
    translate  <0.0, 4.299557, -2.707451>
  }
  object { Zahn03 }
  object { Zahn02 }
  object { Zahn01 }
  object { // Zahn46->Zahn08
    Zahn08
    rotate 0.0*y
    translate  <0.0, 3.955198, -1.958019>
  }
}
//
// Include file contains 'Rammsporn'
//
#include "nautilus.in7"
#declare Rammsporn = object {
  Rammsporn_Raw
  material {
    hullMskinMzahn
  }
  scale 6.0
  rotate -90.0*x
  translate  -4.439699*y
}
// Include contains 'aufbauMvorne'
#include "nautilus.in8"

#declare aufbauMvorne = object {
  aufbauMvorne_Raw
  material {
    hullMskinMparts
  }
  scale <-8.186571, -12.162523, -21.699602>
  rotate 90.0*z
  translate  <0.0, -59.114382, 12.615413>
}
// Include contains 'aufbau_hinten'
#include "nautilus.in9"

#declare aufbau_hinten = object {
  aufbau_hinten_Raw
  material {
    hullMskinMparts
  }
  scale <2.452254, 3.33789, 7.368827>
  rotate -90.203224*z
  translate  <0.0, -95.999174, 5.181593>
}
// Include contains 'hintenMrechts'
#include "nautilus.i10"

#declare hintenMrechts = object {
  hintenMrechts_Raw
  material {
    hullMskinMparts
  }
  scale <17.801283, 22.198717, 1.0>
  rotate <180.0, 0.0, -90.0>
  translate  <0.0, -60.44183, 0.5>
}
// Include contains 'hintenMlinks'
#include "nautilus.i11"

#declare hintenMlinks = object {
  hintenMlinks_Raw
  material {
    hullMskinMparts
  }
  scale <17.801283, 22.198717, 1.0>
  rotate <180.0, 0.0, -90.0>
  translate  <0.0, -60.44183, 0.5>
}
// Include contains 'vorneMrechts'
#include "nautilus.i12"

#declare vorneMrechts = object {
  vorneMrechts_Raw
  material {
    hullMskinMparts
  }
  scale <17.801283, 22.198717, 1.0>
  rotate <180.0, 0.0, -90.0>
  translate  <-0.189128, -0.43645, 0.5>
}
#declare hintenMoben = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  24  // control points
  <5.929877, 0.00313>,
  <1.389373, -0.003075>,
  <1.392759, 0.52734>,
  <1.615853, 0.581665>,
  <1.871056, 0.803206>,
  <2.206306, 0.856201>,
  <2.123633, 0.76777>,
  <2.035018, 0.53759>,
  <4.127556, 0.546341>,
  <4.401891, 0.423529>,
  <4.679976, 0.370679>,
  <5.021005, 0.385273>,
  <5.319, 0.43699>,
  <5.546349, 0.532427>,
  <5.785726, 0.643377>,
  <6.018056, 0.725811>,
  <6.422396, 0.802249>,
  <6.668553, 0.835896>,
  <6.72232, 0.821224>,
  <6.722448, 0.768138>,
  <6.450592, 0.364418>,
  <5.964556, 0.355279>,
  <5.929451, 0.327498>,
  <5.929877, 0.00313>
  rotate -x*90
  material {
    hullMskinMparts
  }
  scale <17.801283, 22.198717, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <0.520259, -54.933407, 0.353886>
}
#declare propellerschutz = union {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <0.5, 0.5, 80.0>
    rotate <92.692123, 0.201502, 3.005566>
    translate  -79.863365*y
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <0.5, 0.5, 80.0>
    rotate <92.676605, 0.201422, -3.005737>
    translate  -79.863365*y
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <0.5, 0.5, 80.0>
    rotate <86.474838, 0.199148, -3.045387>
    translate  -79.863365*y
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <0.5, 0.5, 80.0>
    rotate <86.472328, 0.199713, 3.041346>
    translate  -79.863365*y
  }
  torus { // propellerring
    1.5, 0.15  rotate -x*90
    material {
      hullMskinMzahn
    }
    scale 4.303849
    rotate <90.0, -90.0, 0.0>
    translate  <0.0, -159.953905, 0.31166>
  }
}
// Include contains 'hintenMunten'
#include "nautilus.i13"

#declare hintenMunten = object {
  hintenMunten_Raw
  material {
    hullMskinMparts
  }
  scale <17.801283, 22.198717, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <0.520259, -54.933407, 0.353886>
}
// Include contains 'vorneMunten'
#include "nautilus.i14"

#declare vorneMunten = object {
  vorneMunten_Raw
  material {
    hullMskinMparts
  }
  scale <17.801283, 22.198717, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <0.520259, -0.434462, 0.203906>
}
// Include contains 'vorneMoben'
#include "nautilus.i15"

#declare vorneMoben = object {
  vorneMoben_Raw
  material {
    hullMskinMparts
  }
  scale <17.801283, 22.198717, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <0.520259, -8.98967, 0.207243>
}
//
// Include file contains 'rumpfMbasis'
//
#include "nautilus.i16"
#declare rumpfMbasis = object {
  rumpfMbasis_Raw
  material {
    hullMskinMrumpfM2
  }
  rotate -90.0*x
  translate  -80.280295*y
}
#declare zahnreihe03 = union {
  object { // Zahn17->Zahn01
    Zahn01
    scale <1.0, 1.299493, 1.0>
    rotate <-13.06045, 0.0, 0.0>
    translate  <-0.0, 41.205055, -27.388023>
  }
  object { // Zahn18->Zahn01
    Zahn01
    rotate <-9.414077, -0.0, -0.0>
    translate  <0.0, 25.681086, -20.116199>
  }
  object { // Zahn19->Zahn01
    Zahn01
    rotate <-7.525631, -0.0, -0.0>
    translate  <0.0, 21.357127, -16.956846>
  }
  object { // Zahn20->Zahn01
    Zahn01
    rotate <-6.33498, -0.0, -0.0>
    translate  <0.0, 16.35743, -14.500585>
  }
  object { // Zahn21->Zahn03
    Zahn03
    rotate <17.691128, -0.0, -0.0>
    translate  <0.0, 6.60938, 5.830399>
  }
  object { // Zahn22->Zahn02
    Zahn02
    rotate <10.237704, -0.0, -0.0>
    translate  <0.0, 5.665238, 1.314133>
  }
  object { // Zahn23->Zahn01
    Zahn01
    rotate <2.120649, -0.0, -0.0>
    translate  <0.0, 4.040903, -4.221273>
  }
  object { Zahn24 }
  object { // Zahn25->Zahn24
    Zahn24
    rotate <1.83871, -0.0, 0.0>
    translate  <-0.0, -4.530848, 2.072904>
  }
  rotate <-0.0, 90.0, 0.0>
}
// The following include file contains the definition for Zahn33
#include "nautilus.i17"
#declare Zahn33 = object {
  Zahn33_Raw
  rotate <-0.0, -0.0, -0.0>
  translate  <-0.013748, 0.025933, -0.011171>
  material {
    hullMskinMzahn
  }
  scale <1.0, 1.0, 7.0>
  rotate <-277.398224, -225.261261, -185.269531>
  translate  <0.028133, -46.838588, 13.7977>
}
#declare zahnreihe04 = union {
  object { // Zahn26->Zahn01
    Zahn01
    scale <1.0, 1.299493, 1.0>
    rotate <-13.06045, 0.0, 0.0>
    translate  <-0.0, 41.523095, -27.388023>
  }
  object { // Zahn27->Zahn01
    Zahn01
    rotate <-9.414077, -0.0, -0.0>
    translate  <0.0, 25.7871, -20.328226>
  }
  object { // Zahn28->Zahn01
    Zahn01
    rotate <-7.525631, -0.0, -0.0>
    translate  <0.0, 21.357127, -16.956846>
  }
  object { // Zahn29->Zahn01
    Zahn01
    rotate <-6.33498, -0.0, -0.0>
    translate  <0.0, 16.675471, -14.394572>
  }
  object { // Zahn30->Zahn03
    Zahn03
    rotate <17.691128, -0.0, -0.0>
    translate  <0.0, 6.927421, 6.042427>
  }
  object { // Zahn31->Zahn02
    Zahn02
    rotate <10.237704, -0.0, -0.0>
    translate  <0.0, 6.195305, 1.208119>
  }
  object { // Zahn32->Zahn01
    Zahn01
    rotate <2.120649, -0.0, -0.0>
    translate  <0.0, 4.040903, -4.327287>
  }
  object { Zahn33 }
  object { // Zahn34->Zahn24
    Zahn24
    rotate <1.83871, -0.0, 0.0>
    translate  <-0.0, -4.742875, 2.072904>
  }
  rotate <0.0, -90.0, 0.0>
}
// Include contains 'vorneMrechts1'
#include "nautilus.i18"

#declare vorneMrechts1 = object {
  vorneMrechts1_Raw
  material {
    hullMskinMparts
  }
  scale <17.801283, 22.198717, 1.0>
  rotate <180.0, 0.0, -90.0>
  translate  <0.045861, -4.617414, 0.5>
}
#declare zahnreihe5 = union {
  object { Zahn35 }
  object { // Zahn36->Zahn35
    Zahn35
    rotate <-19.97105, 0.0, -0.0>
    translate  <-0.0, -8.61361, -31.111257>
  }
  object { // Zahn37->Zahn35
    Zahn35
    rotate <-25.0, 0.0, -0.0>
    translate  <0.0, -11.012834, -39.960856>
  }
  object { // Zahn38->Zahn35
    Zahn35
    rotate <-15.697927, 0.0, -0.0>
    translate  <0.0, -1.02204, -29.011673>
  }
}
#declare CSG001 = union {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      hullMskinMcyl
    }
    scale <1.5, 2.0, 1.5>
    rotate -32.029266*x
    translate  <0.0, -0.572393, 2.524018>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      hullMskinMcyl
    }
    scale <1.5, 4.0, 1.0>
    rotate 6.649404*x
    translate  <0.0, -3.758019, 0.775993>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      hullMskinMstandard
    }
    scale <1.0, 2.0, 2.0>
    rotate <-5.322911, -30.27261, 34.352219>
    translate  <1.330856, 4.012681, 0.14274>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 2.0>
    rotate <-4.953034, 30.241562, -35.093876>
    translate  <-1.221103, 4.022354, 0.14274>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 4.0, 1.5>
    rotate <0.0, -9.38137, -1.54656>
    translate  <1.71535, -0.810029, 0.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 4.0, 1.5>
    rotate <-0.0, 9.381366, 1.546561>
    translate  <-1.715355, -0.810029, 0.0>
  }
}
#declare Aufbau = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 4.0, 1.296672>
    translate  -0.336228*z
  }
  object { CSG001 }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    material {
      fensterlicht
    }
    scale <0.394243, 0.304179, 1.647707>
    rotate <90.0, -44.269943, -90.0>
    translate  <0.831495, 3.075709, 0.270796>
  }
  material {
    hullMskinMparts
  }
  scale <4.077021, 5.0, 5.0>
  translate  <0.0, -60.72959, 14.291958>
}
// Include contains 'ruder'
#include "nautilus.i19"

#declare ruder = object {
  ruder_Raw
  material {
    hullMskinMparts
  }
  scale <5.473386, 5.024999, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <0.5, -166.55194, 0.0>
}
#declare propellor = union {
  object { // Sphere006->Sphere002
    Sphere002
    rotate 72.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // Sphere005->Sphere002
    Sphere002
    rotate <-180.0, 36.0, -180.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Sphere004->Sphere002
    Sphere002
    rotate <-180.0, -36.0, -180.0>
    translate  <-0.0, 0.0, -0.0>
  }
  object { // Sphere003->Sphere002
    Sphere002
    rotate -72.0*y
    translate  -0.0*x
  }
  object { Sphere002 }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale 1.646487
    rotate 90.0*x
    translate  0.611275*y
  }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      hullMskinMzahn
    }
    scale <1.0, 2.491893, 1.0>
  }
  translate  -161.59713*y
}
#declare Luke2 = union {
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMstandard
    }
    scale <0.49977, 0.241587, 0.49977>
    rotate <-90.0, -11.46053, -0.0>
    translate  <-0.5, -0.25, 1.121483>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <0.314201, 0.314201, 0.123078>
    translate  1.484554*z
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMcyl
    }
    scale <0.128632, 0.128632, 0.346474>
    translate  1.202166*z
  }
  sphere { // Sphere009
    <0,0,0>,1
    material {
      hullMskinMcyl
    }
    scale <1.0, 1.0, 0.289996>
    translate  1.032733*z
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <1.080682, 1.080682, 0.120563>
    translate  0.943982*z
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMcyl
    }
  }
  scale 3.0
  rotate <180.0, 0.0, -90.0>
  translate  <0.0, -83.529482, -10.528878>
}
#declare Luke1 = union {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMstandard
    }
    scale <0.49977, 0.241587, 0.49977>
    rotate <-90.0, -11.46053, -0.0>
    translate  <-0.5, -0.25, 1.121483>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <0.314201, 0.314201, 0.123078>
    translate  <0.0, 0.0, 1.427053>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMcyl
    }
    scale <0.128632, 0.128632, 0.346474>
    translate  1.202166*z
  }
  sphere { // Sphere008
    <0,0,0>,1
    material {
      hullMskinMcyl
    }
    scale <1.0, 1.0, 0.289996>
    translate  1.032733*z
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <1.080682, 1.080682, 0.120563>
    translate  0.943982*z
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMcyl
    }
  }
  scale 1.5
  rotate <-0.0, 0.0, -90.0>
  translate  <0.0, -38.640515, 11.323179>
}
#declare Luke = union {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMstandard
    }
    scale <0.49977, 0.241587, 0.49977>
    rotate <-90.0, -11.46053, -0.0>
    translate  <-0.5, -0.25, 1.121483>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <0.314201, 0.314201, 0.123078>
    translate  <-0.018789, -0.0, 1.421869>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMcyl
    }
    scale <0.128632, 0.128632, 0.346474>
    translate  1.202166*z
  }
  sphere { // Sphere007
    <0,0,0>,1
    material {
      hullMskinMcyl
    }
    scale <1.0, 1.0, 0.289996>
    translate  1.032733*z
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMzahn
    }
    scale <1.080682, 1.080682, 0.120563>
    translate  0.943982*z
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      hullMskinMcyl
    }
  }
  scale 3.0
  rotate <-0.0, 5.115659, -90.0>
  translate  <0.0, -94.787082, 10.147055>
}
#declare zahlreiheMruecken = union {
  object { // Zahn45->Zahn44
    Zahn44
    scale <0.9, 1.0, 1.0>
    translate  <0.0, -2.750744, -0.4074>
  }
  object { Zahn44 }
  object { Zahn43 }
  object { Zahn42 }
  object { Zahn41 }
  object { Zahn40 }
  object { Zahn39 }
}
#declare verstaerkungMhinten = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  6  // control points
  <-1.99374, 0.00939>,
  <-0.99374, -0.761346>,
  <0.00626, -0.984351>,
  <0.00626, 1.015649>,
  <-0.976526, 0.773083>,
  <-1.99374, 0.00939>
  rotate <90,0,90>
  material {
    hullMskinMparts
  }
  scale <3.499007, 4.272623, 34.093945>
  rotate <90.617531, 0.018489, 179.999741>
  translate  <0.0, -124.942468, -9.042605>
}
#declare verstaerkungMvorne = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  6  // control points
  <-1.99374, 0.00939>,
  <-0.99374, -0.761346>,
  <0.00626, -0.984351>,
  <0.00626, 1.015649>,
  <-0.976526, 0.773083>,
  <-1.99374, 0.00939>
  rotate <90,0,90>
  material {
    hullMskinMparts
  }
  scale <1.890909, 3.720911, 34.109375>
  rotate 87.95063*x
  translate  <0.0, -36.852733, -11.305389>
}
#declare CSG002 = union {
  sphere { // Sphere010
    <0,0,0>,1
    scale <0.75037, 0.427257, 0.725083>
    translate  -1.033963*z
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <0.75037, 0.427257, 2.178586>
    translate  -1.075492*z
  }
  sphere { // Sphere011
    <0,0,0>,1
    scale <0.75037, 0.427257, 0.725083>
    translate  1.125526*z
  }
}
#declare CSG003 = difference {
  object { CSG002 }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.690719, 2.111121>
    translate  1.185743*x
  }
}
#declare beiboot = union {
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <1.639965, 0.376751, 0.230307>
    rotate <0.0, 90.0, 0.0>
    translate  0.064043*z
  }
  object { CSG003 }
  material {
    hullMskinMcyl
  }
  scale <4.073679, 4.426357, 5.84459>
  rotate <90.0, -90.0, 0.0>
  translate  <0.0, -119.764755, 12.183701>
}
#declare fensterMobenMrechts = union {
  sphere { // Sphere013
    <0,0,0>,1
    material {
      fensterglas
    }
    scale <1.0, 1.0, 0.5>
  }
  torus { // Torus002
    1.1, 0.1  rotate -x*90
    material {
      hullMskinMcyl
    }
  }
  rotate <-0.0, 0.0, -0.0>
  scale 1.9
  rotate <-3.616959, 63.67812, 29.979191>
  translate  <1.65875, -45.29987, 15.64972>
}
#declare fensterMobenMlinks = union {
  sphere { // Sphere012
    <0,0,0>,1
    material {
      fensterglas
    }
    scale <1.0, 1.0, 0.5>
  }
  torus { // Torus001
    1.1, 0.1  rotate -x*90
    material {
      hullMskinMcyl
    }
  }
  rotate <-0.0, 0.0, -0.0>
  scale 1.9
  rotate <-3.616959, -63.678116, -29.979187>
  translate  <-1.658745, -45.29987, 15.64972>
}
#declare CSG008 = difference {
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 0.8>
    rotate <0.0, -90.0, 0.0>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    rotate <0.0, -90.0, 0.0>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 0.4, 2.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <-0.796127, -0.904195, -0.543661>
  }
  material {
    hullMskinMzahn
  }
  translate  -0.679577*x
}
#declare scheinwerfer1 = union {
  sphere { // Sphere015
    <0,0,0>,1
    material {
      scheinwerferlicht
    }
    scale <0.2, 0.5, 0.5>
    translate  -1.032956*x
  }
  object { CSG008 }
  translate  -0.61468*z
}
#declare CSG009 = union {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    rotate 45.0*x
    translate  <0.0, -0.73922, 0.443532>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    rotate -45.0*x
    translate  <0.0, 0.763861, 0.443532>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    translate  <0.0, 0.006365, 0.568562>
  }
  scale <1.638802, 1.0, 1.0>
  translate  0.638802*x
}
#declare CSG010 = union {
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    rotate 45.0*x
    translate  <0.0, -0.73922, 0.443532>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    rotate -45.0*x
    translate  <0.0, 0.763861, 0.443532>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    translate  <0.0, -0.013605, 0.468173>
  }
  scale <1.815492, 1.0, 1.0>
  rotate 19.910236*y
  translate  <0.815492, 0.0, -0.203873>
}
#declare CSG011 = difference {
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <1.339788, 1.0, 1.8>
    translate  <0.448521, 0.0, -1.005992>
  }
  object { CSG009 }
  object { CSG010 }
  material {
    hullMskinMcyl
  }
  scale <1.1, 0.9, 1.0>
}
#declare scheinwerfergruppe2 = union {
  object { scheinwerfer1 }
  object { CSG011 }
  scale 1.5
  rotate -126.109024*z
  translate  <0.9179, -49.131, 20.3>
}
#declare CSG007 = difference {
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 0.8>
    rotate <0.0, -90.0, 0.0>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.0>
    rotate <0.0, -90.0, 0.0>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 0.4, 2.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <-0.796127, -0.904195, -0.543661>
  }
  material {
    hullMskinMzahn
  }
  translate  -0.679577*x
}
#declare scheinwerfer = union {
  sphere { // Sphere014
    <0,0,0>,1
    material {
      scheinwerferlicht
    }
    scale <0.2, 0.5, 0.5>
    translate  -1.032956*x
  }
  object { CSG007 }
  translate  -0.61468*z
}
#declare CSG004 = union {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    rotate 45.0*x
    translate  <0.0, -0.73922, 0.443532>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    rotate -45.0*x
    translate  <0.0, 0.763861, 0.443532>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    translate  <0.0, 0.006365, 0.568562>
  }
  scale <1.638802, 1.0, 1.0>
  translate  0.638802*x
}
#declare CSG005 = union {
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    rotate 45.0*x
    translate  <0.0, -0.73922, 0.443532>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    rotate -45.0*x
    translate  <0.0, 0.763861, 0.443532>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.086242, 0.470226>
    translate  <0.0, -0.013605, 0.468173>
  }
  scale <1.815492, 1.0, 1.0>
  rotate 19.910236*y
  translate  <0.815492, 0.0, -0.203873>
}
#declare CSG006 = difference {
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <1.339788, 1.0, 1.8>
    translate  <0.448521, 0.0, -1.005992>
  }
  object { CSG004 }
  object { CSG005 }
  material {
    hullMskinMcyl
  }
  scale <1.1, 0.9, 1.0>
}
#declare scheinwerfergruppe1 = union {
  object { scheinwerfer }
  object { CSG006 }
  scale 1.5
  rotate -53.89098*z
  translate  <-0.917902, -49.131448, 20.3>
}
#declare Unterarm12 = union {
  sphere { // Sphere141
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr505
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere142
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-29.437571, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm12 = union {
  cylinder { // Cylndr504
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere140
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm12 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-1.253264, 0.134929, -3.790518>
  scale <1.1, 1.1, 1.2>
  rotate <-77.423576, -151.713348, 136.295395>
  translate  <0.995993, -0.253488, 3.753248>
}
#declare Unterarm13 = union {
  sphere { // Sphere144
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr507
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere145
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <-1.167786, 0.084277, -2.522267>
  rotate <126.354454, -210.370071, 144.78537>
  translate  <1.167786, -0.061442, 2.561833>
}
#declare Oberarm13 = union {
  cylinder { // Cylndr506
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere143
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm13 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-1.212634, 0.070751, -3.777058>
  scale <1.1, 1.1, 1.2>
  rotate <-190.114624, -185.919708, -202.564926>
  translate  <-1.167486, -0.080428, 3.81988>
}
#declare Kopf6 = union {
  sphere { // Sphere146
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr508
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere147
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere148
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper6 = union {
  cylinder { // Cylndr503
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere139
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm12 }
  object { Oberarm13 }
  object { Kopf6 }
  translate  <0.0, 0.1, -1.1>
  rotate <-8.680178, -0.097739, -0.019938>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh12 = union {
  cylinder { // Cylndr511
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr512
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere151
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere152
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <86.472839, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel12 = union {
  cylinder { // Cylndr510
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere150
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh12 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-17.41935, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein12 = union {
  cylinder { // Cylndr509
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere149
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel12 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-6.506654, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh13 = union {
  cylinder { // Cylndr515
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr516
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere155
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere156
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel13 = union {
  cylinder { // Cylndr514
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere154
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh13 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-16.593012, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein13 = union {
  cylinder { // Cylndr513
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere153
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel13 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  rotate <-5.788723, 0.655885, 1.466334>
  translate  <-1.770354, -0.250236, 1.257197>
}
#declare sailor7 = union {
  object { Oberkoeper6 }
  object { Bein12 }
  object { Bein13 }
  scale 0.4
  rotate <29.861078, -1.463645, 46.381409>
  translate  <-1.269617, -46.093394, 14.752753>
}
#declare Unterarm10 = union {
  sphere { // Sphere123
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr491
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere124
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <32.182419, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm10 = union {
  cylinder { // Cylndr490
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere122
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm10 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-1.253264, 0.134929, -3.790518>
  scale <1.1, 1.1, 1.2>
  rotate <-76.009682, -133.786148, 111.132988>
  translate  <1.150582, -0.304697, 3.742141>
}
#declare Unterarm11 = union {
  sphere { // Sphere126
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr493
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere127
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <-1.167786, 0.084277, -2.522267>
  rotate <-17.446228, -255.838684, 3.423344>
  translate  <1.167786, -0.061442, 2.561833>
}
#declare Oberarm11 = union {
  cylinder { // Cylndr492
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere125
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm11 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-1.212634, 0.070751, -3.777058>
  scale <1.1, 1.1, 1.2>
  rotate <-217.595871, -161.806763, -223.356384>
  translate  <-1.099915, -0.12059, 3.782799>
}
#declare Kopf5 = union {
  sphere { // Sphere128
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr494
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere129
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere130
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper5 = union {
  cylinder { // Cylndr489
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere121
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm10 }
  object { Oberarm11 }
  object { Kopf5 }
  translate  <0.0, 0.1, -1.1>
  rotate <-8.680178, -0.097739, -0.019938>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh10 = union {
  cylinder { // Cylndr497
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr498
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere133
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere134
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <86.472839, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel10 = union {
  cylinder { // Cylndr496
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere132
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh10 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-17.41935, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein10 = union {
  cylinder { // Cylndr495
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere131
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel10 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-6.506654, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh11 = union {
  cylinder { // Cylndr501
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr502
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere137
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere138
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel11 = union {
  cylinder { // Cylndr500
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere136
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh11 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-16.593012, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein11 = union {
  cylinder { // Cylndr499
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere135
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel11 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  rotate <-5.788723, 0.655885, 1.466334>
  translate  <-1.770354, -0.250236, 1.257197>
}
#declare sailor6 = union {
  object { Oberkoeper5 }
  object { Bein10 }
  object { Bein11 }
  scale 0.4
  rotate <25.433559, -4.403522, 69.533279>
  translate  <-0.512458, -44.992611, 14.65134>
}
#declare Unterarm16 = union {
  sphere { // Sphere177
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr533
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere178
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <0.0, -0.0, -0.0>
  translate  <-1.19964, 0.041431, -2.432053>
  rotate <-198.528839, -205.623291, -204.284058>
  translate  <1.152173, -0.052125, 2.485786>
}
#declare Oberarm16 = union {
  cylinder { // Cylndr532
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere176
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm16 }
  rotate <0.0, -0.0, -0.0>
  translate  <-1.164499, 0.070139, -3.835243>
  scale <1.1, 1.1, 1.2>
  rotate <283.681641, -162.748932, 113.174088>
  translate  <1.115353, -0.09176, 3.67779>
}
#declare Unterarm17 = union {
  sphere { // Sphere180
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr535
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere181
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <-1.191332, 0.02253, -2.502566>
  rotate <-44.132084, 44.197582, -55.475452>
  translate  <1.170975, -0.038313, 2.496948>
}
#declare Oberarm17 = union {
  cylinder { // Cylndr534
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere179
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm17 }
  rotate <-0.0, 0.0, 0.0>
  translate  <-1.212634, 0.070751, -3.777058>
  scale <1.1, 1.1, 1.2>
  rotate <-9.455241, 26.555227, -25.289513>
  translate  <-1.191156, -0.226886, 3.600679>
}
#declare Kopf8 = union {
  sphere { // Sphere182
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr536
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere183
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere184
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper8 = union {
  cylinder { // Cylndr531
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.1212, 0.509059, 2.850714>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere175
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm16 }
  object { Oberarm17 }
  object { Kopf8 }
  translate  <0.0, 0.1, -1.1>
  rotate <-8.680178, -0.097739, -0.019938>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh16 = union {
  cylinder { // Cylndr539
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr540
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere187
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere188
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.05191, 0.787867, -2.507105>
  scale <0.545776, 0.563379, 0.208274>
  rotate <86.472839, 1.350429, -0.608842>
  translate  <1.189946, 2.381616, 1.401935>
}
#declare Unterschenkel16 = union {
  cylinder { // Cylndr538
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere186
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh16 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-1.221135, -2.277359, -0.231115>
  rotate <-17.41935, 0.0, 0.0>
  translate  <1.221135, -0.004146, 1.685323>
}
#declare Bein16 = union {
  cylinder { // Cylndr537
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere185
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel16 }
  rotate <0.0, 0.0, 0.0>
  translate  <-1.189824, 0.007668, -3.74985>
  rotate <-4.428905, -6.674704, 1.091611>
  translate  <0.564457, -0.218664, 1.033892>
}
#declare Schuh17 = union {
  cylinder { // Cylndr543
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr544
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere191
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere192
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.165521, 0.941744, -2.235358>
  scale <0.545776, 0.563379, 0.208274>
  rotate <84.359268, 1.290424, -0.633021>
  translate  <1.250372, 2.406593, 1.322772>
}
#declare Unterschenkel17 = union {
  cylinder { // Cylndr542
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere190
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh17 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-1.190073, -2.267865, -0.174211>
  rotate <-16.593012, 0.0, 0.0>
  translate  <1.190073, -0.029496, 1.633499>
}
#declare Bein17 = union {
  cylinder { // Cylndr541
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere189
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel17 }
  rotate <0.0, -0.0, -0.0>
  translate  <-1.251954, 0.033904, -3.698657>
  rotate <0.6508, 5.455555, 1.268269>
  translate  <-0.517908, -0.250236, 1.006708>
}
#declare sailor9 = union {
  object { Oberkoeper8 }
  object { Bein16 }
  object { Bein17 }
  scale 0.4
  rotate <9.932131, 1.216816, 61.633766>
  translate  <-13.9509, -73.768765, -0.958442>
}
#declare Unterarm14 = union {
  sphere { // Sphere159
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr519
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere160
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <0.0, -0.0, -0.0>
  translate  <-1.19964, 0.041431, -2.432053>
  rotate <-66.686256, 6.332821, -46.32629>
  translate  <1.152173, -0.052125, 2.485786>
}
#declare Oberarm14 = union {
  cylinder { // Cylndr518
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere158
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm14 }
  rotate <0.0, -0.0, -0.0>
  translate  <-1.164499, 0.070139, -3.835243>
  scale <1.1, 1.1, 1.2>
  rotate <205.820145, -178.22641, 124.563133>
  translate  <1.115353, -0.09176, 3.67779>
}
#declare Unterarm15 = union {
  sphere { // Sphere162
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr521
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere163
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <-1.191332, 0.02253, -2.502566>
  rotate <-134.5979, -233.805374, -109.359047>
  translate  <1.170975, -0.038313, 2.496948>
}
#declare Oberarm15 = union {
  cylinder { // Cylndr520
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere161
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm15 }
  rotate <-0.0, 0.0, 0.0>
  translate  <-1.212634, 0.070751, -3.777058>
  scale <1.1, 1.1, 1.2>
  rotate <-1.691968, 21.682245, -22.388681>
  translate  <-1.191156, -0.226886, 3.600679>
}
#declare Kopf7 = union {
  sphere { // Sphere164
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr522
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere165
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere166
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper7 = union {
  cylinder { // Cylndr517
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.1212, 0.509059, 2.850714>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere157
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm14 }
  object { Oberarm15 }
  object { Kopf7 }
  translate  <0.0, 0.1, -1.1>
  rotate <-8.680178, -0.097739, -0.019938>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh14 = union {
  cylinder { // Cylndr525
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr526
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere169
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere170
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.05191, 0.787867, -2.507105>
  scale <0.545776, 0.563379, 0.208274>
  rotate <86.472839, 1.350429, -0.608842>
  translate  <1.189946, 2.381616, 1.401935>
}
#declare Unterschenkel14 = union {
  cylinder { // Cylndr524
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere168
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh14 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-1.221135, -2.277359, -0.231115>
  rotate <-17.41935, 0.0, 0.0>
  translate  <1.221135, -0.004146, 1.685323>
}
#declare Bein14 = union {
  cylinder { // Cylndr523
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere167
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel14 }
  rotate <0.0, 0.0, 0.0>
  translate  <-1.189824, 0.007668, -3.74985>
  rotate <-5.584095, -8.323264, 1.41294>
  translate  <0.564457, -0.218664, 1.033892>
}
#declare Schuh15 = union {
  cylinder { // Cylndr529
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr530
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere173
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere174
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.165521, 0.941744, -2.235358>
  scale <0.545776, 0.563379, 0.208274>
  rotate <84.359268, 1.290424, -0.633021>
  translate  <1.250372, 2.406593, 1.322772>
}
#declare Unterschenkel15 = union {
  cylinder { // Cylndr528
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere172
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh15 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-1.190073, -2.267865, -0.174211>
  rotate <-16.593012, 0.0, 0.0>
  translate  <1.190073, -0.029496, 1.633499>
}
#declare Bein15 = union {
  cylinder { // Cylndr527
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere171
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel15 }
  rotate <0.0, -0.0, -0.0>
  translate  <-1.251954, 0.033904, -3.698657>
  rotate <-6.286752, 5.398475, 0.598202>
  translate  <-0.517908, -0.250236, 1.006708>
}
#declare sailor8 = union {
  object { Oberkoeper7 }
  object { Bein14 }
  object { Bein15 }
  scale 0.4
  rotate <9.932131, 1.216816, 83.085258>
  translate  <-14.110829, -75.752084, -0.977369>
}
union { // Nautilus
  object { zahnreihe02 }
  object { zahnreihe01 }
  object { Rammsporn }
  object { aufbauMvorne }
  object { aufbau_hinten }
  object { hintenMrechts }
  object { hintenMlinks }
  object { vorneMrechts }
  object { hintenMoben }
  object { propellerschutz }
  object { hintenMunten }
  object { vorneMunten }
  object { vorneMoben }
  object { rumpfMbasis }
  object { zahnreihe03 }
  object { zahnreihe04 }
  object { vorneMrechts1 }
  object { zahnreihe5 }
  object { Aufbau }
  object { ruder }
  object { propellor }
  object { Luke2 }
  object { Luke1 }
  object { Luke }
  object { zahlreiheMruecken }
  object { verstaerkungMhinten }
  object { verstaerkungMvorne }
  object { beiboot }
  object { fensterMobenMrechts }
  object { fensterMobenMlinks }
  object { scheinwerfergruppe2 }
  object { scheinwerfergruppe1 }
  object { fenstergruppeMlinks }
  object { // fenstergruppeMrechts->fenstergruppe-links
    fenstergruppeMlinks
    rotate -180.0*z
    translate  -150.46293*y
  }
  object { sailor7 }
  object { sailor6 }
  object { sailor9 }
  object { sailor8 }
  // All transformations fixed
}


cylinder { // Hintergrund
  <0,0,1>, <0,0,0>, 1 open
  material {
    wasser
  }
  hollow
  scale <534.359009, 534.359009, 1000.0>
  translate  <0.0, -9.479248, -582.425808>
}




