// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: megaPOV6a
// Desc: contrast
// Date: dec 2000
// Auth: j charter
 
#version unofficial MegaPov 0.5;
#include "kolors.inc"
global_settings { assumed_gamma 1 }
global_settings { max_trace_level 200 }
global_settings{number_of_waves 10 }    //10 is default

  
#declare rot = 231;
#declare angl = radians(rot);
#declare PdA=<cos(angl),0,sin(angl)>*80;
#declare PdV=< 0, 40, 0 >;

camera {        location  PdV  
                look_at   PdA+<0,5,0>  
                angle  60
} 
 
#include "branches.inc"
object { branches light_group "g2" no_shadow "g2" } 


#declare t1 =
texture {
         pigment {color rgbf <1, 1, 1, 1>} 
         finish {        phong 1 
                         phong_size 90 
                         diffuse 0
                         reflection .9
                         conserve_energy
         }
       
         normal {ripples scale <4,1,4>*2000 frequency 2000 rotate y*60 }     
}  
#declare t2 =
texture {
         pigment {color rgbf <1, 1, 1, 1>} 
         finish {        phong 1 
                         phong_size 90 
                         diffuse 0
                         reflection .9
                         conserve_energy 
         }
       
         normal {bozo scale <2, 1, 2>  }     
}  


plane{y, -38 
        hollow            
        
        texture { t2 }
        texture { t1 }
        interior { 
                        ior 1.33
                        media {
                                absorption <.1, .05, .05 > 
                                samples 20, 20
                        }
        }
        light_group "g0"
 }     
plane{y, -50 
                                                   
        pigment{ rgb < 0, 0, 0 > }
        light_group "g0"
        
}
blob { threshold .2
          sphere { 0,  1, .9  scale < 12, .75, 3 >*60   translate <   0, -31, 461+40 >      } 
          sphere { 0,  1, .9  scale < 12, 1.5, 2 >*60   translate <   0, -31, 610+40 >         } 
          sphere { 0,  1, .9  scale < 4,  1.5, 4 >*60   translate <-445, -31, 500+40 >      }
          pigment{ White } 
          finish { ambient .1 reflection .4 }
          normal { dents scale 1 turbulence 1.2 octaves 3  lambda 1.5  omega .6 } 
          rotate y*rot
          light_group "g0"   
}
  

sky_sphere { 
        pigment {
                        gradient y
                        color_map {
                                        [0 rgb <.010, 0, .015> ]
                                        [1 rgb <0, 0, .005>  ]
                        }
        }
}

#declare moon = 
sphere { <0,0,0> 3000  pigment { Silver*2  } light_group "g0"}
 
light_source {  < 100000, 0, 0 > 

                 color Blue*Silver*.0005
                 looks_like { moon } 
                 rotate  z*40 rotate y*110
                 groups "g0" 
             }
light_source {  < 100000, 0, 0 > 

                 color Silver*.05
                  
                 rotate  z*40 rotate y*110
                 groups "g1"
             }
light_source {   PdV 

                 color DustyRose*.6
                  
                  
                 groups "g0,g2"
             }             

#include "statue4c4.inc"

#declare st =
union {
        object { statue }
        object { traceStatue }
        light_group "g1"  
}

object { st scale 10 rotate y*rot translate PdA*.55 rotate y*-18 texture { statue_texture } }                                          