//***************************************************
// Curved surface macro ver 0.1r000727c include file
// Persistence Of Vision raytracer version 3.1g
// By S.Nishimura
//***************************************************


//**********************************************************************************
#macro Usign(Rp)
 #if(Rp>0) #local Rp= 1;#end #if(Rp=0) #local Rp= 0;#end #if(Rp<0) #local Rp=-1;#end
#end
//**********************************************************************************
#macro Usqrt(Rp)
 #if(Rp>=0) #local Rp=sqrt(Rp); #else #local Rp=-sqrt(abs(Rp));#end
#end
//**********************************************************************************
//--------------------------- sample functions -------------------------------------
/*
#macro Surface_func(Ss,Se,Px,Py,Pz,Func_type)
 #switch(Func_type)
 #case(0) #local Px=4*Ss; #local Pz=4*Se; #local Rp=(pow(.2*Px,2)+pow(.2*Pz,2)); 
          #local Py=-4/sqrt(Rp)*sin(pi*sqrt(Rp)); #break
 
 #case(1) #local Rp=5*sqrt(2+sin(Se));
          #local Px=Rp*cos(Ss); #local Py=Rp*sin(Ss); #local Pz=8*sin(Se); #break
  
 #case(2) #local Rp=sin(Se)-0.7; Usign(Rp) #local Rr=5*Rp+6;
          #local Px=Rr*sin(Se)*cos(Ss); #local Py=Rr*cos(Se); #local Pz=Rr*sin(Se)*sin(Ss); #break
 #end
#end
*/
//**********************************************************************************
//--------------------------- sample parameters -------------------------------------
/*
object { Surface_tri4m(-pi*1,pi*1,pi/12,-pi*1,pi*1,pi/12,0)   scale 4 rotate <-30, 30, 0 > translate <  6, 0, 0 > }
object { Surface_tri2m(-pi*1,pi*1,pi/12,-pi*1,pi*1,pi/8,1)    scale 4 rotate <-30, 30, 0 > translate < -3, 0, 0 > }
object { Surface_tri2m(-pi*1,pi*1,pi/12,-pi*0,pi*0.5,pi/12,2) scale 4 rotate < 30, 30, 0 > translate < -3, 0, 0 > }
*/
//**********************************************************************************
#macro Surface_tri4m(Sts,Eds,Ads,Ste,Ede,Ade,Func_type) // mesh data set
 #local Px=0; #local Py=0; #local Pz=0;
 mesh {
 #local Se=Ste; #local Ee=Ede; #local Ae=Ade;
 #while(Se<Ee)
  #local Ss=Sts; #local Es=Eds; #local As=Ads;
  #while(Ss<Es)
   Surface_func(Ss-As/2,Se-Ae/2,Px,Py,Pz,Func_type) #local Pd11=< Px, Py, Pz >;   
   Surface_func(Ss-As/2,Se+Ae/2,Px,Py,Pz,Func_type) #local Pd12=< Px, Py, Pz >;  
   Surface_func(Ss+As/2,Se+Ae/2,Px,Py,Pz,Func_type) #local Pd22=< Px, Py, Pz >;   
   Surface_func(Ss+As/2,Se-Ae/2,Px,Py,Pz,Func_type) #local Pd21=< Px, Py, Pz >;
   Surface_func(Ss     ,Se     ,Px,Py,Pz,Func_type) #local Pd00=< Px, Py, Pz >;
   triangle { Pd11, Pd12, Pd00 }
   triangle { Pd12, Pd22, Pd00 }
   triangle { Pd22, Pd21, Pd00 }
   triangle { Pd21, Pd11, Pd00 } 
   #local Ss=Ss+As;
  #end
  #local Se=Se+Ae;
 #end
 }
#end // macro end
//**********************************************************************************
#macro Mtri4_y(Sts,Eds,Ads,Ste,Ede,Ade,Func_type) // mesh data set
 #local Px=0; #local Py=0; #local Pz=0;
 mesh {
 #local Se=Ste; #local Ee=Ede; #local Ae=Ade;
 #while(Se<Ee)
  #local Ss=Sts; #local Es=Eds; #local As=Ads;
  #while(Ss<Es)
   Surface_func(Ss-As/2,Se-Ae/2,Px,Py,Pz,Func_type) #local Px1=Px; #local Py11=Py;  
   Surface_func(Ss-As/2,Se+Ae/2,Px,Py,Pz,Func_type) #local Pz2=Pz; #local Py12=Py;  
   Surface_func(Ss+As/2,Se+Ae/2,Px,Py,Pz,Func_type) #local Px2=Px; #local Py22=Py;    
   Surface_func(Ss+As/2,Se-Ae/2,Px,Py,Pz,Func_type) #local Pz1=Pz; #local Py21=Py;
   Surface_func(Ss     ,Se     ,Px,Py,Pz,Func_type) #local Px0=Px; #local Py00=Py; #local Pz0=Pz;
   triangle { < Px1,Py11,Pz1 >,< Px1,Py12,Pz2 >,< Px0,Py00,Pz0 > }
   triangle { < Px1,Py12,Pz2 >,< Px2,Py22,Pz2 >,< Px0,Py00,Pz0 > }
   triangle { < Px2,Py22,Pz2 >,< Px2,Py21,Pz1 >,< Px0,Py00,Pz0 > }
   triangle { < Px2,Py21,Pz1 >,< Px1,Py11,Pz1 >,< Px0,Py00,Pz0 > } 
   #local Ss=Ss+As;
  #end
  #local Se=Se+Ae;
 #end
 }
#end // macro end
//**********************************************************************************
//**********************************************************************************
#macro Surface_tri2m(Sts,Eds,Ads,Ste,Ede,Ade,Func_type) // mesh data set
 #local Px=0; #local Py=0; #local Pz=0;
 mesh {
 #local Se=Ste; #local Ee=Ede; #local Ae=Ade;
 #while(Se<Ee)
  #local Ss=Sts; #local Es=Eds; #local As=Ads;
  #while(Ss<Es)
   Surface_func(Ss,     Se,     Px,Py,Pz,Func_type) #local Pd11=< Px, Py, Pz >;   
   Surface_func(Ss,     Se+Ae,  Px,Py,Pz,Func_type) #local Pd12=< Px, Py, Pz >;  
   Surface_func(Ss+As,  Se+Ae,  Px,Py,Pz,Func_type) #local Pd22=< Px, Py, Pz >;    
   Surface_func(Ss+As,  Se   ,  Px,Py,Pz,Func_type) #local Pd21=< Px, Py, Pz >;
   triangle { Pd11, Pd12, Pd22 }
   triangle { Pd11, Pd21, Pd22 }
   #local Ss=Ss+As;
  #end
  #local Se=Se+Ae;
 #end
 }
#end // macro end
//**********************************************************************************
#macro Mtri2_y(Sts,Eds,Ads,Ste,Ede,Ade,Func_type) // mesh data set
 #local Px=0; #local Py=0; #local Pz=0;
 mesh {
 #local Se=Ste; #local Ee=Ede; #local Ae=Ade;
 #while(Se<Ee)
  #local Ss=Sts; #local Es=Eds; #local As=Ads;
  #while(Ss<Es)
   Surface_func(Ss,     Se,     Px,Py,Pz,Func_type) #local Px1=Px; #local Py11=Py;   
   Surface_func(Ss,     Se+Ae,  Px,Py,Pz,Func_type) #local Pz2=Pz; #local Py12=Py;  
   Surface_func(Ss+As,  Se+Ae,  Px,Py,Pz,Func_type) #local Px2=Px; #local Py22=Py;    
   Surface_func(Ss+As,  Se   ,  Px,Py,Pz,Func_type) #local Pz1=Pz; #local Py21=Py;
   triangle { < Px1,Py11,Pz1 >,< Px1,Py12,Pz2 >,< Px2,Py22,Pz2 > }
   triangle { < Px1,Py11,Pz1 >,< Px2,Py21,Pz1 >,< Px2,Py22,Pz2 > }
   #local Ss=Ss+As;
  #end
  #local Se=Se+Ae;
 #end
 }
#end // macro end
//**********************************************************************************