
#include "campov.inc"  
#include "skies.inc"


global_settings {
 ambient_light rgb <0.9,0.9,0.9>
 max_trace_level 10
}

background { color <0.2,0.8,1> }

camera {
 location <60.0,440.0,-3.76>
 right <-1.333333,0.0,0.0>
 sky <0.0,0.0,1.0>
 look_at <296.0,444.0,-3.76>
 angle 70.5369
 normal {
    waves 0.25 * (1 - clock)
    frequency 8
    phase 3.14 * clock
  }
}


   
light_source {
 <0,10000,0>,
 color rgb <1,1,0.9>*1.5
 area_light <5, 0, 0>, <0, 0, 5>, 5, 5
 jitter
 fade_distance 0
 fade_power 1
 rotate 23.0*x
 rotate -4.0*z
 translate <256,0,256>
 looks_like {
      sphere { <0.0, 0.0, 0.0>, 190.0
         pigment { colour red 1.0 green 0.6 filter 0.35 }
         finish { ambient 1.0 diffuse 0.0 }
      }
   }
}

object {     // Water
 plane { z,0
  translate -8.76*z
 }
 material { water_material }
 } 
                   
object {    // The heightfield
 height_field {
  tga "CamTerrain.tga"
  water_level 0.1213
  smooth
 }
 rotate <-90,0,0>
 translate <-0.5,-0.5,0>
 material { heightfield_material }
 scale <1,1,-0.286558> * 513
 translate <0.5,0.5,0.0> * 513
}
   
 
 sky_sphere {
     pigment {
        gradient y
        pigment_map {
            [0.00 rgb <0.847, 0.749, 0.847> ] // horizon
            [0.10 SkyBlue ]                   // horizon
            [0.20 P_Cloud4 ]
        }
     
     scale 2
      translate -1
    
    }      
}
 
 // Put in a few clouds 
plane { y, 300.0
   hollow on
   pigment {
      bozo
      turbulence 0.5
      colour_map {
         [0.0 0.6   colour red 1.0 green 1.0 blue 1.0 filter 1.0
                    colour red 1.0 green 1.0 blue 1.0 filter 1.0]
         [0.6 0.8   colour red 1.0 green 1.0 blue 1.0 filter 1.0
                    colour red 1.0 green 0.8 blue 0.1]
         [0.8 1.001 colour red 1.0 green 0.8 blue 0.1
                    colour red 0.8 green 0.4 blue 0.2]
      }
      quick_colour red 0.7 green 0.7 blue 1.0
      scale <1000.0, 200.0, 800.0>
   }
   finish {
      ambient 0.7
      diffuse 0.0
   }

   translate -450*x
   rotate 6*y
}


