#ifdef(Missile_Inc_Temp)
   // do nothing, already loaded.
#else
   #declare Missile_Inc_Temp = version;
   #ifdef(View_POV_Include_Stack)
      #debug "including missile.inc\n"
   #end

   #declare legoThinHeight=8; // height of thin blocks
   #declare legoNormalHeight=3*8; // height of normal blocks
   #declare legoWidth=20; // width of blocks
   #macro legoBrick(l,d,h)
	 merge{difference{box{<-l/2,0,-d/2>,<l/2,h,d/2>}
			  box{<-l/2+4,-1,-d/2+4>,<l/2,h,d/2>-4}
			 }
	       #local xx=0.5*legoWidth;
	       #while (xx<l)
		     #local zz=0.5*legoWidth;
		     #while (zz<d)
			   cylinder{<xx-l/2,h-1,zz-d/2>,<xx-l/2,h+4,zz-d/2>,6}
			   #local zz=zz+legoWidth;
		     #end
		     #local xx=xx+legoWidth;
	       #end
	       bounded_by{box{<-l/2-0.0001,-0.0001,-d/2-0.0001>,
			      <l/2+0.0001,h+4.0001,d/2+0.0001>}}
	      }
   #end

   #declare legoWhite= 
   texture{pigment { rgb <1,1,1>}
	   finish { ambient 0.4 diffuse 0.4}
	   finish { phong 0.5 phong_size 40 reflection 0.08}
	  }
   #declare legoRed=
   texture{pigment { rgb <0.968627,0.160784,0.054902>}
	   finish { ambient 0.4 diffuse 0.4}
	   finish { phong 0.5 phong_size 40 reflection 0.08}
	  }

   #declare Missile=
   union{object {legoBrick(8*legoWidth,2*legoWidth,legoThinHeight) translate <-4*legoWidth,0,0> texture {legoWhite}}
	 object {legoBrick(2*legoWidth,4*legoWidth,legoThinHeight) translate <-legoWidth,legoThinHeight,0> texture {legoRed}}
	 object {legoBrick(8*legoWidth,2*legoWidth,legoThinHeight) translate <-6*legoWidth,legoThinHeight,0> texture {legoRed}}
	 object {legoBrick(8*legoWidth,2*legoWidth,legoThinHeight) translate <-4*legoWidth,2*legoThinHeight,0> texture {legoWhite}}
	 object {legoBrick(2*legoWidth,1*legoWidth,legoThinHeight) rotate -90*x translate <-legoWidth+1,3*legoThinHeight+0.5*legoWidth+0.5,0.5*legoThinHeight> texture {legoRed}}
	}
   #declare Trail=object{merge{cylinder{1.5*legoWidth*x,20*legoWidth*x,3}
			       sphere{0,1 scale <legoWidth,3,3> translate 1.5*legoWidth*x} }
			 texture{pigment{gradient x
					 color_map{[0 color rgbt <0.95,0.95,0.95,0.4>]
						   [0.5 color rgbt <0.95,0.95,0.95,1>]
						   [1 color rgbt <0.95,0.95,0.95,1>] }
					 scale 20*legoWidth
					}
				 finish{ambient 0.4 diffuse 0.4 roughness 0.5 reflection 0.1} }
			}
   #declare complMissile=
   union{object{Missile}
	 object{Trail translate <0,12,40>}
	 object{Trail translate <0,12,-40>}
	 object{Trail translate <0,44,0>}
	}
   #ifndef(Colors_Inc_Temp) // if not called as an include file
       #include "colors.inc"  // make a scene
       #include "skies.inc"

       #declare WL0=-50;
       #declare waterScale=10;
       #include "water.inc"

       object{complMissile}
       object{complMissile translate <-20,1,20>*legoWidth}
       background { color rgb <0.8,0.8,1>}
       sky_sphere{S_Cloud5}
       object{waterPlane}
       light_source{10000*z // the moon
		    color rgb 0.5
		    rotate -3*x rotate -45*y
		   }
       sphere{10000*z,10000/25
	      texture{pigment{White} finish{ambient 1}}
	      rotate -3*x rotate -45*y
	      no_shadow
	     }

       // Camera (Latitude,Longitude,Radius = 30,45,0)
       camera {location <10,5,-18>*legoWidth
	       look_at  <-5,1,2>*legoWidth
	       angle 26
//               translate 0.02*<-20,0,15>*legoWidth // left picture for STEREO view
       }

       // Lights:
       light_source{<99.6367,103.091,-63.2988>  // Latitude,Longitude,Radius: 30,120,146.182
		    color rgb <1,1,1> }
       light_source{<-73.2988,156.598,-36.5456>  // Latitude,Longitude,Radius: 60,-120,146.182
		    color rgb <1,1,1> }
   #end

#end
