global_settings{max_trace_level 8
		assumed_gamma 2.2
	       }
#render "Author\n"
#render "  Name................................Willem Bogaerts\n"
#render "  From.................Delft, the Netherlands, Europe\n"
#render "  E-mail...................................w-p@dds.nl\n"
#render "  Homepage.................http://huizen.dds.nl/~w-p/\n"
#render "  VRML'97......http://huizen.dds.nl/~w-p/gyrodrom.wrl\n"
#render "Subject\n"
#render "  Name..........................Shall we Play a Game?\n"
#render "  Description.....entry for the IRTC, theme \"contrast\"\n"

#include "colors.inc"
#include "skies.inc"
#include "missile.inc"


#declare WL0=-50;
#declare waterScale=10;
#include "water.inc"

object{complMissile}
object{complMissile rotate -120*x rotate 60*z translate <-70,0,200>}
object{complMissile translate <-20,1,20>*legoWidth}
#macro pressureHill(W,H)
#local R=(H*H+W*W/4)/(4*H);
difference{merge{sphere{(H-R)*y,R}
		 cylinder{0,0.5*H*y,W/2}
		}
	   torus{W/2,R translate R*y} }
#end
#declare studBubbles=
union{sphere{<5.7,3,4.7>,1}
      sphere{<8.3,2,2.0>,2}
      sphere{<9.0,2,-2.2>,2}
      sphere{<6.0,3,-4.4>,1}
      sphere{<10.8,2.2,4.9>,2}
      sphere{<11.4,2.4,0.4>,2}
      sphere{<11.7,2.1,-4.5>,2}
      sphere{<13.8,2.8,5.0>,1}
      sphere{<14.5,2.9,-5.0>,1}
     }

// Background:
background { color rgb <0.8,0.8,1>}
sky_sphere{S_Cloud5}

difference{merge{plane{y,WL0}
		 object{pressureHill(7*legoWidth,1.5*legoNormalHeight)
			translate<-90,WL0-1,200-1.5*legoThinHeight>
		       }
		}
	   object{studBubbles translate<-9.5*legoWidth,2*legoThinHeight,-0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
	   object{studBubbles translate<-9.5*legoWidth,2*legoThinHeight,0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
	   object{studBubbles translate<-8.5*legoWidth,2*legoThinHeight,-0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
	   object{studBubbles translate<-8.5*legoWidth,2*legoThinHeight,0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
		  
	   object{studBubbles translate<-7.5*legoWidth,3*legoThinHeight,-0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
	   object{studBubbles translate<-7.5*legoWidth,3*legoThinHeight,0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
	   object{studBubbles translate<-6.5*legoWidth,3*legoThinHeight,-0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
	   object{studBubbles translate<-6.5*legoWidth,3*legoThinHeight,0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
	   object{studBubbles translate<-5.5*legoWidth,3*legoThinHeight,-0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
	   object{studBubbles translate<-5.5*legoWidth,3*legoThinHeight,0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
	   object{studBubbles translate<-4.5*legoWidth,3*legoThinHeight,-0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
	   object{studBubbles translate<-4.5*legoWidth,3*legoThinHeight,0.5*legoWidth>
			      rotate -120*x rotate 60*z translate <-70,0,200> }
	   material{Water}
	  }
plane{y,WL0-100*waterScale pigment{color rgb 0.4}}

difference{superellipsoid{<0.75,0.75> // foam at the crashing missile
			  scale 1.75*legoWidth rotate -15*z 
			  translate <-84,WL0+1.5*legoNormalHeight-1.8*legoWidth,200-1.5*legoThinHeight>
			 }
	   object{pressureHill(7*legoWidth,1.5*legoNormalHeight)
		  translate<-90,WL0-1,200-1.5*legoThinHeight>
		 }
	   texture{pigment{spotted
			   color_map{[0 rgbt <0.95,0.95,0.95,0.4>]
				     [1 rgbt <0.95,0.95,0.95,0>]}
			  }
		   finish{ambient 0.4 diffuse 0.4 roughness 0.5 reflection 0.1} }
	  }

light_source{10000*z // the moon as a light source
	     color rgb 0.5
	     rotate -3*x rotate -45*y
	    }
sphere{10000*z,10000/25 // what the moon looks like
       texture{pigment{White} finish{ambient 1}}
       rotate -3*x rotate -45*y
       no_shadow
      }

camera {location <10,5,-18>*legoWidth
	look_at  <-5,1,2>*legoWidth
	angle 26
	translate 0.04*<-20,0,15>*legoWidth // left picture for STEREO view
       }
light_source{<99.6367,103.091,-63.2988>  // Latitude,Longitude,Radius: 30,120,146.182
	     color rgb <1,1,1> }
light_source{<-73.2988,156.598,-36.5456>  // Latitude,Longitude,Radius: 60,-120,146.182
	     color rgb <1,1,1> }
