#ifndef (main)
    camera { location <3,1,-4> look_at 0 }

    light_source { <10,50,-50> color rgb 1 }
#end

#declare box_gold = 
texture {
    pigment { color rgb <1,.9,.4> } 
    finish { diffuse .1 brilliance 1 specular 2 roughness .05 reflection .25 metallic ambient .025 }
}

#declare box_mirror =
texture {
    pigment {color rgb 1}
    finish {diffuse .05 specular .5 roughness .001 reflection 1 ambient 0 }
}
/*
texture {
    pigment {
        granite
        color_map {
            [0 color rgbt <1,1,1,1>]
            [0.4 color rgbt <1,1,1,1>]
            [0.4 color rgbt <.125,.125,.125,.25>]
            [0.6 color rgbt <.125,.125,.125,.25>]
            [0.6 color rgbt <1,1,1,1>]
            [1 color rgbt <1,1,1,1>]
        }
        scale 5
        turbulence .5
        lambda 5
    }
}
*/

#declare box_cover = 
texture {
    pigment { color rgb <.9,0,.05> } 
    normal { granite .0625 scale .25 }
    finish { specular .1 roughness .3 ambient .15 }
}

union {
    
    // lower part
    union {

        #local r = .1;
        difference {
            torus { 1.5-r r }
            box { <-2,-2,-2> <2,2,0> }
            translate <0,r,.5>
        }

        cylinder { <0,0,-.5> <0,r,-.5> 1.5+r }
        cylinder { <0,0,.5> <0,r,.5> 1.5+r }

        difference {
            torus { 1.5-r r }
            box { <-2,-2,2> <2,2,0> }
            translate <0,r,-.5>
        }
    
        cylinder { <1.5-r,r,-.5> <1.5-r,r,.5> r }
        cylinder { <-1.5+r,r,-.5> <-1.5+r,r,.5> r }
    
        difference {
            torus { 1.5-2*r r }
            box { <-2,-2,-2> <2,2,0> }
            translate <0,2*r,.5>
        }
        difference {
            torus { 1.5-2*r r }
            box { <-2,-2,2> <2,2,0> }
            translate <0,2*r,-.5>
        }
    
        cylinder { <1.5-2*r,2*r,-.5> <1.5-2*r,2*r,.5> r }
        cylinder { <-1.5+2*r,2*r,-.5> <-1.5+2*r,2*r,.5> r }
    
        difference {
            torus { 1.5-3*r r }
            box { <-2,-2,-2> <2,2,0> }
            translate <0,3*r,.5>
        }
        difference {
            torus { 1.5-3*r r }
            box { <-2,-2,2> <2,2,0> }
            translate <0,3*r,-.5>
        }
    
        difference {
            cylinder { <1.5-3*r,3*r,-.5> <1.5-3*r,3*r,.5> r }
            cylinder { <1.5-2.5*r,3.5*r,-.5> <1.5-2.5*r,3.5*r,.5> r }
        }
        
        texture { box_gold }

    }
    
    // upper part
    union {
        cylinder { <-1.5+3*r,3*r,-.5> <-1.5+3*r,3*r,.5> r }
        cylinder { <-1.5+3.5*r,3*r,-.5> <-1.5+3.5*r,3*r,.5> r*.9 }
        cylinder { <-1.5+4*r,3*r,-.5> <-1.5+4*r,3*r,.5> r*.8 }
        cylinder { <-1.5+4.5*r,3*r,-.5> <-1.5+4.5*r,3*r,.5> r*.7 }
        cylinder { <-1.5+5*r,3*r,-.5> <-1.5+5*r,3*r,.5> r*.6 }
        cylinder { <-1.5+5.5*r,3*r,-.5> <-1.5+5.5*r,3*r,.5> r*.5 }
        cylinder { <-1.5+6*r,3*r,-.5> <-1.5+6*r,3*r,.5> r*.4 }

        difference {
            union {
                sphere { <0,0,0> 4*r-1.5 scale <1,r,1> translate <0,4*r,.5> }
                cylinder { <0,0,-.5> <0,0,.5> 4*r-1.5 scale <1,r,1> translate <0,4*r.0> }
                sphere { <0,0,0> 4*r-1.5 scale <1,r,1> translate <0,4*r,-.5> }
            }
            union {
                sphere { <0,0,0> 4*r-1.5 scale <1,.65*r,1> translate <0,3*r,.5> }
                cylinder { <0,0,-.5> <0,0,.5> 4*r-1.5 scale <1,.65*r,1> translate <0,3*r.0> }
                sphere { <0,0,0> 4*r-1.5 scale <1,.65*r,1> translate <0,3*r,-.5> }
                texture { box_mirror }
            }

        }

        texture { box_cover }

        // changing rotate z after first translation opens and closes the cover
        // use values 0..180 (degrees)
        translate -1*<-1.5+3*r,3*r,0> rotate z*80 translate <-1.5+3*r,3*r,0> 
    }

    rotate y*10 translate <-1.5,0,0>
}

