// main
#declare main = 0;

// global
camera { location <4.5,1,-3> look_at <-.5,1,-.5> angle 40 }
light_source { <25,50,30> color rgb 1 spotlight point_at 0 radius 1 falloff 4.75 tightness 10 }
light_source { <-20,5,-30> color rgb 1 spotlight point_at 0 radius 1 falloff 4.75 tightness 10 }

global_settings {
    assumed_gamma 2.5 
    max_trace_level 15
    radiosity { distance_maximum 1 error_bound 0.35 recursion_limit 1 }
}

// materials
#local glass_p =
pigment { color rgbt 1 }

#local glass_f =
finish { diffuse .1 specular .75 roughness .125 reflection .3 ambient .2 }

#local mirror_f =
finish { diffuse .1 specular .75 roughness .125 reflection 1 ambient 0 }

#local dollar_f =
    finish { 
        diffuse .7 
        brilliance 1.75
        specular 1
        roughness .075 
        reflection .3
        metallic 
        ambient .075 
    }

#local euro_f =
    finish { 
        diffuse .7
        brilliance 1.75
        specular 1.5
        roughness .075 
        reflection .2
        metallic 
        ambient .075 
    }

#local board_t =
texture {
    pigment {
        gradient x
        color_map {
            [0 color rgb <.60,.40,.20>*1.2]
            [.3 color rgb <.60,.40,.20>]
            [.5 color rgb <.42,.28,.14>]
            [.7 color rgb <.60,.40,.20>]
            [1 color rgb <.60,.40,.20>*1.2]
        }
        scale .25
        turbulence .2
    }
    normal {
        granite
        scale <1,1,10>
    }
    finish { diffuse .6 brilliance .25 reflection .05 ambient .2 }
}
texture {
    pigment {
        granite
        color_map {
            [0 color rgbt <.42,.28,.14,1>]
            [.4 color rgbt <.42,.28,.14,1>]
            [.5 color rgbt <.42,.28,.14,.125>]
            [.6 color rgbt <.42,.28,.14,1>]
            [1 color rgbt <.42,.28,.14,1>]
        }
        scale <1,1,10>*.25
    }
    finish { diffuse .6 brilliance .125 specular .4 roughness .1 reflection .085}
}

// Makeup box
#include "box.pov"

// Eurodollar
#local r = 23.25
#declare euro_dollar =
union {
    cylinder { 
        <0,1.15,0> <0,1.25,0> r
        pigment {
            spherical
            pigment_map {
                [0 color rgb <.8,.67,.35>]
                [.333 color rgb <.8,.67,.35>]
                [.333 color rgb .75 ]
            }
            scale 23
        }
        normal {
            bump_map { png "euro1_h.png" bump_size 2 }
            rotate x*90
            rotate y*180
            scale r*2
            translate r
        }
        finish { euro_f }
    }
    cylinder { 
        <0,-1.15,0> <0,1.15,0> r
        pigment { 
            gradient y
            pigment_map {
                [0 color rgb <.95,1,.9875> ]
                [1 color rgb <.8,.67,.35>]
            }
            scale 2.5
            translate y*-.75
        }
        finish { dollar_f }
    }
    cylinder { 
        <0,1.15,0> <0,1.25,0> r
        pigment {
            color rgb <.95,1,.9875>
        }
        normal {
            bump_map { png "dollar025_h.png" bump_size 2 }
            rotate x*90
            scale 2*r
            translate r
        }
        finish { dollar_f }
        rotate x*180
    }
} 

object { euro_dollar scale .5/23.25 rotate y*-90 translate x*.5 rotate z*90  rotate y*0 translate <1,0,0> }

/// Board plane
cylinder {
    <0,0,0> <0,-10,0> 10
    texture { board_t }
    rotate y*15
}

