//___________________________________________________________________________________________________
//_______________________                                                  __________________________
//_______________________           P O V       C H E S S B O A R D        __________________________
//_______________________                                                  __________________________ 
//_______________________        by   R E N Z O    D E L   F A B B R O     __________________________ 
//_______________________                                                  __________________________
//_______________________          Tai di Cadore  Belluno  Italy           __________________________
//_______________________                                                  __________________________
//_______________________                                                  __________________________
//_______________________             renzo_adriano@libero.it              __________________________
//_______________________                                                  __________________________
//_______________________        http://members.tripod.com/azzazzel        __________________________
//___________________________________________________________________________________________________

//__________________________________________ General_______________________________________________________
global_settings { assumed_gamma 2.2 }

#include "consts.inc"
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "golds.inc"
#include "metals.inc"

#declare Rad_Quality = Radiosity_Final;
#include "rad_def.inc"

//------------declare White----------------------
#declare bia=
texture {
  pigment
  {
    granite
    turbulence 0.4
    color_map
    {
      [0.56 color rgb<0.776, 0.667, 0.561>]
      [0.73 color rgb<0.737, 0.659, 0.573>]
      [1.00 color rgb<0.725, 0.502, 0.451>]
    }
  }
  rotate <0.0, 0.0, 40.0>
  scale <2.0, 3.0, 2.0>
}

texture {
  pigment
  {
    granite
    turbulence 2
    color_map
    {
      [0 color rgbf<0.537, 0.369, 0.294, 0.545>]
      [0 color rgbf<0.573, 0.424, 0.282, 0.965>*0.5]
      [0.73 color rgbf<0.490, 0.392, 0.306, 0.737>]
      [1.00 color rgbf<0.435, 0.310, 0.278, 0.627>]
    }
  }

  finish {
    ambient 0.05
    diffuse 0.3
    phong 1.0    phong_size 90
  }

  rotate <0.0, 0.0, -30.0>
  scale <1.3, 2.0, 1.3>
}

//----------------- declare Black ------------------
#declare ner=
texture {
  pigment
  {
    granite
    turbulence 0.4
    color_map
    {
      [0.56 color rgb<0.176, 0.167, 0.161>]
      [0.73 color rgb<0.137, 0.159, 0.173>]
      [1.00 color rgb<0.125, 0.102, 0.151>]
    }
  }
  rotate <0.0, 0.0, 40.0>
  scale <2.0, 3.0, 2.0>
}

texture {
  pigment
  {
    granite
    turbulence 3
    color_map
    {
      [0 color rgbf<0.573, 0.424, 0.282, 0.965>]
      [0.73 color rgbf<0.490, 0.392, 0.306, 0.737>]
      [1.00 color rgbf<0.435, 0.310, 0.278, 0.627>]
    }
  }
   
    finish {
    ambient 0.2
    diffuse 0.8
    phong 1.0    phong_size 90
            }

  rotate <0.0, 0.0, -30.0>
  scale <1.3, 2.0, 1.3>
         }
        

//---------------------------- Declare Frame  ------------------------

#declare White = rgb 1;
#declare Gray95 = White*0.95;
#declare Mbase = color Gray95;
#declare MfLo = .2;
#declare MfHi = .85;
#declare Gray65 = White*0.65;
#declare Mfade = color Gray65;
#declare Gray10 = White*0.10;
#declare Mvein = color Gray10;
#declare Shiny = finish {
  specular 1 roughness 0.001
}
#declare NBmarble = texture {
  pigment {
    marble
    turbulence 1.15
    color_map {
      [0 color Mbase]
      [MfLo color Mbase]
      [MfHi color Mfade]
      [.95 color Mvein]
      [1 color Mvein]
    }
    rotate <57,33,-19>
  }
  finish {
    Shiny
    reflection .2
  }
}

#declare Wheat = color red 0.847059 green 0.847059 blue 0.74902;
#declare Mbase = color Wheat;
#declare MfLo = .05;
#declare MfHi = .92;
#declare Mfade = color red .4 green .5 blue .45;

#declare HuntersGreen = color red 0.13 green 0.37 blue 0.31;

#declare Mvein = color HuntersGreen;

#declare NBmarble3 = texture {
  NBmarble
  pigment {
    color_map {
      [0 color Mbase]
      [MfLo color Mbase]
      [MfHi color Mfade]
      [.95 color Mvein]
      [1 color Mvein]
    }
  }
}

 
//-------------------------------------------------------------
#declare bianco = ner   
#declare nero =  bia
#declare bor= NBmarble3     

//-------------------- Camera ---------------------------------

camera {
   location <8,3,-4>*2          
   angle 24
   look_at   <0, .51, .33>
}

//--------------------- Lights --------------------------------

light_source { <3, 10, -15>*2 White 1.5
spotlight
point_at <0,0,0>
radius 185
falloff 195
area_light <.2,0,0>, <0,0,.2>,  4,  4
jitter
}

light_source { <8, 3, -4> color White 1.2
 shadowless}

light_source { <-11, 1, 5> color White 1.5
 }


//--------------------- Sky sphere -----------------------------
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.3] [1.0 color rgb 1] }
  }
}

//---------------------  Textures ------------------------------
#declare legno= pigment{
image_map {
tga "legno.tga"}
}
#declare camin= pigment{
image_map {
tga "camin3.tga" }
}

//_______________________________ TABLE _______________________________________________________

cylinder {-.43*y,-.45*y,6 pigment {legno rotate 30*y} finish { reflection .3  diffuse .5 }}

#declare sc=.6 ;


//============================================================================================


//_________________________________  P A W N  ________________________________________________
#declare tor = torus{ 0.78,0.74 }
#declare cil = cylinder{  -.3*y,  .8*y , .2 }

#declare tron = //-------------------------------------------  chest
 difference {
object {cil}
object {tor}
scale <1.3,1,1.3>
}#declare base = //-----------------------------------------  base
 union {
torus{ 0.12, 0.03  translate -.3*y}
torus{  0.14,  0.06 translate -.36*y}
}
#declare pedone =
 merge {
sphere{<0,.16, 0> 0.12}//------------------------------------  head
cone{.1*y,  0.0, 0*y, .14}
cylinder{ -.02*y,.0*y, .141}
object { tron clipped_by { plane {y,0}}}
base
}

//__________________________________ B I S H O P _________________________________________

#declare testa_A = difference{
sphere {<0,.16, 0> 0.15 scale<1.1,1.2,1.1> translate .2*y }//------------------  head
box {<-.2, 0, -.2>  < .2, .04, .2> rotate <0,0,30> translate <.25,.52,0>}
}
#declare alfiere = merge {
sphere {<0,0,0> 0.07 scale<1.1,.6,1.1> translate .58*y }
testa_A
cylinder{ .17*y,.25*y, .08 }
sphere {<0,0,0> 0.2 clipped_by { plane {-y,.03}} scale<.8,.3,.8>translate .17*y}
sphere {<0,0,0> 0.2 clipped_by { plane {-y,.03}} scale<1,.4,1>translate .13*y}
object { tron clipped_by { plane {y,0}} scale <1.1,1.6,1.1> translate .245*y}// chest
union {                                      //-------------------------------- base
torus{ 0.11, 0.04 scale 1.3 translate -.28*y}
torus{  0.14,  0.05  scale 1.3 translate -.36*y}
}
}
//___________________________________ Q U E E N __________________________________________

#declare kk= cylinder{ -.2*y,  .2*y,  .05  rotate 45*z  translate <.25,0,0>}
#declare cc= union {
sphere { <0,0,0> .8 translate .8*y }
 object { kk }
 object { kk rotate 45*y}
 object { kk rotate 90*y}
 object { kk rotate 135*y}
 object { kk rotate 180*y}
 object { kk rotate 225*y}
 object { kk rotate 270*y}
 object { kk rotate 315*y}
 }
#declare cor_Q = difference {//---------------------------------------------- crown
sphere {<0,0,0> 0.1 scale<2.2,.5,2.2> translate <0,0,0>} cc }
#declare regina= merge {
sphere {<0,0,0> 0.1 scale<.7,.4,.7> translate .8*y}
sphere {<0,0,0> 0.1 scale<2.2,.5,2.2> translate .40*y}
torus{ 0.094, 0.01 scale 1.3 translate .53*y}
torus{ 0.09, 0.01 scale 1.3 translate .44*y}
object { tron clipped_by { plane {y,0}} clipped_by  { plane {-y,.24}}//------ chest
rotate <180,0,0> scale <2.2,1.4,2.2> translate .445*y}
object { cor_Q scale <1.2,1,1.2> translate .79*y }
object { tron clipped_by { plane {y,0}} scale <1.5,2.2,1.5> translate .355*y}
union {                                               //--------------------- base
torus{ 0.11, 0.04 scale 1.5 translate -.28*y}
torus{  0.14,  0.05  scale 1.5 translate -.36*y}
}
}

//_________________________________  KING  _______________________________________________
  
//---------------------------------  Cross  ------------------------------------
#declare crocex = merge {
sphere {<0,.91,0> 1.055 clipped_by { plane {-y,-1.7}}}
cone{ 0*y,  0.0, 1.7*y, .7}
cylinder {.4*y, 1.3*y,.9}
cylinder {.4*y, 0*y,.6}
}
 #declare crocef = difference {
 object {crocex}
 union { box {<-1.1,2.1,.25> <1.1,-.1,2>} box {<1.1,-.1,-.25> <-1.1,2.1,-2>}}
 }
 #declare croce = object {crocef scale .12}

//---------------------------------  Body  -------------------------------------
#declare tt= sor
{
  10,
    <0,0>
    <.6,0>
    <.7,.1>
    < 1.2, 1.1>
    < 1.3, 1.5>
    < 1, 1.77>
    < 0.6, 1.9>
    < 0.5,1.95>
    <0.05,1.96>
    <0,0>
scale .17
}
#declare re= merge {
object { croce translate .83*y} // -------------------------  cross
object { tt translate .52*y} //-----------------------------  crown
torus{ 0.094, 0.01 scale 1.3 translate .53*y} //------------  first ring
cylinder{ .4*y,.55*y, .121 }//------------------------------  neck
sphere {<0,0,0> 0.1 scale<2.2,.5,2.2> translate .40*y} //---  bib :)
torus{ 0.09, 0.01 scale 1.3 translate .44*y} //-------------  second ring
object { tron clipped_by { plane {y,0}} scale <1.5,2.2,1.5> translate .355*y} //- chest
union {    //----------------------- base ------------------  
torus{ 0.11, 0.04 scale 1.5 translate -.28*y}
torus{  0.14,  0.05  scale 1.5 translate -.36*y}
cylinder{ -.42*y,-.39*y, .27 }
}//--------------------------------- end -------------------
}//



//_______________________________________ ROOK ___________________________________________

#declare tubo= //-------------------------------------------  chest 
difference { 
cylinder { -1*y , 1*y ,.5}
cylinder { -1*y , 1*y ,.25}
}
#declare merli = //-----------------------------------------  battlements
difference { 
torus { .25,.1 }  tubo
box {<.3,-.04,.03> <-.3,.4,-.03>}
 box {<.03,-.04,.3> <-.03,.4,-3>}
}
#declare  mm =
 merge{
object {merli}  cone {0*y ,.15 ,-.1*y,.25}  cone {-.19*y ,.14 ,-.1*y,.25}
torus{ 0.243, 0.01  translate -.1*y}
torus{ 0.097, 0.015 scale 1.3 translate -.20*y}
}
#declare torre= //------------------------------------------  rook union 
 merge {
object { mm translate .35*y scale <.74,.74,.74> rotate 30*y}
object { tron clipped_by { plane {y,0}}
clipped_by { plane {y,-.16}}
 scale <1.33,3,1.33> translate .6*y}
 union {
torus{ 0.11, 0.04 scale 1.3 translate -.28*y}
torus{  0.14,  0.05  scale 1.3 translate -.36*y}
}
}
//________________________________________ KNIGHT ___________________________________________

#declare g=2 ;
#declare rr=.2;
#declare an= blob {
threshold .3
sphere {0,.34,2 scale<1,1.3,.9> rotate 20*z translate .06*x} //----------- belly
cylinder{.3*y,.48*y,.19,g}                       //----------------------- neck
cylinder{.49*y,.52*y,.15,g translate .1*x}      //------------------------ 1 snout
cylinder{.46*y,.51*y,.13,1 translate .2*x}      //------------------------ 2 snout
cylinder{.46*y,.50*y,.12,g translate .3*x}      //------------------------ 3 snout
sphere {0,.15,1  scale<1,3.5,.8> rotate -12*z translate <-.18,.3,0>}//---- mane
sphere {0,.15,2  scale<1,2.5,1.5> rotate -12*z translate <-.08,.3,0>}//--- under_mane
sphere {0,.15,1   scale<.4,.8,.4> rotate 30*z translate <-.03,.65,.07>}//- ear1
sphere {0,.15,1   scale<.4,.8,.4> rotate 30*z translate <-.03,.65,-.07>}// ear2
}
#declare cava= difference {
 object{an}
box{<-.1,-.01,-.1><.1,.01,.1> translate <.4,.43,0>}
sphere {<.37,.5,.05> .03 } //--------------------------------------------- nose 1
sphere {<.37,.5,-.05> .03 } //-------------------------------------------- nose 2
sphere {0,.14   scale<.3,.48,.2> rotate 30*z translate <-.028,.65,.1>}
sphere {0,.14   scale<.3,.48,.2> rotate 30*z translate <-.028,.65,-.1>}
difference{ sphere {<.14,.6,-.125> .06} sphere {<.09,.56,-.05> .055 }}//-- eye1
difference{ sphere {<.14,.6,.125> .06} sphere {<.09,.56,.05> .055 }}//---- eye2
}
#declare cavallo=merge{
object {cava clipped_by { plane {-y,0}}  scale<.9,.9,.8> translate <-.04,-.05,0> }
object { tron clipped_by { plane {-y,.14}} clipped_by { plane {y,.05}}
scale <2.7,1,2.7> translate -.13*y }
torus{ 0.07, 0.01 rotate 90*z scale<2,1.35,1.05> translate <.16,.39,0>}
torus{ 0.19, 0.03 scale<1.16,1,.9> translate <0.01,-.05,0>}//------------- belt
union {
torus{ 0.15, 0.03 scale 1.2 translate -.29*y}
torus{  0.16,  0.05  scale 1.3 translate -.36*y}
}
}
//__________________________________ end singles  _______________________________________



//------------------------------ BUILD THE 32 pieces ------------------------------------ 

#declare vr =  rgb<.2,.4,.1>;
#declare a= 2.625;
#declare b= 0.75 ;
#declare c= 1.125;
#declare d= 1.875;
#declare e= 0.375;
//__________________________________   PAWNS  ____________________________________________

#declare tp= cylinder { -.42*y,-.39*y, .18}
#declare i=0;
#while (i<8)
object { pedone translate <d,0,a-i*b> texture {bianco} }
object { pedone translate<-d,0,a-i*b> texture {nero} }
object { tp translate <d,0,a-i*b> pigment {vr}}
object { tp translate <-d,0,a-i*b> pigment {vr}}
#declare i=i+1;
#end
 
//__________________________________  ROKS  ______________________________________________

#declare tt= cylinder { -.42*y,-.39*y, .22}
object { torre rotate 45*y translate<a,0,a> texture {bianco}}
object { torre rotate 45*y translate<a,0,-a> texture {bianco}}
object { torre rotate 45*y translate<-a,0,a> texture {nero}}
object { torre rotate 45*y translate<-a,0,-a> texture {nero}}
object { tt translate <a,0,-a> pigment {vr}}//-----------  green felt
object { tt translate <-a,0,a> pigment {vr}}
object { tt translate <a,0,a>  pigment {vr}}
object { tt translate <-a,0,-a>pigment {vr}}

//________________________________   BISHOPS  ____________________________________________

#declare ta=cylinder { -.42*y,-.39*y, .22}
object { alfiere rotate 180*y translate<a,0,c> texture {bianco}}
object { alfiere rotate 180*y translate<a,0,-c> texture {bianco}}
object { alfiere rotate 0*y translate<-a,0,c> texture {nero}}
object { alfiere rotate 0*y translate<-a,0,-c> texture {nero}}
object { ta  translate<a,0,c>  pigment {vr}}
object { ta  translate<a,0,-c> pigment {vr}}
object { ta  translate<-a,0,c> pigment {vr}}
object { ta  translate<-a,0,-c>pigment {vr}}

//_______________________________ KNIGHTS  ______________________________________________

#declare tc=cylinder { -.42*y,-.39*y, .26}
object { cavallo rotate 180*y translate<a,0,d> texture {bianco}}
object { cavallo rotate 180*y translate<a,0,-d> texture {bianco}}
object { cavallo rotate 0*y translate<-a,0,d> texture {nero}}
object { cavallo rotate 0*y translate<-a,0,-d> texture {nero}}
object { tc  translate<a,0,d>  pigment {vr}}
object { tc translate<a,0,-d>  pigment {vr}}
object { tc  translate<-a,0,d> pigment {vr}}
object { tc  translate<-a,0,-d>pigment {vr}}

//______________________________  QUEENS ________________________________________________

#declare tr= cylinder { -.42*y,-.39*y, .27}
object { re rotate -90*y translate<a,0,e> texture {bianco}}
object { re rotate -90*y translate<-a,0,e> texture {nero}}
object { tr  translate<a,0,e> pigment {vr}}
object { tr translate<-a,0,e> pigment {vr}}

//______________________________ KINGS __________________________________________________

object { regina  translate<a,0,-e> texture {bianco}}
object { regina  translate<-a,0,-e> texture {nero}}
object { tr  translate<a,0,-e> pigment {vr}}
object { tr translate<-a,0,-e> pigment {vr}}

//________________________________ E N D ________________________________________________


//   
//_______________________________  Chessboard ___________________________________________

#declare lato=merge{
 object {cylinder {-4*x,4*x,.3}  clipped_by {plane {x,0 rotate -45*y translate 3.375*x}}
  clipped_by {plane {-x,0 rotate 45*y translate -3.375*x}}
   texture {bor} scale <1,0.2,1> translate <0,-.421,-3.375>}

 object {cylinder {-4*x,4*x,.05}  clipped_by {plane {x,0 rotate -45*y translate 3.04*x}}
  clipped_by {plane {-x,0 rotate 45*y translate -3.04*x}}
   texture {T_Gold_5A} scale <1,.2,1> translate <0,-.421,-3.04>}
}
object {lato rotate 90*y}
object {lato rotate 180*y}
object {lato rotate 270*y}
object {lato rotate 0*y}

box {<3,-.421,3><-3,-.451,-3> pigment {checker pigment{Black} pigment{White} scale .75}
finish { reflection .3  diffuse .5 } }

//________________________________ Clock ________________________________________________

#declare scat= union {
superellipsoid { <.1, .1> scale <1.8,1,.5> texture {T_Copper_3D}}
cone {<.85,0,-.50>, .73, <.85,0,-.8>, 0  texture {T_Gold_5A}}
cone {<-.85,0,-.50>, .73, <-.85,0,-.8>, 0 texture {T_Gold_5A} }
  }

//----------------------- make holes ----------------------------------------------------

#declare sca = difference {
object  {scat}
cone {-.35*z,.55,-.8*z,.8 translate .85*x}
cone {-.35*z,.55,-.8*z,.8 translate -.85*x}
texture {T_Chrome_4B}
}

//------------------------ and face  ------------------------------------------------
#declare al=0 ;
#declare stris= union {
#while (al<12)
 box{ <-.015,.48,-.36> <.015,.53,-.33> rotate al*30*z translate .85*x  pigment{Black}}
 box{ <-.015,.48,-.36> <.015,.53,-.33> rotate al*30*z translate -.85*x  pigment{Black}}
#declare al=al+1;
#end
#declare al=0;
#while (al<60)
 box{ <-.005,.48,-.36> <.005,.53,-.33> rotate al*6*z translate .85*x  pigment{Black}}
 box{ <-.005,.48,-.36> <.005,.53,-.33> rotate al*6*z translate -.85*x  pigment{Black}}
#declare al=al+1;
#end
}

//------------------------ and numbers ------------------------------------------------
#declare se=-.36;
#declare qua = union{
text { ttf "F.ttf", "12", .2, 0  scale 0.13 translate <.80,.37,se> pigment{Black}}
text { ttf "F.ttf", "1", .2, 0  scale .13 translate <1.05,.32,se> pigment{Black}}
text { ttf "F.ttf", "2", .2, 0  scale .13 translate <1.19,.15,se> pigment{Black}}
text { ttf "F.ttf", "3", .2, 0  scale .13 translate <1.26,-.05,se> pigment{Black}}
text { ttf "F.ttf", "4", .2, 0  scale .13 translate <1.20,-.24,se> pigment{Black}}
text { ttf "F.ttf", "5", .2, 0  scale .13 translate <1.05,-.39,se> pigment{Black}}
text { ttf "F.ttf", "6", .2, 0  scale .13 translate <.84,-.44,se> pigment{Black}}
text { ttf "F.ttf", "11", .2, 0  scale .13 translate <.61,.32,se> pigment{Black}}
text { ttf "F.ttf", "10", .2, 0  scale .13 translate <.47,.17,se> pigment{Black}}
text { ttf "F.ttf", "9", .2, 0  scale .13 translate <.41,-.05,se> pigment{Black}}
text { ttf "F.ttf", "8", .2, 0  scale .13 translate <.47,-.23,se> pigment{Black}}
text { ttf "F.ttf", "7", .2, 0  scale .13 translate <.61,-.38,se> pigment{Black}}
cylinder {0*z,-.45*z,.05 translate .85*x pigment{Black}}
cylinder {0*z,-.45*z,.03 translate .85*x texture{T_Chrome_2A}}
}

//------------------------  and  hands  ----------------------------------------------
#declare lan= union{
box{<-.02,-.1,-.41><.02,.5,-.42> rotate 10*z translate .85*x pigment{Black}}
box{<-.02,-.1,-.41><.02,.5,-.42> rotate 182*z translate .85*x pigment{Black}}
box{<-.02,-.1,-.41><.02,.5,-.42> rotate 60*z translate -.85*x pigment{Black}}
box{<-.02,-.1,-.41><.02,.5,-.42> rotate 185*z translate -.85*x pigment{Black}}
}

//----------------------   duplicate -------------------------------------------------
#declare quadr = union {
object { qua }
object { qua translate -1.7*x}
}
//----------------------   something more :) -----------------------------------------
#declare a1 = blob {
sphere {0,.06,2 scale <1,2,1> translate <0,-.04,0> }
sphere {0,.06,2 scale <1,2,1> translate <0,-.04,0> rotate 120*z}
sphere {0,.06,2 scale <1,2,1> translate <0,-.04,0> rotate 240*z}
translate <.51,0.17,-.37> pigment{Red}
}
#declare a2= blob{
sphere {0,.07,2 scale <1,1,1> }
sphere {0,.05,2 scale <3,.7,1> translate .08*x }
  pigment{Red}
}
#declare agg= union{
object {a1}
object { a1 translate -1.7*x}
object {a2 rotate 20*z translate <0.67,.47,-.375>}
object {a2 rotate -90*z translate <-1.03,.47,-.375> }
}
//-------------------------------  Buttons  ------------------------------------------
#declare pul= union {
cylinder {.15*y,.25*y,.18 }
cylinder {0*y,.16*y,.07 }
}
#declare pulsa= union {
object {pul translate <-1,.85,0>  texture {T_Gold_5A}}
object {pul translate <1,1,0>   texture {T_Gold_5A}}
}
//---------------------------- base ---------------------------------------------------
#declare m_g = merge {
object { cylinder {-4*x,4*x,.2}  clipped_by {plane {x,0 rotate 45*y }}
  clipped_by {plane {-x,0 rotate -45*y translate -3.75*x}}}
object { cylinder {-4*z,4*z,.2}  clipped_by {plane {z,0 rotate -45*y }}
 clipped_by {plane {-z,0 rotate 45*y translate -1*z}}}
   translate <1.875,0,.5>  scale <1,0.8,1> texture {T_Copper_3D}                     }
//----------------------- 
#declare m_p = merge {
object { cylinder {-4*x,4*x,.05}  clipped_by {plane {x,0 rotate 45*y }}
  clipped_by {plane {-x,0 rotate -45*y translate -3.75*x}}}
object { cylinder {-4*z,4*z,.05}  clipped_by {plane {z,0 rotate -45*y }}
 clipped_by {plane {-z,0 rotate 45*y translate -1*z}}}
   translate <1.875,0,.5>  scale <1,0.8,1> texture {T_Gold_5A}                     }
//-----------------------
#declare uni= union{
union { object {m_g} object {m_g rotate <180,0,180>} translate -1.1*y}
union { object {m_p} object {m_p rotate <180,0,180>} translate -0.95*y}
}

//--------------------   The final Clock union --------------------------------------------
#declare orologio=union {
object {uni scale <0.95,1,1>}
object {sca}
lan
quadr
agg
pulsa
stris
//----------------------  POV inscription ------------------------------------------------------
text { ttf "F.ttf", "POVRay", .2, 0 scale 0.2 translate <-0.42,0.7,-0.52> texture {T_Gold_5A}}
text { ttf "F.ttf", "3", .2, 0 scale 0.25 translate <-0.08,0.4,-0.52> texture {T_Gold_5A}}
}
object {orologio scale .5 rotate -7*y translate <0,.2,4>}
//
//_____________________________________ Clock END ______________________________________________


//_____________________________________ Environment ____________________________________________


//----------------------- Background 1----------------
box {<0,0,0><-1,1,-.1>
pigment { camin }
scale <24,14,14>  rotate -60*y translate <-12,-7,16>}

//______________________________________________ THE END __________________________________________ eof
//



