 /*******************
 * global settings *
*******************/

global_settings {
	assumed_gamma 2.2
  adc_bailout 0.0
  max_trace_level 100
}
//random seed
#declare rs = seed(132);//116,124,132 //seed(113);
#declare rs2 = seed(12);

#declare final_image = true; //for include files to turn off test render stuff


 /************
 * Includes *
************/

#include "shuttle.inc"
#include "can.inc"
#include "bug.inc"

 /******************
 * scene switches *
******************/

#declare fog_on = false;
#declare smoke_media = true;
#declare algae_on = false;

//camera type
#declare CAM_FINAL = 0;
#declare CAM_SMOKE_OVERVIEW = 1;
#declare CAM_LILY_PAD = 2;

#declare camera_type = CAM_FINAL;


 /********************
 * object positions *
********************/

//dimensions for the yinyang symbol
#declare yinyang_radius = 0.6; //multiply by dist from camera
#declare yinyang_dot_radius = 0.07;

//smoke
#declare top_angle = pi/2*(18.3/20);
#declare bottom_angle = -pi*0.51;

//camera position and orientation
#declare cam_dist = 1;
#declare cam_xrot = 45;//60;
#declare cam_yrot = 0;

#declare cam_loc = <0,0,0> - cam_dist*<cos(radians(cam_xrot))*sin(radians(cam_yrot)),-sin(radians(cam_xrot)),cos(radians(cam_xrot))*cos(radians(cam_yrot))>;
#declare lookat = <0,0,0>;
#declare cam_angle = 90;//66; //70 //77

#declare cam_dir = <cos(radians(cam_xrot))*sin(radians(cam_yrot)),-sin(radians(cam_xrot)),cos(radians(cam_xrot))*cos(radians(cam_yrot))>;
#declare cam_right = <cos(radians(cam_yrot)),0,-sin(radians(cam_yrot))>;
#declare cam_up = <sin(radians(cam_xrot))*sin(radians(cam_yrot)),cos(radians(cam_xrot)),sin(radians(cam_xrot))*cos(radians(cam_yrot))>;

#declare sky_vect = cam_up;




 /********************************************************************************************************************
 * CAMERA *
**********/


camera {         
	right x*4/3
	up y
	direction z*3/4
             
  #switch (camera_type)
  
	  #case (CAM_FINAL)
			location cam_loc
			look_at lookat
			//angle cam_angle
		#break

	  #case (CAM_SMOKE_OVERVIEW)
			location <0,100,-400>
			look_at <0,100,0>
			angle cam_angle
		#break

	  #case (CAM_LILY_PAD)
#declare footle = cam_dir - cam_up*yinyang_radius/2;
#declare footle_dist = -cam_loc.y/footle.y;
#declare insect_pos = footle*footle_dist + cam_loc;
			location insect_pos + <0,0.1,-0.2>
			look_at insect_pos
			angle cam_angle
		#break
		
	#end //switch(camera_type)
}




 /********************************************************************************************************************
 * SMOKE *
*********/

#if ( smoke_media )
	
	#declare smoke_material =
		material {
			texture {
				pigment { rgbf 1 }
				finish {
					ambient 0
					diffuse 0
				}
			}
			interior {
				media {
			    scattering {
			      5, rgb 0.9 //0.7 //0.2 //less means more light
			      eccentricity 0
			      extinction 1.0
			    }
//			    absorption 0.6
//			    emission 0.3 //0.08//0.12//adjust acording to above rgb value (which affects extinction)
			
			    intervals 8//8
			    samples 1, 8//8
			
//			    confidence 0.9999
//			    variance 1/1000
//			    ratio 0.9
//			    density { rgb 1 }
				}
			}
		}

#else
	
	#declare smoke_material =
		material {
			texture {
				pigment { rgb <1,1,1> }
				finish {
					ambient 0//0.6
					diffuse 1//0.4
				}
			}
		}

#end
	

#declare smoke_camloc = <cam_loc.x,-cam_loc.y,cam_loc.z>;
#declare smoke_camrot = <-cam_xrot,cam_yrot,0>;

//the spiral yang smoke 
#macro compute_yang_sphere(cysdist, cysangle)
	#declare d = yinyang_radius*(1-sin(cysangle))/(2*(3+sin(cysangle)));
	#declare yang_disc_centre = <(yinyang_radius/2+d)*cos(cysangle),yinyang_radius/2+(yinyang_radius/2+d)*sin(cysangle),1>*cysdist;
	//modify for perspective (a bit of trigonometry)
	#declare yang_disc_radius = cysdist*d;//*sin(atan2(1,yinyang_radius));
#end

#declare dist_range = 800;
#declare base_dist = 50;
#declare numspheres = 2500;
#declare sphere_radius = 3;

#declare nsphere = 0;
union {
	#while (nsphere <= numspheres)
		#declare nsphere_dist = pow(rand(rs),2);//pow(nsphere/numspheres,1.6)*dist_range + base_dist;
		#declare nsphere_angle = sqrt(nsphere_dist)*(top_angle-bottom_angle) + bottom_angle;//pow(nsphere_dist,0.8)*pi - pi/2;//pow(nsphere_dist,0.8)*pi - pi/2;
		#declare nsphere_dist = nsphere_dist*dist_range + base_dist;
	
		compute_yang_sphere( nsphere_dist, nsphere_angle )
		#declare yang_disc_radius = yang_disc_radius-sphere_radius*pi/8;
		#if ( yang_disc_radius < 0 )
			#declare yang_disc_radius = 0;
		#end 
		//sphere { yang_sphere_centre, yang_sphere_radius }
		//randomly position sphere within bounding disc
		#declare sphere_made = false;
		#while ( sphere_made != true )
			#declare sphere_pos = <yang_disc_radius*(2*rand(rs)-1),yang_disc_radius*(2*rand(rs)-1),0>;
			#if ( vlength(sphere_pos) <= yang_disc_radius )
				#declare sphere_made = true;
			#end
		#end

		sphere {
			sphere_pos+yang_disc_centre, sphere_radius
//			material {
//				smoke_material
//				scale sqrt(nsphere_dist)*5/sqrt(2)
//				translate <-100,50,0>
//			}
		}
		
		#declare nsphere = nsphere+1;
	#end

#if ( !smoke_media )
	no_shadow
#end

	hollow on

	material {
		smoke_material
	}

	scale <1,-1,1>	
	rotate smoke_camrot	
	translate smoke_camloc
}

 /********************************************************************************************************************
 * THE SPACE SHUTTLE *
*********************/
 
compute_yang_sphere(dist_range+base_dist+4, top_angle)

object {
	rocket

	//position on end of smoke trail
	scale 1.5
	rotate y*180
	rotate x*90
	rotate z*30
	rotate -x*20
	rotate z*81
	rotate -x*30
	translate yang_disc_centre
	//transform for camera 
	scale <1,-1,1>	
	rotate smoke_camrot	
	translate smoke_camloc
}


       
       
//dots. project <0,yinyang_radius/2,1> in direction of camera onto plane <0,1,0>, 0

 /********************************************************************************************************************
 * DRINKS CAN *
**************/

//create a vector from <0,yinyang_radius/2,1> rotated to direction of camera, an find where it hits y=0
#declare footle = cam_dir + cam_up*yinyang_radius/2;
#declare footle_dist = -cam_loc.y/footle.y;
#declare can_pos = footle*footle_dist + cam_loc;
/*sphere {
	can_pos, yinyang_dot_radius*footle_dist
	
	pigment { rgb 1 }
	finish {
		ambient 0.0
		diffuse 0.8
	}
}*/

object {
	can
  
	//sink it a little
	translate <0,-0.04,0>
  //scale to be the size of the desired dot (in 2D)
	scale yinyang_dot_radius*footle_dist/can_radius
	//rotate it so most of the chrome reflects the black smoke
	rotate <-13,0,-8>
	//position it
	translate can_pos
}



 /********************************************************************************************************************
 * I AM THE WATERBOATMAN!! *
***************************/
//or similar surface-tension stepping insect.

//create a vector from <0,-yinyang_radius/2,1> rotated to direction of camera, an find where it hits y=0
#declare footle = cam_dir - cam_up*yinyang_radius/2;
#declare footle_dist = -cam_loc.y/footle.y;
#declare insect_pos = footle*footle_dist + cam_loc;
/*sphere {
	insect_pos, yinyang_dot_radius*footle_dist
	
	pigment { rgb <0.8,0.8,0.93> }
	finish {
		ambient 0.8
		diffuse 0.2
		specular 1.0 roughness 0.002
	}
}*/

object {
	bug
	
  //scale to be the size of the desired dot (in 2D)
	scale yinyang_dot_radius*footle_dist*35//0.019//bug_wing_length
	//rotate it
	rotate <0,245,0>
	//position it
	translate insect_pos + 0.015*z// + <-0.016,0,-0.008>
}


#declare lily_pad_tex =
	texture {
		pigment {
			crackle
			turbulence 0.75
			scale 0.2
			colour_map {
				[-0.1 rgb <0.2, 0.7, 0.3>]//<0.8, 1.0, 0.9>]
				[0.1 rgb <1.2, 1.3, 1.25>]
			}
		}
		normal {
			spotted 0.02
			scale 0.15
		}
		finish {
			diffuse 0.5
			ambient 0.2
			reflection 0.4
			specular 0.7 roughness 0.01
		}
	}


#declare seg =
	union {
		intersection {
			torus { 0.08, 0.02 }
			plane { -z, 0 }
			plane { -x, 0 }
			rotate x*90
			translate <1,0.08-0.02,0>
		}
		cylinder { <1.1,0.08-0.02,0>, <1.1,0.12,0>, 0.02 }
	}

intersection {
	union {
		intersection {
			disc { <0,0,0>, y, 1 }
		}
		#declare loop = 0;
		#while ( loop < 360 )
			object { seg rotate y*loop }
			#declare loop = loop + 0.04*180/pi;
		#end
	}
	//cut out a bit
	#declare cut_in = 0.2;
	#declare slit	= 2;
	union {
		plane { x, 0 rotate y*(slit+degrees(asin(cut_in/(1.12-cut_in)))) }
		plane { -x, 0 rotate -y*(slit+degrees(asin(cut_in/(1.12-cut_in)))) }
		intersection {
			union {
				plane { x, 0 rotate y*slit }
				plane { -x, 0 rotate -y*slit }
			}
			plane { -z, (1.12-cut_in) rotate y*(slit+degrees(asin(cut_in/(1.12-cut_in)))) }
			plane { -z, (1.12-cut_in) rotate -y*(slit+degrees(asin(cut_in/(1.12-cut_in)))) }
		}
		cylinder { <0,-1,-(1.12-cut_in)>, <0,1,-(1.12-cut_in)>, cut_in rotate y*(slit+degrees(asin(cut_in/(1.12-cut_in)))) }
		cylinder { <0,-1,-(1.12-cut_in)>, <0,1,-(1.12-cut_in)>, cut_in rotate -y*(slit+degrees(asin(cut_in/(1.12-cut_in)))) }
	}
	
	texture { lily_pad_tex }

	rotate -80*y	
	scale yinyang_dot_radius*footle_dist
	translate insect_pos+0.0001*y
}


//lilly pad, project cone (?) in camera space and intersect with back to back planes.



 /********************************************************************************************************************
 * LAKE SURFACE *
****************/

#declare ripple_amplitude = 10;//0.4;

#declare special_ripples =
	normal {
		onion sine_wave slope_map { [0.0 <0,0>] [0.5 <0,0>] [1.0 <ripple_amplitude,ripple_amplitude>] }
	}

#declare temp = (bug_leg_spread+bug_thorax_rad)*yinyang_dot_radius*footle_dist/0.019;
#declare temp2 = (bug_length/2-bug_head_length-bug_thorax_length/2)*yinyang_dot_radius*footle_dist/0.019;

plane { <0,1,0>, 0
	no_shadow
	texture {
//		pigment { rgb <0.00, 0.15, 0.10> }
		pigment { rgb 1 }
		finish {
//			diffuse 0.14  //0.7
//			ambient 0.06  //0.3
//			reflection 0.8
			diffuse 0
			ambient 0
			reflection 1
//			specular 1 roughness 0.004
		}
		normal {
			average
			normal_map {
				[1.0 spherical normal_map { [0 bozo 0] [4 special_ripples scale 0.03/*015*/ scale 5/*8*/] } scale 1/5 translate insect_pos ]
				/*[1 spherical normal_map { [0 bozo 0] [1 special_ripples scale 0.005 scale 40] } scale 1/40 translate temp*z rotate 20*y rotate 245*y translate insect_pos ]
				[1 spherical normal_map { [0 bozo 0] [1 special_ripples scale 0.005 scale 40] } scale 1/40 translate temp*z rotate -10*y rotate 245*y translate insect_pos ]
				[1 spherical normal_map { [0 bozo 0] [1 special_ripples scale 0.005 scale 40] } scale 1/40 translate temp*z rotate -40*y rotate 245*y translate insect_pos ]
				[1 spherical normal_map { [0 bozo 0] [1 special_ripples scale 0.005 scale 40] } scale 1/40 translate temp*z rotate (-20+180)*y rotate 245*y translate insect_pos ]
				[1 spherical normal_map { [0 bozo 0] [1 special_ripples scale 0.005 scale 40] } scale 1/40 translate temp*z rotate (10+180)*y rotate 245*y translate insect_pos ]
				[1 spherical normal_map { [0 bozo 0] [1 special_ripples scale 0.005 scale 40] } scale 1/40 translate temp*z rotate (40+180)*y rotate 245*y translate insect_pos ]*/
//		[0.2 spherical normal_map { [0 bozo 0] [1 special_ripples scale 0.04 scale 4] } scale 1/4 translate can_pos ]
				[1.0 spherical normal_map { [0 bozo 0] [2.4 special_ripples scale 0.03 scale 4] } scale 1/4 translate can_pos ]
//				[0.5 gradient z sine_wave slope_map { [0.0 <0,0>] [1.0 <0,0.1>] } scale 0.3 rotate <0,-80,0> translate <-200,-200,-200> ]
//				[0.5 gradient z turbulence 0.0 slope_map { [0.0 <0,0>] [0.8 <0.04,0>] [1.0 <0.0, 0.0>] } scale 0.2 rotate <0,-60,0> translate <-200,-200,-200> ]
//				[0.5 gradient z sine_wave turbulence 0.0 slope_map { [0.0 <0,0>] [0.3 <0,0.06>] [0.5 <0,0.04>] [0.8 <0,0.08>] [1.0 <0,0.1>] } scale 1.2 rotate <0,-80,0> translate <-200,-200,-200> ]
			}
		}
	}
}

#if ( algae_on )
	//create algae stuff
	#macro create_algae( pos )
		disc {
			<0,0,0>, <0,1,0>, 0.01
			
			texture {
				pigment {
					spotted
					colour_map {
						[0.7 rgb <0.0,0.2,0.04>]
						[0.7 rgb <0.1,0.3,0.0>]
					}
					scale 0.002
				}
				finish {
					ambient 0.5
					diffuse 0.5
					specular 1 roughness 0.01
				}
				normal {
					spotted 0.2
					scale 0.004
				}
				translate <0,rand(rs)*20,0> //vary it
			}
	
			scale 1.3+0.4*rand(rs)		
			rotate <(rand(rs)-0.5)*360/8, rand(rs)*360, 0>
			translate pos + <0,0.002,0>
		}
	#end
	
	#declare algae_count = 0;
	#declare num_algae = 15000;
	
	#while ( algae_count < num_algae )
		
		//generate a random pos on the plane
		#declare algae_pos = <-pow(rand(rs),0.3)*2.2+0.8,0,(rand(rs)-0.5)*6+2.5>;
		#declare ang = pi/6;
		#declare algae_pos = <algae_pos.x*cos(ang) - algae_pos.z*sin(ang),0,algae_pos.z*cos(ang) + algae_pos.x*sin(ang)>;
		
		//clip it to outside yin/yang circle
		#declare rel = algae_pos - cam_loc;
		#declare rel = <vdot(rel,cam_right),vdot(rel,cam_up),vdot(rel,cam_dir)>;
		#if ( pow(rel.x/rel.z,2)+pow(rel.y/rel.z,2) > pow(yinyang_radius,2)+rand(rs)*0.1-0.05 )
	
			create_algae( algae_pos )
			
		#end
		
		#declare algae_count = algae_count + 1;
	#end
#end
          
#declare blossom =
	intersection {
		difference {
			sphere { <0,0,0>, 1 scale <0.100,0.100,0.050> }
			sphere { <0,0,0>, 1 scale <0.1005,0.099,0.0508> }
		}
		plane { <0,1,0>, 0 }

		no_shadow
		
		texture {
			pigment {
				rgb <1.3333, 1.05, 1.0>
			}
			finish {
				ambient rgb <0.6, 0.4, 0.4>
				diffuse 0.45
			}
		}
		
		translate <0.0, 0.100, 0.0>
		scale <0.7,0.7,1>
	}          

#declare loop = 0;
#while ( loop < 12 )
	object { blossom rotate <0,rand(rs2)*180,0> translate <(rand(rs2)*2-1)*1.4, 0.0, (rand(rs2)*2-1)*2.4+0.8> rotate <0,-12,0> }
	#declare loop = loop + 1;
#end
/*object { blossom rotate <0,0,0> translate <0.5, 0.0, 0.0> }
object { blossom rotate <0,30,0> translate <0.3, 0.0, 0.0> }
object { blossom rotate <0,60,0> translate <0.1, 0.0, 0.0> }
object { blossom rotate <0,90,0> translate <-.1, 0.0, 0.0> }
object { blossom rotate <0,120,0> translate <-.3, 0.0, 0.0> }
object { blossom rotate <0,150,0> translate <-.5, 0.0, 0.0> }*/
         
 /********************************************************************************************************************
 * LIGHTS AND ATMOSPHERE *
*************************/


#if ( fog_on )
//some ethereal fog
intersection {
  plane { y, dist_range+base_dist+100 }
  plane { -y, 0 }
  pigment { rgbf 1.0 }
  hollow on
  interior {
    media {
      scattering {
        1, rgb 0.00005
        extinction 0.4
      }
    
      intervals 10//40
      samples 1, 2//8
    }
  }
}
#end




//put a light in line with the tip of the smoke
compute_yang_sphere(dist_range+base_dist+20, pi/2)
#declare light_loc = yang_disc_centre;

//line up with camera
#declare light_loc = <light_loc.x,-light_loc.y,light_loc.z>;
#declare light_loc = <light_loc.x,light_loc.y*cos(radians(smoke_camrot.x)) - light_loc.z*sin(radians(smoke_camrot.x)),light_loc.z*cos(radians(smoke_camrot.x)) + light_loc.y*sin(radians(smoke_camrot.x))>;
#declare light_loc = <light_loc.x*cos(radians(smoke_camrot.y)) + light_loc.z*sin(radians(smoke_camrot.y)),light_loc.y,light_loc.z*cos(radians(smoke_camrot.y)) - light_loc.x*sin(radians(smoke_camrot.y))>;
#declare light_loc = light_loc + smoke_camloc;

light_source {
	light_loc
//#if ( smoke_media )
//	rgb 10
//#else
	rgb 2
//#end
	
//	scale <1,-1,1>	
//	rotate smoke_camrot	
//	translate smoke_camloc
}

#declare light_loc = <light_loc.x,-light_loc.y,light_loc.z>;

/*light_source {
	insect_pos + <-1,-1,1>
//#if ( smoke_media )
//	rgb 10
//#else
	rgb 0.7
//#end
	
//	scale <1,-1,1>	
//	rotate smoke_camrot	
//	translate smoke_camloc
}

difference {
	intersection {
		plane { y, -0.0001 }
		plane { -y, 0.0002 }
	}
	cylinder { insect_pos+y, insect_pos-y, 0.1 }
}*/

#declare flare_type = "my"
#declare flare_size = 4;//1.8;
#declare flare_brightness = 0.2;
#include "nkflare.inc"


/*sky_sphere {
  pigment {
//		rgb <0.1, 0.2, 0.625>
//		rgb 0.1//0.2
		rgb sky_colour
	}
  pigment {
  	bozo
  	turbulence 0.5
  	scale 2*<0.2, 0.1, 0.2>
  	translate <-0.22,0,0.3>
  	rotate <5,8,9>
  	cubic_wave
  	colour_map {
	    [0.00 rgb cloud_colour_dark transmit 0]
	    [0.40 rgb cloud_colour_light transmit 1]
	  }
	}*/
/* framing yin/yang
  pigment {
  	bozo
  	turbulence 0.5
  	scale 2*<0.2, 0.1, 0.2>
  	translate <-0.22,0,0.3>
  	rotate <1,0,0>
  	cubic_wave
  	colour_map {
	    [0.00 rgbt <0.9, 0.9, 0.9, 0.0>]
	    [0.40 rgbt <1.0, 1.0, 1.0, 1.0>]
	  }
	}
*/
/* old
  pigment {
    gradient y
    scale 2
    translate -0.5*y
    sine_wave
    colour_map {
      [0.3 rgbt rgbt <0.1, 0.2, 0.625, 1.0>]
      [1.0 rgbt rgbt <0.4, 0.5, 1.0, 0.0>]
    }
  }*/
/*  pigment {
    boxed
//    scale <1, 0.2, 1>
    scale <1, 0.8, 1>
    pigment_map {
      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
      [0.000000000001
        gradient y
        translate -y
        poly_wave 0.35
        //cubic_wave
        colour_map {
          [0.00 rgb sky_bright transmit 0]
          [1.00 rgb sky_bright transmit 1]
        }
      ]
    }
  }
}*/



//very nice sunset fx

#declare sunset_layer1 =
  //blue
  pigment {
    gradient y
    cubic_wave //use a cubic wave to avoid mach banding.
    colour_map {
      [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
      [1.00 rgbt <0.0, 0.0, 1.0, 0.8>]
    }
  }

#declare sunset_layer2 =
  //green
  pigment {
    boxed
    scale <1, 0.7, 1>
    pigment_map {
      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
      [0.000000000001
        gradient y
        cubic_wave
        colour_map {
          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
          [1.00 rgbt <0.0, 1.0, 0.0, 1.0>]
        }
      ]
    }
  }

#declare sunset_layer3 =
  //red
  pigment {
    boxed
    scale <1, 0.6, 1>
    pigment_map {
      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
      [0.000000000001
        gradient y
        cubic_wave
        colour_map {
          [0.00 rgbt <1.1, 1.1, 1.1, 0.0>]
          [1.00 rgbt <1.0, 0.0, 0.0, 1.0>]
        }
      ]
    }
  }

sky_sphere {
  pigment { sunset_layer1 }
  pigment { sunset_layer2 }
	pigment {
  	bozo
  	turbulence 0.5
  	scale <0.2, 0.1, 0.2>
	  scale 1/1.8
  	translate <2.85,0,0>
//  	translate <-0.22,0,0.3>
//  	rotate <1,0,0>
  	cubic_wave
  	colour_map {
	    [-0.10 rgbt <0.9, 0.95, 0.95, 0.0>]
	    [0.30 rgbt <1.0, 1.0, 1.0, 1.0>]
	  }
	}
  pigment { sunset_layer3 }
  scale 1.8
//  translate -0.15*y
}
