// Persistence of Vision Ray Tracer Scene Description File
// File: tmcont.pov
// Vers: 3.1g.wmp.0.6a
// Desc: entry for contrasts irtc round
// Date: dd/12/2000
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

#version unofficial MegaPov 0.6;

#include "colors.inc"
#include "trunk.inc"

#declare quickTreeZ = 35;    //35
#declare treeSpace =  35;    //was 35
#declare do3Trees =   true;
#declare doTrees =    true;
#declare doCover =    true;
#declare doGround =   true;
#declare doMedia =    true;
#declare doFigure =   true;

#declare camera_pos = <0.0, 5, -10.0>;
camera{location camera_pos right 2*x up y look_at   <0.0, 4,  0.0> }
light_source{<0,0,0> color rgb<1.0,1.0,0.9>*2 translate <-60000, 100000, 30000>}
light_source{<0,0,0> color rgb<1,1,1>*0.5 translate camera_pos fade_distance 10 fade_power 3}

sky_sphere{pigment{bozo scale 0.05 turbulence 0.25 pigment_map{[0 Blue][1 White]}}}

#declare groundleaf =
texture{
  pigment {crackle turbulence 0.25 scale 0.01 pigment_map{[0 Gold][1/2 MediumWood][1 DarkWood]}}
  normal{crackle 4 turbulence 0.25 scale 0.01}
}

#declare groundmuda =
texture{
  pigment{rgb<0.2,0.15,0.0>}
  normal{average normal_map{[bozo 5 scale 0.1][agate 5 scale 0.1]}}
  finish{ambient 0.07 diffuse 0.6 reflection 0.1}
}
#declare groundmudb =
texture{
  wrinkles turbulence 0.25 scale 0.2
  texture_map{
    [0.50 groundmuda]
    [0.55 groundleaf]
  }
}

#declare groundmud =
texture{
  gradient y
  texture_map{
    [0.5 groundmudb]
    [1.0 groundleaf]
  }
}
#declare groundTex =
texture{
  wrinkles turbulence 0.25 scale 0.2
  texture_map{
    [0.50 groundmud]
    [0.60 groundleaf]
  }
}

#if(doGround)
  #declare single_hf =
  height_field{
    tga
    "ground.tga"
  }
  #declare hf_patch =
  union{
    object{single_hf scale <-1,1,1>}  object{single_hf}
    object{single_hf scale <-1,1,-1>} object{single_hf scale <1,1,-1>}
  }
  #declare full_ground_strip =
  union{
    object{hf_patch translate <-2,0,8>}    object{hf_patch translate<0,0,8>}    object{hf_patch translate<2,0,8>}
    object{hf_patch translate <-2,0,6>}    object{hf_patch translate<0,0,6>}    object{hf_patch translate<2,0,6>}
    object{hf_patch translate <-2,0,4>}    object{hf_patch translate<0,0,4>}    object{hf_patch translate<2,0,4>}
    object{hf_patch translate <-2,0,2>}    object{hf_patch translate<0,0,2>}    object{hf_patch translate<2,0,2>}
    object{hf_patch translate <-2,0,0>}    object{hf_patch}                     object{hf_patch translate<2,0,0>}
  }
  #declare full_ground_lane =
  union{
    object{full_ground_strip translate x*-12}
    object{full_ground_strip translate x*-6}
    object{full_ground_strip}
    object{full_ground_strip translate x*6}
    object{full_ground_strip translate x*12}
  }
  #declare full_ground =
  union{
    object{full_ground_lane}
    object{full_ground_lane translate z*10}
    translate <0.35,0,0.7>
    scale <35,2,35>
  }
  object{full_ground texture{groundTex}}  
#end

#declare barkTexture =
texture{
  pigment{wrinkles scale 0.1 pigment_map{[0 MediumWood][1 DarkWood]}} normal{agate 2 scale 0.1}
}
#declare mossTexture =
texture{
  pigment{
    wrinkles 
    pigment_map{
      [0 rgb<0.2,0.4,0.0>]
      [1 rgb<0.1, 0.3, 0.0>]
    }
  }
  normal{average normal_map{[granite 10 scale 0.1][agate 10 scale 0.75]}}
}
#declare treeTexture =
texture{
  bozo turbulence 0.25 scale <1,1,1>
  texture_map{
    [0.4 barkTexture]
    [0.6 agate scale 0.75 texture_map{[0.4 barkTexture][0.6 mossTexture]}]
  }
}

#macro Tree_macro()
  #declare norm_reg = <0,0,0>;
  #declare ypos = false;
  #declare trace_result =
    trace(full_ground, <xpos, 10, zpos+zpos_rand>, <0, -10, 0>, norm_reg);
  #if (norm_reg.x != 0 | norm_reg.y != 0 | norm_reg.z != 0)
    #declare ypos = trace_result.y;
  #end 
#end

#if(do3Trees)
  object{patch_trunk scale<1/6,1,1/6> texture{treeTexture} rotate z*90 rotate y*-20 translate<14,2,20> }
  object{patch_trunk scale 1/3 rotate y*-35 translate<10,0,6> texture{treeTexture}}
  object{patch_trunk scale 1/4 translate<-5,0,-3> texture{treeTexture}}
#end

#if(doTrees)
  #declare Rand1 = seed(276);
  #declare zpos = 5;
  #while (zpos <= 700)
    #declare xpos= -25*(sqrt(zpos));
    #while (xpos <= 25*(sqrt(zpos)))
      #declare zpos_rand = treeSpace*rand(Rand1);
      Tree_macro()
      #if(ypos)
        #if (zpos < quickTreeZ)
          object{patch_trunk scale 1/(3.5+rand(Rand1)) rotate (y*(360*rand(Rand1))) rotate<((rand(Rand1))-0.5)*10, 0, ((rand(Rand1))-0.5)*10>  translate<xpos, ypos, zpos+zpos_rand> texture{treeTexture}}
        #else    
          cylinder{y*-1, y*250, (rand(Rand1)/2)+0.75 rotate<((rand(Rand1))-0.5)*10, 0, ((rand(Rand1))-0.5)*10> translate<xpos, ypos, zpos+zpos_rand> texture{treeTexture}}
        #end
      #end
      #declare xpos = xpos + (treeSpace*rand(Rand1));
    #end
    #declare zpos = zpos + (treeSpace*rand(Rand1));
  #end
#end

#declare leafPig = pigment{bozo turbulence 0.25 scale 0.02 pigment_map{[0 ForestGreen filter 0.25][1 MediumForestGreen filter 0.25]}}
#declare coverPig =
pigment{
  bozo turbulence 0.25 scale 15.0
  pigment_map{
    [0.4 White filter 1]
    [0.5 wrinkles scale 0.1 pigment_map{[0 White filter 1][1 leafPig]}]
    [0.6 leafPig]
  }
}
#declare cover = union{
  plane{y, 40 hollow pigment{coverPig} rotate x*1}
  plane{y, 45 hollow pigment{coverPig} rotate x*1}
}

#declare mediaWood =
sphere{0, 50 hollow pigment{rgbf 1} scale <1,0.5, 1> translate camera_pos translate z*40
  interior{
    media{method 3 absorption 0.05 emission 0.05 density{agate scale 10 density_map{[0.4 White][0.6 Black]}} density{planar scale 20 turbulence 0.25}}
  }
}

#if(doCover)
  object{cover}
#end

#if(doMedia)
  object{mediaWood}
#end

#if(doFigure)
  #declare norm_reg = <0,0,0>;
  #declare ypos = false;
  #declare trace_result = trace(full_ground, <4, 10, 5>, <0, -10, 0>, norm_reg);
  #declare ypos = trace_result.y;
  #include "child.inc"
  object{full_figure scale 3 translate trace_result}
#end