//Macro des colonnes
//Romain Gaittet
//Pour faire un plateau de colonnes:
/*
choose_round (your_offset          ,resize_to                ,shape_to_cut)
where         ^: is the distance     ^: the size of the       ^:shape of the engravement
               to the border            engravement            {Sphere|Cone|User_obj}  (User_obj non implemented)
{cRect(***) (refer to the name of the args in the macro itself : they're self explanatory)
|colonne(***)}

What to write :

init_colonnes()        -> set constants
choose_round(***)      -> set the shape of the engravement
1-: colonne(***)       -> make one colonne with the specified params
or 2-: set_colonne(**) -> set the base colonne with these params
      cRect(**)        -> make the colonne rectangle with the base-parametred colonne
*/
#macro init_colonnes ()
#declare Basis     = 1 ;
#declare CutAll    = 2 ;
#declare WithRound = 3 ;
#declare Sphere    = 1 ;
#declare Cone      = 2 ;
#declare SVal      = 0.0000001;
#declare xy        = x + y;
#declare xz        = x + z;
#declare yz        = y + z;
#end

#macro choose_round (FOffset,Flenght,FObject)
#declare Offset = FOffset ;
#declare lenght = Flenght ;
#declare Object = FObject ;
#end

#macro set_colonne(_radi,_bottom,_top,_nb,_Type,_Ratio)
#declare Cradi   = _radi;
#declare Cbottom = _bottom;
#declare Ctop    = _top;
#declare Cnb     = _nb;
#declare CType   = _Type;
#declare CRatio  = _Ratio;

#end


#macro colonne(radi,bottom,top,nb,Type,Ratio)

#local Count = 0 ;
#local Angle = (360/nb)*y ;
#local lradi = (radi/nb/Ratio)*pi ;
#if (lenght=0)
#declare lenght = lradi ;
#end
difference
{
        cylinder { bottom*y , top*y , radi }
        #switch (Type) 
        #case (Basis) 
        union {
                #while ( Count < nb)
                cylinder { bottom*y, top*y, lradi translate radi*x rotate Angle*Count}
                #local Count = Count+1;
                #end
        }#break
        #case (CutAll)
        union {
                #while ( Count < nb)
                cylinder { (bottom-1)*y, (top+1)*y, lradi translate radi*x rotate Angle*Count}
                #local Count = Count+1;
                #end
        }#break
        #case (WithRound)
                // La colonne elle-mme
                union {
                #while ( Count < nb)
                cylinder { (bottom+(lenght+Offset-SVal))*y, (top-(lenght+Offset-SVal))*y, lradi translate radi*x rotate Angle*Count}
                #local Count = Count+1;
                #end
                }
                #local Count = 0 ;
                // L'objet de la fin
                #switch (Object)
                #case (Sphere)
                // Fin en Sphre
                #while ( Count < nb)
                sphere { <radi,(top-(lenght+Offset+SVal)),0>,lradi scale xz + (lenght/lradi)*y rotate Angle*Count }
                sphere { <radi,(bottom+(lenght+Offset+SVal)),0>,lradi scale xz+ (lenght/lradi)*y rotate Angle*Count }
                #local Count = Count+1;
                #end
                #break

                #case (Cone)
                // Fin en Cne
                #while ( Count < nb)
                cone { <0,(top-(lenght+Offset+SVal)),0>,lradi <0,(top-Offset),0>,0 scale xz + (lenght/lradi)*y translate radi*x rotate Angle*Count }
                cone { <0,(bottom+(lenght+Offset+SVal)),0>,lradi <0,(bottom+Offset),0>,0 scale xz + (lenght/lradi)*y
translate radi*x rotate Angle*Count }
                #local Count = Count+1;
                #end
                #break

                #end
        #end
}
#end

//init_colonnes ()
//choose_round(1,0,Sphere)
#macro cRect (xmin,xmax,xstep,zmin,zmax,zstep)
//         Attention      ^       et      ^    doivent tre non-nuls et indiquent le nombre d'lm./ranges-1
//         Warning        ^       and     ^    must not be equal to zero and are the number of elem/row-1
#local xl = xmax-xmin;
#local zl = zmax-zmin;
#local xsl = xl/xstep;
#local zsl = zl/zstep;
#local i = 0;
#while (i <= xstep)
object{colonne (Cradi,Cbottom,Ctop,Cnb,CType,CRatio) pigment{color Blue} translate ((i*xsl)+xmin)*x+zmin*z}
object{colonne (Cradi,Cbottom,Ctop,Cnb,CType,CRatio) pigment{color Blue} translate ((i*xsl)+xmin)*x+zmax*z}
#local i = i+1;
#end
#local i = 1;     
#while (i < zstep)
object{colonne (Cradi,Cbottom,Ctop,Cnb,CType,CRatio) pigment{color Blue} translate ((i*zsl)+zmin)*z+xmin*x}
object{colonne (Cradi,Cbottom,Ctop,Cnb,CType,CRatio) pigment{color Blue} translate ((i*zsl)+zmin)*z+xmax*x}
#local i = i+1;
#end
#end

//radi=3.5
//bottom=0
//top=16
//nb=15
//Type=WithRound
//Ratio=0.5