#include "colors.inc"
#include "metals.inc"
#include "stones.inc"
#include "glass.inc"

global_settings {
    assumed_gamma 2.2
  }

camera {
  location <2,-.9,-5>
  look_at <2,-.8,0>
}

light_source {<50,50,-100>White shadowless}
background{color rgb<.8,.2,.2>}

//Declarations
#declare SkyRadius = 80


#declare demonfire =
sphere {0,.8
  pigment { color rgbt <1,1,1,1>}
  halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [0 color rgbt <1,1,1,1>]
      [1 color rgbt <1,.5,1,-.2>]
    }
    samples 20
  }
  hollow
}

#declare fire3 =
sphere {0,.8
  pigment { color rgbt <1,1,1,1>}
  halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [0 color rgbt <1,0,0,1>]
      [1 color rgbt <1,1,1,-.5>]
    }
    samples 20
  }
  hollow
}

#declare eye =
sphere {0,.8
  pigment { color rgbt <1,1,1,1>}
  halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [0 color rgbt <0,.8,.4,1>]
      [1 color rgbt <1,1,1,-.5>]
    }
    samples 20
  }
  hollow
}

#declare other_shape =
julia_fractal {
    <-.08,0,1.1,-.025>
    quaternion
    sqr
    max_iteration 6
    precision 15
  }

#declare fire2 =
sphere {0,.8
  pigment { color rgbt <1,1,1,1>}
  halo {
    emitting
    spherical_mapping
    linear
    color_map {
      [0 color rgbt <1,0,0,1>]
      [1 color rgbt <1,1,0,-.5>]
    }
    samples 50
  }
  hollow
}

#declare shape1 =
  julia_fractal {
    <-0.083,0.0,-0.83,-0.025>
    quaternion
    sqr
    max_iteration 12
    precision 30
  }

#declare shape2=
  julia_fractal {
    <-.08,0,-1,-.045>
    quaternion
    sqr
    max_iteration 8
    precision 15
  }

#declare T_Black_Glass=
texture {
    finish { F_Glass4 }
    pigment { color rgbf <0.1, 0.15, 0.1, 0.9> }
}


#declare shape3 =
union {
  object {
    shape1
      texture {T_Black_Glass}
      translate <0,0,0>
      scale <4,2,1>
      clipped_by{plane{x,-1}}
      rotate z*-90

  }
  object {
    shape2
      texture {T_Gold_5E}
      scale <5,1,1>
      clipped_by{plane{x,0}}
      rotate z*-90
      translate <0,0,0>
  }
}

#declare demon=
union {
  object {
    shape2
    pigment {color rgbt<1,.8,.8,.4>}
    rotate z*90
    rotate x*-10
    scale .2
    translate <2, -.7, -4>
  }

  object {
    fire3
    scale <.065,.03,.05>
    rotate z*40
    translate <2.1, -.64, -4>
  }

  object {
    fire3
    scale <.065,.03,.05>
    rotate z*-40
    translate <1.9, -.64, -4>
  }


  object {
    shape2
    scale <8,1,2>
    clipped_by{plane{x,0}}
    rotate z*-90
    translate <0,0,0>
    scale<.05,.06,.05>
    rotate z*-90
    rotate x*60
    rotate z*25
    translate<2.05,-.55,-3.85>
    pigment {color rgbt<1,.8,.8,.4>}
  }

  object {
    shape2
    scale <8,1,2>
    clipped_by{plane{x,0}}
    rotate z*-90
    translate <0,0,0>
    scale<.05,.06,.05>
    rotate z*90
    rotate x*60
    rotate z*-25
    translate<1.95,-.55,-3.85>
    pigment {color rgbt<1,.8,.8,.4>}
  }
}


sphere
{
   <0,0,0>, SkyRadius
   pigment
   {
      bozo
      turbulence 0.6
         octaves 6
         omega 0.7
         lambda 2.2
      color_map
      {
         [0.0 0.2 color rgb <0.00, 0.00, 0.00>
                  color rgb <0.25, 0.25, 0.25>]
         [0.2 0.4 color rgb <0.25, 0.25, 0.25>
                  color rgb <0.75, 0.75, 0.75>]
         [0.4 0.6 color rgb <0.75, 0.75, 0.75>
                  color rgbt <1, 1, 1, 1>]
         [0.6 1.0 color rgbt <1, 1, 1, 1>
                  color rgbt <1, 1, 1, 1>]
      }
      scale <0.2*SkyRadius, 2*SkyRadius, 0.2*SkyRadius>
   }
   hollow
   scale <30, 1, 40>
   rotate y*20
   clipped_by { box { <-3000,10,-40000> <3000,1000,40000> } }
}


plane {y,-1
  pigment {rgb<.988,.1,.1>}
  normal {
    agate
    agate_turb .7
  }
  finish {
    ambient 0
    diffuse .5
    reflection .5
    //ior 1.33
    specular .5
   // roughness .001
    refraction 1
  }
}

 height_field {
  tga "hght1.tga"
  smooth
  texture {T_Stone6}

  translate <-.5,-.5,-.5>
  scale <10,3.2,20>
  rotate y*-7
}

object {
  demon
  scale <.9,.8,.9>
  translate <.2,.05,0>
}

object {
  demonfire
  scale <1.3,1,1>
  translate < 2, 0, -2>
}

object {
  other_shape
  texture{T_Black_Glass}
  scale<.3,.1,.1>
  clipped_by{plane{x,0}}
  rotate x*90
  rotate y*-90
  rotate x*-20
  rotate y*30
  rotate x*20
  translate <1.9,-.9,-4.5>

}

object {
  eye
    scale<.03,.02,.02>
    rotate z*10
    translate <1.89, -.897, -4.55>
}

object {
  shape3
  scale<.07,.07,.07>
  rotate z*90
  rotate x*60
  rotate z*-20
  translate<2.7,-1.1,-4>
}
object {
  shape3
  scale<.07,.07,.07>
  rotate z*90
  rotate x*60
  rotate z*-30
  translate<2.7,-1.1,-3.8>
}
object {
  shape3
  scale<.07,.07,.07>
  rotate z*90
  rotate x*60
  rotate z*-25
  translate<2.7,-1.1,-3.6>
}

object {
  shape2
  texture {T_Brass_5E}
  scale <.1,.1,.3>
  rotate x*90
  rotate y*-135
  rotate z*-30
  translate <1.3,-.8,-3.6>
}
