#version unofficial MegaPov 0.6;

#include "clothutil.inc"

#default { texture { finish { ambient 0 diffuse 1 } } }

#macro WriteClothFile(nomfile, n1, n2, nlng, ks)

	#debug "\nWriting new .cth file"
	#fopen file nomfile write
	#write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")
	#local l1 = nlng*(n1-1);
	#local l2 = nlng*(n2-1);
	#local h = 85;
	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = -l1/2 + i*nlng;
			#local tempz = -l2/2 + j*nlng;
			#local tempy = h;
			#write(file, tempx, ",", tempy, ",", tempz, ", 0.0, 0.0, 0.0\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	#fclose file
#end




#include "colors.inc"
#include "woods.inc"


#declare Obj = union {
	plane { y, 0 }  // sol
	// tabouret
	union {
		cylinder { 33*y, 40*y, 15 }
		intersection {
			cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
			box { <-3.1, 0, -25>, <3.1, 40, 0> }
		}
		intersection {
			cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
			box { <-3.1, 0, -25>, <3.1, 40, 0> }
			rotate y*120
		}
		intersection {
			cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
			box { <-3.1, 0, -25>, <3.1, 40, 0> }
			rotate -y*120
		}
	}
	// guides
//	box { <0, 0, -15>, <60, 60, 15> rotate -z*30 translate 39*y + 5*x }
//	box { <-60, 0, -15>, <0, 60, 15> rotate z*30 translate 39*y - 5*x }
}

//  WriteClothFile(nomfile, n1, n2, nlng, ks)
// WriteClothFile("robe01.cth", 40, 80, 100/80, 20)
//              clothsim(Obj, Grav, Wind, damp, dt, nbi, file);
// #declare vect = clothsim(Obj, <0,-.5,0>, <0,0,0>, 0.0, .90, .05, 1000, "robe01.cth", "robe01.cth");

ReadClothFile("robe01.cth")

/*
#debug concat("\nn1 = ", str(n1, 4, 0))
#debug concat("\nn2 = ", str(n2, 4, 0))
*/


#declare Robe02 = mesh {
	DrawTriangles(Points, n1, n2, on, off, "robe02.msh")
//	DrawSmoothTriangles(Points, n1, n2, on, off, "robe02.msh")
//	DrawDoubleSmoothMesh(Points, n1, n2, 0.7, on, <.5*0.7/50, .5*0.7/100>, off, "robe02.msh")
//	pigment { rgb <1, .9, .9> }
	uv_mapping
//	pigment { checker color rgb<1, .5, .2>, color rgb <1, .8, .4> scale <1/8, 1/16, 1/10>}
	pigment { image_map { tga "image_maps/texture_robe3" once interpolate 2 } }
	normal { bump_map { png "image_maps/bmp_robe" bump_size .5 interpolate 2 } scale <.10, .30, 1>  }
}


/*
#declare Robe01 = mesh {
	DrawTriangles(Points, n1, n2, on, off, "robe01.msh")
//	#include "robe01.msh"
	uv_mapping
//	pigment { checker color rgb<1, .5, .2>, color rgb <1, .8, .4> scale <1/16, 1/8, 1/10>}
	pigment { image_map { png "image_maps/texture_robe2" once interpolate 2 } }
	normal { bump_map { png "image_maps/bmp_robe" bump_size .5 interpolate 2 } scale <.10, .30, 1>  }
}
*/


#declare Tabouret = union {
	union {
		cylinder { 34*y, 39*y, 15 }
		cylinder { 33*y, 40*y, 14 }
		torus { 14, 1 translate 34*y }
		torus { 14, 1 translate 39*y }
		texture { T_Wood23 }
	}
	intersection {
		cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
		box { <-3.1, 0, -30>, <3.1, 40, 0> }
		texture { T_Wood23 rotate -x*70}
	}
	intersection {
		cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
		box { <-3.1, 0, -30>, <3.1, 40, 0> }
		texture { T_Wood23 rotate -x*70}
		rotate y*120
	}
	intersection {
		cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
		box { <-3.1, 0, -30>, <3.1, 40, 0> }
		texture { T_Wood23 rotate -x*70}
		rotate -y*120
	}
}



union {
//	object { Robe01 translate y*0.07 }
	object { Robe02 translate y*0.07 }
	object { Tabouret scale <.99, .99, .99> }
	rotate -y*40
}

plane { y, 0 pigment { rgb 1 } }

background { rgb <.8,.9,1>*.6 }

camera {location -40*z + 80*y + 60*x look_at 30*y }

//light_source { <1, 5, -3>*5000 color rgb 1  }

light_source { <5,3,-1>*200, color rgb <1, 1, .6>*.8
	spotlight
	radius 5
	falloff 10
	tightness 2
	point_at 30*y
}

global_settings {
	ini_option "+QR"
	radiosity {
		count 100
		nearest_count 5
		error_bound .1
		brightness 0.9
		recursion_limit 1
		pretrace_start .1
		pretrace_end .005
	}
}

