#version unofficial MegaPov 0.6;

// #include "../clothutil.inc"
#include "colors.inc"
#include "woods.inc"

// ReadClothFile("robe01.cth")

#declare PigTr = pigment {
	image_map { png "alpharobe2" once interpolate 2 }
}
#declare PigTx = pigment {
	image_map { tga "texture_robe3" once interpolate 2 }
}

#declare Robe = mesh {
//	DrawTriangles(Points, n1, n2, on, off, "robe02.msh")
//	DrawSmoothTriangles(Points, n1, n2, on, on, "robe02.msh")
//	DrawDoubleSmoothTriangles(Points, n1, n2, 0.7, on, <.5*0.7/50, .5*0.7/100>, on, "robe.msh")
	#include "robe.msh"
	uv_mapping
	pigment {
		pigment_pattern { PigTr }
		pigment_map {
			[0 rgbt <0,0,0,1>]
			[1 PigTx]
		}
	}
	normal { bump_map { png "bmp_robe" bump_size .5 interpolate 2 } scale <.10, .30, 1>  }
}

#declare Tabouret = union {
	union {
		cylinder { 34*y, 39*y, 15 }
		cylinder { 33*y, 40*y, 14 }
		torus { 14, 1 translate 34*y }
		torus { 14, 1 translate 39*y }
		texture { T_Wood23 }
	}
	intersection {
		cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
		box { <-3.1, 0, -30>, <3.1, 40, 0> }
		texture { T_Wood23 rotate -x*70}
	}
	intersection {
		cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
		box { <-3.1, 0, -30>, <3.1, 40, 0> }
		texture { T_Wood23 rotate -x*70}
		rotate y*120
	}
	intersection {
		cylinder { -5*y, 35*y, 3 translate -35*y rotate x*20 translate 35*y - 10*z }
		box { <-3.1, 0, -30>, <3.1, 40, 0> }
		texture { T_Wood23 rotate -x*70}
		rotate -y*120
	}
}



#declare EnsempleTabouretRobe = union {
	object { Robe translate y*0.07 }
	object { Tabouret scale <.99, .99, .99> }
}

/*
plane { y, 0 pigment { rgb 1 } }

background { rgb <.8,.9,1>*.6 }

camera {location -40*z + 80*y + 60*x look_at 30*y }

light_source { <5,3,-1>*200, color rgb <1, 1, .6>*.8
	spotlight
	radius 5
	falloff 10
	tightness 2
	point_at 30*y
}

global_settings {
	ini_option "+QR"
	radiosity {
		count 100
		nearest_count 4
		error_bound .05
		brightness 0.9
		recursion_limit 1
		pretrace_start .1
		pretrace_end .005
	}
}

*/
