#version unofficial megapov 0.6;


#declare test_boites_inc = off;


#macro BoiteBiscuits(lx, ly, lz, base_color, imgfile)

#local R1 = min(lx, lz)/40;
#local R2 = min(lx, lz)/15;

union {
	// base
	cylinder { <R2, R1, R1>, <lx-R2, R1, R1>, R1 }
	cylinder { <R2, R1, lz-R1>, <lx-R2, R1, lz-R1>, R1 }
	cylinder { <R1, R1, R2>, <R1, R1, lz-R2>, R1 }
	cylinder { <lx-R1, R1, R2>, <lx-R1, R1, lz-R2>, R1 }
	torus { R2-R1, R1  translate <R2, R1, R2> }
	torus { R2-R1, R1  translate <R2, R1, lz-R2> }
	torus { R2-R1, R1  translate <lx-R2, R1, R2> }
	torus { R2-R1, R1  translate <lx-R2, R1, lz-R2> }
	// boite
	cylinder { <R2, R1, R2>, <R2, ly*.9, R2>, R2-R1/2 }
	cylinder { <lx-R2, R1, R2>, <lx-R2, ly*.9, R2>, R2-R1/2 }
	cylinder { <R2, R1, lz-R2>, <R2, ly*.9, lz-R2>, R2-R1/2 }
	cylinder { <lx-R2, R1, lz-R2>, <lx-R2, ly*.9, lz-R2>, R2-R1/2 }
	box { <R1/2, R1, R2>, <3*R1/4, ly*.9, lz-R2> }
	box { <R2, R1, R1/2>, <lx-R2, ly*.9, 3*R1/4> }
	box { <lx-R1/2, R1, R2>, <lx-3*R1/4, ly*.9, lz-R2> }
	box { <R2, R1, lz-R1/2>, <lx-R2, ly*.9, lz-3*R1/4> }
	// couvercle
	cylinder { <R2-R1, ly*.85, 0>, <lx-R2+R1, ly*.85, 0>, R1 }
	cylinder { <R2-R1, ly*.85, lz>, <lx-R2+R1, ly*.85, lz>, R1 }
	cylinder { <0, ly*.85, R2-R1>, <0, ly*.85, lz-R2+R1>, R1 }
	cylinder { <lx, ly*.85, R2-R1>, <lx, ly*.85, lz-R2+R1>, R1 }
	torus { R2-R1, R1  translate <R2-R1, ly*.85, R2-R1> }
	torus { R2-R1, R1  translate <R2-R1, ly*.85, lz-R2+R1> }
	torus { R2-R1, R1  translate <lx-R2+R1, ly*.85, R2-R1> }
	torus { R2-R1, R1  translate <lx-R2+R1, ly*.85, lz-R2+R1> }
	cylinder { <R2-R1, ly*.85, R2-R1>, <R2-R1, ly, R2-R1>, R2-R1/2 }
	cylinder { <lx-R2+R1, ly*.85, R2-R1>, <lx-R2+R1, ly, R2-R1>, R2-R1/2 }
	cylinder { <R2-R1, ly*.85, lz-R2+R1>, <R2-R1, ly, lz-R2+R1>, R2-R1/2 }
	cylinder { <lx-R2+R1, ly*.85, lz-R2+R1>, <lx-R2+R1, ly, lz-R2+R1>, R2-R1/2 }
	box { <-R1/2, ly*.85, R2-R1>, <-R1/2, ly, lz-R2+R1> }
	box { <R2-R1, ly*.85, -R1/2>, <lx-R2+R1, ly, R1/2> }
	box { <lx+R1/2, ly*.85, R2-R1>, <lx-R1/2, ly, lz-R2+R1> }
	box { <R2-R1, ly*.85, lz+R1/2>, <lx-R2+R1, ly, lz-R1/2> }
	sphere { <R2-R1, ly, R2-R1>, R2-R1/2 }
	sphere { <lx-R2+R1, ly, R2-R1>, R2-R1/2 }
	sphere { <R2-R1, ly, lz-R2+R1>, R2-R1/2 }
	sphere { <lx-R2+R1, ly, lz-R2+R1>, R2-R1/2 }
	cylinder { <R2-R1, ly, R2-R1>, <lx-R2+R1, ly, R2-R1>, R2-R1/2 }
	cylinder { <R2-R1, ly, R2-R1>, <R2-R1, ly, lz-R2+R1>, R2-R1/2 }
	cylinder { <lx-R2+R1, ly, R2-R1>, <lx-R2+R1, ly, lz-R2+R1>, R2-R1/2 }
	cylinder { <R2-R1, ly, lz-R2+R1>, <lx-R2+R1, ly, lz-R2+R1>, R2-R1/2 }
	box { <R2-R1, ly+R2-R1, R2-R1>, <lx-R2+R1, ly+R2-R1/2, lz-R2+R1> }

#local PigLoc = pigment {
	average
	pigment_map {
		[1 color base_color]
		[2 image_map { tga imgfile once interpolate 2 } rotate x*90 ]
	}
}

	texture {
		pigment {
			pigment_pattern {
				boxed
				scale .5
				translate .5*x+.5*z+.5*y
			}
			pigment_map {
				[.1 color base_color ]
				[.1 color base_color*1.2 ]
				[.12 color base_color*1.2 ]
				[.12 PigLoc ]
			}
			scale <lx, ly*2, lz>
		}
		normal {
			average
			normal_map {
				[1 dents .3 scale R2*10 ]
				[1 bumps .2 scale R2*3 ]
				[1 dents .6 scale R2*.5 ]
			}
		}
		finish {
			ambient 0 diffuse .5
			reflection_min .05 reflection_max .3
			specular .5 roughness .01
			reflect_metallic metallic
		}
	}
}

#end


#if (test_boites_inc)

#default { texture { finish { ambient .4 diffuse .6 } } }

camera { location <15, 30, -60>  angle 40 look_at <0, 5, 0> }

light_source { <-5, 20, -15>*50 color rgb 1.2 }

plane { y, 0 pigment { checker rgb .3, rgb .95 scale 10 } }


#include "colors.inc"

object {
	BoiteBiscuits(25, 14, 18, <1.0, 0.7, 0.6>, "boite2")
	translate <-25/2, 0, -18/2>
}

#end
